/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaJoinTableRelationshipStrategy
extends AbstractJavaJpaContextNode
implements JavaJoinTableRelationshipStrategy,
ReadOnlyTable.Owner {
    protected JavaJoinTable joinTable;

    protected AbstractJavaJoinTableRelationshipStrategy(JavaJoinTableRelationship parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        if (this.joinTable != null) {
            this.joinTable.synchronizeWithResourceModel();
        }
    }

    @Override
    public void update() {
        super.update();
        this.updateJoinTable();
    }

    @Override
    public JavaJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(JavaJoinTable joinTable) {
        JavaJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable() {
        if (this.buildsJoinTable()) {
            if (this.joinTable == null) {
                this.setJoinTable(this.buildJoinTable());
            } else {
                this.joinTable.update();
            }
        } else if (this.joinTable != null) {
            this.setJoinTable(null);
        }
    }

    protected boolean buildsJoinTable() {
        return this.getJoinTableAnnotation().isSpecified() || this.getRelationship().mayHaveDefaultJoinTable();
    }

    protected JavaJoinTable buildJoinTable() {
        return this.getJpaFactory().buildJavaJoinTable(this, this);
    }

    protected abstract JoinTableAnnotation addJoinTableAnnotation();

    protected abstract void removeJoinTableAnnotation();

    @Override
    public JavaJoinTableRelationship getParent() {
        return (JavaJoinTableRelationship)super.getParent();
    }

    @Override
    public JavaJoinTableRelationship getRelationship() {
        return this.getParent();
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public void initializeFrom(ReadOnlyJoinTableRelationshipStrategy oldStrategy) {
        ReadOnlyJoinTable oldJoinTable = oldStrategy.getJoinTable();
        if (oldJoinTable != null) {
            this.addStrategy();
            this.joinTable.initializeFrom(oldJoinTable);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinTableRelationshipStrategy virtualStrategy) {
        ReadOnlyJoinTable oldJoinTable = virtualStrategy.getJoinTable();
        if (oldJoinTable != null) {
            this.addStrategy();
            this.joinTable.initializeFromVirtual(oldJoinTable);
        }
    }

    @Override
    public String getTableName() {
        return this.joinTable == null ? null : this.joinTable.getName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.joinTable == null ? null : this.joinTable.getDbTable();
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return Tools.valuesAreDifferent((Object)this.getTableName(), (Object)tableName);
    }

    @Override
    public String getColumnTableNotValidDescription() {
        return JpaValidationDescriptionMessages.DOES_NOT_MATCH_JOIN_TABLE;
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    @Override
    public void addStrategy() {
        if (this.joinTable == null) {
            this.addJoinTableAnnotation();
            this.setJoinTable(this.buildJoinTable());
        }
    }

    @Override
    public void removeStrategy() {
        if (this.joinTable != null) {
            this.removeJoinTableAnnotation();
            this.setJoinTable(null);
        }
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.joinTable != null) {
            result = this.joinTable.getJavaCompletionProposals(pos, filter, astRoot);
        }
        return result;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter, astRoot);
        }
    }
}

