/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.utility.JDTTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMethod;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ClassName;
import org.eclipse.jpt.common.utility.internal.ReflectionTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.CollectionMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.Accessor;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.PersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.FieldAccessor;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaPersistentAttributeTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.PropertyAccessor;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.Access2_0Annotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaPersistentAttribute
extends AbstractJavaJpaContextNode
implements JavaPersistentAttribute2_0 {
    protected final Accessor accessor;
    protected AccessType defaultAccess;
    protected AccessType specifiedAccess;
    protected JavaAttributeMapping mapping;
    protected String defaultMappingKey;
    protected JavaPersistentAttribute.JpaContainerDefinition jpaContainerDefinition = JavaPersistentAttribute.JpaContainerDefinition.Null.instance();
    protected static final JavaPersistentAttribute.JpaContainerDefinition[] JPA_CONTAINER_DEFINITION_ARRAY = new JavaPersistentAttribute.JpaContainerDefinition[]{new CollectionJpaContainerDefinition(Set.class, "javax.persistence.metamodel.SetAttribute"), new CollectionJpaContainerDefinition(List.class, "javax.persistence.metamodel.ListAttribute"), new CollectionJpaContainerDefinition(Collection.class, "javax.persistence.metamodel.CollectionAttribute"), new MapJpaContainerDefinition(Map.class, "javax.persistence.metamodel.MapAttribute")};
    protected static final Iterable<JavaPersistentAttribute.JpaContainerDefinition> JPA_CONTAINER_DEFINITIONS = new ArrayIterable((Object[])JPA_CONTAINER_DEFINITION_ARRAY);

    protected AbstractJavaPersistentAttribute(PersistentType parent, JavaResourceField resourceField) {
        super(parent);
        this.accessor = new FieldAccessor(this, resourceField);
        this.initialize();
    }

    protected AbstractJavaPersistentAttribute(PersistentType parent, JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        super(parent);
        this.accessor = new PropertyAccessor(this, resourceGetter, resourceSetter);
        this.initialize();
    }

    protected AbstractJavaPersistentAttribute(PersistentType parent, Accessor accessor) {
        super(parent);
        this.accessor = accessor;
        this.initialize();
    }

    protected void initialize() {
        this.defaultAccess = this.buildDefaultAccess();
        this.specifiedAccess = this.buildSpecifiedAccess();
        this.mapping = this.buildMapping();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setDefaultAccess(this.buildDefaultAccess());
        this.setSpecifiedAccess_(this.buildSpecifiedAccess());
        this.syncMapping();
    }

    @Override
    public void update() {
        super.update();
        this.updateJpaContainerDefinition();
        this.updateMapping();
    }

    @Override
    public String getName() {
        return this.getResourceAttribute().getName();
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public boolean isFor(JavaResourceField resourceField) {
        return this.accessor.isFor(resourceField);
    }

    @Override
    public boolean isFor(JavaResourceMethod resourceGetter, JavaResourceMethod resourceSetter) {
        return this.accessor.isFor(resourceGetter, resourceSetter);
    }

    @Override
    public AccessType getAccess() {
        AccessType access = this.getSpecifiedAccess();
        return access != null ? access : this.defaultAccess;
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    protected AccessType buildDefaultAccess() {
        return this.getAccessor().getDefaultAccess();
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType specifiedAccess) {
        throw new UnsupportedOperationException();
    }

    protected void setSpecifiedAccess_(AccessType access) {
        AccessType old = this.specifiedAccess;
        this.specifiedAccess = access;
        this.firePropertyChanged("specifiedAccess", old, access);
    }

    protected AccessType buildSpecifiedAccess() {
        Access2_0Annotation accessAnnotation = this.getAccessAnnotation();
        return accessAnnotation == null ? null : AccessType.fromJavaResourceModel(accessAnnotation.getValue(), this.getJpaPlatform(), this.getResourceType());
    }

    protected Access2_0Annotation getAccessAnnotation() {
        return (Access2_0Annotation)this.getResourceAttribute().getAnnotation("javax.persistence.Access");
    }

    @Override
    public JavaAttributeMapping getMapping() {
        return this.mapping;
    }

    protected void setMapping(JavaAttributeMapping mapping) {
        JavaAttributeMapping old = this.mapping;
        this.mapping = mapping;
        this.firePropertyChanged("mapping", old, mapping);
    }

    @Override
    public String getMappingKey() {
        return this.mapping.getKey();
    }

    @Override
    public JavaAttributeMapping setMappingKey(String key) {
        if (this.mapping.isDefault()) {
            if (key != null) {
                this.setMappingKey_(key);
            }
        } else if (!this.valuesAreEqual(key, this.mapping.getKey())) {
            this.setMappingKey_(key);
        }
        return this.mapping;
    }

    protected void setMappingKey_(String key) {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition(key);
        if (definition == null) {
            definition = this.getDefaultMappingDefinition();
            Iterable<String> supportingAnnotationNames = definition != null ? definition.getSupportingAnnotationNames() : EmptyIterable.instance();
            this.setMappingAnnotation(null, supportingAnnotationNames);
        } else {
            this.setMappingAnnotation(definition);
        }
        this.setMapping(this.buildMapping(definition));
    }

    protected void setMappingAnnotation(JavaAttributeMappingDefinition definition) {
        this.setMappingAnnotation(definition.getAnnotationName(), definition.getSupportingAnnotationNames());
    }

    protected void setMappingAnnotation(String primaryAnnotationName, Iterable<String> supportingAnnotationNames) {
        this.getResourceAttribute().setPrimaryAnnotation(primaryAnnotationName, supportingAnnotationNames);
    }

    protected JavaAttributeMapping buildMapping(JavaAttributeMappingDefinition definition) {
        return definition == null ? this.buildNullMapping() : this.buildMapping_(definition);
    }

    protected JavaAttributeMapping buildNullMapping() {
        return this.getJpaFactory().buildJavaNullAttributeMapping(this);
    }

    protected JavaAttributeMapping buildMapping_(JavaAttributeMappingDefinition definition) {
        if (this.mapping != null && this.mapping.isDefault() && Tools.valuesAreEqual((Object)this.mapping.getKey(), (Object)definition.getKey())) {
            this.mapping.updateDefault();
            return this.mapping;
        }
        return definition.buildMapping(this, this.getJpaFactory());
    }

    protected JavaAttributeMapping buildMapping() {
        return this.buildMapping(this.getSpecifiedMappingDefinition());
    }

    protected void syncMapping() {
        JavaAttributeMappingDefinition definition = this.getSpecifiedMappingDefinition();
        if (definition == null) {
            if (this.mapping.isDefault()) {
                this.mapping.synchronizeWithResourceModel();
            } else {
                definition = this.getDefaultMappingDefinition();
                this.setMapping(this.buildMapping(definition));
            }
        } else if (this.mapping.isDefault()) {
            this.setMapping(this.buildMapping(definition));
        } else if (this.valuesAreEqual(definition.getKey(), this.mapping.getKey())) {
            this.mapping.synchronizeWithResourceModel();
        } else {
            this.setMapping(this.buildMapping(definition));
        }
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition(String key) {
        if (key == null) {
            return null;
        }
        for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)key)) continue;
            return definition;
        }
        throw new IllegalArgumentException("invalid mapping key: " + key);
    }

    protected JavaAttributeMappingDefinition getSpecifiedMappingDefinition() {
        if (this.accessor.getResourceAttribute().isAnnotated()) {
            for (JavaAttributeMappingDefinition definition : this.getSpecifiedMappingDefinitions()) {
                if (!definition.isSpecified(this)) continue;
                return definition;
            }
        }
        return null;
    }

    protected Iterable<JavaAttributeMappingDefinition> getSpecifiedMappingDefinitions() {
        return this.getJpaPlatform().getSpecifiedJavaAttributeMappingDefinitions();
    }

    @Override
    public String getDefaultMappingKey() {
        return this.defaultMappingKey;
    }

    protected void setDefaultMappingKey(String mappingKey) {
        String old = this.defaultMappingKey;
        this.defaultMappingKey = mappingKey;
        this.firePropertyChanged("defaultMappingKey", old, mappingKey);
    }

    protected void updateMapping() {
        String newDefaultKey;
        JavaAttributeMappingDefinition definition = this.getDefaultMappingDefinition();
        String string = newDefaultKey = definition == null ? null : definition.getKey();
        if (this.mapping.isDefault() && Tools.valuesAreDifferent((Object)this.mapping.getKey(), (Object)newDefaultKey)) {
            this.setMapping(this.buildMapping(definition));
        } else {
            this.mapping.update();
        }
        this.setDefaultMappingKey(newDefaultKey);
    }

    protected JavaAttributeMappingDefinition getDefaultMappingDefinition() {
        for (DefaultJavaAttributeMappingDefinition definition : this.getDefaultMappingDefinitions()) {
            if (!definition.isDefault(this)) continue;
            return definition;
        }
        return null;
    }

    protected Iterable<DefaultJavaAttributeMappingDefinition> getDefaultMappingDefinitions() {
        return this.getJpaPlatform().getDefaultJavaAttributeMappingDefinitions();
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<JavaPersistentAttribute> getType() {
        return JavaPersistentAttribute.class;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        return this;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.getSelectionTextRange(this.buildASTRoot());
    }

    protected TextRange getSelectionTextRange(CompilationUnit astRoot) {
        return this.getResourceAttribute().getNameTextRange(astRoot);
    }

    protected CompilationUnit buildASTRoot() {
        return this.getResourceAttribute().getJavaResourceCompilationUnit().buildASTRoot();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean typeIsBasic() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return false;
        }
        int arrayDepth = ReflectionTools.getArrayDepthForTypeDeclaration((String)typeName);
        if (arrayDepth > 1) {
            return false;
        }
        if (arrayDepth == 1) {
            String elementTypeName = ReflectionTools.getElementTypeNameForTypeDeclaration((String)typeName, (int)1);
            return MappingTools.elementTypeIsValidForBasicArray(elementTypeName);
        }
        if (ClassName.isVariablePrimitive((String)typeName)) {
            return true;
        }
        if (ClassName.isVariablePrimitiveWrapper((String)typeName)) {
            return true;
        }
        if (MappingTools.typeIsOtherValidBasicType(typeName)) {
            return true;
        }
        if (this.getResourceAttribute().typeIsEnum()) {
            return true;
        }
        return this.getResourceAttribute().typeIsSubTypeOf(JDTTools.SERIALIZABLE_CLASS_NAME);
    }

    @Override
    public String getSingleReferenceTargetTypeName() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return null;
        }
        if (ReflectionTools.getArrayDepthForTypeDeclaration((String)typeName) != 0) {
            return null;
        }
        if (this.typeIsContainer()) {
            return null;
        }
        return typeName;
    }

    @Override
    public String getMultiReferenceTargetTypeName() {
        return this.getJpaContainerDefinition().getMultiReferenceTargetTypeName(this.getResourceAttribute());
    }

    @Override
    public String getMultiReferenceMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMultiReferenceMapKeyTypeName(this.getResourceAttribute());
    }

    protected boolean typeIsContainer() {
        return this.jpaContainerDefinition.isContainer();
    }

    @Override
    public PersistentType getParent() {
        return (PersistentType)super.getParent();
    }

    @Override
    public PersistentType getOwningPersistentType() {
        return this.getParent();
    }

    @Override
    public TypeMapping getOwningTypeMapping() {
        return this.getOwningPersistentType().getMapping();
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this;
    }

    @Override
    public JavaResourceAttribute getResourceAttribute() {
        return this.accessor.getResourceAttribute();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.mapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        return this.getResourceAttribute().getTypeName();
    }

    @Override
    public boolean contains(int offset, CompilationUnit astRoot) {
        TextRange fullTextRange = this.getResourceAttribute().getTextRange(astRoot);
        return fullTextRange == null ? false : fullTextRange.includes(offset);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.isVirtual() ? this.getOwningPersistentType().getValidationTextRange() : this.getSelectionTextRange(astRoot);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateAttribute(messages, reporter, astRoot);
        this.mapping.validate(messages, reporter, astRoot);
    }

    protected void validateAttribute(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.buildAttributeValidator(astRoot).validate(messages, reporter);
    }

    protected abstract JptValidator buildAttributeValidator(CompilationUnit var1);

    protected PersistentAttributeTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaPersistentAttributeTextRangeResolver(this, astRoot);
    }

    @Override
    public boolean isVirtual() {
        IContentType persistentTypeContentType = this.getOwningPersistentType().getResourceType().getContentType();
        return !persistentTypeContentType.isKindOf(JptCommonCorePlugin.JAVA_SOURCE_CONTENT_TYPE) && !persistentTypeContentType.isKindOf(JptCommonCorePlugin.JAR_CONTENT_TYPE);
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return this.mapping.getJavaCompletionProposals(pos, filter, astRoot);
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainerDefinition().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.mapping));
    }

    @Override
    public String getMetamodelTypeName() {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return MetamodelField.DEFAULT_TYPE_NAME;
        }
        if (ClassName.isPrimitive((String)typeName)) {
            return ClassName.getWrapperClassName((String)typeName);
        }
        return typeName;
    }

    @Override
    public JavaPersistentAttribute.JpaContainerDefinition getJpaContainerDefinition() {
        return this.jpaContainerDefinition;
    }

    protected void updateJpaContainerDefinition() {
        this.setJpaContainerDefinition(this.buildJpaContainerDefinition());
    }

    protected void setJpaContainerDefinition(JavaPersistentAttribute.JpaContainerDefinition jpaContainerDefinition) {
        JavaPersistentAttribute.JpaContainerDefinition old = this.jpaContainerDefinition;
        this.jpaContainerDefinition = jpaContainerDefinition;
        this.firePropertyChanged("jpaContainerDefinition", old, this.jpaContainerDefinition);
    }

    protected JavaPersistentAttribute.JpaContainerDefinition buildJpaContainerDefinition() {
        for (JavaPersistentAttribute.JpaContainerDefinition definition : this.getJpaContainerDefinitions()) {
            if (!this.getResourceAttribute().typeIsSubTypeOf(definition.getTypeName())) continue;
            return definition;
        }
        return JavaPersistentAttribute.JpaContainerDefinition.Null.instance();
    }

    protected Iterable<JavaPersistentAttribute.JpaContainerDefinition> getJpaContainerDefinitions() {
        return JPA_CONTAINER_DEFINITIONS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class AbstractJpaContainerDefinition
    implements JavaPersistentAttribute.JpaContainerDefinition {
        protected final String typeName;
        protected final String metamodelContainerFieldTypeName;

        protected AbstractJpaContainerDefinition(Class<?> containerClass, String metamodelContainerFieldTypeName) {
            this(containerClass.getName(), metamodelContainerFieldTypeName);
        }

        protected AbstractJpaContainerDefinition(String typeName, String metamodelContainerFieldTypeName) {
            if (typeName == null || metamodelContainerFieldTypeName == null) {
                throw new NullPointerException();
            }
            this.typeName = typeName;
            this.metamodelContainerFieldTypeName = metamodelContainerFieldTypeName;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public boolean isContainer() {
            return true;
        }

        @Override
        public String getMetamodelContainerFieldTypeName() {
            return this.metamodelContainerFieldTypeName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CollectionJpaContainerDefinition
    extends AbstractJpaContainerDefinition {
        protected CollectionJpaContainerDefinition(Class<?> collectionClass, String staticMetamodelTypeDeclarationTypeName) {
            super(collectionClass, staticMetamodelTypeDeclarationTypeName);
        }

        @Override
        public String getMultiReferenceTargetTypeName(JavaResourceAttribute resourceAttribute) {
            return resourceAttribute.getTypeTypeArgumentNamesSize() == 1 ? resourceAttribute.getTypeTypeArgumentName(0) : null;
        }

        @Override
        public String getMultiReferenceMapKeyTypeName(JavaResourceAttribute resourceAttribute) {
            return null;
        }

        @Override
        public String getMetamodelContainerFieldMapKeyTypeName(CollectionMapping mapping) {
            return null;
        }

        @Override
        public boolean isMap() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MapJpaContainerDefinition
    extends AbstractJpaContainerDefinition {
        protected MapJpaContainerDefinition(Class<?> mapClass, String staticMetamodelTypeDeclarationTypeName) {
            super(mapClass, staticMetamodelTypeDeclarationTypeName);
        }

        @Override
        public String getMultiReferenceTargetTypeName(JavaResourceAttribute resourceAttribute) {
            return resourceAttribute.getTypeTypeArgumentNamesSize() == 2 ? resourceAttribute.getTypeTypeArgumentName(1) : null;
        }

        @Override
        public String getMultiReferenceMapKeyTypeName(JavaResourceAttribute resourceAttribute) {
            return resourceAttribute.getTypeTypeArgumentNamesSize() == 2 ? resourceAttribute.getTypeTypeArgumentName(0) : null;
        }

        @Override
        public String getMetamodelContainerFieldMapKeyTypeName(CollectionMapping mapping) {
            return mapping.getMetamodelFieldMapKeyTypeName();
        }

        @Override
        public boolean isMap() {
            return true;
        }
    }
}

