/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaTable;
import org.eclipse.jpt.jpa.core.context.java.JavaUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaTableTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTable<A extends BaseTableAnnotation>
extends AbstractJavaJpaContextNode
implements JavaTable,
ReadOnlyUniqueConstraint.Owner {
    protected final ReadOnlyTable.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final AbstractJpaNode.ContextListContainer<JavaUniqueConstraint, UniqueConstraintAnnotation> uniqueConstraintContainer;

    protected AbstractJavaTable(JavaJpaContextNode parent, ReadOnlyTable.Owner owner) {
        this(parent, owner, null);
    }

    protected AbstractJavaTable(JavaJpaContextNode parent, ReadOnlyTable.Owner owner, A tableAnnotation) {
        super(parent);
        this.owner = owner;
        this.setTableAnnotation(tableAnnotation);
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedSchema = this.buildSpecifiedSchema();
        this.specifiedCatalog = this.buildSpecifiedCatalog();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getUniqueConstraints());
    }

    public abstract A getTableAnnotation();

    protected void setTableAnnotation(A tableAnnotation) {
        if (tableAnnotation != null) {
            throw new IllegalArgumentException("this method must be overridden if the table annotation is not null: " + tableAnnotation);
        }
    }

    protected void removeTableAnnotationIfUnset() {
        if (this.getTableAnnotation().isUnset()) {
            this.removeTableAnnotation();
        }
    }

    protected abstract void removeTableAnnotation();

    @Override
    public boolean isSpecifiedInResource() {
        return this.getTableAnnotation().isSpecified();
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            this.getTableAnnotation().setName(name);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedName_(name);
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getTableAnnotation().getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (this.valuesAreDifferent(this.specifiedSchema, schema)) {
            this.getTableAnnotation().setSchema(schema);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedSchema_(schema);
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        return this.getTableAnnotation().getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (this.valuesAreDifferent(this.specifiedCatalog, catalog)) {
            this.getTableAnnotation().setCatalog(catalog);
            this.removeTableAnnotationIfUnset();
            this.setSpecifiedCatalog_(catalog);
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        return this.getTableAnnotation().getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    @Override
    public ListIterable<JavaUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer.getContextElements();
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.getContextElementsSize();
    }

    @Override
    public JavaUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraintContainer.getContextElement(index);
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public JavaUniqueConstraint addUniqueConstraint(int index) {
        UniqueConstraintAnnotation annotation = this.getTableAnnotation().addUniqueConstraint(index);
        return (JavaUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.getTableAnnotation().removeUniqueConstraint(index);
        this.uniqueConstraintContainer.removeContextElement(index);
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOfContextElement((JavaUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.getTableAnnotation().moveUniqueConstraint(targetIndex, sourceIndex);
        this.uniqueConstraintContainer.moveContextElement(targetIndex, sourceIndex);
    }

    protected void syncUniqueConstraints() {
        this.uniqueConstraintContainer.synchronizeWithResourceModel();
    }

    protected JavaUniqueConstraint buildUniqueConstraint(UniqueConstraintAnnotation constraintAnnotation) {
        return this.getJpaFactory().buildJavaUniqueConstraint(this, this, constraintAnnotation);
    }

    protected ListIterable<UniqueConstraintAnnotation> getUniqueConstraintAnnotations() {
        return this.getTableAnnotation().getUniqueConstraints();
    }

    protected AbstractJpaNode.ContextListContainer<JavaUniqueConstraint, UniqueConstraintAnnotation> buildUniqueConstraintContainer() {
        UniqueConstraintContainer container = new UniqueConstraintContainer();
        container.initialize();
        return container;
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getConnectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos)) {
            return this.getJavaCandidateNames(filter);
        }
        if (this.schemaTouches(pos)) {
            return this.getJavaCandidateSchemata(filter);
        }
        if (this.catalogTouches(pos)) {
            return this.getJavaCandidateCatalogs(filter);
        }
        return null;
    }

    protected boolean nameTouches(int pos) {
        return this.getTableAnnotation().nameTouches(pos);
    }

    protected Iterable<String> getJavaCandidateNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateNames(filter));
    }

    protected Iterable<String> getCandidateNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateNames(), filter);
    }

    protected Iterable<String> getCandidateNames() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean schemaTouches(int pos) {
        return this.getTableAnnotation().schemaTouches(pos);
    }

    protected Iterable<String> getJavaCandidateSchemata(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateSchemata(filter));
    }

    protected Iterable<String> getCandidateSchemata(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateSchemata(), filter);
    }

    protected Iterable<String> getCandidateSchemata() {
        return this.getDbSchemaContainer().getSortedSchemaIdentifiers();
    }

    protected boolean catalogTouches(int pos) {
        return this.getTableAnnotation().catalogTouches(pos);
    }

    protected Iterable<String> getJavaCandidateCatalogs(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateCatalogs(filter));
    }

    protected Iterable<String> getCandidateCatalogs(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateCatalogs(), filter);
    }

    protected Iterable<String> getCandidateCatalogs() {
        Database db = this.getDatabase();
        return db != null ? db.getSortedCatalogIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.buildTableValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildTableValidator(CompilationUnit astRoot) {
        return this.owner.buildTableValidator(this, this.buildTextRangeResolver(astRoot));
    }

    protected TableTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaTableTextRangeResolver(this, astRoot);
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getTableAnnotation().getTextRange(astRoot);
        return textRange != null ? textRange : this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getTableAnnotation().getNameTextRange(), astRoot);
    }

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getTableAnnotation().getSchemaTextRange(), astRoot);
    }

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getTableAnnotation().getCatalogTextRange(), astRoot);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    protected void initializeFrom(ReadOnlyTable oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
        for (ReadOnlyUniqueConstraint constraint : oldTable.getUniqueConstraints()) {
            this.addUniqueConstraint().initializeFrom(constraint);
        }
    }

    protected void initializeFromVirtual(ReadOnlyTable virtualTable) {
        this.setSpecifiedName(virtualTable.getName());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainer
    extends AbstractJpaNode.ContextListContainer<JavaUniqueConstraint, UniqueConstraintAnnotation> {
        protected UniqueConstraintContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "uniqueConstraints";
        }

        @Override
        protected JavaUniqueConstraint buildContextElement(UniqueConstraintAnnotation resourceElement) {
            return AbstractJavaTable.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        protected ListIterable<UniqueConstraintAnnotation> getResourceElements() {
            return AbstractJavaTable.this.getUniqueConstraintAnnotations();
        }

        @Override
        protected UniqueConstraintAnnotation getResourceElement(JavaUniqueConstraint contextElement) {
            return contextElement.getUniqueConstraintAnnotation();
        }
    }
}

