/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Column;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.Relationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.core.internal.context.AttributeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TypeMappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaTypeMappingTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.GenericTypeMappingValidator;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaTypeMapping<A extends Annotation>
extends AbstractJavaJpaContextNode
implements JavaTypeMapping {
    protected final A mappingAnnotation;

    protected AbstractJavaTypeMapping(JavaPersistentType parent, A mappingAnnotation) {
        super(parent);
        this.mappingAnnotation = mappingAnnotation;
    }

    @Override
    public JavaPersistentType getParent() {
        return (JavaPersistentType)super.getParent();
    }

    @Override
    public JavaPersistentType getPersistentType() {
        return this.getParent();
    }

    @Override
    public JavaResourceType getJavaResourceType() {
        return this.getPersistentType().getJavaResourceType();
    }

    @Override
    public String getName() {
        return this.getPersistentType().getName();
    }

    public A getMappingAnnotation() {
        return this.mappingAnnotation;
    }

    @Override
    public boolean attributeIsDerivedId(String attributeName) {
        return TypeMappingTools.attributeIsDerivedId(this, attributeName);
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getPersistentType().getName());
    }

    @Override
    public String getPrimaryTableName() {
        return null;
    }

    @Override
    public Table getPrimaryDbTable() {
        return null;
    }

    @Override
    public Schema getDbSchema() {
        return null;
    }

    @Override
    public Iterable<ReadOnlyTable> getAssociatedTables() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReadOnlyTable> getAllAssociatedTables() {
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getAllAssociatedTableNames() {
        return EmptyIterable.instance();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return null;
    }

    @Override
    public TypeMapping getSuperTypeMapping() {
        PersistentType superPersistentType = this.getPersistentType().getSuperPersistentType();
        return superPersistentType == null ? null : superPersistentType.getMapping();
    }

    @Override
    public Iterable<TypeMapping> getInheritanceHierarchy() {
        return this.convertToMappings(this.getPersistentType().getInheritanceHierarchy());
    }

    protected Iterable<TypeMapping> getAncestors() {
        return this.convertToMappings(this.getPersistentType().getAncestors());
    }

    protected Iterable<TypeMapping> convertToMappings(Iterable<PersistentType> types) {
        return new TransformationIterable<PersistentType, TypeMapping>(types){

            protected TypeMapping transform(PersistentType type) {
                return type.getMapping();
            }
        };
    }

    @Override
    public InheritanceType getInheritanceStrategy() {
        return null;
    }

    @Override
    public boolean isRootEntity() {
        return false;
    }

    @Override
    public Entity getRootEntity() {
        return null;
    }

    @Override
    public Iterable<JavaAttributeMapping> getAttributeMappings() {
        return new TransformationIterable<JavaPersistentAttribute, JavaAttributeMapping>(this.getPersistentType().getAttributes()){

            protected JavaAttributeMapping transform(JavaPersistentAttribute attribute) {
                return attribute.getMapping();
            }
        };
    }

    @Override
    public Iterable<JavaAttributeMapping> getAttributeMappings(final String mappingKey) {
        return new FilteringIterable<JavaAttributeMapping>(this.getAttributeMappings()){

            protected boolean accept(JavaAttributeMapping attributeMapping) {
                return Tools.valuesAreEqual((Object)attributeMapping.getKey(), (Object)mappingKey);
            }
        };
    }

    @Override
    public Iterable<AttributeMapping> getAllAttributeMappings() {
        return new CompositeIterable(this.getAllAttributeMappingsLists());
    }

    protected Iterable<Iterable<AttributeMapping>> getAllAttributeMappingsLists() {
        return new TransformationIterable(this.getNonNullInheritanceHierarchy(), TypeMappingTools.ATTRIBUTE_MAPPINGS_TRANSFORMER);
    }

    protected Iterable<TypeMapping> getNonNullInheritanceHierarchy() {
        return new FilteringIterable(this.getInheritanceHierarchy(), NotNullFilter.instance());
    }

    public Iterable<AttributeMapping> getAllAttributeMappings(final String mappingKey) {
        return new FilteringIterable<AttributeMapping>(this.getAllAttributeMappings()){

            protected boolean accept(AttributeMapping attributeMapping) {
                return Tools.valuesAreEqual((Object)attributeMapping.getKey(), (Object)mappingKey);
            }
        };
    }

    @Override
    public boolean attributeMappingKeyAllowed(String attributeMappingKey) {
        return true;
    }

    @Override
    public Iterable<AttributeMapping> getNonTransientAttributeMappings() {
        return new FilteringIterable<AttributeMapping>(this.getAllAttributeMappings()){

            protected boolean accept(AttributeMapping attributeMapping) {
                return attributeMapping.getKey() != "transient";
            }
        };
    }

    @Override
    public Iterable<String> getOverridableAttributeNames() {
        return new CompositeIterable(this.getOverridableAttributeNamesLists());
    }

    protected Iterable<Iterable<String>> getOverridableAttributeNamesLists() {
        return new TransformationIterable(this.getAttributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ATTRIBUTE_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAttributeNames() {
        return new CompositeIterable(this.allOverridableAttributeNamesLists());
    }

    protected Iterable<Iterable<String>> allOverridableAttributeNamesLists() {
        return new TransformationIterable(this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER);
    }

    @Override
    public Column resolveOverriddenColumn(String attributeName) {
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            Column column = attributeMapping.resolveOverriddenColumn(attributeName);
            if (column == null) continue;
            return column;
        }
        return null;
    }

    @Override
    public Iterable<String> getOverridableAssociationNames() {
        return new CompositeIterable(this.getOverridableAssociationNamesLists());
    }

    protected Iterable<Iterable<String>> getOverridableAssociationNamesLists() {
        return new TransformationIterable(this.getAttributeMappings(), AttributeMappingTools.ALL_OVERRIDABLE_ASSOCIATION_MAPPING_NAMES_TRANSFORMER);
    }

    @Override
    public Iterable<String> getAllOverridableAssociationNames() {
        return new CompositeIterable(this.getAllOverridableAssociationNamesLists());
    }

    protected Iterable<Iterable<String>> getAllOverridableAssociationNamesLists() {
        return new TransformationIterable(this.getInheritanceHierarchy(), TypeMappingTools.OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER);
    }

    @Override
    public Relationship resolveOverriddenRelationship(String attributeName) {
        for (AttributeMapping attributeMapping : this.getAttributeMappings()) {
            Relationship relationship = attributeMapping.resolveOverriddenRelationship(attributeName);
            if (relationship == null) continue;
            return relationship;
        }
        return null;
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return new CompositeIterable(this.getAttributeMappingGeneratorLists());
    }

    protected Iterable<Iterable<Generator>> getAttributeMappingGeneratorLists() {
        return new TransformationIterable<JavaAttributeMapping, Iterable<Generator>>(this.getAttributeMappings()){

            protected Iterable<Generator> transform(JavaAttributeMapping attributeMapping) {
                return attributeMapping.getGenerators();
            }
        };
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateType(messages, reporter, astRoot);
    }

    protected void validateType(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.buildTypeMappingValidator(astRoot).validate(messages, reporter);
    }

    protected JptValidator buildTypeMappingValidator(CompilationUnit astRoot) {
        return new GenericTypeMappingValidator(this, this.getJavaResourceType(), this.buildTextRangeResolver(astRoot));
    }

    protected TypeMappingTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaTypeMappingTextRangeResolver(this, astRoot);
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getPersistenceUnit().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.mappingAnnotation.getTextRange(astRoot);
        return textRange != null ? textRange : this.getPersistentType().getValidationTextRange(astRoot);
    }
}

