/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmBaseColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmTableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBaseColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBaseColumn<X extends XmlBaseColumn, O extends OrmReadOnlyBaseColumn.Owner>
extends AbstractOrmNamedColumn<X, O>
implements OrmBaseColumn {
    protected String specifiedTable = this.buildSpecifiedTable();
    protected String defaultTable;
    protected Boolean specifiedUnique = this.buildSpecifiedUnique();
    protected Boolean specifiedNullable = this.buildSpecifiedNullable();
    protected Boolean specifiedInsertable = this.buildSpecifiedInsertable();
    protected Boolean specifiedUpdatable = this.buildSpecifiedUpdatable();

    protected AbstractOrmBaseColumn(XmlContextNode parent, O owner) {
        this(parent, owner, null);
    }

    protected AbstractOrmBaseColumn(XmlContextNode parent, O owner, X xmlColumn) {
        super(parent, owner, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTable_(this.buildSpecifiedTable());
        this.setSpecifiedUnique_(this.buildSpecifiedUnique());
        this.setSpecifiedNullable_(this.buildSpecifiedNullable());
        this.setSpecifiedInsertable_(this.buildSpecifiedInsertable());
        this.setSpecifiedUpdatable_(this.buildSpecifiedUpdatable());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTable(this.buildDefaultTable());
    }

    @Override
    public String getTable() {
        return this.specifiedTable != null ? this.specifiedTable : this.defaultTable;
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String table) {
        if (this.valuesAreDifferent(this.specifiedTable, table)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedTable_(table);
            xmlColumn.setTable(table);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedTable_(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        this.firePropertyChanged("specifiedTable", old, table);
    }

    protected String buildSpecifiedTable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getTable();
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String table) {
        String old = this.defaultTable;
        this.defaultTable = table;
        this.firePropertyChanged("defaultTable", old, table);
    }

    protected String buildDefaultTable() {
        return ((OrmReadOnlyBaseColumn.Owner)this.owner).getDefaultTableName();
    }

    @Override
    public boolean isUnique() {
        return this.specifiedUnique != null ? this.specifiedUnique.booleanValue() : this.isDefaultUnique();
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean unique) {
        if (this.valuesAreDifferent(this.specifiedUnique, unique)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedUnique_(unique);
            xmlColumn.setUnique(unique);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedUnique_(Boolean unique) {
        Boolean old = this.specifiedUnique;
        this.specifiedUnique = unique;
        this.firePropertyChanged("specifiedUnique", old, unique);
    }

    protected Boolean buildSpecifiedUnique() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getUnique();
    }

    @Override
    public boolean isDefaultUnique() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.specifiedNullable != null ? this.specifiedNullable.booleanValue() : this.isDefaultNullable();
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean nullable) {
        if (this.valuesAreDifferent(this.specifiedNullable, nullable)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedNullable_(nullable);
            xmlColumn.setNullable(nullable);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedNullable_(Boolean nullable) {
        Boolean old = this.specifiedNullable;
        this.specifiedNullable = nullable;
        this.firePropertyChanged("specifiedNullable", old, nullable);
    }

    protected Boolean buildSpecifiedNullable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getNullable();
    }

    @Override
    public boolean isDefaultNullable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return this.specifiedInsertable != null ? this.specifiedInsertable.booleanValue() : this.isDefaultInsertable();
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean insertable) {
        if (this.valuesAreDifferent(this.specifiedInsertable, insertable)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedInsertable_(insertable);
            xmlColumn.setInsertable(insertable);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedInsertable_(Boolean insertable) {
        Boolean old = this.specifiedInsertable;
        this.specifiedInsertable = insertable;
        this.firePropertyChanged("specifiedInsertable", old, insertable);
    }

    protected Boolean buildSpecifiedInsertable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getInsertable();
    }

    @Override
    public boolean isDefaultInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return this.specifiedUpdatable != null ? this.specifiedUpdatable.booleanValue() : this.isDefaultUpdatable();
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean updatable) {
        if (this.valuesAreDifferent(this.specifiedUpdatable, updatable)) {
            XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumnForUpdate();
            this.setSpecifiedUpdatable_(updatable);
            xmlColumn.setUpdatable(updatable);
            this.removeXmlColumnIfUnset();
        }
    }

    protected void setSpecifiedUpdatable_(Boolean updatable) {
        Boolean old = this.specifiedUpdatable;
        this.specifiedUpdatable = updatable;
        this.firePropertyChanged("specifiedUpdatable", old, updatable);
    }

    protected Boolean buildSpecifiedUpdatable() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getUpdatable();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return true;
    }

    protected void initializeFrom(ReadOnlyBaseColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedTable(oldColumn.getSpecifiedTable());
        this.setSpecifiedUnique(oldColumn.getSpecifiedUnique());
        this.setSpecifiedNullable(oldColumn.getSpecifiedNullable());
        this.setSpecifiedInsertable(oldColumn.getSpecifiedInsertable());
        this.setSpecifiedUpdatable(oldColumn.getSpecifiedUpdatable());
    }

    protected void initializeFromVirtual(ReadOnlyBaseColumn virtualColumn) {
        super.initializeFromVirtual(virtualColumn);
        this.setSpecifiedTable(virtualColumn.getTable());
    }

    @Override
    public boolean tableNameIsInvalid() {
        return ((OrmReadOnlyBaseColumn.Owner)this.owner).tableNameIsInvalid(this.getTable());
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return ((OrmReadOnlyBaseColumn.Owner)this.owner).getCandidateTableNames();
    }

    @Override
    public TextRange getTableTextRange() {
        return this.getValidationTextRange(this.getXmlColumnTableTextRange());
    }

    protected TextRange getXmlColumnTableTextRange() {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn == null ? null : xmlColumn.getTableTextRange();
    }

    @Override
    protected NamedColumnTextRangeResolver buildTextRangeResolver() {
        return new OrmTableColumnTextRangeResolver(this);
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getCandidateTableNames();
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        XmlBaseColumn xmlColumn = (XmlBaseColumn)this.getXmlColumn();
        return xmlColumn != null && xmlColumn.tableTouches(pos);
    }
}

