/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.jpa.core.context.Converter;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyNamedColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmBasicMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmColumnMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmLobConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmTemporalConverter;
import org.eclipse.jpt.jpa.core.context.orm.OrmXmlContextNodeFactory;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.TableColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.AbstractNamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.EntityTableDescriptionProvider;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.NamedColumnValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.resource.orm.Attributes;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.core.resource.orm.XmlColumn;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmBasicMapping<X extends XmlBasic>
extends AbstractOrmAttributeMapping<X>
implements OrmBasicMapping {
    protected final OrmColumn column;
    protected FetchType specifiedFetch;
    protected FetchType defaultFetch = DEFAULT_FETCH_TYPE;
    protected Boolean specifiedOptional;
    protected boolean defaultOptional = true;
    protected OrmConverter converter;
    protected static final OrmConverter.Adapter[] CONVERTER_ADAPTER_ARRAY = new OrmConverter.Adapter[]{OrmEnumeratedConverter.Adapter.instance(), OrmTemporalConverter.BasicAdapter.instance(), OrmLobConverter.Adapter.instance()};
    protected static final Iterable<OrmConverter.Adapter> CONVERTER_ADAPTERS = new ArrayIterable((Object[])CONVERTER_ADAPTER_ARRAY);

    protected AbstractOrmBasicMapping(OrmPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
        this.column = this.buildColumn();
        this.specifiedFetch = this.buildSpecifiedFetch();
        this.specifiedOptional = this.buildSpecifiedOptional();
        this.converter = this.buildConverter();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.column.synchronizeWithResourceModel();
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
        this.setSpecifiedOptional_(this.buildSpecifiedOptional());
        this.syncConverter();
    }

    @Override
    public void update() {
        super.update();
        this.column.update();
        this.setDefaultFetch(this.buildDefaultFetch());
        this.setDefaultOptional(this.buildDefaultOptional());
        this.converter.update();
    }

    @Override
    public OrmColumn getColumn() {
        return this.column;
    }

    protected OrmColumn buildColumn() {
        return this.getContextNodeFactory().buildOrmColumn(this, this);
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.defaultFetch;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        this.setSpecifiedFetch_(fetch);
        ((XmlBasic)this.xmlAttributeMapping).setFetch(FetchType.toOrmResourceModel(fetch));
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildSpecifiedFetch() {
        return FetchType.fromOrmResourceModel(((XmlBasic)this.xmlAttributeMapping).getFetch());
    }

    @Override
    public FetchType getDefaultFetch() {
        return this.defaultFetch;
    }

    protected void setDefaultFetch(FetchType fetch) {
        FetchType old = this.defaultFetch;
        this.defaultFetch = fetch;
        this.firePropertyChanged("defaultFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildDefaultFetch() {
        return DEFAULT_FETCH_TYPE;
    }

    @Override
    public boolean isOptional() {
        return this.specifiedOptional != null ? this.specifiedOptional.booleanValue() : this.isDefaultOptional();
    }

    @Override
    public Boolean getSpecifiedOptional() {
        return this.specifiedOptional;
    }

    @Override
    public void setSpecifiedOptional(Boolean optional) {
        this.setSpecifiedOptional_(optional);
        ((XmlBasic)this.xmlAttributeMapping).setOptional(optional);
    }

    protected void setSpecifiedOptional_(Boolean optional) {
        Boolean old = this.specifiedOptional;
        this.specifiedOptional = optional;
        this.firePropertyChanged("specifiedOptional", old, optional);
    }

    protected Boolean buildSpecifiedOptional() {
        return ((XmlBasic)this.xmlAttributeMapping).getOptional();
    }

    @Override
    public boolean isDefaultOptional() {
        return this.defaultOptional;
    }

    protected void setDefaultOptional(boolean optional) {
        boolean old = this.defaultOptional;
        this.defaultOptional = optional;
        this.firePropertyChanged("defaultOptional", old, optional);
    }

    protected boolean buildDefaultOptional() {
        return true;
    }

    @Override
    public OrmConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(Class<? extends Converter> converterType) {
        if (this.converter.getType() != converterType) {
            this.clearXmlConverterValues();
            OrmConverter.Adapter converterAdapter = this.getConverterAdapter(converterType);
            this.setConverter_(this.buildConverter(converterAdapter));
            this.converter.initialize();
        }
    }

    protected OrmConverter buildConverter(OrmConverter.Adapter converterAdapter) {
        return converterAdapter != null ? converterAdapter.buildNewConverter(this, this.getContextNodeFactory()) : this.buildNullConverter();
    }

    protected void setConverter_(OrmConverter converter) {
        OrmConverter old = this.converter;
        this.converter = converter;
        this.firePropertyChanged("converter", old, converter);
    }

    protected void clearXmlConverterValues() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            adapter.clearXmlValue(this.xmlAttributeMapping);
        }
    }

    protected OrmConverter buildConverter() {
        OrmXmlContextNodeFactory factory = this.getContextNodeFactory();
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            OrmConverter ormConverter = adapter.buildConverter(this, factory);
            if (ormConverter == null) continue;
            return ormConverter;
        }
        return this.buildNullConverter();
    }

    protected void syncConverter() {
        OrmConverter.Adapter adapter = this.getXmlConverterAdapter();
        if (adapter == null) {
            if (this.converter.getType() != null) {
                this.setConverter_(this.buildNullConverter());
            }
        } else if (this.converter.getType() == adapter.getConverterType()) {
            this.converter.synchronizeWithResourceModel();
        } else {
            this.setConverter_(adapter.buildNewConverter(this, this.getContextNodeFactory()));
        }
    }

    protected OrmConverter.Adapter getXmlConverterAdapter() {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (!adapter.isActive(this.xmlAttributeMapping)) continue;
            return adapter;
        }
        return null;
    }

    protected OrmConverter buildNullConverter() {
        return new NullOrmConverter(this);
    }

    protected OrmConverter.Adapter getConverterAdapter(Class<? extends Converter> converterType) {
        for (OrmConverter.Adapter adapter : this.getConverterAdapters()) {
            if (adapter.getConverterType() != converterType) continue;
            return adapter;
        }
        return null;
    }

    protected Iterable<OrmConverter.Adapter> getConverterAdapters() {
        return CONVERTER_ADAPTERS;
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public void initializeOn(OrmAttributeMapping newMapping) {
        newMapping.initializeFromOrmBasicMapping(this);
    }

    @Override
    protected void initializeFromOrmColumnMapping(OrmColumnMapping oldMapping) {
        super.initializeFromOrmColumnMapping(oldMapping);
        this.column.initializeFrom(oldMapping.getColumn());
    }

    @Override
    public int getXmlSequence() {
        return 20;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public void addXmlAttributeMappingTo(Attributes xmlAttributes) {
        xmlAttributes.getBasics().add((Object)((XmlBasic)this.xmlAttributeMapping));
    }

    @Override
    public void removeXmlAttributeMappingFrom(Attributes xmlAttributes) {
        xmlAttributes.getBasics().remove((Object)this.xmlAttributeMapping);
    }

    @Override
    public String getDefaultColumnName(ReadOnlyNamedColumn column) {
        return this.name;
    }

    @Override
    public String getDefaultTableName() {
        return this.getTypeMapping().getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        return this.getTypeMapping().resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        return this.getTypeMapping().tableNameIsInvalid(tableName);
    }

    @Override
    public Iterable<String> getCandidateTableNames() {
        return this.getTypeMapping().getAllAssociatedTableNames();
    }

    @Override
    public XmlColumn getXmlColumn() {
        return ((XmlBasic)this.xmlAttributeMapping).getColumn();
    }

    @Override
    public XmlColumn buildXmlColumn() {
        XmlColumn xmlColumn = OrmFactory.eINSTANCE.createXmlColumn();
        ((XmlBasic)this.xmlAttributeMapping).setColumn(xmlColumn);
        return xmlColumn;
    }

    @Override
    public void removeXmlColumn() {
        ((XmlBasic)this.xmlAttributeMapping).setColumn(null);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.column.validate(messages, reporter);
        this.converter.validate(messages, reporter);
    }

    @Override
    public JptValidator buildColumnValidator(ReadOnlyNamedColumn col, NamedColumnTextRangeResolver textRangeResolver) {
        return new NamedColumnValidator((ReadOnlyPersistentAttribute)this.getPersistentAttribute(), (ReadOnlyBaseColumn)col, (TableColumnTextRangeResolver)textRangeResolver, (AbstractNamedColumnValidator.TableDescriptionProvider)new EntityTableDescriptionProvider());
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.column.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.converter.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        return null;
    }
}

