/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmJoinColumnRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumnContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmJoinColumnRelationshipStrategy
extends AbstractOrmXmlContextNode
implements OrmJoinColumnRelationshipStrategy {
    protected final AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> specifiedJoinColumnContainer;
    protected final OrmReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmJoinColumn defaultJoinColumn;

    protected AbstractOrmJoinColumnRelationshipStrategy(OrmJoinColumnRelationship parent) {
        super(parent);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    protected XmlJoinColumnContainer getXmlJoinColumnContainer() {
        return this.getRelationship().getXmlContainer();
    }

    @Override
    public ListIterable<OrmJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public ListIterable<OrmJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public OrmJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public OrmJoinColumn addSpecifiedJoinColumn(int index) {
        XmlJoinColumn xmlJoinColumn = this.buildXmlJoinColumn();
        OrmJoinColumn joinColumn = (OrmJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, xmlJoinColumn);
        this.getXmlJoinColumnContainer().getJoinColumns().add(index, (Object)xmlJoinColumn);
        return joinColumn;
    }

    protected XmlJoinColumn buildXmlJoinColumn() {
        return OrmFactory.eINSTANCE.createXmlJoinColumn();
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOfContextElement((OrmJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        this.specifiedJoinColumnContainer.removeContextElement(index);
        this.getXmlJoinColumnContainer().getJoinColumns().remove(index);
    }

    @Override
    public void convertDefaultJoinColumnsToSpecified() {
        if (this.defaultJoinColumn == null) {
            throw new IllegalStateException("default  join column is null");
        }
        String columnName = this.defaultJoinColumn.getDefaultName();
        String referencedColumnName = this.defaultJoinColumn.getDefaultReferencedColumnName();
        OrmJoinColumn joinColumn = this.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName(columnName);
        joinColumn.setSpecifiedReferencedColumnName(referencedColumnName);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.clearContextList();
        this.getXmlJoinColumnContainer().getJoinColumns().clear();
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        this.specifiedJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
        this.getXmlJoinColumnContainer().getJoinColumns().move(targetIndex, sourceIndex);
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJoinColumn> getXmlJoinColumns() {
        return new LiveCloneListIterable(this.getXmlJoinColumnContainer().getJoinColumns());
    }

    protected AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> buildSpecifiedJoinColumnContainer() {
        SpecifiedJoinColumnContainer container = new SpecifiedJoinColumnContainer();
        container.initialize();
        return container;
    }

    protected abstract OrmReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    @Override
    public OrmJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmJoinColumn joinColumn) {
        OrmJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(null));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns() && this.getRelationship().mayHaveDefaultJoinColumn();
    }

    @Override
    public OrmJoinColumnRelationship getParent() {
        return (OrmJoinColumnRelationship)super.getParent();
    }

    @Override
    public OrmJoinColumnRelationship getRelationship() {
        return this.getParent();
    }

    protected OrmJoinColumn buildJoinColumn(XmlJoinColumn xmlJoinColumn) {
        return this.getContextNodeFactory().buildOrmJoinColumn(this, this.joinColumnOwner, xmlJoinColumn);
    }

    @Override
    public void initializeFrom(ReadOnlyJoinColumnRelationshipStrategy oldStrategy) {
        for (ReadOnlyJoinColumn joinColumn : oldStrategy.getSpecifiedJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinColumnRelationshipStrategy virtualStrategy) {
        for (ReadOnlyJoinColumn joinColumn : virtualStrategy.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected RelationshipMapping getRelationshipMapping() {
        return this.getRelationship().getMapping();
    }

    @Override
    public String getTableName() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.getPrimaryTableName();
    }

    @Override
    public Table resolveDbTable(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping == null ? null : typeMapping.resolveDbTable(tableName);
    }

    @Override
    public boolean tableNameIsInvalid(String tableName) {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null && typeMapping.tableNameIsInvalid(tableName);
    }

    public Table getReferencedColumnDbTable() {
        TypeMapping relationshipTarget = this.getRelationshipTarget();
        return relationshipTarget == null ? null : relationshipTarget.getPrimaryDbTable();
    }

    protected Iterable<String> getCandidateTableNames() {
        TypeMapping typeMapping = this.getRelationshipSource();
        return typeMapping != null ? typeMapping.getAllAssociatedTableNames() : EmptyIterable.instance();
    }

    @Override
    public void addStrategy() {
        if (this.getSpecifiedJoinColumnsSize() == 0) {
            this.addSpecifiedJoinColumn();
        }
    }

    @Override
    public void removeStrategy() {
        int i = this.getSpecifiedJoinColumnsSize();
        while (i-- > 0) {
            this.removeSpecifiedJoinColumn(i);
        }
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        for (OrmJoinColumn joinColumn : this.getJoinColumns()) {
            joinColumn.validate(messages, reporter);
        }
    }

    @Override
    public Iterable<String> getXmlCompletionProposals(int pos) {
        Iterable result = super.getXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmJoinColumn joinColumn : this.getJoinColumns()) {
            result = joinColumn.getXmlCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<OrmJoinColumn, XmlJoinColumn> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected OrmJoinColumn buildContextElement(XmlJoinColumn resourceElement) {
            return AbstractOrmJoinColumnRelationshipStrategy.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<XmlJoinColumn> getResourceElements() {
            return AbstractOrmJoinColumnRelationshipStrategy.this.getXmlJoinColumns();
        }

        @Override
        protected XmlJoinColumn getResourceElement(OrmJoinColumn contextElement) {
            return contextElement.getXmlColumn();
        }
    }
}

