/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SuperListIterableWrapper;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.VirtualReferenceTable;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmVirtualTable;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmVirtualReferenceTable<T extends ReadOnlyReferenceTable>
extends AbstractOrmVirtualTable<T>
implements VirtualReferenceTable {
    protected final AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> specifiedJoinColumnContainer;
    protected final OrmReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmVirtualJoinColumn defaultJoinColumn;

    protected AbstractOrmVirtualReferenceTable(XmlContextNode parent, ReadOnlyTable.Owner owner, T overridenTable) {
        super(parent, owner, overridenTable);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    public ListIterable<OrmVirtualJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    public ListIterable<OrmVirtualJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public OrmVirtualJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    protected void updateSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.update();
    }

    protected ListIterable<ReadOnlyJoinColumn> getOverriddenJoinColumns() {
        return new SuperListIterableWrapper(((ReadOnlyReferenceTable)this.getOverriddenTable()).getSpecifiedJoinColumns());
    }

    protected void moveSpecifiedJoinColumn(int index, OrmVirtualJoinColumn joinColumn) {
        this.specifiedJoinColumnContainer.moveContextElement(index, joinColumn);
    }

    protected OrmVirtualJoinColumn addSpecifiedJoinColumn(int index, ReadOnlyJoinColumn joinColumn) {
        return (OrmVirtualJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, joinColumn);
    }

    protected void removeSpecifiedJoinColumn(OrmVirtualJoinColumn joinColumn) {
        this.specifiedJoinColumnContainer.removeContextElement(joinColumn);
    }

    protected AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> buildSpecifiedJoinColumnContainer() {
        return new SpecifiedJoinColumnContainer();
    }

    @Override
    public OrmVirtualJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmVirtualJoinColumn joinColumn) {
        OrmVirtualJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmVirtualJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(((ReadOnlyReferenceTable)this.getOverriddenTable()).getDefaultJoinColumn()));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected OrmVirtualJoinColumn buildJoinColumn(ReadOnlyJoinColumn joinColumn) {
        return this.buildJoinColumn(this.joinColumnOwner, joinColumn);
    }

    protected OrmVirtualJoinColumn buildJoinColumn(OrmReadOnlyJoinColumn.Owner columnOwner, ReadOnlyJoinColumn joinColumn) {
        return this.getContextNodeFactory().buildOrmVirtualJoinColumn(this, columnOwner, joinColumn);
    }

    protected abstract OrmReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        boolean continueValidating = this.buildTableValidator().validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter) {
        this.validateNodes((Iterable<? extends XmlContextNode>)this.getJoinColumns(), messages, reporter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<OrmVirtualJoinColumn, ReadOnlyJoinColumn> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected OrmVirtualJoinColumn buildContextElement(ReadOnlyJoinColumn resourceElement) {
            return AbstractOrmVirtualReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<ReadOnlyJoinColumn> getResourceElements() {
            return AbstractOrmVirtualReferenceTable.this.getOverriddenJoinColumns();
        }

        @Override
        protected ReadOnlyJoinColumn getResourceElement(OrmVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }
    }
}

