/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.BodySourceWriter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NonEmptyStringFilter;
import org.eclipse.jpt.common.utility.internal.NotNullFilter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.AccessType;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.JpaNamedContextNode;
import org.eclipse.jpt.jpa.core.context.MappingFile;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitDefaults;
import org.eclipse.jpt.jpa.core.context.MappingFilePersistenceUnitMetadata;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.Query;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.orm.EntityMappings;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmQuery;
import org.eclipse.jpt.jpa.core.context.orm.OrmQueryContainer;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.JarFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitTransactionType;
import org.eclipse.jpt.jpa.core.context.persistence.PersistentTypeContainer;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.persistence.AbstractPersistenceXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpa2.JpaFactory2_0;
import org.eclipse.jpt.jpa.core.jpa2.JpaProject2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MappingFilePersistenceUnitDefaults2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelSourceType;
import org.eclipse.jpt.jpa.core.jpa2.context.PersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.PersistenceUnit2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.SharedCacheMode;
import org.eclipse.jpt.jpa.core.jpa2.context.persistence.options.ValidationMode;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJarFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperties;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnit
extends AbstractPersistenceXmlContextNode
implements PersistenceUnit2_0 {
    protected final XmlPersistenceUnit xmlPersistenceUnit;
    protected String name;
    protected Boolean specifiedExcludeUnlistedClasses;
    protected PersistenceUnitTransactionType specifiedTransactionType;
    protected PersistenceUnitTransactionType defaultTransactionType = PersistenceUnitTransactionType.JTA;
    protected String description;
    protected String provider;
    protected String jtaDataSource;
    protected String nonJtaDataSource;
    protected final Hashtable<String, PersistentType> persistentTypeMap = new Hashtable();
    protected final AbstractJpaNode.ContextListContainer<MappingFileRef, XmlMappingFileRef> specifiedMappingFileRefContainer;
    protected MappingFileRef impliedMappingFileRef;
    protected final MappingFileRef potentialImpliedMappingFileRef;
    protected final AbstractJpaNode.ContextListContainer<JarFileRef, XmlJarFileRef> jarFileRefContainer;
    protected final AbstractJpaNode.ContextListContainer<ClassRef, XmlJavaClassRef> specifiedClassRefContainer;
    protected final AbstractJpaNode.ContextCollectionContainer<ClassRef, String> impliedClassRefContainer;
    protected final AbstractJpaNode.ContextListContainer<PersistenceUnit.Property, XmlProperty> propertyContainer;
    protected final Vector<Generator> generators = new Vector();
    protected final Vector<Query> queries = new Vector();
    protected boolean xmlMappingMetadataComplete;
    protected AccessType defaultAccess;
    protected String defaultCatalog;
    protected String defaultSchema;
    protected boolean defaultCascadePersist;
    protected boolean defaultDelimitedIdentifiers;
    protected PersistenceUnitProperties connection;
    protected PersistenceUnitProperties options;
    protected SharedCacheMode specifiedSharedCacheMode;
    protected SharedCacheMode defaultSharedCacheMode;
    protected ValidationMode specifiedValidationMode;
    protected ValidationMode defaultValidationMode = DEFAULT_VALIDATION_MODE;
    protected final Set<IFile> metamodelFiles = Collections.synchronizedSet(new HashSet());

    protected AbstractPersistenceUnit(Persistence parent, XmlPersistenceUnit xmlPersistenceUnit) {
        super(parent);
        this.xmlPersistenceUnit = xmlPersistenceUnit;
        this.name = xmlPersistenceUnit.getName();
        this.specifiedExcludeUnlistedClasses = xmlPersistenceUnit.getExcludeUnlistedClasses();
        this.specifiedTransactionType = this.buildSpecifiedTransactionType();
        this.description = xmlPersistenceUnit.getDescription();
        this.provider = xmlPersistenceUnit.getProvider();
        this.jtaDataSource = xmlPersistenceUnit.getJtaDataSource();
        this.nonJtaDataSource = xmlPersistenceUnit.getNonJtaDataSource();
        this.propertyContainer = this.buildPropertyContainer();
        this.initializeProperties();
        this.specifiedMappingFileRefContainer = this.buildSpecifiedMappingFileRefContainer();
        this.potentialImpliedMappingFileRef = this.buildImpliedMappingFileRef();
        this.jarFileRefContainer = this.buildJarFileRefContainer();
        this.specifiedClassRefContainer = this.buildSpecifiedClassRefContainer();
        this.impliedClassRefContainer = this.buildImpliedClassRefContainer();
        this.specifiedSharedCacheMode = this.buildSpecifiedSharedCacheMode();
        this.specifiedValidationMode = this.buildSpecifiedValidationMode();
        this.initializeMetamodelFiles();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setName_(this.xmlPersistenceUnit.getName());
        this.setSpecifiedExcludeUnlistedClasses_(this.xmlPersistenceUnit.getExcludeUnlistedClasses());
        this.setSpecifiedTransactionType_(this.buildSpecifiedTransactionType());
        this.setDescription_(this.xmlPersistenceUnit.getDescription());
        this.setProvider_(this.xmlPersistenceUnit.getProvider());
        this.setJtaDataSource_(this.xmlPersistenceUnit.getJtaDataSource());
        this.setNonJtaDataSource_(this.xmlPersistenceUnit.getNonJtaDataSource());
        this.syncSpecifiedMappingFileRefs();
        this.syncImpliedMappingFileRef();
        this.syncJarFileRefs();
        this.syncSpecifiedClassRefs();
        this.synchronizeNodesWithResourceModel(this.getImpliedClassRefs());
        this.syncProperties();
        this.setSpecifiedSharedCacheMode_(this.buildSpecifiedSharedCacheMode());
        this.setSpecifiedValidationMode_(this.buildSpecifiedValidationMode());
    }

    @Override
    public void update() {
        super.update();
        this.rebuildPersistentTypeMap();
        this.setDefaultTransactionType(this.buildDefaultTransactionType());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedClassRefs());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedMappingFileRefs());
        this.updateImpliedMappingFileRef();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getJarFileRefs());
        this.updateImpliedClassRefs();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getProperties());
        this.updatePersistenceUnitMetadata();
        this.setGenerators(this.buildGenerators());
        this.setQueries(this.buildQueries());
        this.setDefaultSharedCacheMode(this.buildDefaultSharedCacheMode());
        this.setDefaultValidationMode(this.buildDefaultValidationMode());
    }

    @Override
    public Persistence getParent() {
        return (Persistence)super.getParent();
    }

    protected Persistence getPersistence() {
        return this.getParent();
    }

    @Override
    public PersistenceUnit getPersistenceUnit() {
        return this;
    }

    @Override
    public JpaStructureNode.ContextType getContextType() {
        return new JpaStructureNode.ContextType(this);
    }

    public Class<PersistenceUnit> getType() {
        return PersistenceUnit.class;
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.xmlPersistenceUnit.getSelectionTextRange();
    }

    @Override
    public void dispose() {
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.dispose();
        }
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            jarFileRef.dispose();
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.dispose();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlPersistenceUnit.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public PersistenceUnitTransactionType getTransactionType() {
        return this.specifiedTransactionType != null ? this.specifiedTransactionType : this.defaultTransactionType;
    }

    @Override
    public PersistenceUnitTransactionType getSpecifiedTransactionType() {
        return this.specifiedTransactionType;
    }

    @Override
    public void setSpecifiedTransactionType(PersistenceUnitTransactionType transactionType) {
        this.setSpecifiedTransactionType_(transactionType);
        this.xmlPersistenceUnit.setTransactionType(PersistenceUnitTransactionType.toXmlResourceModel(transactionType));
    }

    protected void setSpecifiedTransactionType_(PersistenceUnitTransactionType transactionType) {
        PersistenceUnitTransactionType old = this.specifiedTransactionType;
        this.specifiedTransactionType = transactionType;
        this.firePropertyChanged("specifiedTransactionType", (Object)old, (Object)transactionType);
    }

    @Override
    public PersistenceUnitTransactionType getDefaultTransactionType() {
        return this.defaultTransactionType;
    }

    protected void setDefaultTransactionType(PersistenceUnitTransactionType transactionType) {
        PersistenceUnitTransactionType old = this.defaultTransactionType;
        this.defaultTransactionType = transactionType;
        this.firePropertyChanged("defaultTransactionType", (Object)old, (Object)transactionType);
    }

    protected PersistenceUnitTransactionType buildSpecifiedTransactionType() {
        return PersistenceUnitTransactionType.fromXmlResourceModel(this.xmlPersistenceUnit.getTransactionType());
    }

    protected PersistenceUnitTransactionType buildDefaultTransactionType() {
        return PersistenceUnitTransactionType.JTA;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.setDescription_(description);
        this.xmlPersistenceUnit.setDescription(description);
    }

    protected void setDescription_(String description) {
        String old = this.description;
        this.description = description;
        this.firePropertyChanged("description", old, description);
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void setProvider(String provider) {
        this.setProvider_(provider);
        this.xmlPersistenceUnit.setProvider(provider);
    }

    protected void setProvider_(String provider) {
        String old = this.provider;
        this.provider = provider;
        this.firePropertyChanged("provider", old, provider);
    }

    @Override
    public String getJtaDataSource() {
        return this.jtaDataSource;
    }

    @Override
    public void setJtaDataSource(String jtaDataSource) {
        this.setJtaDataSource_(jtaDataSource);
        this.xmlPersistenceUnit.setJtaDataSource(jtaDataSource);
    }

    protected void setJtaDataSource_(String jtaDataSource) {
        String old = this.jtaDataSource;
        this.jtaDataSource = jtaDataSource;
        this.firePropertyChanged("jtaDataSource", old, jtaDataSource);
    }

    @Override
    public String getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    @Override
    public void setNonJtaDataSource(String nonJtaDataSource) {
        this.setNonJtaDataSource_(nonJtaDataSource);
        this.xmlPersistenceUnit.setNonJtaDataSource(nonJtaDataSource);
    }

    protected void setNonJtaDataSource_(String nonJtaDataSource) {
        String old = this.nonJtaDataSource;
        this.nonJtaDataSource = nonJtaDataSource;
        this.firePropertyChanged("nonJtaDataSource", old, nonJtaDataSource);
    }

    @Override
    public ListIterable<MappingFileRef> getMappingFileRefs() {
        return this.impliedMappingFileRef == null ? this.getSpecifiedMappingFileRefs() : this.getCombinedMappingFileRefs();
    }

    protected ListIterable<MappingFileRef> getCombinedMappingFileRefs() {
        return new CompositeListIterable(this.getSpecifiedMappingFileRefs(), (Object)this.impliedMappingFileRef);
    }

    @Override
    public int getMappingFileRefsSize() {
        return this.impliedMappingFileRef == null ? this.getSpecifiedMappingFileRefsSize() : this.getCombinedMappingFileRefsSize();
    }

    protected int getCombinedMappingFileRefsSize() {
        return this.getSpecifiedMappingFileRefsSize() + 1;
    }

    @Override
    public Iterable<MappingFileRef> getMappingFileRefsContaining(final String typeName) {
        return new FilteringIterable<MappingFileRef>(this.getMappingFileRefs()){

            protected boolean accept(MappingFileRef mappingFileRef) {
                return mappingFileRef.getPersistentType(typeName) != null;
            }
        };
    }

    protected Iterable<MappingFile> getMappingFiles() {
        return new FilteringIterable(this.getMappingFiles_(), NotNullFilter.instance());
    }

    protected Iterable<MappingFile> getMappingFiles_() {
        return new TransformationIterable<MappingFileRef, MappingFile>(this.getMappingFileRefs()){

            protected MappingFile transform(MappingFileRef ref) {
                return ref.getMappingFile();
            }
        };
    }

    @Override
    public ListIterable<MappingFileRef> getSpecifiedMappingFileRefs() {
        return this.specifiedMappingFileRefContainer.getContextElements();
    }

    @Override
    public int getSpecifiedMappingFileRefsSize() {
        return this.specifiedMappingFileRefContainer.getContextElementsSize();
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(String fileName) {
        return this.addSpecifiedMappingFileRef(this.getSpecifiedMappingFileRefsSize(), fileName);
    }

    @Override
    public MappingFileRef addSpecifiedMappingFileRef(int index, String fileName) {
        XmlMappingFileRef xmlMappingFileRef = this.buildXmlMappingFileRef(fileName);
        MappingFileRef mappingFileRef = (MappingFileRef)this.specifiedMappingFileRefContainer.addContextElement(index, xmlMappingFileRef);
        this.xmlPersistenceUnit.getMappingFiles().add(index, (Object)xmlMappingFileRef);
        return mappingFileRef;
    }

    protected XmlMappingFileRef buildXmlMappingFileRef(String fileName) {
        XmlMappingFileRef ref = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        ref.setFileName(fileName);
        return ref;
    }

    protected MappingFileRef buildSpecifiedMappingFileRef(XmlMappingFileRef xmlMappingFileRef) {
        return this.getContextNodeFactory().buildMappingFileRef(this, xmlMappingFileRef);
    }

    @Override
    public void removeSpecifiedMappingFileRef(MappingFileRef mappingFileRef) {
        this.removeSpecifiedMappingFileRef(this.specifiedMappingFileRefContainer.indexOfContextElement(mappingFileRef));
    }

    @Override
    public void removeSpecifiedMappingFileRef(int index) {
        this.removeSpecifiedMappingFileRef_(index);
        this.xmlPersistenceUnit.getMappingFiles().remove(index);
    }

    protected void removeSpecifiedMappingFileRef_(int index) {
        this.specifiedMappingFileRefContainer.removeContextElement(index).dispose();
    }

    protected void syncSpecifiedMappingFileRefs() {
        this.specifiedMappingFileRefContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlMappingFileRef> getXmlMappingFileRefs() {
        return new LiveCloneListIterable(this.xmlPersistenceUnit.getMappingFiles());
    }

    protected AbstractJpaNode.ContextListContainer<MappingFileRef, XmlMappingFileRef> buildSpecifiedMappingFileRefContainer() {
        SpecifiedMappingFileRefContainer container = new SpecifiedMappingFileRefContainer();
        container.initialize();
        return container;
    }

    @Override
    public MappingFileRef getImpliedMappingFileRef() {
        return this.impliedMappingFileRef;
    }

    protected void setImpliedMappingFileRef(MappingFileRef mappingFileRef) {
        MappingFileRef old = this.impliedMappingFileRef;
        this.impliedMappingFileRef = mappingFileRef;
        this.firePropertyChanged("impliedMappingFileRef", old, mappingFileRef);
    }

    protected MappingFileRef buildImpliedMappingFileRef() {
        return this.getContextNodeFactory().buildImpliedMappingFileRef(this);
    }

    protected void syncImpliedMappingFileRef() {
        this.potentialImpliedMappingFileRef.synchronizeWithResourceModel();
    }

    protected void updateImpliedMappingFileRef() {
        if (this.usesImpliedMappingFile()) {
            this.setImpliedMappingFileRef(this.potentialImpliedMappingFileRef);
            this.impliedMappingFileRef.update();
        } else if (this.impliedMappingFileRef != null) {
            this.impliedMappingFileRef.dispose();
            this.setImpliedMappingFileRef(null);
        }
    }

    protected boolean usesImpliedMappingFile() {
        return this.impliedMappingFileIsNotSpecified() && this.impliedMappingFileExists();
    }

    protected boolean impliedMappingFileIsNotSpecified() {
        return !this.impliedMappingFileIsSpecified();
    }

    protected boolean impliedMappingFileIsSpecified() {
        return this.mappingFileIsSpecified(JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.toString());
    }

    protected boolean mappingFileIsSpecified(String impliedMappingFileName) {
        for (MappingFileRef specifiedMappingFileRef : this.getSpecifiedMappingFileRefs()) {
            if (!Tools.valuesAreEqual((Object)specifiedMappingFileRef.getFileName(), (Object)impliedMappingFileName)) continue;
            return true;
        }
        return false;
    }

    protected boolean impliedMappingFileExists() {
        return this.getJpaProject().getDefaultOrmXmlResource() != null;
    }

    @Override
    public ListIterable<JarFileRef> getJarFileRefs() {
        return this.jarFileRefContainer.getContextElements();
    }

    @Override
    public int getJarFileRefsSize() {
        return this.jarFileRefContainer.getContextElementsSize();
    }

    @Override
    public JarFileRef addJarFileRef(String fileName) {
        return this.addJarFileRef(this.getJarFileRefsSize(), fileName);
    }

    @Override
    public JarFileRef addJarFileRef(int index, String fileName) {
        XmlJarFileRef xmlJarFileRef = this.buildXmlJarFileRef(fileName);
        JarFileRef jarFileRef = (JarFileRef)this.jarFileRefContainer.addContextElement(index, xmlJarFileRef);
        this.xmlPersistenceUnit.getJarFiles().add(index, (Object)xmlJarFileRef);
        return jarFileRef;
    }

    protected XmlJarFileRef buildXmlJarFileRef(String fileName) {
        XmlJarFileRef ref = PersistenceFactory.eINSTANCE.createXmlJarFileRef();
        ref.setFileName(fileName);
        return ref;
    }

    protected JarFileRef buildJarFileRef(XmlJarFileRef xmlJarFileRef) {
        return this.getContextNodeFactory().buildJarFileRef(this, xmlJarFileRef);
    }

    @Override
    public void removeJarFileRef(JarFileRef jarFileRef) {
        this.removeJarFileRef(this.jarFileRefContainer.indexOfContextElement(jarFileRef));
    }

    @Override
    public void removeJarFileRef(int index) {
        this.removeJarFileRef_(index);
        this.xmlPersistenceUnit.getJarFiles().remove(index);
    }

    protected void removeJarFileRef_(int index) {
        this.jarFileRefContainer.removeContextElement(index).dispose();
    }

    protected void syncJarFileRefs() {
        this.jarFileRefContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJarFileRef> getXmlJarFileRefs() {
        return new LiveCloneListIterable(this.xmlPersistenceUnit.getJarFiles());
    }

    protected AbstractJpaNode.ContextListContainer<JarFileRef, XmlJarFileRef> buildJarFileRefContainer() {
        JarFileRefContainer container = new JarFileRefContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<ClassRef> getClassRefs() {
        return new CompositeIterable(new Iterable[]{this.getSpecifiedClassRefs(), this.getImpliedClassRefs()});
    }

    @Override
    public int getClassRefsSize() {
        return this.getSpecifiedClassRefsSize() + this.getImpliedClassRefsSize();
    }

    @Override
    public ListIterable<ClassRef> getSpecifiedClassRefs() {
        return this.specifiedClassRefContainer.getContextElements();
    }

    @Override
    public int getSpecifiedClassRefsSize() {
        return this.specifiedClassRefContainer.getContextElementsSize();
    }

    @Override
    public ClassRef addSpecifiedClassRef(String className) {
        return this.addSpecifiedClassRef(this.getSpecifiedClassRefsSize(), className);
    }

    @Override
    public ClassRef addSpecifiedClassRef(int index, String className) {
        XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef(className);
        ClassRef classRef = (ClassRef)this.specifiedClassRefContainer.addContextElement(index, xmlClassRef);
        this.xmlPersistenceUnit.getClasses().add(index, (Object)xmlClassRef);
        return classRef;
    }

    protected Iterable<ClassRef> addSpecifiedClassRefs(Iterable<String> classNames) {
        return this.addSpecifiedClassRefs(this.getSpecifiedClassRefsSize(), classNames);
    }

    protected Iterable<ClassRef> addSpecifiedClassRefs(int index, Iterable<String> classNames) {
        ArrayList<XmlJavaClassRef> xmlClassRefs = new ArrayList<XmlJavaClassRef>();
        for (String className : classNames) {
            xmlClassRefs.add(this.buildXmlJavaClassRef(className));
        }
        Iterable<ClassRef> classRefs = this.specifiedClassRefContainer.addContextElements(index, xmlClassRefs);
        this.xmlPersistenceUnit.getClasses().addAll(index, xmlClassRefs);
        return classRefs;
    }

    protected XmlJavaClassRef buildXmlJavaClassRef(String className) {
        XmlJavaClassRef ref = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        ref.setJavaClass(className);
        return ref;
    }

    protected ClassRef buildClassRef(XmlJavaClassRef xmlClassRef) {
        return this.getContextNodeFactory().buildClassRef((PersistenceUnit)this, xmlClassRef);
    }

    @Override
    public void removeSpecifiedClassRef(ClassRef classRef) {
        this.removeSpecifiedClassRef(this.specifiedClassRefContainer.indexOfContextElement(classRef));
    }

    @Override
    public void removeSpecifiedClassRef(int index) {
        this.removeSpecifiedClassRef_(index);
        this.xmlPersistenceUnit.getClasses().remove(index);
    }

    protected void removeSpecifiedClassRef_(int index) {
        this.specifiedClassRefContainer.removeContextElement(index).dispose();
    }

    protected void removeSpecifiedClassRefs(Iterable<ClassRef> classRefs) {
        ArrayList<XmlJavaClassRef> xmlClassRefs = new ArrayList<XmlJavaClassRef>();
        for (ClassRef classRef : classRefs) {
            xmlClassRefs.add(classRef.getXmlClassRef());
        }
        this.specifiedClassRefContainer.removeAll(classRefs);
        for (ClassRef classRef : classRefs) {
            classRef.dispose();
        }
        this.xmlPersistenceUnit.getClasses().removeAll(xmlClassRefs);
    }

    protected void syncSpecifiedClassRefs() {
        this.specifiedClassRefContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlJavaClassRef> getXmlClassRefs() {
        return new LiveCloneListIterable(this.xmlPersistenceUnit.getClasses());
    }

    protected AbstractJpaNode.ContextListContainer<ClassRef, XmlJavaClassRef> buildSpecifiedClassRefContainer() {
        SpecifiedClassRefContainer container = new SpecifiedClassRefContainer();
        container.initialize();
        return container;
    }

    @Override
    public Iterable<ClassRef> getImpliedClassRefs() {
        return this.impliedClassRefContainer.getContextElements();
    }

    @Override
    public int getImpliedClassRefsSize() {
        return this.impliedClassRefContainer.getContextElementsSize();
    }

    protected ClassRef addImpliedClassRef(String className) {
        return (ClassRef)this.impliedClassRefContainer.addContextElement(this.getImpliedClassRefsSize(), className);
    }

    protected ClassRef buildClassRef(String className) {
        return this.getContextNodeFactory().buildClassRef((PersistenceUnit)this, className);
    }

    protected void updateImpliedClassRefs() {
        this.impliedClassRefContainer.update();
    }

    protected Iterable<String> getImpliedClassNames() {
        return this.excludesUnlistedClasses() ? EmptyIterable.instance() : this.getImpliedClassNames_();
    }

    protected Iterable<String> getImpliedClassNames_() {
        return new FilteringIterable<String>(this.getJpaProject().getMappedJavaSourceClassNames()){

            protected boolean accept(String mappedClassName) {
                return !AbstractPersistenceUnit.this.specifiesPersistentType(mappedClassName);
            }
        };
    }

    protected AbstractJpaNode.ContextCollectionContainer<ClassRef, String> buildImpliedClassRefContainer() {
        return new ImpliedClassRefContainer();
    }

    @Override
    public boolean excludesUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses != null ? this.specifiedExcludeUnlistedClasses.booleanValue() : this.getDefaultExcludeUnlistedClasses();
    }

    @Override
    public Boolean getSpecifiedExcludeUnlistedClasses() {
        return this.specifiedExcludeUnlistedClasses;
    }

    @Override
    public void setSpecifiedExcludeUnlistedClasses(Boolean specifiedExcludeUnlistedClasses) {
        this.setSpecifiedExcludeUnlistedClasses_(specifiedExcludeUnlistedClasses);
        this.xmlPersistenceUnit.setExcludeUnlistedClasses(this.specifiedExcludeUnlistedClasses);
    }

    protected void setSpecifiedExcludeUnlistedClasses_(Boolean excludeUnlistedClasses) {
        Boolean old = this.specifiedExcludeUnlistedClasses;
        this.specifiedExcludeUnlistedClasses = excludeUnlistedClasses;
        this.firePropertyChanged("specifiedExcludeUnlistedClasses", old, excludeUnlistedClasses);
    }

    @Override
    public boolean getDefaultExcludeUnlistedClasses() {
        return false;
    }

    @Override
    public ListIterable<PersistenceUnit.Property> getProperties() {
        return this.propertyContainer.getContextElements();
    }

    @Override
    public int getPropertiesSize() {
        return this.propertyContainer.getContextElementsSize();
    }

    @Override
    public PersistenceUnit.Property getProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    @Override
    public Iterable<PersistenceUnit.Property> getPropertiesNamed(final String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        return new FilteringIterable<PersistenceUnit.Property>(this.getProperties()){

            protected boolean accept(PersistenceUnit.Property property) {
                return Tools.valuesAreEqual((Object)property.getName(), (Object)propertyName);
            }
        };
    }

    @Override
    public Iterable<PersistenceUnit.Property> getPropertiesWithNamePrefix(final String propertyNamePrefix) {
        if (propertyNamePrefix == null) {
            throw new NullPointerException();
        }
        return new FilteringIterable<PersistenceUnit.Property>(this.getProperties()){

            protected boolean accept(PersistenceUnit.Property property) {
                String pName = property.getName();
                return pName != null && pName.startsWith(propertyNamePrefix);
            }
        };
    }

    @Override
    public PersistenceUnit.Property addProperty() {
        return this.addProperty(this.getPropertiesSize());
    }

    @Override
    public PersistenceUnit.Property addProperty(int index) {
        XmlProperty xmlProperty = this.buildXmlProperty();
        PersistenceUnit.Property property = this.addProperty_(index, xmlProperty);
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        if (xmlProperties == null) {
            xmlProperties = this.buildXmlProperties();
            this.xmlPersistenceUnit.setProperties(xmlProperties);
        }
        xmlProperties.getProperties().add(index, (Object)xmlProperty);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected XmlProperty buildXmlProperty() {
        return PersistenceFactory.eINSTANCE.createXmlProperty();
    }

    protected PersistenceUnit.Property buildProperty(XmlProperty xmlProperty) {
        return this.getContextNodeFactory().buildProperty(this, xmlProperty);
    }

    protected XmlProperties buildXmlProperties() {
        return PersistenceFactory.eINSTANCE.createXmlProperties();
    }

    @Override
    public void setProperty(String propertyName, String value) {
        this.setProperty(propertyName, value, false);
    }

    @Override
    public void setProperty(String propertyName, String value, boolean duplicatePropertyNamesAllowed) {
        PersistenceUnit.Property prev = this.getProperty(propertyName);
        if (prev == null) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (duplicatePropertyNamesAllowed) {
            if (value != null) {
                this.addProperty(propertyName, value);
            }
        } else if (value == null) {
            this.removeProperty(prev);
        } else {
            prev.setValue(value);
        }
    }

    protected void addProperty(String propertyName, String value) {
        PersistenceUnit.Property property = this.addProperty();
        property.setName(propertyName);
        property.setValue(value);
    }

    @Override
    public void removeProperty(PersistenceUnit.Property property) {
        this.removeProperty(this.propertyContainer.indexOfContextElement(property));
    }

    @Override
    public void removeProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName())) continue;
            this.removeProperty(property);
            return;
        }
        throw new IllegalArgumentException("invalid property name: " + propertyName);
    }

    @Override
    public void removeProperty(String propertyName, String value) {
        if (propertyName == null || value == null) {
            throw new NullPointerException();
        }
        for (PersistenceUnit.Property property : this.getProperties()) {
            if (!propertyName.equals(property.getName()) || !value.equals(property.getValue())) continue;
            this.removeProperty(property);
            return;
        }
        throw new IllegalArgumentException("invalid property name/value pair: " + propertyName + " = " + value);
    }

    protected void removeProperty(int index) {
        PersistenceUnit.Property removedProperty = this.propertyContainer.removeContextElement(index);
        this.xmlPersistenceUnit.getProperties().getProperties().remove(index);
        if (this.xmlPersistenceUnit.getProperties().getProperties().isEmpty()) {
            this.xmlPersistenceUnit.setProperties(null);
        }
        if (removedProperty.getName() != null) {
            this.propertyRemoved(removedProperty.getName());
        }
    }

    @Override
    public void propertyNameChanged(String oldPropertyName, String newPropertyName, String value) {
        if (oldPropertyName == null && value == null) {
            return;
        }
        if (oldPropertyName != null) {
            this.propertyRemoved(oldPropertyName);
        }
        if (newPropertyName != null) {
            this.propertyAdded(newPropertyName, value);
        }
    }

    @Override
    public void propertyValueChanged(String propertyName, String newValue) {
        this.connection.propertyValueChanged(propertyName, newValue);
        this.options.propertyValueChanged(propertyName, newValue);
    }

    protected void propertyAdded(String propertyName, String value) {
        this.propertyValueChanged(propertyName, value);
    }

    protected void propertyRemoved(String propertyName) {
        this.connection.propertyRemoved(propertyName);
        this.options.propertyRemoved(propertyName);
    }

    protected void initializeProperties() {
        this.connection = this.getContextNodeFactory().buildConnection(this);
        this.options = this.getContextNodeFactory().buildOptions(this);
    }

    protected void syncProperties() {
        this.propertyContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<XmlProperty> getXmlProperties() {
        XmlProperties xmlProperties = this.xmlPersistenceUnit.getProperties();
        return xmlProperties == null ? EmptyListIterable.instance() : new LiveCloneListIterable(xmlProperties.getProperties());
    }

    protected PersistenceUnit.Property addProperty_(int index, XmlProperty xmlProperty) {
        PersistenceUnit.Property property = (PersistenceUnit.Property)this.propertyContainer.addContextElement(index, xmlProperty);
        if (property.getName() != null) {
            this.propertyAdded(property.getName(), property.getValue());
        }
        return property;
    }

    protected void removeProperty_(PersistenceUnit.Property property) {
        this.propertyContainer.removeContextElement(property);
        if (property.getName() != null) {
            this.propertyRemoved(property.getName());
        }
    }

    protected AbstractJpaNode.ContextListContainer<PersistenceUnit.Property, XmlProperty> buildPropertyContainer() {
        PropertyContainer container = new PropertyContainer();
        container.initialize();
        return container;
    }

    @Override
    public boolean isXmlMappingMetadataComplete() {
        return this.xmlMappingMetadataComplete;
    }

    protected void setXmlMappingMetadataComplete(boolean xmlMappingMetadataComplete) {
        boolean old = this.xmlMappingMetadataComplete;
        this.xmlMappingMetadataComplete = xmlMappingMetadataComplete;
        this.firePropertyChanged("xmlMappingMetadataComplete", old, xmlMappingMetadataComplete);
    }

    protected boolean buildXmlMappingMetadataComplete(MappingFilePersistenceUnitMetadata metadata) {
        return metadata == null ? false : metadata.isXmlMappingMetadataComplete();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType access) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = access;
        this.firePropertyChanged("defaultAccess", old, access);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog(MappingFilePersistenceUnitDefaults defaults) {
        String catalog = defaults == null ? null : defaults.getCatalog();
        return catalog != null ? catalog : this.getJpaProject().getDefaultCatalog();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema(MappingFilePersistenceUnitDefaults defaults) {
        String schema = defaults == null ? null : defaults.getSchema();
        return schema != null ? schema : this.getJpaProject().getDefaultSchema();
    }

    @Override
    public boolean getDefaultCascadePersist() {
        return this.defaultCascadePersist;
    }

    protected void setDefaultCascadePersist(boolean cascadePersist) {
        boolean old = this.defaultCascadePersist;
        this.defaultCascadePersist = cascadePersist;
        this.firePropertyChanged("defaultCascadePersist", old, cascadePersist);
    }

    protected boolean buildDefaultCascadePersist(MappingFilePersistenceUnitDefaults defaults) {
        return defaults == null ? false : defaults.isCascadePersist();
    }

    @Override
    public boolean getDefaultDelimitedIdentifiers() {
        return this.defaultDelimitedIdentifiers;
    }

    protected void setDefaultDelimitedIdentifiers(boolean delimitedIdentifiers) {
        boolean old = this.defaultDelimitedIdentifiers;
        this.defaultDelimitedIdentifiers = delimitedIdentifiers;
        this.firePropertyChanged("defaultDelimitedIdentifiers", old, delimitedIdentifiers);
    }

    protected boolean buildDefaultDelimitedIdentifiers(MappingFilePersistenceUnitDefaults defaults) {
        return !this.isJpa2_0Compatible() ? false : (defaults == null ? false : ((MappingFilePersistenceUnitDefaults2_0)defaults).isDelimitedIdentifiers());
    }

    protected void updatePersistenceUnitMetadata() {
        MappingFilePersistenceUnitMetadata metadata = this.getMetadata();
        this.setXmlMappingMetadataComplete(this.buildXmlMappingMetadataComplete(metadata));
        MappingFilePersistenceUnitDefaults defaults = metadata == null ? null : metadata.getPersistenceUnitDefaults();
        this.setDefaultAccess(defaults == null ? null : defaults.getAccess());
        this.setDefaultCatalog(this.buildDefaultCatalog(defaults));
        this.setDefaultSchema(this.buildDefaultSchema(defaults));
        this.setDefaultDelimitedIdentifiers(this.buildDefaultDelimitedIdentifiers(defaults));
    }

    protected MappingFilePersistenceUnitMetadata getMetadata() {
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.persistenceUnitMetadataExists()) continue;
            return mappingFileRef.getPersistenceUnitMetadata();
        }
        return null;
    }

    @Override
    public PersistenceUnitProperties getConnection() {
        return this.connection;
    }

    @Override
    public PersistenceUnitProperties getOptions() {
        return this.options;
    }

    @Override
    public SharedCacheMode getSharedCacheMode() {
        return this.specifiedSharedCacheMode != null ? this.specifiedSharedCacheMode : this.defaultSharedCacheMode;
    }

    @Override
    public SharedCacheMode getSpecifiedSharedCacheMode() {
        return this.specifiedSharedCacheMode;
    }

    @Override
    public void setSpecifiedSharedCacheMode(SharedCacheMode specifiedSharedCacheMode) {
        this.setSpecifiedSharedCacheMode_(specifiedSharedCacheMode);
        this.xmlPersistenceUnit.setSharedCacheMode(SharedCacheMode.toXmlResourceModel(specifiedSharedCacheMode));
    }

    protected void setSpecifiedSharedCacheMode_(SharedCacheMode sharedCacheMode) {
        SharedCacheMode old = this.specifiedSharedCacheMode;
        this.specifiedSharedCacheMode = sharedCacheMode;
        this.firePropertyChanged("specifiedSharedCacheMode", (Object)old, (Object)sharedCacheMode);
    }

    @Override
    public SharedCacheMode getDefaultSharedCacheMode() {
        return this.defaultSharedCacheMode;
    }

    protected void setDefaultSharedCacheMode(SharedCacheMode defaultSharedCacheMode) {
        SharedCacheMode old = this.defaultSharedCacheMode;
        this.defaultSharedCacheMode = defaultSharedCacheMode;
        this.firePropertyChanged("defaultSharedCacheMode", (Object)old, (Object)defaultSharedCacheMode);
    }

    @Override
    public boolean calculateDefaultCacheable() {
        SharedCacheMode sharedCacheMode = this.getSharedCacheMode();
        if (sharedCacheMode == null) {
            return false;
        }
        switch (sharedCacheMode) {
            case NONE: 
            case ENABLE_SELECTIVE: 
            case UNSPECIFIED: {
                return false;
            }
            case ALL: 
            case DISABLE_SELECTIVE: {
                return true;
            }
        }
        throw new IllegalStateException("unknown mode: " + (Object)((Object)sharedCacheMode));
    }

    protected SharedCacheMode buildSpecifiedSharedCacheMode() {
        return SharedCacheMode.fromXmlResourceModel(this.xmlPersistenceUnit.getSharedCacheMode());
    }

    protected SharedCacheMode buildDefaultSharedCacheMode() {
        return SharedCacheMode.UNSPECIFIED;
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.specifiedValidationMode != null ? this.specifiedValidationMode : this.defaultValidationMode;
    }

    @Override
    public ValidationMode getSpecifiedValidationMode() {
        return this.specifiedValidationMode;
    }

    @Override
    public void setSpecifiedValidationMode(ValidationMode specifiedValidationMode) {
        this.setSpecifiedValidationMode_(specifiedValidationMode);
        this.xmlPersistenceUnit.setValidationMode(ValidationMode.toXmlResourceModel(specifiedValidationMode));
    }

    protected void setSpecifiedValidationMode_(ValidationMode validationMode) {
        ValidationMode old = this.specifiedValidationMode;
        this.specifiedValidationMode = validationMode;
        this.firePropertyChanged("specifiedValidationMode", (Object)old, (Object)validationMode);
    }

    @Override
    public ValidationMode getDefaultValidationMode() {
        return this.defaultValidationMode;
    }

    protected void setDefaultValidationMode(ValidationMode defaultValidationMode) {
        ValidationMode old = this.defaultValidationMode;
        this.defaultValidationMode = defaultValidationMode;
        this.firePropertyChanged("defaultValidationMode", (Object)old, (Object)defaultValidationMode);
    }

    protected ValidationMode buildSpecifiedValidationMode() {
        return ValidationMode.fromXmlResourceModel(this.xmlPersistenceUnit.getValidationMode());
    }

    protected ValidationMode buildDefaultValidationMode() {
        return DEFAULT_VALIDATION_MODE;
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return new LiveCloneIterable(this.generators);
    }

    @Override
    public int getGeneratorsSize() {
        return this.generators.size();
    }

    @Override
    public Iterable<String> getUniqueGeneratorNames() {
        return CollectionTools.set(this.getNonEmptyGeneratorNames(), (int)this.getGeneratorsSize());
    }

    protected Iterable<String> getNonEmptyGeneratorNames() {
        return new FilteringIterable(this.getGeneratorNames(), NonEmptyStringFilter.instance());
    }

    /*
     * Exception decompiling
     */
    protected Iterable<String> getGeneratorNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractConstructorInvokation.applyExpressionRewriter(AbstractConstructorInvokation.java:65)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:73)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setGenerators(Iterable<Generator> generators) {
        this.synchronizeCollection(generators, this.generators, "generators");
    }

    protected Iterable<Generator> buildGenerators() {
        ArrayList result = CollectionTools.list(this.getMappingFileGenerators());
        HashSet<String> mappingFileGeneratorNames = this.convertToNames(result);
        HashMap<String, ArrayList<JavaGenerator>> allJavaGenerators = this.mapByName(this.getAllJavaGenerators());
        for (Map.Entry<String, ArrayList<JavaGenerator>> entry : allJavaGenerators.entrySet()) {
            if (mappingFileGeneratorNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<Generator> getMappingFileGenerators() {
        return new CompositeIterable(this.getMappingFileGeneratorLists());
    }

    protected Iterable<Iterable<Generator>> getMappingFileGeneratorLists() {
        return new TransformationIterable<MappingFileRef, Iterable<Generator>>(this.getMappingFileRefs()){

            protected Iterable<Generator> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.getMappingFileGenerators();
            }
        };
    }

    protected Iterable<JavaGenerator> getAllJavaGenerators() {
        return new CompositeIterable(this.getAllJavaTypeMappingGeneratorLists());
    }

    protected Iterable<Iterable<JavaGenerator>> getAllJavaTypeMappingGeneratorLists() {
        return new TransformationIterable<TypeMapping, Iterable<JavaGenerator>>(this.getAllJavaTypeMappingsUnique()){

            protected Iterable<JavaGenerator> transform(TypeMapping typeMapping) {
                return new SubIterableWrapper(this.transform_(typeMapping));
            }

            protected Iterable<Generator> transform_(TypeMapping typeMapping) {
                return typeMapping.getGenerators();
            }
        };
    }

    @Override
    public boolean hasConvertibleJavaGenerators() {
        return !this.getConvertibleJavaGenerators().isEmpty();
    }

    @Override
    public void convertJavaGenerators(EntityMappings entityMappings, IProgressMonitor monitor) {
        ArrayList<JavaGenerator> convertibleJavaGenerators = this.getConvertibleJavaGenerators();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JptCoreMessages.JAVA_METADATA_CONVERSION_IN_PROGRESS, (int)convertibleJavaGenerators.size());
        for (JavaGenerator generator : convertibleJavaGenerators) {
            this.convertJavaGenerator(entityMappings, generator, subMonitor.newChild(1));
        }
        subMonitor.setTaskName(JptCoreMessages.JAVA_METADATA_CONVERSION_COMPLETE);
    }

    protected void convertJavaGenerator(EntityMappings entityMappings, JavaGenerator generator, SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(JptCoreMessages.JAVA_METADATA_CONVERSION_CANCELED);
        }
        monitor.setTaskName(NLS.bind((String)JptCoreMessages.JAVA_METADATA_CONVERSION_CONVERT_GENERATOR, (Object)generator.getName()));
        generator.convertTo(entityMappings);
        generator.delete();
    }

    protected ArrayList<JavaGenerator> getConvertibleJavaGenerators() {
        return this.extractConvertibleJavaNodes(this.getAllJavaGenerators(), this.getMappingFileGenerators());
    }

    @Override
    public Iterable<Query> getQueries() {
        return new LiveCloneIterable(this.queries);
    }

    @Override
    public int getQueriesSize() {
        return this.queries.size();
    }

    @Override
    public void addQuery(Query query) {
        this.queries.add(query);
    }

    protected void setQueries(Iterable<Query> queries) {
        this.synchronizeCollection(queries, this.queries, "queries");
    }

    protected Iterable<Query> buildQueries() {
        ArrayList result = CollectionTools.list(this.getMappingFileQueries());
        HashSet<String> mappingFileQueryNames = this.convertToNames(result);
        HashMap<String, ArrayList<JavaQuery>> allJavaQueries = this.mapByName(this.getAllJavaQueries());
        for (Map.Entry<String, ArrayList<JavaQuery>> entry : allJavaQueries.entrySet()) {
            if (mappingFileQueryNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<Query> getMappingFileQueries() {
        return new CompositeIterable(this.getMappingFileQueryLists());
    }

    protected Iterable<Iterable<Query>> getMappingFileQueryLists() {
        return new TransformationIterable<MappingFileRef, Iterable<Query>>(this.getMappingFileRefs()){

            protected Iterable<Query> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.getMappingFileQueries();
            }
        };
    }

    protected Iterable<JavaQuery> getAllJavaQueries() {
        return new CompositeIterable(this.getAllJavaTypeMappingQueryLists());
    }

    protected Iterable<Iterable<JavaQuery>> getAllJavaTypeMappingQueryLists() {
        return new TransformationIterable<TypeMapping, Iterable<JavaQuery>>(this.getAllJavaTypeMappingsUnique()){

            protected Iterable<JavaQuery> transform(TypeMapping typeMapping) {
                return new SubIterableWrapper(this.transform_(typeMapping));
            }

            protected Iterable<Query> transform_(TypeMapping typeMapping) {
                return typeMapping.getQueries();
            }
        };
    }

    protected Iterable<TypeMapping> getAllJavaTypeMappingsUnique() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getAllJavaPersistentTypesUnique()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    @Override
    public boolean hasConvertibleJavaQueries() {
        return !this.getConvertibleJavaQueries().isEmpty();
    }

    @Override
    public void convertJavaQueries(EntityMappings entityMappings, IProgressMonitor monitor) {
        OrmQueryContainer queryContainer = entityMappings.getQueryContainer();
        ArrayList<JavaQuery> convertibleJavaQueries = this.getConvertibleJavaQueries();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)JptCoreMessages.JAVA_METADATA_CONVERSION_IN_PROGRESS, (int)convertibleJavaQueries.size());
        for (JavaQuery query : convertibleJavaQueries) {
            this.convertJavaQuery(queryContainer, query, subMonitor.newChild(1));
        }
        subMonitor.setTaskName(JptCoreMessages.JAVA_METADATA_CONVERSION_COMPLETE);
    }

    protected void convertJavaQuery(OrmQueryContainer queryContainer, JavaQuery query, SubMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(JptCoreMessages.JAVA_METADATA_CONVERSION_CANCELED);
        }
        monitor.setTaskName(NLS.bind((String)JptCoreMessages.JAVA_METADATA_CONVERSION_CONVERT_QUERY, (Object)query.getName()));
        query.convertTo(queryContainer);
        query.delete();
    }

    protected ArrayList<JavaQuery> getConvertibleJavaQueries() {
        return this.extractConvertibleJavaNodes(this.getAllJavaQueries(), this.getMappingFileQueries());
    }

    public Iterable<PersistentType> getPersistentTypes() {
        return new CompositeIterable(new Iterable[]{this.getMappingFilePersistentTypes(), this.getClassRefPersistentTypes(), this.getJarFilePersistentTypes()});
    }

    protected Iterable<PersistentType> getMappingFilePersistentTypes() {
        return new CompositeIterable(this.getMappingFilePersistentTypeLists());
    }

    protected Iterable<Iterable<? extends PersistentType>> getMappingFilePersistentTypeLists() {
        return new TransformationIterable(this.getMappingFileRefs(), PersistentTypeContainer.TRANSFORMER);
    }

    @Override
    public Iterable<PersistentType> getJavaPersistentTypes() {
        return new CompositeIterable(new Iterable[]{this.getClassRefPersistentTypes(), this.getJarFilePersistentTypes()});
    }

    protected Iterable<PersistentType> getClassRefPersistentTypes() {
        return new FilteringIterable(this.getClassRefPersistentTypes_(), NotNullFilter.instance());
    }

    protected Iterable<PersistentType> getClassRefPersistentTypes_() {
        return new TransformationIterable<ClassRef, PersistentType>(this.getClassRefs()){

            protected PersistentType transform(ClassRef classRef) {
                return classRef.getJavaPersistentType();
            }
        };
    }

    protected Iterable<PersistentType> getJarFilePersistentTypes() {
        return new CompositeIterable(this.getJarFilePersistentTypeLists());
    }

    protected Iterable<Iterable<? extends PersistentType>> getJarFilePersistentTypeLists() {
        return new TransformationIterable(this.getJarFileRefs(), PersistentTypeContainer.TRANSFORMER);
    }

    @Override
    public PersistentType getPersistentType(String typeName) {
        return typeName == null ? null : this.persistentTypeMap.get(typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildPersistentTypeMap() {
        Hashtable<String, PersistentType> hashtable = this.persistentTypeMap;
        synchronized (hashtable) {
            this.persistentTypeMap.clear();
            for (JarFileRef jarFileRef : this.getJarFileRefs()) {
                for (PersistentType persistentType : jarFileRef.getPersistentTypes()) {
                    if (persistentType.getName() == null) continue;
                    this.persistentTypeMap.put(persistentType.getName(), persistentType);
                }
            }
            for (ClassRef classRef : this.getClassRefs()) {
                PersistentType persistentType;
                persistentType = classRef.getJavaPersistentType();
                if (persistentType == null || persistentType.getName() == null) continue;
                this.persistentTypeMap.put(persistentType.getName(), persistentType);
            }
            for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
                for (PersistentType persistentType : mappingFileRef.getPersistentTypes()) {
                    if (persistentType.getName() == null) continue;
                    this.persistentTypeMap.put(persistentType.getName(), persistentType);
                }
            }
        }
    }

    @Override
    public boolean specifiesPersistentType(String typeName) {
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            if (!classRef.isFor(typeName)) continue;
            return true;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (mappingFileRef.getPersistentType(typeName) == null) continue;
            return true;
        }
        return false;
    }

    protected Iterable<PersistentType> getAllJavaPersistentTypesUnique() {
        HashMap<String, PersistentType> map = new HashMap<String, PersistentType>();
        this.addPersistentTypesTo(this.getJarFilePersistentTypes(), map);
        this.addPersistentTypesTo(this.getClassRefPersistentTypes(), map);
        this.addPersistentTypesTo(this.getMappingFileJavaPersistentTypes(), map);
        return map.values();
    }

    protected void addPersistentTypesTo(Iterable<? extends PersistentType> persistentTypes, HashMap<String, PersistentType> persistentTypeMap) {
        for (PersistentType persistentType : persistentTypes) {
            String ptName = persistentType.getName();
            if (ptName == null) continue;
            persistentTypeMap.put(ptName, persistentType);
        }
    }

    protected Iterable<PersistentType> getMappingFileJavaPersistentTypes() {
        return new FilteringIterable(this.getMappingFileJavaPersistentTypes_(), NotNullFilter.instance());
    }

    protected Iterable<PersistentType> getMappingFileJavaPersistentTypes_() {
        return new TransformationIterable<PersistentType, PersistentType>(this.getMappingFilePersistentTypes()){

            protected PersistentType transform(PersistentType mappingFilePersistentType) {
                return mappingFilePersistentType.getOverriddenPersistentType();
            }
        };
    }

    @Override
    public Entity getEntity(String typeName) {
        TypeMapping typeMapping = this.getTypeMapping(typeName);
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    @Override
    public Embeddable getEmbeddable(String typeName) {
        TypeMapping typeMapping = this.getTypeMapping(typeName);
        return typeMapping instanceof Embeddable ? (Embeddable)typeMapping : null;
    }

    protected TypeMapping getTypeMapping(String typeName) {
        PersistentType persistentType = this.getPersistentType(typeName);
        return persistentType == null ? null : persistentType.getMapping();
    }

    @Override
    public Iterable<Entity> getEntities() {
        return this.filterToEntities(this.getTypeMappings());
    }

    protected Iterable<Entity> filterToEntities(Iterable<TypeMapping> typeMappings) {
        return new SubIterableWrapper(this.filterToEntities_(typeMappings));
    }

    protected Iterable<TypeMapping> filterToEntities_(Iterable<TypeMapping> typeMappings) {
        return new FilteringIterable<TypeMapping>(typeMappings){

            protected boolean accept(TypeMapping typeMapping) {
                return typeMapping instanceof Entity;
            }
        };
    }

    protected Iterable<TypeMapping> getTypeMappings() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getPersistentTypes()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    protected Iterable<Entity> getActiveEntities() {
        return this.filterToEntities(this.getActiveTypeMappings());
    }

    protected Iterable<TypeMapping> getActiveTypeMappings() {
        ArrayList result = CollectionTools.list(this.getMappingFileTypeMappings());
        HashSet<String> mappingFileClassNames = this.convertToClassNames(result);
        HashMap<String, ArrayList<TypeMapping>> javaTypeMappings = this.mapTypeMappingsByClassName(this.getJavaTypeMappings());
        for (Map.Entry<String, ArrayList<TypeMapping>> entry : javaTypeMappings.entrySet()) {
            if (mappingFileClassNames.contains(entry.getKey())) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    protected Iterable<TypeMapping> getMappingFileTypeMappings() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getMappingFilePersistentTypes()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    protected HashSet<String> convertToClassNames(Collection<? extends TypeMapping> typeMappings) {
        HashSet<String> classNames = new HashSet<String>(typeMappings.size());
        for (TypeMapping typeMapping : typeMappings) {
            classNames.add(typeMapping.getPersistentType().getName());
        }
        return classNames;
    }

    protected <M extends TypeMapping> HashMap<String, ArrayList<M>> mapTypeMappingsByClassName(Iterable<M> typeMappings) {
        HashMap<String, ArrayList<M>> map = new HashMap<String, ArrayList<M>>();
        for (TypeMapping typeMapping : typeMappings) {
            String typeMappingName = typeMapping.getPersistentType().getName();
            ArrayList<Object> list = map.get(typeMappingName);
            if (list == null) {
                list = new ArrayList();
                map.put(typeMappingName, list);
            }
            list.add(typeMapping);
        }
        return map;
    }

    protected Iterable<TypeMapping> getJavaTypeMappings() {
        return new TransformationIterable<PersistentType, TypeMapping>(this.getJavaPersistentTypes()){

            protected TypeMapping transform(PersistentType persistentType) {
                return persistentType.getMapping();
            }
        };
    }

    @Override
    public void synchronizeClasses(IProgressMonitor monitor) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        HashSet newTypeNames = CollectionTools.set(this.getJpaProject().getMappedJavaSourceClassNames());
        ArrayList<ClassRef> deadClassRefs = new ArrayList<ClassRef>();
        HashSet<String> mappingFileTypeNames = this.getMappingFileTypeNames();
        for (ClassRef classRef : this.getSpecifiedClassRefs()) {
            JavaPersistentType specifiedJPT = classRef.getJavaPersistentType();
            if (specifiedJPT == null) {
                deadClassRefs.add(classRef);
                continue;
            }
            String specifiedName = specifiedJPT.getName();
            if (!newTypeNames.remove(specifiedName)) {
                deadClassRefs.add(classRef);
                continue;
            }
            if (!mappingFileTypeNames.contains(specifiedName)) continue;
            deadClassRefs.add(classRef);
        }
        if (sm.isCanceled()) {
            return;
        }
        sm.worked(1);
        this.removeSpecifiedClassRefs(deadClassRefs);
        if (sm.isCanceled()) {
            return;
        }
        sm.worked(1);
        this.addSpecifiedClassRefs(newTypeNames);
        sm.worked(1);
    }

    protected HashSet<String> getMappingFileTypeNames() {
        HashSet<String> result = new HashSet<String>();
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            for (PersistentType persistentType : mappingFileRef.getPersistentTypes()) {
                result.add(persistentType.getName());
            }
        }
        return result;
    }

    public void addPersistentTypes(MappedType[] mappedTypes, boolean listInPersistenceXml, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)10);
        this.annotateClasses(mappedTypes, (IProgressMonitor)sm.newChild(6));
        if (listInPersistenceXml) {
            this.listInPersistenceXml(mappedTypes, (IProgressMonitor)sm.newChild(4));
        } else {
            sm.subTask(JptCoreMessages.MAKE_PERSISTENT_UPDATING_JPA_MODEL);
            this.getJpaProject().synchronizeContextModel();
            sm.worked(4);
        }
    }

    protected void annotateClasses(MappedType[] mappedTypes, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)mappedTypes.length);
        sm.setTaskName(JptCoreMessages.MAKE_PERSISTENT_PROCESSING_JAVA_CLASSES);
        MappedType[] mappedTypeArray = mappedTypes;
        int n = mappedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MappedType mappedType = mappedTypeArray[n2];
            if (sm.isCanceled()) {
                return;
            }
            String name = mappedType.getFullyQualifiedName();
            sm.subTask(NLS.bind((String)JptCoreMessages.MAKE_PERSISTENT_ANNOTATING_CLASS, (Object)name));
            JavaResourceAbstractType type = this.getJpaProject().getJavaResourceType(name);
            type.addAnnotation(this.getJavaTypeMappingDefinition(mappedType.getMappingKey()).getAnnotationName());
            sm.worked(1);
            ++n2;
        }
    }

    protected void listInPersistenceXml(MappedType[] mappedTypes, IProgressMonitor pm) {
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pm, (int)11);
        sm.setTaskName(JptCoreMessages.MAKE_PERSISTENT_LISTING_IN_PERSISTENCE_XML);
        ArrayList<XmlJavaClassRef> addedXmlClassRefs = new ArrayList<XmlJavaClassRef>();
        ArrayList<ClassRef> addedClassRefs = new ArrayList<ClassRef>();
        MappedType[] mappedTypeArray = mappedTypes;
        int n = mappedTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MappedType mappedType = mappedTypeArray[n2];
            String name = mappedType.getFullyQualifiedName();
            XmlJavaClassRef xmlClassRef = this.buildXmlJavaClassRef(name);
            addedXmlClassRefs.add(xmlClassRef);
            addedClassRefs.add(this.buildClassRef(xmlClassRef));
            ++n2;
        }
        if (sm.isCanceled()) {
            return;
        }
        sm.worked(1);
        sm.subTask(JptCoreMessages.MAKE_PERSISTENT_UPDATING_JPA_MODEL);
        this.specifiedClassRefContainer.addAll(this.getSpecifiedClassRefsSize(), addedClassRefs);
        sm.worked(5);
        sm.subTask(JptCoreMessages.MAKE_PERSISTENT_ADD_TO_PERSISTENCE_XML_RESOURCE_MODEL);
        this.xmlPersistenceUnit.getClasses().addAll(addedXmlClassRefs);
        sm.worked(5);
    }

    protected JavaTypeMappingDefinition getJavaTypeMappingDefinition(String key) {
        for (JavaTypeMappingDefinition definition : this.getJpaPlatform().getJavaTypeMappingDefinitions()) {
            if (!Tools.valuesAreEqual((Object)definition.getKey(), (Object)key)) continue;
            return definition;
        }
        throw new IllegalArgumentException("Illegal type mapping key: " + key);
    }

    @Override
    public XmlPersistenceUnit getXmlPersistenceUnit() {
        return this.xmlPersistenceUnit;
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            if (!jarFileRef.containsOffset(textOffset)) continue;
            return jarFileRef;
        }
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            if (!mappingFileRef.containsOffset(textOffset)) continue;
            return mappingFileRef;
        }
        for (ClassRef classRef : this.getClassRefs()) {
            if (!classRef.containsOffset(textOffset)) continue;
            return classRef;
        }
        return this;
    }

    @Override
    public boolean containsOffset(int textOffset) {
        return this.xmlPersistenceUnit != null && this.xmlPersistenceUnit.containsOffset(textOffset);
    }

    protected HashSet<String> convertToNames(Collection<? extends JpaNamedContextNode> nodes) {
        HashSet<String> names = new HashSet<String>(nodes.size());
        for (JpaNamedContextNode jpaNamedContextNode : nodes) {
            names.add(jpaNamedContextNode.getName());
        }
        return names;
    }

    protected <N extends JpaNamedContextNode> HashMap<String, ArrayList<N>> mapByName(Iterable<N> nodes) {
        HashMap<String, ArrayList<N>> map = new HashMap<String, ArrayList<N>>();
        for (JpaNamedContextNode node : nodes) {
            String nodeName = node.getName();
            ArrayList<Object> list = map.get(nodeName);
            if (list == null) {
                list = new ArrayList();
                map.put(nodeName, list);
            }
            list.add(node);
        }
        return map;
    }

    protected <N extends JpaNamedContextNode> ArrayList<N> extractConvertibleJavaNodes(Iterable<N> allJavaNodes, Iterable<? extends JpaNamedContextNode> mappingFileNodes) {
        ArrayList<JpaNamedContextNode> convertibleNodes = new ArrayList<JpaNamedContextNode>();
        HashSet<String> mappingFileNodeNames = this.convertToNames(CollectionTools.list(mappingFileNodes));
        HashMap<String, ArrayList<N>> allJavaNodesByName = this.mapByName(allJavaNodes);
        for (Map.Entry<String, ArrayList<N>> entry : allJavaNodesByName.entrySet()) {
            ArrayList<N> javaNodesWithSameName;
            String javaNodeName = entry.getKey();
            if (StringTools.stringIsEmpty((String)javaNodeName) || (javaNodesWithSameName = entry.getValue()).size() != 1 || mappingFileNodeNames.contains(javaNodeName)) continue;
            convertibleNodes.add((JpaNamedContextNode)javaNodesWithSameName.get(0));
        }
        return convertibleNodes;
    }

    public void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(this.name);
    }

    @Override
    public Iterable<String> getPackageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        for (PersistentType pType : this.getJavaPersistentTypes()) {
            JavaResourceType jrt = ((JavaPersistentType)pType).getJavaResourceType();
            packageNames.add(jrt.getPackageName());
        }
        return packageNames;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappingFiles(messages, reporter);
        this.validateClassRefs(messages, reporter);
        this.validateJarFileRefs(messages, reporter);
        this.validateProperties(messages, reporter);
        this.validateGenerators(messages, reporter);
        this.validateQueries(messages, reporter);
        this.validateEntityNames(messages);
    }

    protected void validateMappingFiles(List<IMessage> messages, IReporter reporter) {
        this.checkForMultiplePersistenceUnitMetadata(messages);
        this.checkForDuplicateMappingFileRefs(messages);
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            mappingFileRef.validate(messages, reporter);
        }
        this.checkForDuplicateMappingFileClasses(messages);
    }

    protected void checkForMultiplePersistenceUnitMetadata(List<IMessage> messages) {
        ArrayList pumdMappingFileRefs = CollectionTools.list(this.getPersistenceUnitMetadataMappingFileRefs());
        if (pumdMappingFileRefs.size() > 1) {
            for (MappingFileRef mappingFileRef : pumdMappingFileRefs) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "MAPPING_FILE_EXTRANEOUS_PERSISTENCE_UNIT_METADATA", new String[]{mappingFileRef.getFileName()}, mappingFileRef.getMappingFile(), mappingFileRef.getPersistenceUnitMetadata().getValidationTextRange()));
            }
        }
    }

    protected Iterable<MappingFileRef> getPersistenceUnitMetadataMappingFileRefs() {
        return new FilteringIterable<MappingFileRef>(this.getMappingFileRefs()){

            protected boolean accept(MappingFileRef mappingFileRef) {
                return mappingFileRef.persistenceUnitMetadataExists();
            }
        };
    }

    protected void checkForDuplicateMappingFileRefs(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<MappingFileRef>> entry : this.mapMappingFileRefsByFileName().entrySet()) {
            ArrayList<MappingFileRef> dups;
            String fileName = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)fileName) || (dups = entry.getValue()).size() <= 1) continue;
            String[] parms = new String[]{fileName};
            for (MappingFileRef dup : dups) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_MAPPING_FILE", parms, dup, dup.getValidationTextRange()));
            }
        }
    }

    protected HashMap<String, ArrayList<MappingFileRef>> mapMappingFileRefsByFileName() {
        HashMap<String, ArrayList<MappingFileRef>> map = new HashMap<String, ArrayList<MappingFileRef>>(this.getMappingFileRefsSize());
        for (MappingFileRef mappingFileRef : this.getMappingFileRefs()) {
            String fileName = mappingFileRef.getFileName();
            ArrayList<MappingFileRef> list = map.get(fileName);
            if (list == null) {
                list = new ArrayList();
                map.put(fileName, list);
            }
            list.add(mappingFileRef);
        }
        return map;
    }

    protected void checkForDuplicateMappingFileClasses(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<PersistentType>> entry : this.mapMappingFilePersistentTypesByName().entrySet()) {
            ArrayList<PersistentType> dups;
            String ptName = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)ptName) || (dups = entry.getValue()).size() <= 1) continue;
            String[] parms = new String[]{ptName};
            for (PersistentType dup : dups) {
                messages.add(DefaultJpaValidationMessages.buildMessage(2, "PERSISTENT_TYPE_DUPLICATE_CLASS", parms, dup, dup.getValidationTextRange()));
            }
        }
    }

    protected HashMap<String, ArrayList<PersistentType>> mapMappingFilePersistentTypesByName() {
        HashMap<String, ArrayList<PersistentType>> map = new HashMap<String, ArrayList<PersistentType>>();
        for (PersistentType persistentType : this.getMappingFilePersistentTypes()) {
            String ptName = persistentType.getName();
            ArrayList<PersistentType> list = map.get(ptName);
            if (list == null) {
                list = new ArrayList();
                map.put(ptName, list);
            }
            list.add(persistentType);
        }
        return map;
    }

    protected void validateClassRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateClassRefs(messages);
        for (ClassRef classRef : this.getClassRefs()) {
            classRef.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateClassRefs(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<ClassRef>> entry : this.mapClassRefsByName().entrySet()) {
            ArrayList<ClassRef> dups;
            String className = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)className) || (dups = entry.getValue()).size() <= 1) continue;
            String[] parms = new String[]{className};
            for (ClassRef dup : dups) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_CLASS", parms, dup, dup.getValidationTextRange()));
            }
        }
    }

    protected HashMap<String, ArrayList<ClassRef>> mapClassRefsByName() {
        HashMap<String, ArrayList<ClassRef>> map = new HashMap<String, ArrayList<ClassRef>>(this.getClassRefsSize());
        for (ClassRef classRef : this.getClassRefs()) {
            String refName = classRef.getClassName();
            ArrayList<ClassRef> list = map.get(refName);
            if (list == null) {
                list = new ArrayList();
                map.put(refName, list);
            }
            list.add(classRef);
        }
        return map;
    }

    protected void validateJarFileRefs(List<IMessage> messages, IReporter reporter) {
        this.checkForDuplicateJarFileRefs(messages);
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            jarFileRef.validate(messages, reporter);
        }
    }

    protected void checkForDuplicateJarFileRefs(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<JarFileRef>> entry : this.mapJarFileRefsByName().entrySet()) {
            ArrayList<JarFileRef> dups;
            String fileName = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)fileName) || (dups = entry.getValue()).size() <= 1) continue;
            String[] parms = new String[]{fileName};
            for (JarFileRef dup : dups) {
                messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENCE_UNIT_DUPLICATE_JAR_FILE", parms, dup, dup.getValidationTextRange()));
            }
        }
    }

    protected HashMap<String, ArrayList<JarFileRef>> mapJarFileRefsByName() {
        HashMap<String, ArrayList<JarFileRef>> map = new HashMap<String, ArrayList<JarFileRef>>(this.getJarFileRefsSize());
        for (JarFileRef jarFileRef : this.getJarFileRefs()) {
            String refName = jarFileRef.getFileName();
            ArrayList<JarFileRef> list = map.get(refName);
            if (list == null) {
                list = new ArrayList();
                map.put(refName, list);
            }
            list.add(jarFileRef);
        }
        return map;
    }

    protected abstract void validateProperties(List<IMessage> var1, IReporter var2);

    protected void validateGenerators(List<IMessage> messages, IReporter reporter) {
        this.checkForGeneratorsWithSameName(messages);
        for (Generator generator : this.getGenerators()) {
            this.validate(generator, messages, reporter);
        }
    }

    protected void checkForGeneratorsWithSameName(List<IMessage> messages) {
        HashMap<String, ArrayList<Generator>> generatorsByName = this.mapByName(this.getGenerators());
        for (Map.Entry<String, ArrayList<Generator>> entry : generatorsByName.entrySet()) {
            ArrayList<Generator> dups;
            String generatorName = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)generatorName) || (dups = entry.getValue()).size() <= 1) continue;
            this.validateGeneratorsWithSameName(generatorName, dups, messages);
        }
    }

    protected void validateGeneratorsWithSameName(String generatorName, ArrayList<Generator> dups, List<IMessage> messages) {
        String[] parms = new String[]{generatorName};
        for (Generator dup : dups) {
            if (!this.generatorSupportsValidationMessages(dup)) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "GENERATOR_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
        }
    }

    protected boolean generatorSupportsValidationMessages(Generator generator) {
        return generator instanceof OrmGenerator || this.generatorSupportsValidationMessages((JavaGenerator)generator);
    }

    protected boolean generatorSupportsValidationMessages(JavaGenerator javaGenerator) {
        return MappingTools.nodeIsInternalSource(javaGenerator, (JavaResourceNode)javaGenerator.getGeneratorAnnotation());
    }

    protected TextRange extractNameTextRange(Generator generator) {
        return generator instanceof OrmGenerator ? ((OrmGenerator)generator).getNameTextRange() : ((JavaGenerator)generator).getNameTextRange(null);
    }

    protected void validate(Generator generator, List<IMessage> messages, IReporter reporter) {
        if (generator instanceof OrmGenerator) {
            ((OrmGenerator)generator).validate(messages, reporter);
        } else {
            JavaGenerator javaGenerator = (JavaGenerator)generator;
            if (this.generatorSupportsValidationMessages(javaGenerator)) {
                javaGenerator.validate(messages, reporter, null);
            }
        }
    }

    protected void validateQueries(List<IMessage> messages, IReporter reporter) {
        this.checkForQueriesWithSameName(messages);
        JpaJpqlQueryHelper queryHelper = this.createJpqlQueryHelper();
        for (Query query : this.getQueries()) {
            this.validate(query, queryHelper, messages, reporter);
        }
    }

    protected void checkForQueriesWithSameName(List<IMessage> messages) {
        HashMap<String, ArrayList<Query>> queriesByName = this.mapByName(this.getQueries());
        for (Map.Entry<String, ArrayList<Query>> entry : queriesByName.entrySet()) {
            ArrayList<Query> dups;
            String queryName = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)queryName) || (dups = entry.getValue()).size() <= 1) continue;
            this.validateQueriesWithSameName(queryName, dups, messages);
        }
    }

    protected void validateQueriesWithSameName(String queryName, ArrayList<Query> dups, List<IMessage> messages) {
        String[] parms = new String[]{queryName};
        for (Query dup : dups) {
            if (!this.querySupportsValidationMessages(dup)) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "QUERY_DUPLICATE_NAME", parms, dup, this.extractNameTextRange(dup)));
        }
    }

    protected boolean querySupportsValidationMessages(Query query) {
        return query instanceof OrmQuery || this.querySupportsValidationMessages((JavaQuery)query);
    }

    protected boolean querySupportsValidationMessages(JavaQuery javaQuery) {
        return MappingTools.nodeIsInternalSource(javaQuery, (JavaResourceNode)javaQuery.getQueryAnnotation());
    }

    protected TextRange extractNameTextRange(Query query) {
        return query instanceof OrmQuery ? ((OrmQuery)query).getNameTextRange() : ((JavaQuery)query).getNameTextRange(null);
    }

    protected void validate(Query query, JpaJpqlQueryHelper queryHelper, List<IMessage> messages, IReporter reporter) {
        if (query instanceof OrmQuery) {
            ((OrmQuery)query).validate(queryHelper, messages, reporter);
        } else {
            JavaQuery javaQuery = (JavaQuery)query;
            if (this.querySupportsValidationMessages(javaQuery)) {
                javaQuery.validate(queryHelper, messages, reporter, null);
            }
        }
    }

    protected void validateEntityNames(List<IMessage> messages) {
        for (Map.Entry<String, ArrayList<Entity>> entry : this.mapTypeMappingsByName(this.getActiveEntities()).entrySet()) {
            ArrayList<Entity> dups;
            String entityName = entry.getKey();
            if (!StringTools.stringIsNotEmpty((String)entityName) || (dups = entry.getValue()).size() <= 1) continue;
            this.validateEntitiesWithSameName(entityName, dups, messages);
        }
    }

    protected <M extends TypeMapping> HashMap<String, ArrayList<M>> mapTypeMappingsByName(Iterable<M> typeMappings) {
        HashMap<String, ArrayList<M>> map = new HashMap<String, ArrayList<M>>();
        for (TypeMapping typeMapping : typeMappings) {
            String typeMappingName = typeMapping.getName();
            ArrayList<Object> list = map.get(typeMappingName);
            if (list == null) {
                list = new ArrayList();
                map.put(typeMappingName, list);
            }
            list.add(typeMapping);
        }
        return map;
    }

    protected void validateEntitiesWithSameName(String entityName, ArrayList<Entity> dups, List<IMessage> messages) {
        String[] parms = new String[]{entityName};
        for (Entity dup : dups) {
            if (!this.entitySupportsValidationMessages(dup)) continue;
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "ENTITY_NAME_DUPLICATED", parms, dup, this.extractNameTextRange(dup)));
        }
    }

    protected boolean entitySupportsValidationMessages(Entity entity) {
        return entity instanceof OrmEntity || this.entitySupportsValidationMessages((JavaEntity)entity);
    }

    protected boolean entitySupportsValidationMessages(JavaEntity javaEntity) {
        return MappingTools.nodeIsInternalSource(javaEntity, (JavaResourceNode)javaEntity.getJavaResourceType());
    }

    protected TextRange extractNameTextRange(Entity entity) {
        return entity instanceof OrmEntity ? ((OrmEntity)entity).getXmlTypeMapping().getNameTextRange() : ((JavaEntity)entity).getMappingAnnotation().getNameTextRange();
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.connectionProfileIsActive();
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlPersistenceUnit.getValidationTextRange();
        return textRange != null ? textRange : this.getPersistence().getValidationTextRange();
    }

    @Override
    public Iterable<DeleteEdit> createDeleteTypeEdits(final IType type) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<DeleteEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<DeleteEdit> transform(ClassRef classRef) {
                return classRef.createDeleteTypeEdits(type);
            }
        });
    }

    @Override
    public Iterable<DeleteEdit> createDeleteMappingFileEdits(final IFile file) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<DeleteEdit>>(this.getSpecifiedMappingFileRefs()){

            protected Iterable<DeleteEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createDeleteMappingFileEdits(file);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return new CompositeIterable(new Iterable[]{this.createSpecifiedClassRefRenameTypeEdits(originalType, newName), this.createPersistenceUnitPropertiesRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefRenameTypeEdits(final IType originalType, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<ReplaceEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<ReplaceEdit> transform(ClassRef classRef) {
                return classRef.createRenameTypeEdits(originalType, newName);
            }
        });
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenameTypeEdits(IType originalType, String newName) {
        return this.options.createRenameTypeEdits(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return new CompositeIterable(new Iterable[]{this.createSpecifiedClassRefMoveTypeEdits(originalType, newPackage), this.createPersistenceUnitPropertiesMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefMoveTypeEdits(final IType originalType, final IPackageFragment newPackage) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<ReplaceEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<ReplaceEdit> transform(ClassRef classRef) {
                return classRef.createMoveTypeEdits(originalType, newPackage);
            }
        });
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return this.options.createMoveTypeEdits(originalType, newPackage);
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return new CompositeIterable(new Iterable[]{this.createSpecifiedClassRefRenamePackageEdits(originalPackage, newName), this.createPersistenceUnitPropertiesRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createSpecifiedClassRefRenamePackageEdits(final IPackageFragment originalPackage, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<ClassRef, Iterable<ReplaceEdit>>(this.getSpecifiedClassRefs()){

            protected Iterable<ReplaceEdit> transform(ClassRef classRef) {
                return classRef.createRenamePackageEdits(originalPackage, newName);
            }
        });
    }

    protected Iterable<ReplaceEdit> createPersistenceUnitPropertiesRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return this.options.createRenamePackageEdits(originalPackage, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createRenameFolderEdits(IFolder originalFolder, String newName) {
        return this.createMappingFileRefRenameFolderEdits(originalFolder, newName);
    }

    protected Iterable<ReplaceEdit> createMappingFileRefRenameFolderEdits(final IFolder originalFolder, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getSpecifiedMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createRenameFolderEdits(originalFolder, newName);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createRenameMappingFileEdits(final IFile originalFile, final String newName) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createRenameMappingFileEdits(originalFile, newName);
            }
        });
    }

    @Override
    public int findInsertLocationForMappingFileRef() {
        return this.xmlPersistenceUnit.getLocationToInsertMappingFileRef();
    }

    @Override
    public Iterable<ReplaceEdit> createMoveMappingFileEdits(final IFile originalFile, final IPath runtineDestination) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createMoveMappingFileEdits(originalFile, runtineDestination);
            }
        });
    }

    @Override
    public Iterable<ReplaceEdit> createMoveFolderEdits(IFolder originalFolder, IPath runtimeDestination) {
        return this.createMappingFileRefMoveFolderReplaceEdits(originalFolder, runtimeDestination);
    }

    protected Iterable<ReplaceEdit> createMappingFileRefMoveFolderReplaceEdits(final IFolder originalFolder, final IPath runtimeDestination) {
        return new CompositeIterable((Iterable)new TransformationIterable<MappingFileRef, Iterable<ReplaceEdit>>(this.getSpecifiedMappingFileRefs()){

            protected Iterable<ReplaceEdit> transform(MappingFileRef mappingFileRef) {
                return mappingFileRef.createMoveFolderEdits(originalFolder, runtimeDestination);
            }
        });
    }

    @Override
    public void initializeMetamodel() {
        this.initializeMetamodelFiles_();
    }

    protected void initializeMetamodelFiles() {
        if (this.isJpa2_0Compatible()) {
            this.initializeMetamodelFiles_();
        }
    }

    protected void initializeMetamodelFiles_() {
        CollectionTools.addAll(this.metamodelFiles, this.getGeneratedMetamodelFiles());
    }

    protected Iterable<IFile> getGeneratedMetamodelFiles() {
        return new TransformationIterable<JavaResourceAbstractType, IFile>(this.getGeneratedMetamodelTopLevelTypes()){

            protected IFile transform(JavaResourceAbstractType jrpt) {
                return jrpt.getFile();
            }
        };
    }

    protected Iterable<JavaResourceAbstractType> getGeneratedMetamodelTopLevelTypes() {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelTypes();
    }

    @Override
    public IStatus synchronizeMetamodel(IProgressMonitor monitor) {
        HashMap<String, PersistentType> allPersistentTypes = new HashMap<String, PersistentType>();
        this.addPersistentTypesTo(this.getJarFilePersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo(this.getClassRefPersistentTypes(), allPersistentTypes);
        this.addPersistentTypesTo(this.getMappingFilePersistentTypes(), allPersistentTypes);
        ArrayList<MetamodelSourceType> topLevelTypes = new ArrayList<MetamodelSourceType>(allPersistentTypes.size());
        HashMap<String, Collection<MetamodelSourceType>> memberTypeTree = new HashMap<String, Collection<MetamodelSourceType>>();
        block0: for (PersistentType type1_0 : allPersistentTypes.values()) {
            PersistentType2_0 type = (PersistentType2_0)type1_0;
            String declaringTypeName = type.getDeclaringTypeName();
            MetamodelSourceType memberType = type;
            while (true) {
                IType jdtDeclaringType;
                IType jdtType;
                JavaResourceAbstractType jrat;
                if (declaringTypeName == null) {
                    topLevelTypes.add(memberType);
                    continue block0;
                }
                ArrayList<PersistentType2_0> memberTypes = (ArrayList<PersistentType2_0>)memberTypeTree.get(declaringTypeName);
                if (memberTypes == null) {
                    memberTypes = new ArrayList<PersistentType2_0>();
                    memberTypeTree.put(declaringTypeName, memberTypes);
                }
                memberTypes.add((PersistentType2_0)memberType);
                String memberTypeName = declaringTypeName;
                memberType = (PersistentType2_0)allPersistentTypes.get(memberTypeName);
                if (memberType != null || (memberType = (declaringTypeName = (jrat = this.getJpaProject().getJavaResourceType(memberTypeName)) != null ? jrat.getDeclaringTypeName() : ((jdtType = this.findJdtType(memberTypeName)) != null ? ((jdtDeclaringType = jdtType.getDeclaringType()) == null ? null : jdtDeclaringType.getFullyQualifiedName('.')) : null)) == null ? this.selectSourceType(topLevelTypes, memberTypeName) : this.selectSourceType((Iterable)memberTypeTree.get(declaringTypeName), memberTypeName)) != null) continue block0;
                memberType = this.buildNonPersistentMetamodelSourceType(memberTypeName);
            }
        }
        Collections.sort(topLevelTypes, MetamodelSourceType.COMPARATOR);
        HashSet<String> names = new HashSet<String>(topLevelTypes.size());
        Iterator stream = topLevelTypes.iterator();
        while (stream.hasNext()) {
            MetamodelSourceType topLevelType = (MetamodelSourceType)stream.next();
            if (names.add(topLevelType.getName().toLowerCase())) continue;
            stream.remove();
        }
        HashSet<IFile> deadMetamodelFiles = new HashSet<IFile>(this.metamodelFiles);
        this.metamodelFiles.clear();
        for (MetamodelSourceType topLevelType : topLevelTypes) {
            IFile metamodelFile = topLevelType.getMetamodelFile();
            deadMetamodelFiles.remove(metamodelFile);
            if (!this.fileIsGeneratedMetamodel(metamodelFile)) continue;
            this.metamodelFiles.add(metamodelFile);
        }
        for (IFile deadMetamodelFile : deadMetamodelFiles) {
            this.deleteMetamodelFile(deadMetamodelFile);
        }
        for (MetamodelSourceType topLevelType : topLevelTypes) {
            topLevelType.synchronizeMetamodel(memberTypeTree);
        }
        return Status.OK_STATUS;
    }

    protected MetamodelSourceType selectSourceType(Iterable<MetamodelSourceType> types, String typeName) {
        if (types != null) {
            for (MetamodelSourceType type : types) {
                if (!type.getName().equals(typeName)) continue;
                return type;
            }
        }
        return null;
    }

    protected MetamodelSourceType buildNonPersistentMetamodelSourceType(String nonPersistentTypeName) {
        return new NonPersistentMetamodelSourceType(nonPersistentTypeName, this.getJpaProject());
    }

    protected IType findJdtType(String typeName) {
        try {
            return this.getJpaProject().getJavaProject().findType(typeName);
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    protected void deleteMetamodelFile(IFile file) {
        try {
            this.deleteMetamodelFile_(file);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    protected void deleteMetamodelFile_(IFile file) throws CoreException {
        if (this.fileIsGeneratedMetamodel(file)) {
            file.delete(true, null);
        }
    }

    protected boolean fileIsGeneratedMetamodel(IFile file) {
        return ((JpaProject2_0)this.getJpaProject()).getGeneratedMetamodelTopLevelType(file) != null;
    }

    @Override
    public void disposeMetamodel() {
        this.metamodelFiles.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ImpliedClassRefContainer
    extends AbstractJpaNode.ContextCollectionContainer<ClassRef, String> {
        protected ImpliedClassRefContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "impliedClassRefs";
        }

        @Override
        protected ClassRef buildContextElement(String resourceElement) {
            return AbstractPersistenceUnit.this.buildClassRef(resourceElement);
        }

        @Override
        protected Iterable<String> getResourceElements() {
            return AbstractPersistenceUnit.this.getImpliedClassNames();
        }

        @Override
        protected String getResourceElement(ClassRef contextElement) {
            return contextElement.getClassName();
        }

        @Override
        protected void disposeElement(ClassRef contextElement) {
            contextElement.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JarFileRefContainer
    extends AbstractJpaNode.ContextListContainer<JarFileRef, XmlJarFileRef> {
        protected JarFileRefContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "jarFileRefs";
        }

        @Override
        protected JarFileRef buildContextElement(XmlJarFileRef resourceElement) {
            return AbstractPersistenceUnit.this.buildJarFileRef(resourceElement);
        }

        @Override
        protected ListIterable<XmlJarFileRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlJarFileRefs();
        }

        @Override
        protected XmlJarFileRef getResourceElement(JarFileRef contextElement) {
            return contextElement.getXmlJarFileRef();
        }
    }

    public static interface MappedType {
        public String getFullyQualifiedName();

        public String getMappingKey();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NonPersistentMetamodelSourceType
    implements MetamodelSourceType {
        protected final String name;
        protected final JpaProject jpaProject;
        protected final MetamodelSourceType.Synchronizer metamodelSynchronizer;

        protected NonPersistentMetamodelSourceType(String name, JpaProject jpaProject) {
            this.name = name;
            this.jpaProject = jpaProject;
            this.metamodelSynchronizer = this.buildMetamodelSynchronizer();
        }

        protected MetamodelSourceType.Synchronizer buildMetamodelSynchronizer() {
            return this.getJpaFactory().buildMetamodelSynchronizer(this);
        }

        protected JpaFactory2_0 getJpaFactory() {
            return (JpaFactory2_0)this.getJpaProject().getJpaPlatform().getJpaFactory();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public PersistentType getSuperPersistentType() {
            return null;
        }

        @Override
        public ListIterable<? extends ReadOnlyPersistentAttribute> getAttributes() {
            return EmptyListIterable.instance();
        }

        @Override
        public IFile getMetamodelFile() {
            return this.metamodelSynchronizer.getFile();
        }

        @Override
        public JpaProject getJpaProject() {
            return this.jpaProject;
        }

        @Override
        public void synchronizeMetamodel(Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
            this.metamodelSynchronizer.synchronize(memberTypeTree);
        }

        @Override
        public void printBodySourceOn(BodySourceWriter pw, Map<String, Collection<MetamodelSourceType>> memberTypeTree) {
            this.metamodelSynchronizer.printBodySourceOn(pw, memberTypeTree);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PropertyContainer
    extends AbstractJpaNode.ContextListContainer<PersistenceUnit.Property, XmlProperty> {
        protected PropertyContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "properties";
        }

        @Override
        protected PersistenceUnit.Property buildContextElement(XmlProperty resourceElement) {
            return AbstractPersistenceUnit.this.buildProperty(resourceElement);
        }

        @Override
        protected ListIterable<XmlProperty> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlProperties();
        }

        @Override
        protected XmlProperty getResourceElement(PersistenceUnit.Property contextElement) {
            return contextElement.getXmlProperty();
        }

        @Override
        protected PersistenceUnit.Property addContextElement_(int index, PersistenceUnit.Property contextElement) {
            super.addContextElement_(index, contextElement);
            if (contextElement.getName() != null) {
                AbstractPersistenceUnit.this.propertyAdded(contextElement.getName(), contextElement.getValue());
            }
            return contextElement;
        }

        @Override
        protected void disposeElement(PersistenceUnit.Property contextElement) {
            if (contextElement.getName() != null) {
                AbstractPersistenceUnit.this.propertyRemoved(contextElement.getName());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedClassRefContainer
    extends AbstractJpaNode.ContextListContainer<ClassRef, XmlJavaClassRef> {
        protected SpecifiedClassRefContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedClassRefs";
        }

        @Override
        protected ClassRef buildContextElement(XmlJavaClassRef resourceElement) {
            return AbstractPersistenceUnit.this.buildClassRef(resourceElement);
        }

        @Override
        protected ListIterable<XmlJavaClassRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlClassRefs();
        }

        @Override
        protected XmlJavaClassRef getResourceElement(ClassRef contextElement) {
            return contextElement.getXmlClassRef();
        }

        @Override
        protected void disposeElement(ClassRef contextElement) {
            contextElement.dispose();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedMappingFileRefContainer
    extends AbstractJpaNode.ContextListContainer<MappingFileRef, XmlMappingFileRef> {
        protected SpecifiedMappingFileRefContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedMappingFileRefs";
        }

        @Override
        protected MappingFileRef buildContextElement(XmlMappingFileRef resourceElement) {
            return AbstractPersistenceUnit.this.buildSpecifiedMappingFileRef(resourceElement);
        }

        @Override
        protected ListIterable<XmlMappingFileRef> getResourceElements() {
            return AbstractPersistenceUnit.this.getXmlMappingFileRefs();
        }

        @Override
        protected XmlMappingFileRef getResourceElement(MappingFileRef contextElement) {
            return contextElement.getXmlMappingFileRef();
        }

        @Override
        protected void disposeElement(MappingFileRef element) {
            element.dispose();
        }
    }
}

