/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.facet.JpaFacetDataModelProvider;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaFacetVersionChangeDataModelProvider
extends JpaFacetDataModelProvider {
    protected static final IStatus PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION_STATUS = JpaFacetVersionChangeDataModelProvider.buildErrorStatus(JptCoreMessages.VALIDATE_PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION);

    protected String getProjectName() {
        return this.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
    }

    protected JpaProject getJpaProject() {
        try {
            return this.getJpaProjectReference().getValue();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected JpaProject.Reference getJpaProjectReference() {
        return (JpaProject.Reference)this.getProject().getAdapter(JpaProject.Reference.class);
    }

    protected IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    @Override
    protected JpaPlatformDescription getDefaultPlatform() {
        return this.getJpaProject().getJpaPlatform().getDescription();
    }

    @Override
    protected String getDefaultConnection() {
        return this.getJpaProject().getDataSource().getConnectionProfileName();
    }

    @Override
    protected Boolean getDefaultUserWantsToOverrideDefaultCatalog() {
        return this.getDefaultUserWantsToOverrideDefaultCatalog_();
    }

    protected boolean getDefaultUserWantsToOverrideDefaultCatalog_() {
        return this.getJpaProject().getUserOverrideDefaultCatalog() != null;
    }

    @Override
    protected String getDefaultCatalogIdentifier() {
        return this.getJpaProject().getUserOverrideDefaultCatalog();
    }

    @Override
    protected Boolean getDefaultUserWantsToOverrideDefaultSchema() {
        return this.getDefaultUserWantsToOverrideDefaultSchema_();
    }

    protected boolean getDefaultUserWantsToOverrideDefaultSchema_() {
        return this.getJpaProject().getUserOverrideDefaultSchema() != null;
    }

    @Override
    protected String getDefaultSchemaIdentifier() {
        return this.getJpaProject().getDefaultSchema();
    }

    @Override
    protected Boolean getDefaultDiscoverAnnotatedClasses() {
        return this.getDefaultDiscoverAnnotatedClasses_();
    }

    protected boolean getDefaultDiscoverAnnotatedClasses_() {
        return this.getJpaProject().discoversAnnotatedClasses();
    }

    @Override
    protected Iterable<JpaPlatformDescription> buildValidPlatformDescriptions() {
        CompositeIterable validPlatformDescs = super.buildValidPlatformDescriptions();
        if (!CollectionTools.contains(validPlatformDescs, (Object)this.getDefaultPlatform())) {
            validPlatformDescs = new CompositeIterable((Object)this.getDefaultPlatform(), validPlatformDescs);
        }
        return validPlatformDescs;
    }

    @Override
    protected IStatus validatePlatform() {
        IStatus status = super.validatePlatform();
        if (status.isOK() && !this.getPlatform().supportsJpaFacetVersion(this.getProjectFacetVersion())) {
            status = PLATFORM_DOES_NOT_SUPPORT_FACET_VERSION_STATUS;
        }
        return status;
    }
}

