/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.facet;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformDescription;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectWorkingCopy;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;

public class RuntimeChangedListener
implements IFacetedProjectListener {
    public void handleEvent(IFacetedProjectEvent facetedProjectEvent) {
        IProjectFacetVersion pfv;
        IFacetedProjectWorkingCopy fpb = facetedProjectEvent.getWorkingCopy();
        if (fpb == null) {
            fpb = facetedProjectEvent.getProject();
        }
        if ((pfv = fpb.getProjectFacetVersion(JpaFacet.FACET)) != null) {
            HashMap<String, Object> enablementVariables = new HashMap<String, Object>();
            enablementVariables.put("jpaPlatform", this.getJpaPlatformId(fpb.getProject()));
            enablementVariables.put("jpaPlatformDescription", this.getJpaPlatformDescription(fpb.getProject()));
            LibraryInstallDelegate lp = new LibraryInstallDelegate((IFacetedProjectBase)fpb, pfv, enablementVariables);
            try {
                try {
                    lp.execute((IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException ce) {
                    JptJpaCorePlugin.log(ce);
                    lp.dispose();
                }
            }
            finally {
                lp.dispose();
            }
        }
    }

    protected String getJpaPlatformId(IProject project) {
        JpaProject jpaProject = this.getJpaProject(project);
        return jpaProject == null ? null : jpaProject.getJpaPlatform().getId();
    }

    protected JpaPlatformDescription getJpaPlatformDescription(IProject project) {
        JpaProject jpaProject = this.getJpaProject(project);
        return jpaProject == null ? null : jpaProject.getJpaPlatform().getDescription();
    }

    protected JpaProject getJpaProject(IProject project) {
        try {
            return this.getJpaProject_(project);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected JpaProject getJpaProject_(IProject project) throws InterruptedException {
        return this.getJpaProjectReference(project).getValue();
    }

    protected JpaProject.Reference getJpaProjectReference(IProject project) {
        return (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
    }
}

