/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context;

import java.util.List;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.ConverterTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemporalConverterValidator
implements JptValidator {
    protected final BaseTemporalConverter converter;
    protected final ConverterTextRangeResolver textRangeResolver;

    protected AbstractTemporalConverterValidator(BaseTemporalConverter converter, ConverterTextRangeResolver textRangeResolver) {
        this.converter = converter;
        this.textRangeResolver = textRangeResolver;
    }

    protected ConverterTextRangeResolver getTextRangeResolver() {
        return this.textRangeResolver;
    }

    protected AttributeMapping getAttributeMapping() {
        return this.converter.getParent();
    }

    protected PersistentAttribute getPersistentAttribute() {
        return this.getAttributeMapping().getPersistentAttribute();
    }

    @Override
    public boolean validate(List<IMessage> messages, IReporter reporter) {
        return this.validateAttributeTypeWithTemporal(messages);
    }

    protected boolean validateAttributeTypeWithTemporal(List<IMessage> messages) {
        String typeName = this.getTypeName();
        if (typeName == null) {
            return true;
        }
        if (!ArrayTools.contains((Object[])BaseTemporalConverter.TEMPORAL_MAPPING_SUPPORTED_TYPES, (Object)typeName)) {
            messages.add(this.buildInvalidTemporalMappingTypeMessage());
            return false;
        }
        return true;
    }

    protected abstract String getTypeName();

    protected IMessage buildInvalidTemporalMappingTypeMessage() {
        return this.getPersistentAttribute().isVirtual() ? this.buildVirtualAttributeInvalidTemporalMappingTypeMessage() : this.buildInvalidTemporalMappingTypeMessage_();
    }

    protected IMessage buildInvalidTemporalMappingTypeMessage_() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getInvalidTemporalMappingType(), StringTools.EMPTY_STRING_ARRAY, this.converter, this.getTextRangeResolver().getConverterTextRange());
    }

    protected abstract String getInvalidTemporalMappingType();

    protected IMessage buildVirtualAttributeInvalidTemporalMappingTypeMessage() {
        return DefaultJpaValidationMessages.buildMessage(1, this.getVirtualAttributeInvalidTemporalMappingType(), new String[]{this.getPersistentAttribute().getName()}, this.converter, this.getTextRangeResolver().getConverterTextRange());
    }

    protected abstract String getVirtualAttributeInvalidTemporalMappingType();
}

