/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyReferenceTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaReferenceTable;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaNode;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaTable;
import org.eclipse.jpt.jpa.core.internal.resource.java.NullJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.ReferenceTableAnnotation;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericJavaReferenceTable<A extends ReferenceTableAnnotation>
extends AbstractJavaTable<A>
implements JavaReferenceTable {
    protected final AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> specifiedJoinColumnContainer;
    protected final JavaReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected JavaJoinColumn defaultJoinColumn;

    protected GenericJavaReferenceTable(JavaJpaContextNode parent, ReadOnlyTable.Owner owner) {
        super(parent, owner);
        this.specifiedJoinColumnContainer = this.buildSpecifiedJoinColumnContainer();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.syncSpecifiedJoinColumns();
    }

    @Override
    public void update() {
        super.update();
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getSpecifiedJoinColumns());
        this.updateDefaultJoinColumn();
    }

    @Override
    public ListIterable<JavaJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int getJoinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    @Override
    public void convertDefaultJoinColumnToSpecified() {
        MappingTools.convertReferenceTableDefaultToSpecifiedJoinColumn(this);
    }

    @Override
    public ListIterable<JavaJoinColumn> getSpecifiedJoinColumns() {
        return this.specifiedJoinColumnContainer.getContextElements();
    }

    @Override
    public int getSpecifiedJoinColumnsSize() {
        return this.specifiedJoinColumnContainer.getContextElementsSize();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.getSpecifiedJoinColumnsSize() != 0;
    }

    @Override
    public JavaJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumnContainer.getContextElement(index);
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn() {
        return this.addSpecifiedJoinColumn(this.getSpecifiedJoinColumnsSize());
    }

    @Override
    public JavaJoinColumn addSpecifiedJoinColumn(int index) {
        JoinColumnAnnotation annotation = ((ReferenceTableAnnotation)this.getTableAnnotation()).addJoinColumn(index);
        return (JavaJoinColumn)this.specifiedJoinColumnContainer.addContextElement(index, annotation);
    }

    @Override
    public void removeSpecifiedJoinColumn(JoinColumn joinColumn) {
        this.removeSpecifiedJoinColumn(this.specifiedJoinColumnContainer.indexOfContextElement((JavaJoinColumn)joinColumn));
    }

    @Override
    public void removeSpecifiedJoinColumn(int index) {
        ((ReferenceTableAnnotation)this.getTableAnnotation()).removeJoinColumn(index);
        this.removeTableAnnotationIfUnset();
        this.specifiedJoinColumnContainer.removeContextElement(index);
    }

    @Override
    public void moveSpecifiedJoinColumn(int targetIndex, int sourceIndex) {
        ((ReferenceTableAnnotation)this.getTableAnnotation()).moveJoinColumn(targetIndex, sourceIndex);
        this.specifiedJoinColumnContainer.moveContextElement(targetIndex, sourceIndex);
    }

    @Override
    public void clearSpecifiedJoinColumns() {
        int index = this.getSpecifiedJoinColumnsSize();
        while (--index >= 0) {
            ((ReferenceTableAnnotation)this.getTableAnnotation()).removeJoinColumn(index);
        }
        this.removeTableAnnotationIfUnset();
        this.specifiedJoinColumnContainer.clearContextList();
    }

    protected void syncSpecifiedJoinColumns() {
        this.specifiedJoinColumnContainer.synchronizeWithResourceModel();
    }

    protected ListIterable<JoinColumnAnnotation> getJoinColumnAnnotations() {
        return ((ReferenceTableAnnotation)this.getTableAnnotation()).getJoinColumns();
    }

    protected abstract JavaReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    protected AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> buildSpecifiedJoinColumnContainer() {
        SpecifiedJoinColumnContainer container = new SpecifiedJoinColumnContainer();
        container.initialize();
        return container;
    }

    @Override
    public JavaJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(JavaJoinColumn joinColumn) {
        JavaJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<JavaJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(new NullJoinColumnAnnotation((JavaResourceNode)this.getTableAnnotation())));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected void initializeFrom(ReadOnlyReferenceTable oldTable) {
        super.initializeFrom(oldTable);
        for (ReadOnlyJoinColumn joinColumn : oldTable.getSpecifiedJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFrom(joinColumn);
        }
    }

    protected void initializeFromVirtual(ReadOnlyReferenceTable virtualTable) {
        super.initializeFromVirtual(virtualTable);
        for (ReadOnlyJoinColumn joinColumn : virtualTable.getJoinColumns()) {
            this.addSpecifiedJoinColumn().initializeFromVirtual(joinColumn);
        }
    }

    protected JavaJoinColumn buildJoinColumn(JoinColumnAnnotation joinColumnAnnotation) {
        return this.buildJoinColumn(this.joinColumnOwner, joinColumnAnnotation);
    }

    protected JavaJoinColumn buildJoinColumn(JavaReadOnlyJoinColumn.Owner jcOwner, JoinColumnAnnotation joinColumnAnnotation) {
        return this.getJpaFactory().buildJavaJoinColumn(this, jcOwner, joinColumnAnnotation);
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (JavaJoinColumn column : this.getJoinColumns()) {
            result = column.getJavaCompletionProposals(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        boolean continueValidating = this.buildTableValidator(astRoot).validate(messages, reporter);
        if (continueValidating) {
            this.validateJoinColumns(messages, reporter, astRoot);
        }
    }

    protected void validateJoinColumns(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        this.validateNodes((Iterable<? extends JavaJpaContextNode>)this.getJoinColumns(), messages, reporter, astRoot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainer
    extends AbstractJpaNode.ContextListContainer<JavaJoinColumn, JoinColumnAnnotation> {
        protected SpecifiedJoinColumnContainer() {
        }

        @Override
        protected String getContextElementsPropertyName() {
            return "specifiedJoinColumns";
        }

        @Override
        protected JavaJoinColumn buildContextElement(JoinColumnAnnotation resourceElement) {
            return GenericJavaReferenceTable.this.buildJoinColumn(resourceElement);
        }

        @Override
        protected ListIterable<JoinColumnAnnotation> getResourceElements() {
            return GenericJavaReferenceTable.this.getJoinColumnAnnotations();
        }

        @Override
        protected JoinColumnAnnotation getResourceElement(JavaJoinColumn contextElement) {
            return (JoinColumnAnnotation)contextElement.getColumnAnnotation();
        }
    }
}

