/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyBaseJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmPrimaryKeyJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmPrimaryKeyJoinColumn
extends AbstractOrmNamedColumn<XmlPrimaryKeyJoinColumn, OrmReadOnlyBaseJoinColumn.Owner>
implements OrmPrimaryKeyJoinColumn {
    protected XmlPrimaryKeyJoinColumn xmlColumn;
    protected String specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName();
    protected String defaultReferencedColumnName;

    public GenericOrmPrimaryKeyJoinColumn(XmlContextNode parent, OrmReadOnlyBaseJoinColumn.Owner owner, XmlPrimaryKeyJoinColumn xmlColumn) {
        super(parent, owner, xmlColumn);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public XmlPrimaryKeyJoinColumn getXmlColumn() {
        return this.xmlColumn;
    }

    @Override
    protected void setXmlColumn(XmlPrimaryKeyJoinColumn xmlColumn) {
        this.xmlColumn = xmlColumn;
    }

    @Override
    protected XmlPrimaryKeyJoinColumn buildXmlColumn() {
        throw new IllegalStateException("XML primary key join column is missing");
    }

    @Override
    protected void removeXmlColumn() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        this.setSpecifiedReferencedColumnName_(name);
        this.xmlColumn.setReferencedColumnName(name);
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName() {
        return this.xmlColumn == null ? null : this.xmlColumn.getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return this.buildDefaultName();
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((OrmReadOnlyBaseJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public void initializeFrom(ReadOnlyPrimaryKeyJoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public String getTable() {
        return ((OrmReadOnlyBaseJoinColumn.Owner)this.owner).getDefaultTableName();
    }

    @Override
    protected NamedColumnTextRangeResolver buildTextRangeResolver() {
        return new OrmPrimaryKeyJoinColumnTextRangeResolver(this);
    }

    @Override
    public TextRange getReferencedColumnNameTextRange() {
        return this.getValidationTextRange(this.xmlColumn.getReferencedColumnNameTextRange());
    }

    @Override
    protected Iterable<String> getConnectedXmlCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedXmlCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos)) {
            return this.getCandidateReferencedColumnNames();
        }
        return null;
    }

    public boolean referencedColumnNameTouches(int pos) {
        XmlPrimaryKeyJoinColumn column = this.getXmlColumn();
        return column != null && column.referencedColumnNameTouches(pos);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((OrmReadOnlyBaseJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }
}

