/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.Tools;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Embeddable;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.internal.validation.JpaValidationDescriptionMessages;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaDerivedIdentity2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaMapsIdDerivedIdentityStrategy2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaSingleRelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapsId2_0Annotation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaMapsIdDerivedIdentityStrategy2_0
extends AbstractJavaJpaContextNode
implements JavaMapsIdDerivedIdentityStrategy2_0 {
    protected String specifiedIdAttributeName = this.buildSpecifiedIdAttributeName();
    protected String defaultIdAttributeName;
    protected static final String[] ID_MAPPING_KEYS_ARRAY = new String[]{"id", "embeddedId"};
    protected static final Iterable<String> ID_MAPPING_KEYS = new ArrayIterable((Object[])ID_MAPPING_KEYS_ARRAY);

    public GenericJavaMapsIdDerivedIdentityStrategy2_0(JavaDerivedIdentity2_0 parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedIdAttributeName_(this.buildSpecifiedIdAttributeName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultIdAttributeName(this.buildDefaultIdAttributeName());
    }

    @Override
    public String getIdAttributeName() {
        return this.specifiedIdAttributeName != null ? this.specifiedIdAttributeName : this.defaultIdAttributeName;
    }

    @Override
    public String getSpecifiedIdAttributeName() {
        return this.specifiedIdAttributeName;
    }

    @Override
    public void setSpecifiedIdAttributeName(String idAttributeName) {
        if (this.valuesAreDifferent(idAttributeName, this.specifiedIdAttributeName)) {
            this.getAnnotation().setValue(idAttributeName);
            this.setSpecifiedIdAttributeName_(idAttributeName);
        }
    }

    protected void setSpecifiedIdAttributeName_(String idAttributeName) {
        String old = this.specifiedIdAttributeName;
        this.specifiedIdAttributeName = idAttributeName;
        this.firePropertyChanged("specifiedIdAttributeName", old, idAttributeName);
    }

    protected String buildSpecifiedIdAttributeName() {
        return this.getAnnotation().getValue();
    }

    @Override
    public String getDefaultIdAttributeName() {
        return this.defaultIdAttributeName;
    }

    protected void setDefaultIdAttributeName(String idAttributeName) {
        String old = this.defaultIdAttributeName;
        this.defaultIdAttributeName = idAttributeName;
        this.firePropertyChanged("defaultIdAttributeName", old, idAttributeName);
    }

    protected String buildDefaultIdAttributeName() {
        Iterator<AttributeMapping> stream = this.getIdAttributeMappings().iterator();
        if (stream.hasNext()) {
            AttributeMapping mapping = stream.next();
            return stream.hasNext() ? null : mapping.getName();
        }
        return null;
    }

    @Override
    public boolean defaultIdAttributeNameIsPossible() {
        return true;
    }

    protected MapsId2_0Annotation getAnnotation() {
        return (MapsId2_0Annotation)this.getResourceAttribute().getNonNullAnnotation(this.getAnnotationName());
    }

    protected MapsId2_0Annotation getAnnotationOrNull() {
        return (MapsId2_0Annotation)this.getResourceAttribute().getAnnotation(this.getAnnotationName());
    }

    protected void addAnnotation() {
        this.getResourceAttribute().addAnnotation(this.getAnnotationName());
    }

    protected void removeAnnotation() {
        this.getResourceAttribute().removeAnnotation(this.getAnnotationName());
    }

    protected String getAnnotationName() {
        return "javax.persistence.MapsId";
    }

    @Override
    public JavaDerivedIdentity2_0 getParent() {
        return (JavaDerivedIdentity2_0)super.getParent();
    }

    protected JavaDerivedIdentity2_0 getDerivedIdentity() {
        return this.getParent();
    }

    protected JavaSingleRelationshipMapping2_0 getMapping() {
        return this.getDerivedIdentity().getMapping();
    }

    protected JavaPersistentAttribute getPersistentAttribute() {
        return this.getMapping().getPersistentAttribute();
    }

    protected JavaResourceAttribute getResourceAttribute() {
        return this.getPersistentAttribute().getResourceAttribute();
    }

    protected Iterable<AttributeMapping> getAllAttributeMappings() {
        return this.getPersistentAttribute().getOwningTypeMapping().getAllAttributeMappings();
    }

    @Override
    public Iterable<String> getSortedCandidateIdAttributeNames() {
        return CollectionTools.sort(this.getAllAttributeMappingChoiceNames());
    }

    protected Iterable<String> getAllAttributeMappingChoiceNames() {
        return new TransformationIterable<AttributeMapping, String>(this.getAllAttributeMappingChoices()){

            protected String transform(AttributeMapping mapping) {
                return mapping.getName();
            }
        };
    }

    protected Iterable<AttributeMapping> getAllAttributeMappingChoices() {
        return this.buildAttributeMappingChoices(this.getAllAttributeMappings());
    }

    protected Iterable<AttributeMapping> buildAttributeMappingChoices(Iterable<AttributeMapping> attributeMappings) {
        return new CompositeIterable(this.getAttributeMappingChoiceIterables(attributeMappings));
    }

    protected Iterable<Iterable<AttributeMapping>> getAttributeMappingChoiceIterables(Iterable<AttributeMapping> availableMappings) {
        return new TransformationIterable<AttributeMapping, Iterable<AttributeMapping>>(availableMappings){

            protected Iterable<AttributeMapping> transform(AttributeMapping mapping) {
                if (Tools.valuesAreEqual((Object)mapping.getKey(), (Object)"embeddedId")) {
                    return GenericJavaMapsIdDerivedIdentityStrategy2_0.this.getEmbeddedIdMappingChoiceIterable((EmbeddedIdMapping)mapping);
                }
                return new SingleElementIterable((Object)mapping);
            }
        };
    }

    protected Iterable<AttributeMapping> getEmbeddedIdMappingChoiceIterable(EmbeddedIdMapping mapping) {
        Embeddable embeddable = mapping.getTargetEmbeddable();
        if (embeddable == null) {
            return new SingleElementIterable((Object)mapping);
        }
        return new CompositeIterable((Object)mapping, embeddable.getAllAttributeMappings());
    }

    @Override
    public AttributeMapping getDerivedIdAttributeMapping() {
        String idAttributeName = this.getIdAttributeName();
        if (idAttributeName != null) {
            for (AttributeMapping mapping : this.getAllAttributeMappingChoices()) {
                if (!idAttributeName.equals(mapping.getName())) continue;
                return mapping;
            }
        }
        return null;
    }

    @Override
    public boolean isSpecified() {
        return this.getAnnotationOrNull() != null;
    }

    @Override
    public void addStrategy() {
        if (this.getAnnotationOrNull() == null) {
            this.addAnnotation();
        }
    }

    @Override
    public void removeStrategy() {
        if (this.getAnnotationOrNull() != null) {
            this.removeAnnotation();
        }
    }

    @Override
    public Iterable<String> getJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterable<String> result = super.getJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.getAnnotation().valueTouches(pos)) {
            result = this.getSortedJavaValueChoices(filter);
        }
        return result;
    }

    protected Iterable<String> getSortedJavaValueChoices(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals((Iterable)new FilteringIterable(this.getSortedCandidateIdAttributeNames(), filter));
    }

    protected Iterable<AttributeMapping> getIdAttributeMappings() {
        return new FilteringIterable<AttributeMapping>(this.getAllAttributeMappings()){

            protected boolean accept(AttributeMapping mapping) {
                return GenericJavaMapsIdDerivedIdentityStrategy2_0.this.mappingIsIdMapping(mapping);
            }
        };
    }

    protected boolean mappingIsIdMapping(AttributeMapping mapping) {
        return CollectionTools.contains(this.getIdMappingKeys(), (Object)mapping.getKey());
    }

    protected Iterable<String> getIdMappingKeys() {
        return ID_MAPPING_KEYS;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        this.validateMapsId(messages, astRoot);
    }

    protected void validateMapsId(List<IMessage> messages, CompilationUnit astRoot) {
        if (this.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy()) {
            this.validateMapsId_(messages, astRoot);
        }
    }

    protected void validateMapsId_(List<IMessage> messages, CompilationUnit astRoot) {
        AttributeMapping attributeMapping = this.getDerivedIdAttributeMapping();
        if (attributeMapping == null) {
            if (this.specifiedIdAttributeName == null) {
                messages.add(this.buildMessage("MAPS_ID_VALUE_NOT_SPECIFIED", EMPTY_STRING_ARRAY, astRoot));
            } else {
                messages.add(this.buildMessage("MAPS_ID_VALUE_NOT_RESOLVED", new String[]{this.getIdAttributeName()}, astRoot));
            }
        } else if (!CollectionTools.contains(this.getValidAttributeMappingChoices(), (Object)attributeMapping)) {
            messages.add(this.buildMessage("MAPS_ID_VALUE_INVALID", new String[]{this.getIdAttributeName()}, astRoot));
        }
    }

    protected Iterable<AttributeMapping> getValidAttributeMappingChoices() {
        return this.buildAttributeMappingChoices(this.getIdAttributeMappings());
    }

    protected IMessage buildMessage(String msgID, String[] parms, CompilationUnit astRoot) {
        JavaPersistentAttribute attribute = this.getPersistentAttribute();
        String attributeDescription = attribute.isVirtual() ? JpaValidationDescriptionMessages.VIRTUAL_ATTRIBUTE_DESC : JpaValidationDescriptionMessages.ATTRIBUTE_DESC;
        attributeDescription = NLS.bind((String)attributeDescription, (Object)attribute.getName());
        parms = (String[])ArrayTools.add((Object[])parms, (int)0, (Object)attributeDescription);
        return DefaultJpaValidationMessages.buildMessage(1, msgID, parms, this, this.getValidationTextRange(astRoot));
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        TextRange textRange = this.getAnnotationTextRange(astRoot);
        return textRange != null ? textRange : this.getDerivedIdentity().getValidationTextRange(astRoot);
    }

    protected TextRange getAnnotationTextRange(CompilationUnit astRoot) {
        return this.getAnnotation().getTextRange(astRoot);
    }
}

