/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.context.java;

import java.util.List;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTableRelationship;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.ReadOnlyRelationship;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualJoinTableRelationshipStrategy;
import org.eclipse.jpt.jpa.core.internal.context.JoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaVirtualOverrideRelationship2_0;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaVirtualOverrideJoinTableRelationshipStrategy2_0
extends AbstractJavaJpaContextNode
implements JavaVirtualJoinTableRelationshipStrategy,
ReadOnlyTable.Owner {
    protected JavaVirtualJoinTable joinTable;

    public GenericJavaVirtualOverrideJoinTableRelationshipStrategy2_0(JavaVirtualOverrideRelationship2_0 parent) {
        super(parent);
    }

    @Override
    public void update() {
        super.update();
        this.updateJoinTable();
    }

    @Override
    public JavaVirtualJoinTable getJoinTable() {
        return this.joinTable;
    }

    protected void setJoinTable(JavaVirtualJoinTable joinTable) {
        JavaVirtualJoinTable old = this.joinTable;
        this.joinTable = joinTable;
        this.firePropertyChanged("joinTable", old, joinTable);
    }

    protected void updateJoinTable() {
        ReadOnlyJoinTable overriddenJoinTable = this.getOverriddenJoinTable();
        if (overriddenJoinTable == null) {
            if (this.joinTable != null) {
                this.setJoinTable(null);
            }
        } else if (this.joinTable != null && this.joinTable.getOverriddenTable() == overriddenJoinTable) {
            this.joinTable.update();
        } else {
            this.setJoinTable(this.buildJoinTable(overriddenJoinTable));
        }
    }

    protected ReadOnlyJoinTable getOverriddenJoinTable() {
        ReadOnlyJoinTableRelationshipStrategy overriddenStrategy = this.getOverriddenStrategy();
        return overriddenStrategy == null ? null : overriddenStrategy.getJoinTable();
    }

    protected JavaVirtualJoinTable buildJoinTable(ReadOnlyJoinTable overriddenJoinTable) {
        return this.getJpaFactory().buildJavaVirtualJoinTable(this, this, overriddenJoinTable);
    }

    @Override
    public JavaVirtualOverrideRelationship2_0 getParent() {
        return (JavaVirtualOverrideRelationship2_0)super.getParent();
    }

    @Override
    public JavaVirtualOverrideRelationship2_0 getRelationship() {
        return this.getParent();
    }

    protected ReadOnlyJoinTableRelationshipStrategy getOverriddenStrategy() {
        ReadOnlyJoinTableRelationship relationship = this.getOverriddenJoinTableRelationship();
        return relationship == null ? null : relationship.getJoinTableStrategy();
    }

    protected ReadOnlyJoinTableRelationship getOverriddenJoinTableRelationship() {
        ReadOnlyRelationship relationship = this.resolveOverriddenRelationship();
        return relationship instanceof ReadOnlyJoinTableRelationship ? (ReadOnlyJoinTableRelationship)relationship : null;
    }

    protected ReadOnlyRelationship resolveOverriddenRelationship() {
        return this.getRelationship().resolveOverriddenRelationship();
    }

    @Override
    public String getTableName() {
        return this.joinTable.getName();
    }

    @Override
    public String getJoinTableDefaultName() {
        return MappingTools.buildJoinTableDefaultName(this.getRelationship());
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter, CompilationUnit astRoot) {
        super.validate(messages, reporter, astRoot);
        if (this.joinTable != null) {
            this.joinTable.validate(messages, reporter, astRoot);
        }
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getRelationship().getTypeMapping().validatesAgainstDatabase();
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getRelationship().getValidationTextRange(astRoot);
    }

    @Override
    public JptValidator buildTableValidator(ReadOnlyTable table, TableTextRangeResolver textRangeResolver) {
        return this.getRelationship().buildJoinTableValidator((ReadOnlyJoinTable)table, textRangeResolver);
    }

    @Override
    public JptValidator buildJoinTableJoinColumnValidator(ReadOnlyJoinColumn column, ReadOnlyJoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
        return this.getRelationship().buildJoinTableJoinColumnValidator(column, owner, textRangeResolver);
    }

    @Override
    public JptValidator buildJoinTableInverseJoinColumnValidator(ReadOnlyJoinColumn column, ReadOnlyJoinColumn.Owner owner, JoinColumnTextRangeResolver textRangeResolver) {
        return this.getRelationship().buildJoinTableInverseJoinColumnValidator(column, owner, textRangeResolver);
    }
}

