/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.operations;

import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.core.internal.operations.AbstractJptFileCreationDataModelProvider;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.operations.JpaFileCreationDataModelProperties;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaFileCreationDataModelProvider
extends AbstractJptFileCreationDataModelProvider
implements JpaFileCreationDataModelProperties {
    protected AbstractJpaFileCreationDataModelProvider() {
    }

    public Set<String> getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("JpaFileCreationDataModelProperties.VERSION");
        return propertyNames;
    }

    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("JpaFileCreationDataModelProperties.VERSION")) {
            return this.getDefaultVersion();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected abstract String getDefaultVersion();

    public IStatus validate(String propertyName) {
        IStatus status = super.validate(propertyName);
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals("JptFileCreationDataModelProperties.CONTAINER_PATH") || propertyName.equals("JpaFileCreationDataModelProperties.VERSION")) {
            status = this.validateVersion();
        }
        if (!status.isOK()) {
            return status;
        }
        return status;
    }

    protected IStatus validateContainerPathAndFileName() {
        IStatus status = super.validateContainerPathAndFileName();
        if (!status.isOK()) {
            return status;
        }
        IContainer container = this.getContainer();
        IProject project = this.getProject(container);
        if (!JpaFacet.isInstalled(project)) {
            return new Status(4, "org.eclipse.jpt.jpa.core", JptCoreMessages.VALIDATE_PROJECT_NOT_JPA);
        }
        if (!this.hasSupportedPlatform(project)) {
            return new Status(4, "org.eclipse.jpt.jpa.core", JptCoreMessages.VALIDATE_PROJECT_IMPROPER_PLATFORM);
        }
        ProjectResourceLocator resourceLocator = (ProjectResourceLocator)project.getAdapter(ProjectResourceLocator.class);
        if (!resourceLocator.resourceLocationIsValid(container)) {
            return new Status(2, "org.eclipse.jpt.jpa.core", JptCoreMessages.VALIDATE_CONTAINER_QUESTIONABLE);
        }
        return Status.OK_STATUS;
    }

    protected IStatus validateVersion() {
        if (this.getProject() == null) {
            return Status.OK_STATUS;
        }
        String fileVersion = this.getStringProperty("JpaFileCreationDataModelProperties.VERSION");
        if (!this.fileVersionSupported(fileVersion)) {
            return new Status(4, "org.eclipse.jpt.jpa.core", JptCoreMessages.VALIDATE_FILE_VERSION_NOT_SUPPORTED);
        }
        try {
            String jpaFacetVersion = this.getJpaFacetVersion(this.getProject());
            if (!this.fileVersionSupportedForFacetVersion(fileVersion, jpaFacetVersion)) {
                return new Status(4, "org.eclipse.jpt.jpa.core", JptCoreMessages.VALIDATE_FILE_VERSION_NOT_SUPPORTED_FOR_FACET_VERSION);
            }
        }
        catch (CoreException coreException) {}
        return Status.OK_STATUS;
    }

    protected abstract boolean fileVersionSupported(String var1);

    protected abstract boolean fileVersionSupportedForFacetVersion(String var1, String var2);

    protected JpaProject getJpaProject() {
        return this.getJpaProject(this.getProject());
    }

    protected JpaProject getJpaProject(IProject project) {
        return project == null ? null : this.getJpaProject_(project);
    }

    protected JpaProject getJpaProject_(IProject project) {
        try {
            return this.getJpaProjectReference(project).getValue();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    protected JpaProject.Reference getJpaProjectReference(IProject project) {
        return (JpaProject.Reference)project.getAdapter(JpaProject.Reference.class);
    }

    protected String getJpaFacetVersion(IProject project) throws CoreException {
        IFacetedProject fproj = ProjectFacetsManager.create((IProject)project);
        return fproj.getProjectFacetVersion(JpaFacet.FACET).getVersionString();
    }

    protected boolean hasSupportedPlatform(IProject project) {
        JpaProject jpaProject = this.getJpaProject(project);
        return jpaProject != null && this.isSupportedPlatformId(jpaProject.getJpaPlatform().getId());
    }

    protected boolean isSupportedPlatformId(String id) {
        return true;
    }
}

