/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.operations;

import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.operations.AbstractJpaFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProperties;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.DataModelPropertyDescriptor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmFileCreationDataModelProvider
extends AbstractJpaFileCreationDataModelProvider
implements OrmFileCreationDataModelProperties {
    public IDataModelOperation getDefaultOperation() {
        return new OrmFileCreationOperation(this.getDataModel());
    }

    @Override
    public Set<String> getPropertyNames() {
        Set<String> propertyNames = super.getPropertyNames();
        propertyNames.add("OrmFileCreationDataModelProperties.DEFAULT_ACCESS");
        propertyNames.add("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        propertyNames.add("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        return propertyNames;
    }

    public boolean isPropertyEnabled(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        }
        return super.isPropertyEnabled(propertyName);
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        PersistenceUnit pUnit;
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            return null;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            return Boolean.FALSE;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT") && (pUnit = this.getDefaultPersistenceUnit()) != null) {
            return pUnit.getName();
        }
        return super.getDefaultProperty(propertyName);
    }

    protected String getDefaultFileName() {
        return JptJpaCorePlugin.DEFAULT_ORM_XML_RUNTIME_PATH.lastSegment();
    }

    @Override
    protected String getDefaultVersion() {
        if (this.getProject() == null) {
            return null;
        }
        JpaProject jpaProject = this.getJpaProject();
        JpaPlatform jpaPlatform = jpaProject == null ? JptJpaCorePlugin.getJpaPlatformManager().buildJpaPlatformImplementation(this.getProject()) : jpaProject.getJpaPlatform();
        return jpaPlatform.getMostRecentSupportedResourceType(JptJpaCorePlugin.ORM_XML_CONTENT_TYPE).getVersion();
    }

    protected PersistenceUnit getDefaultPersistenceUnit() {
        JpaProject jpaProject = this.getJpaProject();
        if (jpaProject == null) {
            return null;
        }
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.getPersistenceUnitsSize() == 0) {
            return null;
        }
        return (PersistenceUnit)persistence.getPersistenceUnits().iterator().next();
    }

    public boolean propertySet(String propertyName, Object propertyValue) {
        boolean ok = super.propertySet(propertyName, propertyValue);
        if (propertyName.equals("JptFileCreationDataModelProperties.CONTAINER_PATH")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 2);
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 4);
        } else if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT")) {
            this.model.notifyPropertyChange("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT", 3);
        }
        return ok;
    }

    public DataModelPropertyDescriptor[] getValidPropertyDescriptors(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            DataModelPropertyDescriptor[] accessTypes = new DataModelPropertyDescriptor[]{this.accessPropertyDescriptor(null), this.accessPropertyDescriptor("FIELD"), this.accessPropertyDescriptor("PROPERTY")};
            return accessTypes;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return (DataModelPropertyDescriptor[])ArrayTools.array((Iterable)new TransformationIterable<String, DataModelPropertyDescriptor>((Iterable)new CompositeIterable(null, this.getPersistenceUnitNames())){

                protected DataModelPropertyDescriptor transform(String next) {
                    return OrmFileCreationDataModelProvider.this.persistenceUnitPropertyDescriptor(next);
                }
            }, (Object[])new DataModelPropertyDescriptor[0]);
        }
        return super.getValidPropertyDescriptors(propertyName);
    }

    public DataModelPropertyDescriptor getPropertyDescriptor(String propertyName) {
        if (propertyName.equals("OrmFileCreationDataModelProperties.DEFAULT_ACCESS")) {
            return this.accessPropertyDescriptor((String)this.getProperty("OrmFileCreationDataModelProperties.DEFAULT_ACCESS"));
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            return this.persistenceUnitPropertyDescriptor(this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT"));
        }
        return super.getPropertyDescriptor(propertyName);
    }

    protected DataModelPropertyDescriptor accessPropertyDescriptor(String accessType) {
        if (accessType == null) {
            return new DataModelPropertyDescriptor(null, JptCoreMessages.NONE);
        }
        return new DataModelPropertyDescriptor((Object)accessType);
    }

    DataModelPropertyDescriptor persistenceUnitPropertyDescriptor(String persistenceUnitName) {
        if (StringTools.stringIsEmpty((String)persistenceUnitName)) {
            return new DataModelPropertyDescriptor(null, JptCoreMessages.NONE);
        }
        return new DataModelPropertyDescriptor((Object)persistenceUnitName);
    }

    @Override
    public IStatus validate(String propertyName) {
        IStatus status = super.validate(propertyName);
        if (!status.isOK()) {
            return status;
        }
        if (propertyName.equals("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT") || propertyName.equals("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT")) {
            status = this.validatePersistenceUnit();
        }
        if (!status.isOK()) {
            return status;
        }
        return Status.OK_STATUS;
    }

    @Override
    protected boolean fileVersionSupported(String fileVersion) {
        return fileVersion.equals("1.0") || fileVersion.equals("2.0");
    }

    @Override
    protected boolean fileVersionSupportedForFacetVersion(String fileVersion, String jpaFacetVersion) {
        return !jpaFacetVersion.equals(JpaFacet.VERSION_1_0.getVersionString()) || !fileVersion.equals("2.0");
    }

    protected IStatus validatePersistenceUnit() {
        boolean addToPUnit = this.getBooleanProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT");
        String projectName = this.getProject().getName();
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        if (addToPUnit) {
            if (StringTools.stringIsEmpty((String)pUnitName)) {
                return new Status(4, "org.eclipse.jpt.jpa.core", NLS.bind((String)JptCoreMessages.VALIDATE_PERSISTENCE_UNIT_DOES_NOT_SPECIFIED, (Object)pUnitName));
            }
            if (this.getPersistenceUnit() == null) {
                return new Status(4, "org.eclipse.jpt.jpa.core", NLS.bind((String)JptCoreMessages.VALIDATE_PERSISTENCE_UNIT_NOT_IN_PROJECT, (Object)pUnitName, (Object)projectName));
            }
        }
        return Status.OK_STATUS;
    }

    protected PersistenceUnit getPersistenceUnit() {
        Persistence persistence;
        String pUnitName = this.getStringProperty("OrmFileCreationDataModelProperties.PERSISTENCE_UNIT");
        JpaProject jpaProject = StringTools.stringIsEmpty((String)pUnitName) ? null : this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getRootContextNode().getPersistenceXml();
        Persistence persistence2 = persistence = persistenceXml == null ? null : persistenceXml.getPersistence();
        if (persistence != null) {
            for (PersistenceUnit next : persistence.getPersistenceUnits()) {
                if (!pUnitName.equals(next.getName())) continue;
                return next;
            }
        }
        return null;
    }

    protected Iterable<PersistenceUnit> getPersistenceUnits() {
        JpaProject jpaProject = this.getJpaProject();
        PersistenceXml persistenceXml = jpaProject == null ? null : jpaProject.getRootContextNode().getPersistenceXml();
        Persistence persistence = persistenceXml == null ? null : persistenceXml.getPersistence();
        return persistence == null ? EmptyIterable.instance() : persistence.getPersistenceUnits();
    }

    protected Iterable<String> getPersistenceUnitNames() {
        return new TransformationIterable<PersistenceUnit, String>(this.getPersistenceUnits()){

            protected String transform(PersistenceUnit next) {
                return next.getName();
            }
        };
    }
}

