/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceNamedColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorColumnAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.DiscriminatorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceBaseDiscriminatorColumnAnnotation
extends SourceNamedColumnAnnotation
implements DiscriminatorColumnAnnotation {
    private DeclarationAnnotationElementAdapter<String> discriminatorTypeDeclarationAdapter = this.buildDiscriminatorTypeDeclarationAdapter();
    private AnnotationElementAdapter<String> discriminatorTypeAdapter = this.buildDiscriminatorTypeAdapter();
    private DiscriminatorType discriminatorType;
    private DeclarationAnnotationElementAdapter<Integer> lengthDeclarationAdapter = this.buildLengthDeclarationAdapter();
    private AnnotationElementAdapter<Integer> lengthAdapter = this.buildLengthAdapter();
    private Integer length;

    protected SourceBaseDiscriminatorColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    protected SourceBaseDiscriminatorColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    protected SourceBaseDiscriminatorColumnAnnotation(JavaResourceNode parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        this.discriminatorType = this.buildDiscriminatorType(astRoot);
        this.length = this.buildLength(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncLength(this.buildLength(astRoot));
        this.syncDiscriminatorType(this.buildDiscriminatorType(astRoot));
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public void setDiscriminatorType(DiscriminatorType discriminatorType) {
        if (this.attributeValueHasChanged((Object)this.discriminatorType, (Object)discriminatorType)) {
            this.discriminatorType = discriminatorType;
            this.discriminatorTypeAdapter.setValue((Object)DiscriminatorType.toJavaAnnotationValue(discriminatorType));
        }
    }

    private void syncDiscriminatorType(DiscriminatorType astDiscriminatorType) {
        DiscriminatorType old = this.discriminatorType;
        this.discriminatorType = astDiscriminatorType;
        this.firePropertyChanged("discriminatorType", (Object)old, (Object)astDiscriminatorType);
    }

    private DiscriminatorType buildDiscriminatorType(CompilationUnit astRoot) {
        return DiscriminatorType.fromJavaAnnotationValue(this.discriminatorTypeAdapter.getValue(astRoot));
    }

    private DeclarationAnnotationElementAdapter<String> buildDiscriminatorTypeDeclarationAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(this.daa, this.getDiscriminatorTypeElementName());
    }

    private AnnotationElementAdapter<String> buildDiscriminatorTypeAdapter() {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, this.discriminatorTypeDeclarationAdapter);
    }

    protected abstract String getDiscriminatorTypeElementName();

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        if (this.attributeValueHasChanged(this.length, length)) {
            this.length = length;
            this.lengthAdapter.setValue((Object)length);
        }
    }

    private void syncLength(Integer astLength) {
        Integer old = this.length;
        this.length = astLength;
        this.firePropertyChanged("length", old, astLength);
    }

    private Integer buildLength(CompilationUnit astRoot) {
        return (Integer)this.lengthAdapter.getValue(astRoot);
    }

    private DeclarationAnnotationElementAdapter<Integer> buildLengthDeclarationAdapter() {
        return this.buildIntegerElementAdapter(this.getLengthElementName());
    }

    private AnnotationElementAdapter<Integer> buildLengthAdapter() {
        return this.buildIntegerElementAdapter(this.lengthDeclarationAdapter);
    }

    protected abstract String getLengthElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.discriminatorType == null && this.length == null;
    }
}

