/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.InheritanceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceInheritanceAnnotation
extends SourceAnnotation
implements InheritanceAnnotation {
    private static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Inheritance");
    private static final DeclarationAnnotationElementAdapter<String> STRATEGY_ADAPTER = SourceInheritanceAnnotation.buildStrategyAdapter();
    private final AnnotationElementAdapter<String> strategyAdapter;
    private InheritanceType strategy;
    private TextRange strategyTextRange;

    public SourceInheritanceAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement element) {
        super((JavaResourceNode)parent, element, DECLARATION_ANNOTATION_ADAPTER);
        this.strategyAdapter = new AnnotatedElementAnnotationElementAdapter(element, STRATEGY_ADAPTER);
    }

    public String getAnnotationName() {
        return "javax.persistence.Inheritance";
    }

    public void initialize(CompilationUnit astRoot) {
        this.strategy = this.buildStrategy(astRoot);
        this.strategyTextRange = this.buildStrategyTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncStrategy(this.buildStrategy(astRoot));
        this.strategyTextRange = this.buildStrategyTextRange(astRoot);
    }

    public boolean isUnset() {
        return super.isUnset() && this.strategy == null;
    }

    public void toString(StringBuilder sb) {
        sb.append((Object)this.strategy);
    }

    @Override
    public InheritanceType getStrategy() {
        return this.strategy;
    }

    @Override
    public void setStrategy(InheritanceType strategy) {
        if (this.attributeValueHasChanged((Object)this.strategy, (Object)strategy)) {
            this.strategy = strategy;
            this.strategyAdapter.setValue((Object)InheritanceType.toJavaAnnotationValue(strategy));
        }
    }

    private void syncStrategy(InheritanceType astStrategy) {
        InheritanceType old = this.strategy;
        this.strategy = astStrategy;
        this.firePropertyChanged("strategy", (Object)old, (Object)astStrategy);
    }

    private InheritanceType buildStrategy(CompilationUnit astRoot) {
        return InheritanceType.fromJavaAnnotationValue(this.strategyAdapter.getValue(astRoot));
    }

    @Override
    public TextRange getStrategyTextRange() {
        return this.strategyTextRange;
    }

    private TextRange buildStrategyTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(STRATEGY_ADAPTER, astRoot);
    }

    private static DeclarationAnnotationElementAdapter<String> buildStrategyAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "strategy");
    }
}

