/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Arrays;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotatedElementAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.ExpressionConverter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.resource.java.UniqueConstraintAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceUniqueConstraintAnnotation
extends SourceAnnotation
implements UniqueConstraintAnnotation {
    private DeclarationAnnotationElementAdapter<String[]> columnNamesDeclarationAdapter;
    private AnnotationElementAdapter<String[]> columnNamesAdapter;
    private final Vector<String> columnNames = new Vector();
    private TextRange columnNamesTextRange;

    public SourceUniqueConstraintAnnotation(JavaResourceNode parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
        this.columnNamesDeclarationAdapter = this.buildColumnNamesDeclarationAdapter();
        this.columnNamesAdapter = this.buildColumnNamesAdapter();
    }

    public String getAnnotationName() {
        return "javax.persistence.UniqueConstraint";
    }

    public void initialize(CompilationUnit astRoot) {
        this.initializeColumnNames(astRoot);
        this.columnNamesTextRange = this.buildColumnNamesTextRange(astRoot);
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncColumnNames(astRoot);
        this.columnNamesTextRange = this.buildColumnNamesTextRange(astRoot);
    }

    @Override
    public ListIterable<String> getColumnNames() {
        return new LiveCloneListIterable(this.columnNames);
    }

    @Override
    public int getColumnNamesSize() {
        return this.columnNames.size();
    }

    @Override
    public String columnNameAt(int index) {
        return this.columnNames.elementAt(index);
    }

    @Override
    public void addColumnName(String columnName) {
        this.addColumnName(this.columnNames.size(), columnName);
    }

    @Override
    public void addColumnName(int index, String columnName) {
        this.columnNames.add(index, columnName);
        this.writeColumnNames();
    }

    @Override
    public void moveColumnName(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.columnNames, (int)targetIndex, (int)sourceIndex);
        this.writeColumnNames();
    }

    @Override
    public void removeColumnName(String columnName) {
        this.columnNames.remove(columnName);
        this.writeColumnNames();
    }

    @Override
    public void removeColumnName(int index) {
        this.columnNames.remove(index);
        this.writeColumnNames();
    }

    private void writeColumnNames() {
        this.columnNamesAdapter.setValue((Object)this.columnNames.toArray(new String[this.columnNames.size()]));
    }

    private void initializeColumnNames(CompilationUnit astRoot) {
        String[] astColumnNames = (String[])this.columnNamesAdapter.getValue(astRoot);
        int i = 0;
        while (i < astColumnNames.length) {
            this.columnNames.add(astColumnNames[i]);
            ++i;
        }
    }

    private void syncColumnNames(CompilationUnit astRoot) {
        String[] javaColumnNames = (String[])this.columnNamesAdapter.getValue(astRoot);
        this.synchronizeList(Arrays.asList(javaColumnNames), this.columnNames, "columnNames");
    }

    private TextRange buildColumnNamesTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.columnNamesDeclarationAdapter, astRoot);
    }

    @Override
    public boolean columnNamesTouches(int pos) {
        return this.textRangeTouches(this.columnNamesTextRange, pos);
    }

    private DeclarationAnnotationElementAdapter<String[]> buildColumnNamesDeclarationAdapter() {
        return SourceUniqueConstraintAnnotation.buildArrayAnnotationElementAdapter(this.daa, "columnNames");
    }

    private AnnotationElementAdapter<String[]> buildColumnNamesAdapter() {
        return this.buildAnnotationElementAdapter(this.columnNamesDeclarationAdapter);
    }

    private AnnotationElementAdapter<String[]> buildAnnotationElementAdapter(DeclarationAnnotationElementAdapter<String[]> daea) {
        return new AnnotatedElementAnnotationElementAdapter(this.annotatedElement, daea);
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return SourceUniqueConstraintAnnotation.buildArrayAnnotationElementAdapter(annotationAdapter, elementName, (ExpressionConverter<String[]>)AnnotationStringArrayExpressionConverter.forStrings());
    }

    private static DeclarationAnnotationElementAdapter<String[]> buildArrayAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, ExpressionConverter<String[]> converter) {
        return new ConversionDeclarationAnnotationElementAdapter(annotationAdapter, elementName, converter);
    }

    public boolean isUnset() {
        return super.isUnset() && this.columnNames.isEmpty();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.columnNames);
    }
}

