/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.common.core.internal.utility.SimpleTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.jpa.core.jpql.spi.IManagedTypeBuilder;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaQuery;
import org.eclipse.jpt.jpa.core.prefs.JpaValidationPreferencesManager;
import org.eclipse.persistence.jpa.jpql.AbstractJPQLQueryHelper;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.spi.IManagedTypeProvider;
import org.eclipse.persistence.jpa.jpql.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.spi.IQuery;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaJpqlQueryHelper
extends AbstractJPQLQueryHelper {
    private IManagedTypeProvider managedTypeProvider;

    protected JpaJpqlQueryHelper(JPQLGrammar jpqlGrammar) {
        super(jpqlGrammar);
    }

    protected abstract IManagedTypeBuilder buildManagedTypeBuilder();

    protected abstract IMappingBuilder<AttributeMapping> buildMappingBuilder();

    public int[] buildPositions(JPQLQueryProblem problem, String parsedJpqlQuery, String actualQuery) {
        int newStartPosition;
        int endPosition;
        int startPosition = problem.getStartPosition();
        if (startPosition == (endPosition = problem.getEndPosition())) {
            startPosition = Math.max(startPosition - 1, 0);
        }
        if ((newStartPosition = ExpressionTools.repositionCursor((CharSequence)parsedJpqlQuery, (int)startPosition, (CharSequence)actualQuery)) != startPosition) {
            endPosition += newStartPosition - startPosition;
            startPosition = newStartPosition;
        }
        return new int[]{startPosition, endPosition};
    }

    protected IMessage buildProblem(NamedQuery namedQuery, TextRange textRange, JPQLQueryProblem problem, String parsedJpqlQuery, String actualQuery, int offset) {
        int[] positions = this.buildPositions(problem, parsedJpqlQuery, actualQuery);
        int[] newStartPosition = new int[]{positions[0]};
        ExpressionTools.escape((CharSequence)actualQuery, (int[])newStartPosition);
        int escapeOffset = positions[0] - newStartPosition[0];
        positions[0] = positions[0] - escapeOffset;
        positions[1] = positions[1] - escapeOffset;
        textRange = new SimpleTextRange(textRange.getOffset() + positions[0] + offset, positions[1] - positions[0], textRange.getLineNumber());
        IMessage message = DefaultJpaValidationMessages.buildMessage(this.severity(namedQuery.getResource()), problem.getMessageKey(), problem.getMessageArguments(), namedQuery, textRange);
        message.setBundleName("jpa_jpql_validation");
        return message;
    }

    protected JpaManagedTypeProvider buildProvider(JpaProject jpaProject, PersistenceUnit persistenceUnit) {
        return new JpaManagedTypeProvider(jpaProject, persistenceUnit, this.buildManagedTypeBuilder(), this.buildMappingBuilder());
    }

    protected String getValidationPreference(NamedQuery namedQuery) {
        return JpaValidationPreferencesManager.getProblemPreference(namedQuery.getResource(), "JPQL_QUERY_VALIDATION");
    }

    public void setQuery(NamedQuery namedQuery, String actualQuery) {
        if (this.managedTypeProvider == null) {
            this.managedTypeProvider = this.buildProvider(namedQuery.getJpaProject(), namedQuery.getPersistenceUnit());
        }
        JpaQuery query = new JpaQuery(this.managedTypeProvider, namedQuery, actualQuery);
        super.setQuery((IQuery)query);
    }

    protected int severity(IResource targetObject) {
        int severity = JpaValidationPreferencesManager.getProblemSeverityPreference(targetObject, "JPQL_QUERY_VALIDATION");
        if (severity == -1) {
            return 1;
        }
        return severity;
    }

    protected boolean shouldValidate(NamedQuery namedQuery) {
        return !StringTools.stringsAreEqual((String)this.getValidationPreference(namedQuery), (String)"ignore");
    }

    public void validate(NamedQuery namedQuery, String jpqlQuery, TextRange textRange, int offset, List<IMessage> messages) {
        try {
            if (this.shouldValidate(namedQuery)) {
                this.setQuery(namedQuery, jpqlQuery);
                String parsedJpqlQuery = this.getParsedJPQLQuery();
                for (JPQLQueryProblem problem : this.validate()) {
                    IMessage message = this.buildProblem(namedQuery, textRange, problem, parsedJpqlQuery, jpqlQuery, offset);
                    messages.add(message);
                }
            }
        }
        finally {
            this.dispose();
        }
    }
}

