/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeDeclaration;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaTypeRepository;
import org.eclipse.persistence.jpa.jpql.spi.IConstructor;
import org.eclipse.persistence.jpa.jpql.spi.IType;
import org.eclipse.persistence.jpa.jpql.spi.ITypeDeclaration;

public class JpaConstructor
implements IConstructor {
    private IMethodBinding constructor;
    private ITypeDeclaration[] typeDeclarations;
    private JpaType type;

    public JpaConstructor(JpaType type, IMethodBinding constructor) {
        this.type = type;
        this.constructor = constructor;
    }

    protected ITypeDeclaration buildTypeDeclaration(ITypeBinding parameterType) {
        String typeParameterName;
        boolean array = parameterType.isArray();
        if (array) {
            ITypeBinding componentType = parameterType.getComponentType();
            typeParameterName = componentType.isTypeVariable() || componentType.isParameterizedType() ? componentType.getErasure().getQualifiedName() : componentType.getQualifiedName();
            parameterType = componentType;
        } else {
            typeParameterName = parameterType.isTypeVariable() || parameterType.isParameterizedType() ? parameterType.getErasure().getQualifiedName() : parameterType.getQualifiedName();
        }
        JpaTypeRepository typeRepository = this.type.getTypeRepository();
        ITypeBinding[] typeArguments = parameterType.getTypeArguments();
        ITypeDeclaration[] genericTypes = new ITypeDeclaration[typeArguments.length];
        int index = 0;
        ITypeBinding[] iTypeBindingArray = typeArguments;
        int n = typeArguments.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeArgument = iTypeBindingArray[n2];
            String genericTypeName = typeArgument.getErasure().getQualifiedName();
            IType genericType = typeRepository.getType(genericTypeName);
            genericTypes[index++] = genericType.getTypeDeclaration();
            ++n2;
        }
        return new JpaTypeDeclaration(typeRepository.getType(typeParameterName), genericTypes, parameterType.getDimensions());
    }

    protected ITypeDeclaration[] buildTypeDeclarations() {
        ITypeBinding[] parameterTypes = this.constructor.getParameterTypes();
        ITypeDeclaration[] declarations = new ITypeDeclaration[parameterTypes.length];
        int index = declarations.length;
        while (--index >= 0) {
            declarations[index] = this.buildTypeDeclaration(parameterTypes[index]);
        }
        return declarations;
    }

    public ITypeDeclaration[] getParameterTypes() {
        if (this.typeDeclarations == null) {
            this.typeDeclarations = this.buildTypeDeclarations();
        }
        return this.typeDeclarations;
    }

    public String toString() {
        return this.constructor.toString();
    }
}

