/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadataprocessors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.jsf.common.dom.AttributeIdentifier;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.ITypeDescriptor;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataContext;
import org.eclipse.jst.jsf.metadataprocessors.internal.AttributeValueRuntimeTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaDataEnabledProcessingFactory {
    private static MetaDataEnabledProcessingFactory INSTANCE;
    public static final String ATTRIBUTE_VALUE_RUNTIME_TYPE_PROP_NAME = "attribute-value-runtime-type";

    public static MetaDataEnabledProcessingFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetaDataEnabledProcessingFactory();
        }
        return INSTANCE;
    }

    private MetaDataEnabledProcessingFactory() {
    }

    public List<IMetaDataEnabledFeature> getAttributeValueRuntimeTypeFeatureProcessors(Class featureType, IStructuredDocumentContext sdContext, String uri, String tagName, String attributeName) {
        String attrKey = String.valueOf(tagName) + "/" + attributeName;
        IMetaDataDomainContext modelContext = this.getMetaDataDomainContext(sdContext);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(modelContext);
        Entity attrEntity = query.getQueryHelper().getEntity(uri, attrKey);
        if (attrEntity != null) {
            return this.getAttributeValueRuntimeTypeFeatureProcessors(featureType, sdContext, attrEntity);
        }
        return Collections.EMPTY_LIST;
    }

    private IProject getProject(IStructuredDocumentContext sdContext) {
        IProject project = null;
        if (sdContext != null) {
            IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(sdContext);
            project = resolver != null ? resolver.getProject() : null;
        }
        return project;
    }

    private IFile getFile(IStructuredDocumentContext sdContext) {
        IFile file = null;
        if (sdContext != null) {
            IResource res;
            IWorkspaceContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(sdContext);
            IResource iResource = res = resolver != null ? resolver.getResource() : null;
            if (res instanceof IFile) {
                file = (IFile)res;
            }
        }
        return file;
    }

    public List<IMetaDataEnabledFeature> getAttributeValueRuntimeTypeFeatureProcessors(Class featureType, IStructuredDocumentContext sdContext, AttributeIdentifier attributeId) {
        return this.getAttributeValueRuntimeTypeFeatureProcessors(featureType, sdContext, attributeId.getTagIdentifier().getUri(), attributeId.getTagIdentifier().getTagName(), attributeId.getName());
    }

    public List<IMetaDataEnabledFeature> getAttributeValueRuntimeTypeFeatureProcessors(Class featureType, IStructuredDocumentContext sdContext, Entity attrEntity) {
        IMetaDataDomainContext modelContext = this.getMetaDataDomainContext(sdContext);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(modelContext);
        Trait trait = query.findTrait(attrEntity, ATTRIBUTE_VALUE_RUNTIME_TYPE_PROP_NAME);
        if (trait == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IMetaDataEnabledFeature> retList = new ArrayList<IMetaDataEnabledFeature>(2);
        String typeId = TraitValueHelper.getValueAsString((Trait)trait);
        ITypeDescriptor type = AttributeValueRuntimeTypeFactory.getInstance().getType(typeId);
        if (type != null) {
            MetaDataContext context = new MetaDataContext(attrEntity, trait);
            List<IMetaDataEnabledFeature> featureAdapters = type.getFeatureAdapters(featureType);
            int j = 0;
            while (j < featureAdapters.size()) {
                featureAdapters.get(j).setMetaDataContext(context);
                featureAdapters.get(j).setStructuredDocumentContext(sdContext);
                retList.add(featureAdapters.get(j));
                ++j;
            }
        }
        return Collections.unmodifiableList(retList);
    }

    private IMetaDataDomainContext getMetaDataDomainContext(IStructuredDocumentContext sdContext) {
        IFile file = this.getFile(sdContext);
        if (file != null) {
            return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        }
        return MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(this.getProject(sdContext));
    }
}

