/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.font.ICSSFont;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.css2.property.FloatInfo;
import org.eclipse.jst.pagedesigner.css2.value.Length;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class LengthMeta
extends CSSPropertyMeta {
    private static final String[] KEYWORDS = new String[]{"auto"};

    public LengthMeta(boolean inherit, Object initvalue) {
        super(inherit, initvalue);
    }

    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        float fvalue;
        if (value == null || value.getCssValueType() == 2 || value.getCssValueType() == 3) {
            return "auto";
        }
        if (value.getCssValueType() == 0) {
            return "auto";
        }
        CSSPrimitiveValue primitive = (CSSPrimitiveValue)value;
        String key = this.checkKeywordValues(primitive.getCssText());
        if (key != null) {
            return key;
        }
        short unitType = primitive.getPrimitiveType();
        try {
            fvalue = primitive.getFloatValue(unitType);
        }
        catch (DOMException dOMException) {
            return "auto";
        }
        return LengthMeta.toLength(fvalue, unitType, style, this.getPercentageType(), this.getBaseFont(style));
    }

    public static Object toLength(String lengthStr, ICSSStyle style, int percenttype, ICSSFont font) {
        try {
            FloatInfo floatinfo = new FloatInfo(lengthStr);
            return LengthMeta.toLength(floatinfo.getValue(), floatinfo.getValueType(), style, percenttype, font);
        }
        catch (Exception exception) {
            return "auto";
        }
    }

    public static Object toLength(float result, short unitType, ICSSStyle style, int percenttype, ICSSFont font) {
        switch (unitType) {
            case 2: {
                if (percenttype == 3) {
                    result = (int)((double)(result * (float)font.getFontSize()) / 100.0);
                    break;
                }
                return new Length((int)result, true);
            }
            case 1: 
            case 5: {
                break;
            }
            case 3: {
                result *= (float)font.getFontSize();
                break;
            }
            case 4: {
                result *= (float)font.getXHeight();
                break;
            }
            case 6: {
                result = LengthMeta.cmToPixel(result);
                break;
            }
            case 8: {
                result = LengthMeta.inToPixel(result);
                break;
            }
            case 7: {
                result = LengthMeta.mmToPixel(result);
                break;
            }
            case 9: {
                result = LengthMeta.ptToPixel(result);
                break;
            }
            case 10: {
                result = LengthMeta.pcToPixel(result);
                break;
            }
            case 19: {
                return "auto";
            }
        }
        return new Length((int)result, false);
    }

    protected ICSSFont getBaseFont(ICSSStyle style) {
        return style.getCSSFont();
    }

    private static float pcToPixel(float value) {
        return LengthMeta.ptToPixel(12.0f * value);
    }

    private static float ptToPixel(float floatValue) {
        return LengthMeta.inToPixel(floatValue / 72.0f);
    }

    private static float mmToPixel(float floatValue) {
        return LengthMeta.cmToPixel(floatValue / 10.0f);
    }

    private static float inToPixel(float floatValue) {
        return LengthMeta.getDPI() * floatValue;
    }

    private static float cmToPixel(float floatValue) {
        return LengthMeta.inToPixel((float)((double)floatValue / 2.54));
    }

    private static float getDPI() {
        return Display.getCurrent().getDPI().x;
    }

    public static boolean isAuto(Object result) {
        if (result == "auto") {
            return true;
        }
        return result instanceof Length && ((Length)result).getValue() <= 0;
    }
}

