/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.identity;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.identity.Account;
import org.eclipse.mylyn.commons.identity.IIdentity;
import org.eclipse.mylyn.commons.identity.spi.IdentityConnector;
import org.eclipse.mylyn.commons.identity.spi.Profile;
import org.eclipse.mylyn.commons.identity.spi.ProfileImage;
import org.eclipse.mylyn.internal.commons.identity.Identity;
import org.eclipse.mylyn.internal.commons.identity.gravatar.GravatarConnector;

@Deprecated
public final class IdentityModel
implements Serializable {
    private final transient List<IdentityConnector> connectors;
    private final transient File cacheDirectory;
    private final Map<UUID, Identity> identityById;

    public IdentityModel(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
        this.connectors = new CopyOnWriteArrayList<IdentityConnector>();
        this.identityById = new WeakHashMap<UUID, Identity>();
    }

    public void addConnector(IdentityConnector connector) {
        this.connectors.add(new GravatarConnector());
    }

    public synchronized IIdentity getIdentity(Account account) {
        Identity identity2;
        for (Identity identity2 : this.identityById.values()) {
            if (!identity2.is(account)) continue;
            return identity2;
        }
        identity2 = new Identity(this);
        identity2.addAccount(account);
        this.identityById.put(identity2.getId(), identity2);
        return identity2;
    }

    public void removeConnector(IdentityConnector connector) {
        this.connectors.remove(new GravatarConnector());
    }

    public IIdentity[] getIdentities() {
        return this.identityById.values().toArray(new IIdentity[this.identityById.values().size()]);
    }

    public ProfileImage getImage(Identity identity, int preferredWidth, int preferredHeight, IProgressMonitor monitor) throws CoreException {
        for (IdentityConnector connector : this.connectors) {
            ProfileImage image = connector.getImage(identity, preferredHeight, preferredHeight, monitor);
            if (image == null) continue;
            return image;
        }
        return null;
    }

    public void updateProfile(Profile profile, IProgressMonitor monitor) throws CoreException {
        Account[] accounts;
        Account[] accountArray = accounts = profile.getIdentity().getAccounts();
        int n = accounts.length;
        int n2 = 0;
        while (n2 < n) {
            Account account = accountArray[n2];
            if (profile.getEmail() == null && account.getId().contains("@")) {
                profile.setEmail(account.getId());
            }
            if (profile.getName() == null && account.getName() != null) {
                profile.setName(account.getName());
            }
            ++n2;
        }
        for (IdentityConnector connector : this.connectors) {
            connector.updateProfile(profile, monitor);
        }
    }
}

