/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorUtil;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SingleSelectionAttributeEditor
extends AbstractAttributeEditor {
    private CCombo combo;
    private boolean ignoreNotification;
    private Text text;
    private String[] values;

    public SingleSelectionAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    public void createControl(Composite parent, FormToolkit toolkit) {
        if (this.isReadOnly()) {
            this.text = new Text(parent, 0x800008);
            this.text.setFont(EditorUtil.TEXT_FONT);
            toolkit.adapt((Control)this.text, false, false);
            this.text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            this.text.setToolTipText(this.getDescription());
            this.setControl((Control)this.text);
        } else {
            this.combo = new CCombo(parent, 0x800008);
            this.combo.setVisibleItemCount(10);
            toolkit.adapt((Control)this.combo, false, false);
            this.combo.setFont(EditorUtil.TEXT_FONT);
            this.combo.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
            this.combo.setToolTipText(this.getDescription());
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int index;
                    if (!SingleSelectionAttributeEditor.this.ignoreNotification && (index = SingleSelectionAttributeEditor.this.combo.getSelectionIndex()) > -1) {
                        Assert.isNotNull((Object)SingleSelectionAttributeEditor.this.values);
                        Assert.isLegal((index >= 0 && index <= SingleSelectionAttributeEditor.this.values.length - 1 ? 1 : 0) != 0);
                        SingleSelectionAttributeEditor.this.setValue(SingleSelectionAttributeEditor.this.values[index]);
                    }
                }
            });
            EditorUtil.addScrollListener(this.combo);
            this.setControl((Control)this.combo);
        }
        this.refresh();
    }

    public String getValue() {
        return this.getAttributeMapper().getValue(this.getTaskAttribute());
    }

    public String getValueLabel() {
        return this.getAttributeMapper().getValueLabel(this.getTaskAttribute());
    }

    public void refresh() {
        try {
            this.ignoreNotification = true;
            if (this.text != null && !this.text.isDisposed()) {
                String label = this.getValueLabel();
                if ("".equals(label)) {
                    this.text.setText(" ");
                } else {
                    this.text.setText(label);
                }
            } else if (this.combo != null && !this.combo.isDisposed()) {
                this.combo.removeAll();
                Map labelByValue = this.getAttributeMapper().getOptions(this.getTaskAttribute());
                if (labelByValue != null) {
                    String[] stringArray = this.values = labelByValue.keySet().toArray(new String[0]);
                    int n = this.values.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        this.combo.add((String)labelByValue.get(value));
                        ++n2;
                    }
                }
                this.select(this.getValue(), this.getValueLabel());
                this.combo.redraw();
            }
        }
        finally {
            this.ignoreNotification = false;
        }
    }

    public boolean shouldAutoRefresh() {
        return true;
    }

    private void select(String value, String label) {
        if (this.values != null) {
            int i = 0;
            while (i < this.values.length) {
                if (this.values[i].equals(value)) {
                    this.combo.select(i);
                    break;
                }
                ++i;
            }
        } else {
            this.combo.setText(label);
        }
    }

    void selectDefaultValue() {
        if (this.combo.getSelectionIndex() == -1 && this.values.length > 0) {
            this.combo.select(0);
            this.setValue(this.values[0]);
        }
    }

    public void setValue(String value) {
        String oldValue = this.getAttributeMapper().getValue(this.getTaskAttribute());
        if (!oldValue.equals(value)) {
            this.getAttributeMapper().setValue(this.getTaskAttribute(), value);
            this.attributeChanged();
        }
    }
}

