/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.IAttributeContainer;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;

public class PresentationFilter
extends AbstractTaskListFilter {
    private static PresentationFilter instance = new PresentationFilter();
    private boolean filterHiddenQueries;
    private boolean filterNonMatching;

    public static PresentationFilter getInstance() {
        return instance;
    }

    private PresentationFilter() {
        this.updateSettings();
    }

    public boolean isFilterHiddenQueries() {
        return this.filterHiddenQueries;
    }

    public boolean isFilterNonMatching() {
        return this.filterNonMatching;
    }

    public boolean select(Object element) {
        if (element instanceof IRepositoryQuery) {
            if (!this.filterHiddenQueries) {
                return true;
            }
            return this.isQueryVisible(element);
        }
        if (element instanceof TaskTask) {
            if (!this.filterNonMatching) {
                return true;
            }
            for (AbstractTaskContainer container : ((AbstractTask)element).getParentContainers()) {
                if (container instanceof AbstractTaskCategory) {
                    return true;
                }
                if (!(container instanceof IRepositoryQuery) || this.filterHiddenQueries && !this.isQueryVisible(container)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean select(Object parent, Object element) {
        return this.select(element);
    }

    public void setFilterHiddenQueries(boolean enabled) {
        this.filterHiddenQueries = enabled;
    }

    public void setFilterNonMatching(boolean filterSubtasks) {
        this.filterNonMatching = filterSubtasks;
    }

    public void updateSettings() {
        this.setFilterHiddenQueries(TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.hidden"));
        this.setFilterNonMatching(TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.nonmatching"));
    }

    private boolean isQueryVisible(Object element) {
        return !Boolean.parseBoolean(((IAttributeContainer)element).getAttribute("task.common.hidden"));
    }

    public boolean isInVisibleQuery(ITask task) {
        for (AbstractTaskContainer container : ((AbstractTask)task).getParentContainers()) {
            if (container instanceof AbstractTaskCategory) {
                return true;
            }
            if (!(container instanceof IRepositoryQuery) || this.filterHiddenQueries && !this.isQueryVisible(container)) continue;
            return true;
        }
        return false;
    }
}

