/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.HashMap;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.commons.ui.dialogs.EnhancedWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage2;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryWizardDialog
extends EnhancedWizardDialog {
    private static final String REFRESH_BUTTON_KEY = "refresh";
    private static final String CLEAR_BUTTON_KEY = "clear";
    public static final int REFRESH_BUTTON_ID = 2001;
    public static final int CLEAR_BUTTON_ID = 2002;
    private Button refreshButton;
    private Button clearButton;
    private AbstractRepositoryQueryPage2 abstractRepositoryQueryPage;

    public QueryWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.setHelpAvailable(false);
        IWizardPage[] iWizardPageArray = newWizard.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            if (page instanceof AbstractRepositoryQueryPage2) {
                this.abstractRepositoryQueryPage = (AbstractRepositoryQueryPage2)page;
            }
            ++n2;
        }
    }

    protected void createExtraButtons(Composite composite) {
        if (this.abstractRepositoryQueryPage != null) {
            if (this.abstractRepositoryQueryPage.needsRefresh()) {
                this.refreshButton = this.createButton(composite, 2001, Messages.QueryWizardDialog_Update_Attributes_from_Repository, false);
                this.refreshButton.setVisible(false);
                this.setButtonLayoutData(this.refreshButton);
            }
            if (this.abstractRepositoryQueryPage.needsClear()) {
                this.clearButton = this.createButton(composite, 2002, Messages.QueryWizardDialog_Clear_Fields, false);
                this.clearButton.setVisible(false);
                this.setButtonLayoutData(this.clearButton);
            }
        }
    }

    protected void updateExtraButtons() {
        if (this.abstractRepositoryQueryPage != null) {
            if (this.refreshButton != null) {
                this.abstractRepositoryQueryPage.setExtraButtonState(this.refreshButton);
            }
            if (this.clearButton != null) {
                this.abstractRepositoryQueryPage.setExtraButtonState(this.clearButton);
            }
        }
    }

    protected boolean handleExtraButtonPressed(int buttonId) {
        if (this.abstractRepositoryQueryPage != null) {
            this.abstractRepositoryQueryPage.handleExtraButtonPressed(buttonId);
        }
        return false;
    }

    protected HashMap<String, Boolean> saveAndSetEnabledStateMylyn() {
        HashMap<String, Boolean> savedEnabledState = null;
        if (this.getShell() != null) {
            savedEnabledState = new HashMap<String, Boolean>();
            if (this.refreshButton != null && this.refreshButton.getShell() == this.getShell()) {
                savedEnabledState.put(REFRESH_BUTTON_KEY, this.refreshButton.getEnabled());
                this.refreshButton.setEnabled(false);
            }
            if (this.clearButton != null && this.clearButton.getShell() == this.getShell()) {
                savedEnabledState.put(CLEAR_BUTTON_KEY, this.clearButton.getEnabled());
                this.clearButton.setEnabled(false);
            }
        }
        return savedEnabledState;
    }

    protected void restoreEnabledStateMylyn(HashMap<String, Boolean> savedEnabledState) {
        if (savedEnabledState != null) {
            Boolean savedValidateEnabledState = savedEnabledState.get(CLEAR_BUTTON_KEY);
            if (this.clearButton != null && savedValidateEnabledState != null) {
                this.clearButton.setEnabled(savedValidateEnabledState.booleanValue());
            }
            savedValidateEnabledState = savedEnabledState.get(REFRESH_BUTTON_KEY);
            if (this.refreshButton != null && savedValidateEnabledState != null) {
                this.refreshButton.setEnabled(savedValidateEnabledState.booleanValue());
            }
        }
    }
}

