/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.ui.dialogs.EnhancedWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepositoryWizardDialog
extends EnhancedWizardDialog {
    private static final String VALIDATE_BUTTON_KEY = "validate";
    private Button validateServerButton;
    private static final int VALIDATE_BUTTON_ID = 2000;

    public TaskRepositoryWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
        this.setHelpAvailable(false);
    }

    protected void createExtraButtons(Composite composite) {
        this.validateServerButton = this.createButton(composite, 2000, Messages.AbstractRepositorySettingsPage_Validate_Settings, false);
        this.validateServerButton.setImage(CommonImages.getImage((ImageDescriptor)TasksUiImages.REPOSITORY_VALIDATE));
        this.validateServerButton.setVisible(false);
        this.setButtonLayoutData(this.validateServerButton);
    }

    public void updateExtraButtons() {
        if (this.getCurrentPage() instanceof AbstractRepositorySettingsPage && ((AbstractRepositorySettingsPage)this.getCurrentPage()).needsValidation()) {
            if (!this.validateServerButton.isVisible()) {
                this.validateServerButton.setVisible(true);
            }
            this.validateServerButton.setEnabled(((AbstractRepositorySettingsPage)this.getCurrentPage()).canValidate());
        } else if (this.validateServerButton != null && this.validateServerButton.isVisible()) {
            this.validateServerButton.setVisible(false);
        }
    }

    protected boolean handleExtraButtonPressed(int buttonId) {
        if (buttonId == 2000 && this.getCurrentPage() instanceof AbstractRepositorySettingsPage) {
            ((AbstractRepositorySettingsPage)this.getCurrentPage()).validateSettings();
            return true;
        }
        return false;
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        HashMap<String, Boolean> savedEnabledState = null;
        try {
            savedEnabledState = this.saveAndSetEnabledStateMylyn();
            super.run(fork, cancelable, runnable);
        }
        finally {
            if (savedEnabledState != null) {
                this.restoreEnabledStateMylyn(savedEnabledState);
            }
        }
    }

    protected HashMap<String, Boolean> saveAndSetEnabledStateMylyn() {
        HashMap<String, Boolean> savedEnabledState = null;
        if (this.getShell() != null) {
            savedEnabledState = new HashMap<String, Boolean>();
            if (this.validateServerButton != null && this.validateServerButton.getShell() == this.getShell()) {
                savedEnabledState.put(VALIDATE_BUTTON_KEY, this.validateServerButton.getEnabled());
                this.validateServerButton.setEnabled(false);
            }
        }
        return savedEnabledState;
    }

    protected void restoreEnabledStateMylyn(HashMap<String, Boolean> savedEnabledState) {
        if (savedEnabledState != null) {
            Boolean savedValidateEnabledState = savedEnabledState.get(VALIDATE_BUTTON_KEY);
            if (this.validateServerButton != null && savedValidateEnabledState != null) {
                this.validateServerButton.setEnabled(savedValidateEnabledState.booleanValue());
            }
        }
    }
}

