/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.internal.ui.commands.CommandList;
import org.eclipse.ui.commands.ICommandService;

public class CommandTreeContentProvider
implements ITreeContentProvider {
    protected final int F_CAT_CONTENT = 0;
    protected final int F_CON_CONTENT = 1;
    private ICommandService fComServ;
    private TreeMap fCatMap;
    private TreeMap fConMap;
    private Viewer fViewer;
    private int fCurContent = 0;

    public CommandTreeContentProvider(ICommandService comServ) {
        this.fComServ = comServ;
        this.init();
    }

    private void init() {
        this.fCatMap = new TreeMap(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                String comA = CommandList.getText(arg0);
                String comB = CommandList.getText(arg1);
                if (comA != null) {
                    return comA.compareTo(comB);
                }
                return 1;
            }
        });
        this.fConMap = new TreeMap();
        Command[] commands = this.fComServ.getDefinedCommands();
        int i = 0;
        while (i < commands.length) {
            if (!commands[i].getId().startsWith("AUTOGEN:::")) {
                try {
                    Category cat = commands[i].getCategory();
                    ArrayList<Command> list = (ArrayList<Command>)this.fCatMap.get(cat);
                    if (list == null) {
                        list = new ArrayList<Command>();
                        this.fCatMap.put(cat, list);
                    }
                    list.add(commands[i]);
                }
                catch (NotDefinedException notDefinedException) {}
            }
            ++i;
        }
    }

    public Object getParent(Object element) {
        if (element instanceof Command) {
            try {
                return ((Command)element).getCategory();
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return null;
    }

    public void dispose() {
        this.fCatMap.clear();
        this.fConMap.clear();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList list;
        if (parentElement instanceof Category && (list = (ArrayList)this.fCatMap.get(parentElement)) != null) {
            return list.toArray(new Command[list.size()]);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ArrayList list;
        if (element instanceof Category && (list = (ArrayList)this.fCatMap.get(element)) != null) {
            return list.size() > 0;
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        switch (this.fCurContent) {
            case 0: {
                return this.fCatMap.keySet().toArray();
            }
            case 1: {
                return new Object[0];
            }
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public void refreshWithCategoryContent() {
        this.fCurContent = 0;
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }

    public void refreshWithContextContent() {
        this.fCurContent = 1;
        if (this.fViewer != null) {
            this.fViewer.refresh();
        }
    }
}

