/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;

public final class Signature {
    public static final char C_SEMICOLON = ';';
    public static final char C_COLON = ':';
    public static final char C_VOID = 'V';
    public static final char C_ANY = 'A';
    public static final char C_DOT = '.';
    public static final char C_DOLLAR = '$';
    public static final char C_ARRAY = '[';
    public static final char C_RESOLVED = 'L';
    public static final char C_COMPILATION_UNIT = 'X';
    public static final char C_UNRESOLVED = 'Q';
    public static final char C_NAME_END = ';';
    public static final char C_PARAM_START = '(';
    public static final char C_PARAM_END = ')';
    public static final String SIG_VOID = "V";
    public static final String SIG_ANY = "A";
    public static final String SIG_COMPILATION_UNIT = "X";
    public static final int CLASS_TYPE_SIGNATURE = 1;
    public static final int BASE_TYPE_SIGNATURE = 2;
    public static final int ARRAY_TYPE_SIGNATURE = 4;
    private static final char[] VOID = "void".toCharArray();
    public static final char[] ANY = "any".toCharArray();

    private Signature() {
    }

    private static int checkName(char[] name, char[] typeName, int pos, int length) {
        if (CharOperation.fragmentEquals(name, typeName, pos, true)) {
            if ((pos += name.length) == length) {
                return pos;
            }
            char currentChar = typeName[pos];
            switch (currentChar) {
                case ' ': 
                case ',': 
                case '.': 
                case '[': {
                    return pos;
                }
            }
            if (ScannerHelper.isWhitespace(currentChar)) {
                return pos;
            }
        }
        return -1;
    }

    public static char[] createArraySignature(char[] typeSignature, int arrayCount) {
        if (arrayCount == 0) {
            return typeSignature;
        }
        int sigLength = typeSignature.length;
        char[] result = new char[arrayCount + sigLength];
        int i = 0;
        while (i < arrayCount) {
            result[i] = 91;
            ++i;
        }
        System.arraycopy(typeSignature, 0, result, arrayCount, sigLength);
        return result;
    }

    public static String createArraySignature(String typeSignature, int arrayCount) {
        return new String(Signature.createArraySignature(typeSignature.toCharArray(), arrayCount));
    }

    public static char[] createMethodSignature(char[][] parameterTypes, char[] returnType) {
        int parameterTypesLength = parameterTypes.length;
        int parameterLength = 0;
        int i = 0;
        while (i < parameterTypesLength) {
            parameterLength += parameterTypes[i].length;
            ++i;
        }
        int returnTypeLength = returnType.length;
        char[] result = new char[1 + parameterLength + 1 + returnTypeLength];
        result[0] = 40;
        int index = 1;
        int i2 = 0;
        while (i2 < parameterTypesLength) {
            char[] parameterType = parameterTypes[i2];
            int length = parameterType.length;
            System.arraycopy(parameterType, 0, result, index, length);
            index += length;
            ++i2;
        }
        result[index] = 41;
        System.arraycopy(returnType, 0, result, index + 1, returnTypeLength);
        return result;
    }

    public static String createMethodSignature(String[] parameterTypes, String returnType) {
        int parameterTypesLenth = parameterTypes.length;
        char[][] parameters = new char[parameterTypesLenth][];
        int i = 0;
        while (i < parameterTypesLenth) {
            parameters[i] = parameterTypes[i].toCharArray();
            ++i;
        }
        return new String(Signature.createMethodSignature(parameters, returnType.toCharArray()));
    }

    public static String createTypeSignature(char[] typeName, boolean isResolved) {
        return new String(Signature.createCharArrayTypeSignature(typeName, isResolved));
    }

    public static char[] createCharArrayTypeSignature(char[] typeName, boolean isResolved) {
        if (typeName == null || typeName.length == 0) {
            return new char[]{'A'};
        }
        int length = typeName.length;
        StringBuffer buffer = new StringBuffer(5);
        int pos = Signature.encodeTypeSignature(typeName, 0, isResolved, length, buffer);
        if ((pos = Signature.consumeWhitespace(typeName, pos, length)) < length) {
            throw new IllegalArgumentException(new String(typeName));
        }
        length = buffer.length();
        char[] result = new char[length];
        buffer.getChars(0, length, result, 0);
        return result;
    }

    private static int consumeWhitespace(char[] typeName, int pos, int length) {
        while (pos < length) {
            char currentChar = typeName[pos];
            if (currentChar != ' ' && !CharOperation.isWhitespace(currentChar)) break;
            ++pos;
        }
        return pos;
    }

    private static int encodeQualifiedName(char[] typeName, int pos, int length, StringBuffer buffer) {
        int count = 0;
        int lastAppendedChar = 0;
        block4: while (pos < length) {
            int currentChar = typeName[pos];
            switch (currentChar) {
                case 44: 
                case 91: {
                    break block4;
                }
                case 46: {
                    buffer.append('.');
                    lastAppendedChar = 46;
                    ++count;
                    break;
                }
                default: {
                    if (currentChar == 32 || ScannerHelper.isWhitespace((char)currentChar)) {
                        if (lastAppendedChar == 46) {
                            pos = Signature.consumeWhitespace(typeName, pos, length) - 1;
                            break;
                        }
                        int checkPos = Signature.checkNextChar(typeName, '.', pos, length, true);
                        if (checkPos <= 0) break block4;
                        buffer.append('.');
                        lastAppendedChar = 46;
                        ++count;
                        pos = checkPos;
                        break;
                    }
                    buffer.append((char)currentChar);
                    lastAppendedChar = currentChar;
                    ++count;
                }
            }
            ++pos;
        }
        if (count == 0) {
            throw new IllegalArgumentException(new String(typeName));
        }
        return pos;
    }

    private static int encodeArrayDimension(char[] typeName, int pos, int length, StringBuffer buffer) {
        int checkPos;
        while (pos < length && (checkPos = Signature.checkNextChar(typeName, '[', pos, length, true)) > 0) {
            pos = Signature.checkNextChar(typeName, ']', checkPos, length, false);
            buffer.append('[');
        }
        return pos;
    }

    private static int checkArrayDimension(char[] typeName, int pos, int length) {
        boolean genericBalance = false;
        while (pos < length) {
            switch (typeName[pos]) {
                case ',': {
                    if (genericBalance) break;
                    return -1;
                }
                case '[': {
                    if (genericBalance) break;
                    return pos;
                }
            }
            ++pos;
        }
        return -1;
    }

    private static int checkNextChar(char[] typeName, char expectedChar, int pos, int length, boolean isOptional) {
        if ((pos = Signature.consumeWhitespace(typeName, pos, length)) < length && typeName[pos] == expectedChar) {
            return pos + 1;
        }
        if (!isOptional) {
            throw new IllegalArgumentException(new String(typeName));
        }
        return -1;
    }

    private static int encodeTypeSignature(char[] typeName, int start, boolean isResolved, int length, StringBuffer buffer) {
        int checkPos;
        int pos = start;
        if ((pos = Signature.consumeWhitespace(typeName, pos, length)) >= length) {
            throw new IllegalArgumentException(new String(typeName));
        }
        char currentChar = typeName[pos];
        switch (currentChar) {
            case 'v': {
                checkPos = Signature.checkName(VOID, typeName, pos, length);
                if (checkPos <= 0) break;
                pos = Signature.encodeArrayDimension(typeName, checkPos, length, buffer);
                buffer.append('V');
                return pos;
            }
        }
        checkPos = Signature.checkArrayDimension(typeName, pos, length);
        int end = checkPos > 0 ? Signature.encodeArrayDimension(typeName, checkPos, length, buffer) : -1;
        buffer.append(isResolved ? (char)'L' : 'Q');
        while ((checkPos = Signature.checkNextChar(typeName, '.', pos = Signature.encodeQualifiedName(typeName, pos, length, buffer), length, true)) > 0) {
            buffer.append('.');
            pos = checkPos;
        }
        buffer.append(';');
        if (end > 0) {
            pos = end;
        }
        return pos;
    }

    public static String createTypeSignature(String typeName, boolean isResolved) {
        return Signature.createTypeSignature(typeName == null ? null : typeName.toCharArray(), isResolved);
    }

    public static int getArrayCount(char[] typeSignature) throws IllegalArgumentException {
        try {
            int count = 0;
            while (typeSignature[count] == '[') {
                ++count;
            }
            return count;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getArrayCount(String typeSignature) throws IllegalArgumentException {
        return Signature.getArrayCount(typeSignature.toCharArray());
    }

    public static char[] getElementType(char[] typeSignature) throws IllegalArgumentException {
        int count = Signature.getArrayCount(typeSignature);
        if (count == 0) {
            return typeSignature;
        }
        int length = typeSignature.length;
        char[] result = new char[length - count];
        System.arraycopy(typeSignature, count, result, 0, length - count);
        return result;
    }

    public static String getElementType(String typeSignature) throws IllegalArgumentException {
        return new String(Signature.getElementType(typeSignature.toCharArray()));
    }

    public static int getParameterCount(char[] methodSignature) throws IllegalArgumentException {
        if (methodSignature == null) {
            return 0;
        }
        try {
            int count = 0;
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            while (true) {
                if (methodSignature[i] == ')') {
                    return count;
                }
                int e = org.eclipse.wst.jsdt.internal.core.util.Util.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                i = e + 1;
                ++count;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static int getTypeSignatureKind(char[] typeSignature) {
        if (typeSignature.length < 1) {
            throw new IllegalArgumentException();
        }
        char c = typeSignature[0];
        switch (c) {
            case '[': {
                return 4;
            }
            case 'L': 
            case 'Q': {
                return 1;
            }
            case 'A': 
            case 'V': {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getTypeSignatureKind(String typeSignature) {
        if (typeSignature.length() < 1) {
            return 2;
        }
        char c = typeSignature.charAt(0);
        switch (c) {
            case '[': {
                return 4;
            }
            case 'L': 
            case 'Q': {
                return 1;
            }
            case 'A': 
            case 'V': {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public static int getParameterCount(String methodSignature) throws IllegalArgumentException {
        return Signature.getParameterCount(methodSignature.toCharArray());
    }

    public static char[][] getParameterTypes(char[] methodSignature) throws IllegalArgumentException {
        try {
            int count = Signature.getParameterCount(methodSignature);
            char[][] result = new char[count][];
            if (count == 0) {
                return result;
            }
            int i = CharOperation.indexOf('(', methodSignature);
            if (i < 0) {
                throw new IllegalArgumentException();
            }
            ++i;
            int t = 0;
            while (true) {
                if (methodSignature[i] == ')') {
                    return result;
                }
                int e = org.eclipse.wst.jsdt.internal.core.util.Util.scanTypeSignature(methodSignature, i);
                if (e < 0) {
                    throw new IllegalArgumentException();
                }
                result[t] = CharOperation.subarray(methodSignature, i, e + 1);
                ++t;
                i = e + 1;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public static String[] getParameterTypes(String methodSignature) throws IllegalArgumentException {
        char[][] parameterTypes = Signature.getParameterTypes(methodSignature.toCharArray());
        return CharOperation.toStrings(parameterTypes);
    }

    public static String getTypeVariable(String formalTypeParameterSignature) throws IllegalArgumentException {
        return new String(Signature.getTypeVariable(formalTypeParameterSignature.toCharArray()));
    }

    public static char[] getTypeVariable(char[] formalTypeParameterSignature) throws IllegalArgumentException {
        int p = CharOperation.indexOf(':', formalTypeParameterSignature);
        if (p < 0) {
            throw new IllegalArgumentException();
        }
        return CharOperation.subarray(formalTypeParameterSignature, 0, p);
    }

    public static char[] getQualifier(char[] name) {
        int lastDot = CharOperation.lastIndexOf('.', name, 0, name.length - 1);
        if (lastDot == -1) {
            return CharOperation.NO_CHAR;
        }
        return CharOperation.subarray(name, 0, lastDot);
    }

    public static String getQualifier(String name) {
        char[] qualifier = Signature.getQualifier(name.toCharArray());
        if (qualifier.length == 0) {
            return Util.EMPTY_STRING;
        }
        return new String(qualifier);
    }

    public static char[] getReturnType(char[] methodSignature) throws IllegalArgumentException {
        if (methodSignature == null) {
            return CharOperation.NO_CHAR;
        }
        int paren = CharOperation.lastIndexOf(')', methodSignature);
        if (paren == -1) {
            return CharOperation.NO_CHAR;
        }
        int last = org.eclipse.wst.jsdt.internal.core.util.Util.scanTypeSignature(methodSignature, paren + 1);
        return CharOperation.subarray(methodSignature, paren + 1, last + 1);
    }

    public static String getReturnType(String methodSignature) throws IllegalArgumentException {
        return new String(Signature.getReturnType(methodSignature.toCharArray()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static char[] getSignatureQualifier(char[] typeSignature) {
        if (typeSignature == null) {
            return CharOperation.NO_CHAR;
        }
        char[] qualifiedType = Signature.toCharArray(typeSignature);
        int dotCount = 0;
        int i = 0;
        block4: while (i < typeSignature.length) {
            switch (typeSignature[i]) {
                case '.': {
                    ++dotCount;
                    break;
                }
                case '$': {
                    break block4;
                }
            }
            ++i;
        }
        if (dotCount > 0) {
            i = 0;
            while (i < qualifiedType.length) {
                if (qualifiedType[i] == '.') {
                    --dotCount;
                }
                if (dotCount <= 0) {
                    return CharOperation.subarray(qualifiedType, 0, i);
                }
                ++i;
            }
        }
        return CharOperation.NO_CHAR;
    }

    public static String getSignatureQualifier(String typeSignature) {
        return new String(Signature.getSignatureQualifier(typeSignature == null ? null : typeSignature.toCharArray()));
    }

    public static char[] getSignatureSimpleName(char[] typeSignature) {
        if (typeSignature == null) {
            return CharOperation.NO_CHAR;
        }
        char[] qualifiedType = Signature.toCharArray(typeSignature);
        return qualifiedType;
    }

    public static String getSignatureSimpleName(String typeSignature) {
        return new String(Signature.getSignatureSimpleName(typeSignature == null ? null : typeSignature.toCharArray()));
    }

    public static char[] getSimpleName(char[] name) {
        int lastDot = -1;
        boolean depth = false;
        int length = name.length;
        int i = length - 1;
        block3: while (i >= 0) {
            switch (name[i]) {
                case '.': {
                    if (!depth) {
                        lastDot = i;
                        break block3;
                    }
                }
                default: {
                    --i;
                }
            }
        }
        if (lastDot < 0) {
            return name;
        }
        return CharOperation.subarray(name, lastDot + 1, length);
    }

    public static String getSimpleName(String name) {
        int lastDot = -1;
        boolean depth = false;
        int length = name.length();
        int i = length - 1;
        block3: while (i >= 0) {
            switch (name.charAt(i)) {
                case '.': {
                    if (!depth) {
                        lastDot = i;
                        break block3;
                    }
                }
                default: {
                    --i;
                }
            }
        }
        if (lastDot < 0) {
            return name;
        }
        return name.substring(lastDot + 1, length);
    }

    public static char[][] getSimpleNames(char[] name) {
        int length;
        int n = length = name == null ? 0 : name.length;
        if (length == 0) {
            return CharOperation.NO_CHAR_CHAR;
        }
        int wordCount = 1;
        int i = 0;
        while (i < length) {
            switch (name[i]) {
                case '.': {
                    ++wordCount;
                }
            }
            ++i;
        }
        char[][] split = new char[wordCount][];
        int last = 0;
        int currentWord = 0;
        int i2 = 0;
        while (i2 < length) {
            if (name[i2] == '.') {
                split[currentWord] = new char[i2 - last];
                System.arraycopy(name, last, split[currentWord++], 0, i2 - last);
                last = i2 + 1;
            }
            ++i2;
        }
        split[currentWord] = new char[length - last];
        System.arraycopy(name, last, split[currentWord], 0, length - last);
        return split;
    }

    public static String[] getSimpleNames(String name) {
        return CharOperation.toStrings(Signature.getSimpleNames(name.toCharArray()));
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        return Signature.toCharArray(methodSignature, methodName, parameterNames, fullyQualifyTypeNames, includeReturnType, false);
    }

    public static char[] toCharArray(char[] methodSignature, char[] methodName, char[][] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType, boolean isVargArgs) {
        int firstParen = CharOperation.indexOf('(', methodSignature);
        if (firstParen == -1) {
            throw new IllegalArgumentException();
        }
        StringBuffer buffer = new StringBuffer(methodSignature.length + 10);
        if (includeReturnType) {
            char[] rts = Signature.getReturnType(methodSignature);
            Signature.appendTypeSignature(rts, 0, fullyQualifyTypeNames, buffer);
            buffer.append(' ');
        }
        if (methodName != null) {
            buffer.append(methodName);
        }
        buffer.append('(');
        char[][] pts = Signature.getParameterTypes(methodSignature);
        int i = 0;
        int max = pts.length;
        while (i < max) {
            if (i == max - 1) {
                Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer, isVargArgs);
            } else {
                Signature.appendTypeSignature(pts[i], 0, fullyQualifyTypeNames, buffer);
            }
            if (parameterNames != null) {
                buffer.append(' ');
                buffer.append(parameterNames[i]);
            }
            if (i != pts.length - 1) {
                buffer.append(',');
                buffer.append(' ');
            }
            ++i;
        }
        buffer.append(')');
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    public static char[] toCharArray(char[] signature) throws IllegalArgumentException {
        int sigLength = signature.length;
        if (sigLength == 0 || signature[0] == '(') {
            return Signature.toCharArray(signature, CharOperation.NO_CHAR, null, true, true);
        }
        StringBuffer buffer = new StringBuffer(signature.length + 10);
        Signature.appendTypeSignature(signature, 0, true, buffer);
        char[] result = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), result, 0);
        return result;
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        return Signature.appendTypeSignature(string, start, fullyQualifyTypeNames, buffer, false);
    }

    private static int appendTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer, boolean isVarArgs) {
        if (start >= string.length) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (isVarArgs) {
            switch (c) {
                case '[': {
                    return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer, true);
                }
            }
            throw new IllegalArgumentException();
        }
        switch (c) {
            case '[': {
                return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'L': 
            case 'Q': {
                return Signature.appendClassTypeSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'X': {
                return Signature.appendCompilationUnitSignature(string, start, fullyQualifyTypeNames, buffer);
            }
            case 'A': {
                buffer.append(ANY);
                return start;
            }
            case 'V': {
                buffer.append(VOID);
                return start;
            }
        }
        buffer.append(string);
        return start;
    }

    private static int appendCompilationUnitSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'X') {
            throw new IllegalArgumentException();
        }
        int p = start + 1;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            switch (c) {
                case ';': {
                    return p;
                }
            }
            buffer.append(c);
            ++p;
        }
    }

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        return Signature.appendArrayTypeSignature(string, start, fullyQualifyTypeNames, buffer, false);
    }

    private static int appendArrayTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer, boolean isVarArgs) {
        int length = string.length;
        if (start >= length - 1) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != '[') {
            throw new IllegalArgumentException();
        }
        int index = start;
        c = string[++index];
        while (c == '[') {
            if (index >= length - 1) {
                throw new IllegalArgumentException();
            }
            c = string[++index];
        }
        int e = Signature.appendTypeSignature(string, index, fullyQualifyTypeNames, buffer);
        int i = 1;
        int dims = index - start;
        while (i < dims) {
            buffer.append('[').append(']');
            ++i;
        }
        if (isVarArgs) {
            buffer.append('.').append('.').append('.');
        } else {
            buffer.append('[').append(']');
        }
        return e;
    }

    private static int appendClassTypeSignature(char[] string, int start, boolean fullyQualifyTypeNames, StringBuffer buffer) {
        boolean removePackageQualifiers;
        if (start >= string.length - 2) {
            throw new IllegalArgumentException();
        }
        char c = string[start];
        if (c != 'L' && c != 'Q') {
            throw new IllegalArgumentException();
        }
        boolean resolved = c == 'L';
        boolean bl = removePackageQualifiers = !fullyQualifyTypeNames;
        if (!resolved) {
            removePackageQualifiers = false;
        }
        int p = start + 1;
        int checkpoint = buffer.length();
        int innerTypeStart = -1;
        boolean inAnonymousType = false;
        while (true) {
            if (p >= string.length) {
                throw new IllegalArgumentException();
            }
            c = string[p];
            switch (c) {
                case ';': {
                    return p;
                }
                case '.': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('.');
                    break;
                }
                case '/': {
                    if (removePackageQualifiers) {
                        buffer.setLength(checkpoint);
                        break;
                    }
                    buffer.append('/');
                    break;
                }
                default: {
                    if (innerTypeStart != -1 && !inAnonymousType && Character.isDigit(c)) {
                        inAnonymousType = true;
                        buffer.setLength(innerTypeStart);
                        buffer.insert(checkpoint, "new ");
                        buffer.append("(){}");
                    }
                    if (!inAnonymousType) {
                        buffer.append(c);
                    }
                    innerTypeStart = -1;
                }
            }
            ++p;
        }
    }

    public static char[] toQualifiedName(char[][] segments) {
        int length = segments.length;
        if (length == 0) {
            return CharOperation.NO_CHAR;
        }
        if (length == 1) {
            return segments[0];
        }
        int resultLength = 0;
        int i = 0;
        while (i < length) {
            resultLength += segments[i].length + 1;
            ++i;
        }
        char[] result = new char[--resultLength];
        int index = 0;
        int i2 = 0;
        while (i2 < length) {
            char[] segment = segments[i2];
            int segmentLength = segment.length;
            System.arraycopy(segment, 0, result, index, segmentLength);
            index += segmentLength;
            if (i2 != length - 1) {
                result[index++] = 46;
            }
            ++i2;
        }
        return result;
    }

    public static String toQualifiedName(String[] segments) {
        int length = segments.length;
        char[][] charArrays = new char[length][];
        int i = 0;
        while (i < length) {
            charArrays[i] = segments[i].toCharArray();
            ++i;
        }
        return new String(Signature.toQualifiedName(charArrays));
    }

    public static String toString(String signature) throws IllegalArgumentException {
        return new String(Signature.toCharArray(signature.toCharArray()));
    }

    public static String toString(String methodSignature, String methodName, String[] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType) {
        return Signature.toString(methodSignature, methodName, parameterNames, fullyQualifyTypeNames, includeReturnType, false);
    }

    public static String toString(String methodSignature, String methodName, String[] parameterNames, boolean fullyQualifyTypeNames, boolean includeReturnType, boolean isVarArgs) {
        char[][] params;
        if (parameterNames == null) {
            params = null;
        } else {
            int paramLength = parameterNames.length;
            params = new char[paramLength][];
            int i = 0;
            while (i < paramLength) {
                params[i] = parameterNames[i].toCharArray();
                ++i;
            }
        }
        return new String(Signature.toCharArray(methodSignature.toCharArray(), methodName == null ? null : methodName.toCharArray(), params, fullyQualifyTypeNames, includeReturnType, isVarArgs));
    }
}

