/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.infer.InferredAttribute;
import org.eclipse.wst.jsdt.core.infer.InferredMethod;
import org.eclipse.wst.jsdt.core.infer.InferredType;
import org.eclipse.wst.jsdt.core.search.FieldDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.FieldReferenceMatch;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.LocalVariableDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.MethodReferenceMatch;
import org.eclipse.wst.jsdt.core.search.PackageReferenceMatch;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.core.search.TypeDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.TypeReferenceMatch;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.ISourceType;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor2;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfIntValues;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Messages;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.BinaryMember;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.MetadataFile;
import org.eclipse.wst.jsdt.internal.core.NameLookup;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceMapper;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceTypeElementInfo;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.HierarchyScope;
import org.eclipse.wst.jsdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.wst.jsdt.internal.core.search.IndexSelector;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.matching.AndPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.ClassFileMatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.InternalSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocatorParser;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.wst.jsdt.internal.core.search.matching.PossibleMatchSet;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.wst.jsdt.internal.core.util.HandleFactory;
import org.eclipse.wst.jsdt.internal.core.util.Util;
import org.eclipse.wst.jsdt.internal.oaametadata.LibraryAPIs;

public class MatchLocator
implements ITypeRequestor,
ITypeRequestor2 {
    public static final int MAX_AT_ONCE;
    public SearchPattern pattern;
    public PatternLocator patternLocator;
    public int matchContainer;
    public SearchRequestor requestor;
    public IJavaScriptSearchScope scope;
    public IProgressMonitor progressMonitor;
    public IJavaScriptUnit[] workingCopies;
    public HandleFactory handleFactory;
    public char[][][] allSuperTypeNames;
    public MatchLocatorParser parser;
    private Parser basicParser;
    public INameEnvironment nameEnvironment;
    public NameLookup nameLookup;
    public LookupEnvironment lookupEnvironment;
    public HierarchyResolver hierarchyResolver;
    public CompilerOptions options;
    public int numberOfMatches;
    public PossibleMatch[] matchesToProcess;
    public PossibleMatch currentPossibleMatch;
    public long resultCollectorTime = 0L;
    int progressStep;
    int progressWorked;
    CompilationUnitScope unitScope;
    SimpleLookupTable bindings;
    HashSet methodHandles;
    private HashtableOfObject parsedUnits;

    static {
        long maxMemory = Runtime.getRuntime().maxMemory();
        int ratio = (int)Math.round((double)maxMemory / 6.7108864E7);
        switch (ratio) {
            case 0: 
            case 1: {
                MAX_AT_ONCE = 100;
                break;
            }
            case 2: {
                MAX_AT_ONCE = 200;
                break;
            }
            case 3: {
                MAX_AT_ONCE = 300;
                break;
            }
            default: {
                MAX_AT_ONCE = 400;
            }
        }
    }

    public static SearchDocument[] addWorkingCopies(InternalSearchPattern pattern, SearchDocument[] indexMatches, IJavaScriptUnit[] copies, SearchParticipant participant) {
        int remainingWorkingCopiesSize;
        HashMap workingCopyDocuments = MatchLocator.workingCopiesThatCanSeeFocus(copies, pattern.focus, pattern.isPolymorphicSearch(), participant);
        SearchDocument[] matches = null;
        int length = indexMatches.length;
        int i = 0;
        while (i < length) {
            SearchDocument workingCopyDocument;
            SearchDocument searchDocument = indexMatches[i];
            if (searchDocument.getParticipant() == participant && (workingCopyDocument = (SearchDocument)workingCopyDocuments.remove(searchDocument.getPath())) != null) {
                if (matches == null) {
                    matches = new SearchDocument[length];
                    System.arraycopy(indexMatches, 0, matches, 0, length);
                }
                matches[i] = workingCopyDocument;
            }
            ++i;
        }
        if (matches == null) {
            matches = indexMatches;
        }
        if ((remainingWorkingCopiesSize = workingCopyDocuments.size()) != 0) {
            SearchDocument[] searchDocumentArray = matches;
            matches = new SearchDocument[length + remainingWorkingCopiesSize];
            System.arraycopy(searchDocumentArray, 0, matches, 0, length);
            Iterator iterator = workingCopyDocuments.values().iterator();
            int index = length;
            while (iterator.hasNext()) {
                matches[index++] = (SearchDocument)iterator.next();
            }
        }
        return matches;
    }

    public static void setFocus(InternalSearchPattern pattern, IJavaScriptElement focus) {
        pattern.focus = focus;
    }

    private static HashMap workingCopiesThatCanSeeFocus(IJavaScriptUnit[] copies, IJavaScriptElement focus, boolean isPolymorphicSearch, SearchParticipant participant) {
        if (copies == null) {
            return new HashMap();
        }
        if (focus != null) {
            while (!(focus instanceof IJavaScriptProject)) {
                focus = focus.getParent();
            }
        }
        HashMap<String, WorkingCopyDocument> result = new HashMap<String, WorkingCopyDocument>();
        int i = 0;
        int length = copies.length;
        while (i < length) {
            IJavaScriptUnit workingCopy = copies[i];
            IPath projectOrJar = MatchLocator.getProjectOrJar(workingCopy).getPath();
            if (focus == null || IndexSelector.canSeeFocus(focus, isPolymorphicSearch, projectOrJar)) {
                result.put(workingCopy.getPath().toString(), new WorkingCopyDocument(workingCopy, participant));
            }
            ++i;
        }
        return result;
    }

    public static SearchPattern createAndPattern(final SearchPattern leftPattern, final SearchPattern rightPattern) {
        return new AndPattern(0, 0){
            SearchPattern current;
            {
                this.current = searchPattern;
            }

            public SearchPattern currentPattern() {
                return this.current;
            }

            protected boolean hasNextQuery() {
                if (this.current == leftPattern) {
                    this.current = rightPattern;
                    return true;
                }
                return false;
            }

            protected void resetQuery() {
                this.current = leftPattern;
            }
        };
    }

    public static void findIndexMatches(InternalSearchPattern pattern, Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaScriptSearchScope scope, IProgressMonitor monitor) throws IOException {
        pattern.findIndexMatches(index, requestor, participant, scope, monitor);
    }

    public static IJavaScriptElement getProjectOrJar(IJavaScriptElement element) {
        while (!(element instanceof IJavaScriptProject || element instanceof LibraryFragmentRoot || element instanceof PackageFragmentRoot)) {
            element = element.getParent();
        }
        return element;
    }

    public static IJavaScriptElement projectOrJarFocus(InternalSearchPattern pattern) {
        return pattern == null || pattern.focus == null ? null : MatchLocator.getProjectOrJar(pattern.focus);
    }

    public MatchLocator(SearchPattern pattern, SearchRequestor requestor, IJavaScriptSearchScope scope, IProgressMonitor progressMonitor) {
        this.pattern = pattern;
        this.patternLocator = PatternLocator.patternLocator(this.pattern);
        this.matchContainer = this.patternLocator.matchContainer();
        this.requestor = requestor;
        this.scope = scope;
        this.progressMonitor = progressMonitor;
    }

    public void accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        System.out.println("Bad call to method-- IMPLEMENT MatchLocator. accept(IBinaryType binaryType, PackageBinding packageBinding, AccessRestriction accessRestriction) ");
    }

    public void accept(ICompilationUnit sourceUnit, char[][] typeNames, AccessRestriction accessRestriction) {
        CompilationResult unitResult;
        block5: {
            unitResult = new CompilationResult(sourceUnit, 1, 1, this.options.maxProblemsPerUnit);
            try {
                CompilationUnitDeclaration parsedUnit;
                if (this.parsedUnits == null) {
                    this.parsedUnits = new HashtableOfObject();
                }
                if ((parsedUnit = (CompilationUnitDeclaration)this.parsedUnits.get(sourceUnit.getFileName())) == null) {
                    Parser parser = this.basicParser();
                    parsedUnit = parser.dietParse(sourceUnit, unitResult);
                    parser.inferTypes(parsedUnit, this.options);
                    this.parsedUnits.put(sourceUnit.getFileName(), parsedUnit);
                }
                this.lookupEnvironment.buildTypeBindings(parsedUnit, typeNames, accessRestriction);
                this.lookupEnvironment.completeTypeBindings(parsedUnit, typeNames, true);
            }
            catch (AbortCompilationUnit e) {
                if (unitResult.compilationUnit == sourceUnit) break block5;
                throw e;
            }
        }
        if (BasicSearchEngine.VERBOSE && unitResult.problemCount > 0) {
            System.out.println(unitResult);
        }
    }

    public void accept(ICompilationUnit sourceUnit, AccessRestriction accessRestriction) {
        this.accept(sourceUnit, new char[0][0], accessRestriction);
    }

    public void accept(LibraryAPIs libraryMetaData) {
        this.lookupEnvironment.buildTypeBindings(libraryMetaData);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ISourceType sourceType = sourceTypes[0];
        while (sourceType.getEnclosingType() != null) {
            sourceType = sourceType.getEnclosingType();
        }
        if (sourceType instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo elementInfo = (SourceTypeElementInfo)sourceType;
            IType type = elementInfo.getHandle();
            ICompilationUnit sourceUnit = (ICompilationUnit)((Object)type.getJavaScriptUnit());
            this.accept(sourceUnit, accessRestriction);
        } else {
            CompilationResult result = new CompilationResult(sourceType.getFileName(), sourceType.getPackageName(), 1, 1, 0);
            CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
            this.lookupEnvironment.buildTypeBindings(unit, accessRestriction);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected Parser basicParser() {
        if (this.basicParser == null) {
            ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
            this.basicParser = new Parser(problemReporter, false);
            this.basicParser.reportOnlyOneSyntaxError = true;
        }
        return this.basicParser;
    }

    protected BinaryTypeBinding cacheBinaryType(IType type, IBinaryType binaryType) throws JavaScriptModelException {
        char[][] compoundName;
        ReferenceBinding referenceBinding;
        BinaryTypeBinding binding;
        IType enclosingType = type.getDeclaringType();
        if (enclosingType != null) {
            this.cacheBinaryType(enclosingType, null);
        }
        if (binaryType == null) {
            ClassFile classFile = (ClassFile)type.getClassFile();
            try {
                binaryType = this.getBinaryInfo(classFile, classFile.getResource());
            }
            catch (CoreException e) {
                if (e instanceof JavaScriptModelException) {
                    throw (JavaScriptModelException)e;
                }
                throw new JavaScriptModelException(e);
            }
        }
        if ((binding = null) == null && (referenceBinding = this.lookupEnvironment.getCachedType(compoundName = CharOperation.splitOn('.', type.getFullyQualifiedName().toCharArray()))) != null && referenceBinding instanceof BinaryTypeBinding) {
            binding = (BinaryTypeBinding)referenceBinding;
        }
        return binding;
    }

    protected char[][][] computeSuperTypeNames(IType focusType) {
        String fullyQualifiedName = focusType.getFullyQualifiedName();
        int lastDot = fullyQualifiedName.lastIndexOf(46);
        char[] qualification = lastDot == -1 ? CharOperation.NO_CHAR : fullyQualifiedName.substring(0, lastDot).toCharArray();
        char[] simpleName = focusType.getElementName().toCharArray();
        SuperTypeNamesCollector superTypeNamesCollector = new SuperTypeNamesCollector(this.pattern, simpleName, qualification, new MatchLocator(this.pattern, this.requestor, this.scope, this.progressMonitor), focusType, this.progressMonitor);
        try {
            this.allSuperTypeNames = superTypeNamesCollector.collect();
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return this.allSuperTypeNames;
    }

    protected IJavaScriptElement createHandle(AbstractMethodDeclaration method, IJavaScriptElement parent) {
        char[] methodName;
        if (!(parent instanceof IType || parent instanceof IJavaScriptUnit || parent instanceof IClassFile)) {
            return parent;
        }
        Argument[] arguments = method.arguments;
        int argCount = arguments == null ? 0 : arguments.length;
        String[] parameterTypeSignatures = new String[argCount];
        if (arguments != null) {
            int i = 0;
            while (i < argCount) {
                TypeReference typeRef = arguments[i].type;
                char[] typeName = typeRef != null ? CharOperation.concatWith(typeRef.getTypeName(), '.') : null;
                parameterTypeSignatures[i] = Signature.createTypeSignature(typeName, false);
                ++i;
            }
        }
        char[] cArray = methodName = method.isInferred() ? method.inferredMethod.name : method.selector;
        if (methodName == null) {
            return null;
        }
        return this.createMethodHandle(parent, new String(methodName), parameterTypeSignatures);
    }

    private IJavaScriptElement createMethodHandle(IJavaScriptElement parent, String methodName, String[] parameterTypeSignatures) {
        IFunction methodHandle = null;
        if (parent instanceof IJavaScriptUnit) {
            IJavaScriptUnit compUnit = (IJavaScriptUnit)parent;
            methodHandle = compUnit.getFunction(methodName, parameterTypeSignatures);
        } else if (parent instanceof ICompilationUnit) {
            IClassFile classFile = (IClassFile)parent;
            methodHandle = classFile.getFunction(methodName, parameterTypeSignatures);
        } else if (parent instanceof IType) {
            IType type = (IType)parent;
            methodHandle = type.getFunction(methodName, parameterTypeSignatures);
        }
        if (methodHandle instanceof SourceMethod) {
            while (this.methodHandles.contains(methodHandle)) {
                ++((SourceMethod)methodHandle).occurrenceCount;
            }
        }
        this.methodHandles.add(methodHandle);
        return methodHandle;
    }

    protected IJavaScriptElement createHandle(InferredAttribute fieldDeclaration, InferredType typeDeclaration, IJavaScriptElement parent) {
        if (parent instanceof ITypeRoot) {
            ITypeRoot typeRoot = (ITypeRoot)parent;
            parent = typeRoot.getType(new String(typeDeclaration.getName()));
        }
        if (!(parent instanceof IType)) {
            return parent;
        }
        return ((IType)parent).getField(new String(fieldDeclaration.name));
    }

    protected IJavaScriptElement createHandle(FieldDeclaration fieldDeclaration, TypeDeclaration typeDeclaration, IJavaScriptElement parent) {
        if (!(parent instanceof IType)) {
            return parent;
        }
        IType type = (IType)parent;
        switch (fieldDeclaration.getKind()) {
            case 1: {
                return ((IType)parent).getField(new String(fieldDeclaration.name));
            }
        }
        if (type.isBinary()) {
            return type;
        }
        int occurrenceCount = 0;
        FieldDeclaration[] fields = typeDeclaration.fields;
        int i = 0;
        int length = fields.length;
        while (i < length) {
            if (fields[i].getKind() == 2) {
                ++occurrenceCount;
                if (fields[i].equals(fieldDeclaration)) break;
            }
            ++i;
        }
        return ((IType)parent).getInitializer(occurrenceCount);
    }

    protected IJavaScriptElement createHandle(AbstractVariableDeclaration variableDeclaration, IJavaScriptElement parent) {
        switch (variableDeclaration.getKind()) {
            case 4: {
                String signature = variableDeclaration.type != null ? new String(variableDeclaration.type.resolvedType.signature()) : "A";
                return new LocalVariable((JavaElement)parent, new String(variableDeclaration.name), variableDeclaration.declarationSourceStart, variableDeclaration.declarationSourceEnd, variableDeclaration.sourceStart, variableDeclaration.sourceEnd, signature);
            }
            case 5: {
                return new LocalVariable((JavaElement)parent, new String(variableDeclaration.name), variableDeclaration.declarationSourceStart, variableDeclaration.declarationSourceEnd, variableDeclaration.sourceStart, variableDeclaration.sourceEnd, new String(variableDeclaration.type.resolvedType.signature()));
            }
        }
        return null;
    }

    protected boolean createHierarchyResolver(IType focusType, PossibleMatch[] possibleMatches) {
        char[][] compoundName = CharOperation.splitOn('.', focusType.getFullyQualifiedName().toCharArray());
        boolean isPossibleMatch = false;
        int i = 0;
        int length = possibleMatches.length;
        while (i < length) {
            if (CharOperation.equals(possibleMatches[i].compoundName, compoundName)) {
                isPossibleMatch = true;
                break;
            }
            ++i;
        }
        if (!isPossibleMatch) {
            if (focusType.isBinary()) {
                try {
                    this.cacheBinaryType(focusType, null);
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    return false;
                }
            } else {
                this.accept((ICompilationUnit)((Object)focusType.getJavaScriptUnit()), null);
            }
        }
        this.hierarchyResolver = new HierarchyResolver(this.lookupEnvironment, null);
        ReferenceBinding binding = this.hierarchyResolver.setFocusType(compoundName);
        return binding != null && binding.isValidBinding() && (binding.tagBits & 0x20000L) == 0L;
    }

    protected IJavaScriptElement createImportHandle(ImportReference importRef) {
        Openable openable;
        char[] importName = CharOperation.concatWith(importRef.getImportName(), '.');
        if ((importRef.bits & 0x20000) != 0) {
            importName = CharOperation.concat(importName, ".*".toCharArray());
        }
        if ((openable = this.currentPossibleMatch.openable) instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getImport(new String(importName));
        }
        IType binaryType = ((ClassFile)openable).getType();
        String typeName = binaryType.getElementName();
        int lastDollar = typeName.lastIndexOf(36);
        if (lastDollar == -1) {
            return binaryType;
        }
        return this.createTypeHandle(typeName.substring(0, lastDollar));
    }

    protected IType createTypeHandle(String simpleTypeName) {
        Openable openable = this.currentPossibleMatch.openable;
        if (openable instanceof CompilationUnit) {
            return ((CompilationUnit)openable).getType(simpleTypeName);
        }
        IType binaryType = ((ClassFile)openable).getType(simpleTypeName);
        return binaryType;
    }

    protected boolean encloses(IJavaScriptElement element) {
        return element != null && this.scope.encloses(element);
    }

    private long findLastTypeArgumentInfo(TypeReference typeRef) {
        TypeReference lastTypeArgument = typeRef;
        int depth = 0;
        while (true) {
            Object lastTypeArguments = null;
            Object last = null;
            if (lastTypeArguments != null) {
                int i = (lastTypeArguments).length - 1;
                while (i >= 0 && last == null) {
                    last = lastTypeArguments[i];
                    ++i;
                }
            }
            if (last == null) break;
            ++depth;
            lastTypeArgument = last;
        }
        return ((long)depth << 32) + (long)lastTypeArgument.sourceEnd;
    }

    protected IBinaryType getBinaryInfo(ClassFile classFile, IResource resource) throws CoreException {
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (classFile.isOpen()) {
            return (IBinaryType)binaryType.getElementInfo();
        }
        return null;
    }

    protected IType getFocusType() {
        return this.scope instanceof HierarchyScope ? ((HierarchyScope)this.scope).focusType : null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getMethodBodies(CompilationUnitDeclaration unit, MatchingNodeSet nodeSet) {
        if (unit.ignoreMethodBodies) {
            unit.ignoreFurtherInvestigation = true;
            return;
        }
        int[] oldLineEnds = this.parser.scanner.lineEnds;
        int oldLinePtr = this.parser.scanner.linePtr;
        try {
            CompilationResult compilationResult = unit.compilationResult;
            this.parser.scanner.setSource(compilationResult);
            if (this.parser.javadocParser.checkDocComment) {
                char[] contents = compilationResult.compilationUnit.getContents();
                this.parser.javadocParser.scanner.setSource(contents);
            }
            this.parser.nodeSet = nodeSet;
            this.parser.parseBodies(unit);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.parser.nodeSet = null;
            this.parser.scanner.lineEnds = oldLineEnds;
            this.parser.scanner.linePtr = oldLinePtr;
            return;
        }
    }

    protected TypeBinding getType(Object typeKey, char[] typeName) {
        if (this.unitScope == null || typeName == null || typeName.length == 0) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(typeKey);
        if (binding != null) {
            if (binding instanceof TypeBinding && binding.isValidBinding()) {
                return (TypeBinding)binding;
            }
            return null;
        }
        char[][] compoundName = CharOperation.splitOn('.', typeName);
        TypeBinding typeBinding = this.unitScope.getType(compoundName, compoundName.length);
        this.bindings.put(typeKey, typeBinding);
        return typeBinding.isValidBinding() ? typeBinding : null;
    }

    public MethodBinding getMethodBinding(MethodPattern methodPattern) {
        TypeBinding declaringTypeBinding;
        if (this.unitScope == null) {
            return null;
        }
        Binding binding = (Binding)this.bindings.get(methodPattern);
        if (binding != null) {
            if (binding instanceof MethodBinding && binding.isValidBinding()) {
                return (MethodBinding)binding;
            }
            return null;
        }
        char[] typeName = PatternLocator.qualifiedPattern(methodPattern.declaringSimpleName, methodPattern.declaringQualification);
        if (typeName == null) {
            if (methodPattern.declaringType == null) {
                return null;
            }
            typeName = methodPattern.declaringType.getFullyQualifiedName().toCharArray();
        }
        if ((declaringTypeBinding = this.getType(typeName, typeName)) != null) {
            if (declaringTypeBinding.isArrayType()) {
                declaringTypeBinding = declaringTypeBinding.leafComponentType();
            }
            if (!declaringTypeBinding.isBaseType()) {
                char[][] parameterTypes = methodPattern.parameterSimpleNames;
                if (parameterTypes == null) {
                    return null;
                }
                int paramTypeslength = parameterTypes.length;
                ReferenceBinding referenceBinding = (ReferenceBinding)declaringTypeBinding;
                MethodBinding[] methods = referenceBinding.getMethods(methodPattern.selector);
                int methodsLength = methods.length;
                int i = 0;
                while (i < methodsLength) {
                    TypeBinding[] methodParameters = methods[i].parameters;
                    int paramLength = methodParameters == null ? 0 : methodParameters.length;
                    boolean found = false;
                    if (methodParameters != null && paramLength == paramTypeslength) {
                        int p = 0;
                        while (p < paramLength) {
                            if (CharOperation.equals(methodParameters[p].sourceName(), parameterTypes[p])) {
                                found = true;
                            } else {
                                found = false;
                                if (!found) break;
                            }
                            ++p;
                        }
                    }
                    if (found) {
                        this.bindings.put(methodPattern, methods[i]);
                        return methods[i];
                    }
                    ++i;
                }
            }
        }
        this.bindings.put(methodPattern, new ProblemMethodBinding(methodPattern.selector, null, 1));
        return null;
    }

    protected boolean hasAlreadyDefinedType(CompilationUnitDeclaration parsedUnit) {
        CompilationResult result = parsedUnit.compilationResult;
        if (result == null) {
            return false;
        }
        int i = 0;
        while (i < result.problemCount) {
            if (result.problems[i].getID() == 16777539) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initialize(JavaProject project, int possibleMatchSize) throws JavaScriptModelException {
        if (this.nameEnvironment != null && possibleMatchSize != 1) {
            this.nameEnvironment.cleanup();
        }
        SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.workingCopies);
        this.nameEnvironment = searchableEnvironment;
        Map map = project.getOptions(true);
        map.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
        this.options = new CompilerOptions(map);
        ProblemReporter problemReporter = new ProblemReporter(DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.options, new DefaultProblemFactory());
        this.lookupEnvironment = new LookupEnvironment(this, this.options, problemReporter, this.nameEnvironment);
        this.parser = MatchLocatorParser.createParser(problemReporter, this);
        this.basicParser = null;
        this.nameLookup = searchableEnvironment.nameLookup;
        this.numberOfMatches = 0;
        this.matchesToProcess = new PossibleMatch[possibleMatchSize];
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void locateMatches(JavaProject javaProject, PossibleMatch[] possibleMatches, int start, int length) throws CoreException {
        boolean bindingsWereCreated;
        boolean mustResolve;
        block36: {
            boolean mustResolvePattern;
            this.initialize(javaProject, length);
            mustResolve = mustResolvePattern = this.pattern.mustResolve;
            this.patternLocator.mayBeGeneric = this.options.sourceLevel >= 0x310000L;
            bindingsWereCreated = mustResolve;
            try {
                IType focusType;
                int i = start;
                int maxUnits = start + length;
                while (true) {
                    block37: {
                        Object var11_14;
                        if (i >= maxUnits) {
                            if (mustResolve) {
                                this.lookupEnvironment.completeTypeBindings();
                            }
                            if ((focusType = this.getFocusType()) != null) break;
                            this.hierarchyResolver = null;
                            break block36;
                        }
                        PossibleMatch possibleMatch = possibleMatches[i];
                        try {
                            if (possibleMatch.openable instanceof MetadataFile) {
                                this.currentPossibleMatch = possibleMatch;
                                this.processMetadata((MetadataFile)possibleMatch.openable);
                            } else {
                                if (!this.parseAndBuildBindings(possibleMatch, mustResolvePattern)) {
                                    var11_14 = null;
                                    if (!possibleMatch.nodeSet.mustResolve) {
                                        possibleMatch.cleanUp();
                                    }
                                    break block37;
                                }
                                if (this.patternLocator.mayBeGeneric) {
                                    if (!mustResolvePattern && !mustResolve) {
                                        bindingsWereCreated = mustResolve = possibleMatch.nodeSet.mustResolve;
                                    }
                                } else {
                                    possibleMatch.nodeSet.mustResolve = mustResolvePattern;
                                }
                                if (!possibleMatch.nodeSet.mustResolve) {
                                    if (this.progressMonitor != null) {
                                        ++this.progressWorked;
                                        if (this.progressWorked % this.progressStep == 0) {
                                            this.progressMonitor.worked(this.progressStep);
                                        }
                                    }
                                    this.process(possibleMatch, bindingsWereCreated);
                                    if (this.numberOfMatches > 0 && this.matchesToProcess[this.numberOfMatches - 1] == possibleMatch) {
                                        --this.numberOfMatches;
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var11_14 = null;
                            if (!possibleMatch.nodeSet.mustResolve) {
                                possibleMatch.cleanUp();
                            }
                            throw throwable;
                        }
                        {
                            var11_14 = null;
                            if (possibleMatch.nodeSet.mustResolve) break block37;
                            possibleMatch.cleanUp();
                        }
                    }
                    ++i;
                }
                if (!this.createHierarchyResolver(focusType, possibleMatches) && this.computeSuperTypeNames(focusType) == null) {
                    return;
                }
            }
            catch (AbortCompilation abortCompilation) {
                bindingsWereCreated = false;
            }
        }
        if (!mustResolve) {
            return;
        }
        int i = 0;
        while (true) {
            PossibleMatch possibleMatch;
            block38: {
                Object var10_13;
                if (i >= this.numberOfMatches) break;
                if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                possibleMatch = this.matchesToProcess[i];
                this.matchesToProcess[i] = null;
                try {
                    try {
                        this.process(possibleMatch, bindingsWereCreated);
                    }
                    catch (AbortCompilation abortCompilation) {
                        bindingsWereCreated = false;
                    }
                    catch (JavaScriptModelException javaScriptModelException) {
                        bindingsWereCreated = false;
                    }
                }
                catch (Throwable throwable) {
                    var10_13 = null;
                    if (this.progressMonitor != null) {
                        ++this.progressWorked;
                        if (this.progressWorked % this.progressStep == 0) {
                            this.progressMonitor.worked(this.progressStep);
                        }
                    }
                    if (this.options.verbose) {
                        System.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
                    }
                    throw throwable;
                }
                {
                    var10_13 = null;
                    if (this.progressMonitor == null) break block38;
                    ++this.progressWorked;
                    if (this.progressWorked % this.progressStep != 0) break block38;
                }
                this.progressMonitor.worked(this.progressStep);
            }
            if (this.options.verbose) {
                System.out.println(Messages.bind(Messages.compilation_done, new String[]{String.valueOf(i + 1), String.valueOf(this.numberOfMatches), new String(possibleMatch.parsedUnit.getFileName())}));
            }
            ++i;
        }
        i = 0;
        while (true) {
            if (i >= this.numberOfMatches) {
                if (this.progressMonitor == null || !this.progressMonitor.isCanceled()) break;
                throw new OperationCanceledException();
            }
            this.matchesToProcess[i].cleanUp();
            this.matchesToProcess[i] = null;
            ++i;
        }
    }

    private void processMetadata(MetadataFile metadataFile) throws CoreException {
        IType[] types = metadataFile.getTypes();
        int matchLevel = 0;
        int typeIndex = 0;
        while (typeIndex < types.length) {
            IType type = types[typeIndex];
            matchLevel = this.patternLocator.matchMetadataElement(type);
            if (matchLevel >= 2) {
                this.reportMatching(type, matchLevel, null, 1);
            }
            IFunction[] methods = type.getFunctions();
            int methodIndex = 0;
            while (methodIndex < methods.length) {
                IFunction method = methods[methodIndex];
                matchLevel = this.patternLocator.matchMetadataElement(method);
                if (matchLevel >= 2) {
                    this.reportMatching(method, matchLevel, null, 1);
                }
                ++methodIndex;
            }
            IField[] fields = type.getFields();
            int fieldIndex = 0;
            while (fieldIndex < fields.length) {
                IField field = fields[fieldIndex];
                matchLevel = this.patternLocator.matchMetadataElement(field);
                if (matchLevel >= 2) {
                    this.reportMatching(field, matchLevel, null, 1);
                }
                ++fieldIndex;
            }
            ++typeIndex;
        }
        IFunction[] methods = metadataFile.getFunctions();
        int methodIndex = 0;
        while (methodIndex < methods.length) {
            IFunction method = methods[methodIndex];
            matchLevel = this.patternLocator.matchMetadataElement(method);
            if (matchLevel >= 2) {
                this.reportMatching(method, matchLevel, null, 1);
            }
            ++methodIndex;
        }
        IField[] fields = metadataFile.getFields();
        int fieldIndex = 0;
        while (fieldIndex < fields.length) {
            IField field = fields[fieldIndex];
            matchLevel = this.patternLocator.matchMetadataElement(field);
            if (matchLevel >= 2) {
                this.reportMatching(field, matchLevel, null, 1);
            }
            ++fieldIndex;
        }
    }

    protected void locateMatches(JavaProject javaProject, PossibleMatchSet matchSet, int expected) throws CoreException {
        PossibleMatch[] possibleMatches = matchSet.getPossibleMatches(javaProject.getPackageFragmentRoots());
        int length = possibleMatches.length;
        if (this.progressMonitor != null && expected > length) {
            this.progressWorked += expected - length;
            this.progressMonitor.worked(expected - length);
        }
        int index = 0;
        while (index < length) {
            int max = Math.min(MAX_AT_ONCE, length - index);
            this.locateMatches(javaProject, possibleMatches, index, max);
            index += max;
        }
        this.patternLocator.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(SearchDocument[] searchDocuments) throws CoreException {
        JavaModelManager manager;
        block34: {
            int docsLength = searchDocuments.length;
            if (BasicSearchEngine.VERBOSE) {
                System.out.println("Locating matches in documents [");
                int i = 0;
                while (i < docsLength) {
                    System.out.println("\t" + searchDocuments[i]);
                    ++i;
                }
                System.out.println("]");
            }
            int n = docsLength < 1000 ? Math.min(Math.max(docsLength / 200 + 1, 2), 4) : 5 * (docsLength / 1000);
            this.progressStep = docsLength < n ? 1 : docsLength / n;
            this.progressWorked = 0;
            ArrayList<IJavaScriptUnit> copies = new ArrayList<IJavaScriptUnit>();
            int i = 0;
            while (i < docsLength) {
                SearchDocument document = searchDocuments[i];
                if (document instanceof WorkingCopyDocument) {
                    copies.add(((WorkingCopyDocument)document).workingCopy);
                }
                ++i;
            }
            int copiesLength = copies.size();
            this.workingCopies = new IJavaScriptUnit[copiesLength];
            copies.toArray(this.workingCopies);
            manager = JavaModelManager.getJavaModelManager();
            this.bindings = new SimpleLookupTable();
            try {
                manager.cacheZipFiles();
                if (this.handleFactory == null) {
                    this.handleFactory = new HandleFactory();
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.beginTask("", searchDocuments.length);
                }
                this.patternLocator.initializePolymorphicSearch(this);
                JavaProject previousJavaProject = null;
                PossibleMatchSet matchSet = new PossibleMatchSet();
                Util.sort(searchDocuments, new Util.Comparer(){

                    public int compare(Object a, Object b) {
                        return ((SearchDocument)a).getPath().compareTo(((SearchDocument)b).getPath());
                    }
                });
                int displayed = 0;
                String previousPath = null;
                int i2 = 0;
                while (i2 < docsLength) {
                    if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    SearchDocument searchDocument = searchDocuments[i2];
                    searchDocuments[i2] = null;
                    String pathString = searchDocument.getPath();
                    if (i2 > 0 && pathString.equals(previousPath)) {
                        if (this.progressMonitor != null) {
                            ++this.progressWorked;
                            if (this.progressWorked % this.progressStep == 0) {
                                this.progressMonitor.worked(this.progressStep);
                            }
                        }
                        ++displayed;
                    } else {
                        Openable openable;
                        previousPath = pathString;
                        IJavaScriptUnit workingCopy = null;
                        if (searchDocument instanceof WorkingCopyDocument) {
                            workingCopy = ((WorkingCopyDocument)searchDocument).workingCopy;
                            openable = (Openable)((Object)workingCopy);
                        } else {
                            openable = searchDocument.isVirtual() ? (Openable)searchDocument.getJavaElement() : this.handleFactory.createOpenable(pathString, this.scope);
                        }
                        if (openable == null) {
                            if (this.progressMonitor != null) {
                                ++this.progressWorked;
                                if (this.progressWorked % this.progressStep == 0) {
                                    this.progressMonitor.worked(this.progressStep);
                                }
                            }
                            ++displayed;
                        } else {
                            IResource resource = null;
                            JavaProject javaProject = (JavaProject)openable.getJavaScriptProject();
                            IResource iResource = resource = workingCopy != null ? workingCopy.getResource() : openable.getResource();
                            if (resource == null) {
                                resource = javaProject.getProject();
                            }
                            if (!javaProject.equals(previousJavaProject)) {
                                if (previousJavaProject != null) {
                                    try {
                                        this.locateMatches(previousJavaProject, matchSet, i2 - displayed);
                                        displayed = i2;
                                    }
                                    catch (JavaScriptModelException javaScriptModelException) {}
                                    matchSet.reset();
                                }
                                previousJavaProject = javaProject;
                            }
                            matchSet.add(new PossibleMatch(this, resource, openable, searchDocument, this.pattern.mustResolve));
                        }
                    }
                    ++i2;
                }
                if (previousJavaProject != null) {
                    try {
                        this.locateMatches(previousJavaProject, matchSet, docsLength - displayed);
                    }
                    catch (JavaScriptModelException javaScriptModelException) {}
                }
                Object var18_20 = null;
                if (this.progressMonitor == null) break block34;
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                if (this.progressMonitor != null) {
                    this.progressMonitor.done();
                }
                if (this.nameEnvironment != null) {
                    this.nameEnvironment.cleanup();
                }
                if (this.parsedUnits != null) {
                    this.parsedUnits.clear();
                }
                manager.flushZipFiles();
                this.bindings = null;
                throw throwable;
            }
            this.progressMonitor.done();
        }
        if (this.nameEnvironment != null) {
            this.nameEnvironment.cleanup();
        }
        if (this.parsedUnits != null) {
            this.parsedUnits.clear();
        }
        manager.flushZipFiles();
        this.bindings = null;
    }

    protected IType lookupType(ReferenceBinding typeBinding) {
        char[][] qualifiedName;
        IType type;
        int length;
        if (typeBinding == null) {
            return null;
        }
        char[] packageName = typeBinding.qualifiedPackageName();
        IPackageFragment[] pkgs = this.nameLookup.findPackageFragments(packageName == null || packageName.length == 0 ? "" : new String(packageName), false);
        char[] sourceName = typeBinding.qualifiedSourceName();
        String typeName = new String(sourceName);
        int acceptFlag = 0;
        if (typeBinding.isClass()) {
            acceptFlag = 2;
        }
        if (pkgs != null) {
            int i = 0;
            length = pkgs.length;
            while (i < length) {
                type = this.nameLookup.findType(typeName, pkgs[i], false, acceptFlag, true);
                if (type != null) {
                    return type;
                }
                ++i;
            }
        }
        if ((length = (qualifiedName = CharOperation.splitOn('.', sourceName)).length) == 0) {
            return null;
        }
        type = this.createTypeHandle(new String(qualifiedName[0]));
        if (type == null) {
            return null;
        }
        int i = 1;
        while (i < length) {
            if ((type = type.getType(new String(qualifiedName[i]))) == null) {
                return null;
            }
            ++i;
        }
        if (type.exists()) {
            return type;
        }
        return null;
    }

    public SearchMatch newDeclarationMatch(IJavaScriptElement element, Binding binding, int accuracy, int offset, int length) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return this.newDeclarationMatch(element, binding, accuracy, offset, length, participant, resource);
    }

    public SearchMatch newDeclarationMatch(IJavaScriptElement element, Binding binding, int accuracy, int offset, int length, SearchParticipant participant, IResource resource) {
        switch (element.getElementType()) {
            case 7: {
                return new TypeDeclarationMatch(binding == null ? element : ((JavaElement)element).resolved(binding), accuracy, offset, length, participant, resource);
            }
            case 8: {
                return new FieldDeclarationMatch(binding == null ? element : ((JavaElement)element).resolved(binding), accuracy, offset, length, participant, resource);
            }
            case 9: {
                return new MethodDeclarationMatch(binding == null ? element : ((JavaElement)element).resolved(binding), accuracy, offset, length, participant, resource);
            }
            case 14: {
                return new LocalVariableDeclarationMatch(element, accuracy, offset, length, participant, resource);
            }
        }
        return null;
    }

    public SearchMatch newFieldReferenceMatch(IJavaScriptElement enclosingElement, Binding enclosingBinding, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        if (enclosingBinding != null) {
            enclosingElement = ((JavaElement)enclosingElement).resolved(enclosingBinding);
        }
        return new FieldReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newLocalVariableReferenceMatch(IJavaScriptElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        int bits = reference.bits;
        boolean isCoupoundAssigned = (bits & 0x10000) != 0;
        boolean isReadAccess = isCoupoundAssigned || (bits & 0x2000) == 0;
        boolean isWriteAccess = isCoupoundAssigned || (bits & 0x2000) != 0;
        boolean insideDocComment = (bits & 0x8000) != 0;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        return new LocalVariableReferenceMatch(enclosingElement, accuracy, offset, length, isReadAccess, isWriteAccess, insideDocComment, participant, resource);
    }

    public SearchMatch newMethodReferenceMatch(IJavaScriptElement enclosingElement, Binding enclosingBinding, int accuracy, int offset, int length, boolean isConstructor, ASTNode reference) {
        boolean insideDocComment;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean bl = insideDocComment = (reference.bits & 0x8000) != 0;
        if (enclosingBinding != null) {
            enclosingElement = ((JavaElement)enclosingElement).resolved(enclosingBinding);
        }
        boolean isOverridden = (accuracy & 0x200) != 0;
        return new MethodReferenceMatch(enclosingElement, accuracy, offset, length, isConstructor, isOverridden, insideDocComment, participant, resource);
    }

    public SearchMatch newPackageReferenceMatch(IJavaScriptElement enclosingElement, int accuracy, int offset, int length, ASTNode reference) {
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean insideDocComment = (reference.bits & 0x8000) != 0;
        return new PackageReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public TypeReferenceMatch newTypeReferenceMatch(IJavaScriptElement enclosingElement, Binding enclosingBinding, int accuracy, int offset, int length, ASTNode reference) {
        boolean insideDocComment;
        SearchParticipant participant = this.getParticipant();
        IResource resource = this.currentPossibleMatch.resource;
        boolean bl = insideDocComment = (reference.bits & 0x8000) != 0;
        if (enclosingBinding != null) {
            enclosingElement = ((JavaElement)enclosingElement).resolved(enclosingBinding);
        }
        return new TypeReferenceMatch(enclosingElement, accuracy, offset, length, insideDocComment, participant, resource);
    }

    public TypeReferenceMatch newTypeReferenceMatch(IJavaScriptElement enclosingElement, Binding enclosingBinding, int accuracy, ASTNode reference) {
        return this.newTypeReferenceMatch(enclosingElement, enclosingBinding, accuracy, reference.sourceStart, reference.sourceEnd - reference.sourceStart + 1, reference);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean parseAndBuildBindings(PossibleMatch possibleMatch, boolean mustResolve) throws CoreException {
        if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            if (BasicSearchEngine.VERBOSE) {
                System.out.println("Parsing " + possibleMatch.openable.toStringWithAncestors());
            }
            this.parser.nodeSet = possibleMatch.nodeSet;
            CompilationResult unitResult = new CompilationResult(possibleMatch, 1, 1, this.options.maxProblemsPerUnit);
            CompilationUnitDeclaration parsedUnit = this.parser.dietParse(possibleMatch, unitResult);
            if (parsedUnit != null) {
                this.parser.inferTypes(parsedUnit, this.options);
                if (!parsedUnit.isEmpty()) {
                    if (mustResolve) {
                        this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                    }
                    if (this.hasAlreadyDefinedType(parsedUnit)) {
                        Object var6_5 = null;
                        this.parser.nodeSet = null;
                        return false;
                    }
                    this.getMethodBodies(parsedUnit, possibleMatch.nodeSet);
                    if (this.patternLocator.mayBeGeneric && !mustResolve && possibleMatch.nodeSet.mustResolve) {
                        this.lookupEnvironment.buildTypeBindings(parsedUnit, null);
                    }
                }
                possibleMatch.parsedUnit = parsedUnit;
                int size = this.matchesToProcess.length;
                if (this.numberOfMatches == size) {
                    this.matchesToProcess = new PossibleMatch[size == 0 ? 1 : size * 2];
                    System.arraycopy(this.matchesToProcess, 0, this.matchesToProcess, 0, this.numberOfMatches);
                }
                this.matchesToProcess[this.numberOfMatches++] = possibleMatch;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.parser.nodeSet = null;
            throw throwable;
        }
        {
            Object var6_7 = null;
            this.parser.nodeSet = null;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void process(PossibleMatch possibleMatch, boolean bindingsWereCreated) throws CoreException {
        this.currentPossibleMatch = possibleMatch;
        CompilationUnitDeclaration unit = possibleMatch.parsedUnit;
        try {
            block20: {
                try {
                    boolean mustResolve;
                    block23: {
                        block22: {
                            block21: {
                                ClassFile classFile;
                                IBinaryType info;
                                if (!unit.isEmpty()) break block21;
                                if (this.currentPossibleMatch.openable instanceof ClassFile && (info = this.getBinaryInfo(classFile = (ClassFile)this.currentPossibleMatch.openable, this.currentPossibleMatch.resource)) != null) {
                                    boolean mayBeGeneric = this.patternLocator.mayBeGeneric;
                                    this.patternLocator.mayBeGeneric = false;
                                    try {
                                        new ClassFileMatchLocator().locateMatches(this, classFile, info);
                                        Object var7_11 = null;
                                        this.patternLocator.mayBeGeneric = mayBeGeneric;
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_10 = null;
                                        this.patternLocator.mayBeGeneric = mayBeGeneric;
                                        throw throwable;
                                    }
                                }
                                break block22;
                            }
                            if (!this.hasAlreadyDefinedType(unit)) break block23;
                        }
                        Object var9_12 = null;
                        this.lookupEnvironment.unitBeingCompleted = null;
                        this.currentPossibleMatch = null;
                        return;
                    }
                    boolean bl = mustResolve = this.pattern.mustResolve || possibleMatch.nodeSet.mustResolve;
                    if (bindingsWereCreated && mustResolve) {
                        if (unit.types != null || unit.statements != null) {
                            if (BasicSearchEngine.VERBOSE) {
                                System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                            }
                            this.lookupEnvironment.unitBeingCompleted = unit;
                            this.reduceParseTree(unit);
                            if (unit.scope != null) {
                                unit.scope.faultInTypes();
                            }
                            unit.resolve();
                        } else if (unit.isPackageInfo()) {
                            if (BasicSearchEngine.VERBOSE) {
                                System.out.println("Resolving " + this.currentPossibleMatch.openable.toStringWithAncestors());
                            }
                            unit.resolve();
                        }
                    }
                    this.reportMatching(unit, mustResolve);
                }
                catch (AbortCompilation e) {
                    this.reportMatching(unit, false);
                    if (e instanceof AbortCompilationUnit) break block20;
                    throw e;
                }
            }
            Object var9_14 = null;
            this.lookupEnvironment.unitBeingCompleted = null;
            this.currentPossibleMatch = null;
            return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.lookupEnvironment.unitBeingCompleted = null;
            this.currentPossibleMatch = null;
            throw throwable;
        }
    }

    protected void purgeMethodStatements(TypeDeclaration type, boolean checkEachMethod) {
        TypeDeclaration[] memberTypes;
        checkEachMethod = checkEachMethod && this.currentPossibleMatch.nodeSet.hasPossibleNodes(type.declarationSourceStart, type.declarationSourceEnd);
        AbstractMethodDeclaration[] methods = type.methods;
        if (methods != null) {
            int length;
            int j;
            if (checkEachMethod) {
                j = 0;
                length = methods.length;
                while (j < length) {
                    AbstractMethodDeclaration method = methods[j];
                    this.purgeMethodStatements(method);
                    ++j;
                }
            } else {
                j = 0;
                length = methods.length;
                while (j < length) {
                    methods[j].statements = null;
                    methods[j].javadoc = null;
                    ++j;
                }
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                this.purgeMethodStatements(memberTypes[i], checkEachMethod);
                ++i;
            }
        }
    }

    private void purgeMethodStatements(AbstractMethodDeclaration method) {
        if (!this.currentPossibleMatch.nodeSet.hasPossibleNodes(method.declarationSourceStart, method.declarationSourceEnd)) {
            method.statements = null;
            method.javadoc = null;
        }
    }

    protected void reduceParseTree(CompilationUnitDeclaration unit) {
        if (unit.types != null) {
            TypeDeclaration[] types = unit.types;
            int i = 0;
            int l = types.length;
            while (i < l) {
                this.purgeMethodStatements(types[i], true);
                ++i;
            }
        }
        if (unit.statements != null) {
            int i = 0;
            while (i < unit.statements.length) {
                if (unit.statements[i] instanceof AbstractMethodDeclaration) {
                    this.purgeMethodStatements((AbstractMethodDeclaration)unit.statements[i]);
                }
                ++i;
            }
        }
    }

    public SearchParticipant getParticipant() {
        return this.currentPossibleMatch.document.getParticipant();
    }

    protected void report(SearchMatch match) throws CoreException {
        long start = -1L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
            System.out.println("Reporting match");
            System.out.println("\tResource: " + match.getResource());
            System.out.println("\tPositions: [offset=" + match.getOffset() + ", length=" + match.getLength() + "]");
            try {
                if (this.parser != null && match.getOffset() > 0 && match.getLength() > 0 && !(match.getElement() instanceof BinaryMember)) {
                    String selection = new String(this.parser.scanner.source, match.getOffset(), match.getLength());
                    System.out.println("\tSelection: -->" + selection + "<--");
                }
            }
            catch (Exception exception) {}
            try {
                JavaElement javaElement = (JavaElement)match.getElement();
                System.out.println("\tJava element: " + javaElement.toStringWithAncestors());
                if (!javaElement.exists()) {
                    System.out.println("\t\tWARNING: this element does NOT exist!");
                }
            }
            catch (Exception exception) {}
            if (match instanceof TypeReferenceMatch) {
                try {
                    int length;
                    IJavaScriptElement[] others;
                    TypeReferenceMatch typeRefMatch = (TypeReferenceMatch)match;
                    JavaElement local = (JavaElement)typeRefMatch.getLocalElement();
                    if (local != null) {
                        System.out.println("\tLocal element: " + local.toStringWithAncestors());
                    }
                    if ((others = typeRefMatch.getOtherElements()) != null && (length = others.length) > 0) {
                        System.out.println("\tOther elements:");
                        int i = 0;
                        while (i < length) {
                            JavaElement other = (JavaElement)others[i];
                            System.out.println("\t\t- " + other.toStringWithAncestors());
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            System.out.println(match.getAccuracy() == 0 ? "\tAccuracy: EXACT_MATCH" : "\tAccuracy: POTENTIAL_MATCH");
            System.out.print("\tRule: ");
            if (match.isExact()) {
                System.out.print("EXACT");
            } else if (match.isEquivalent()) {
                System.out.print("EQUIVALENT");
            } else if (match.isErasure()) {
                System.out.print("ERASURE");
            } else {
                System.out.print("INVALID RULE");
            }
            if (match instanceof MethodReferenceMatch) {
                MethodReferenceMatch methodReferenceMatch = (MethodReferenceMatch)match;
                if (methodReferenceMatch.isSuperInvocation()) {
                    System.out.print("+SUPER INVOCATION");
                }
                if (methodReferenceMatch.isImplicit()) {
                    System.out.print("+IMPLICIT");
                }
            }
            System.out.println("\n\tRaw: " + match.isRaw());
        }
        this.requestor.acceptSearchMatch(match);
        if (BasicSearchEngine.VERBOSE) {
            this.resultCollectorTime += System.currentTimeMillis() - start;
        }
    }

    protected void reportAccurateTypeReference(SearchMatch match, ASTNode typeRef, char[] name) throws CoreException {
        if (match.getRule() == 0) {
            return;
        }
        if (!this.encloses((IJavaScriptElement)match.getElement())) {
            return;
        }
        int sourceStart = typeRef.sourceStart;
        int sourceEnd = typeRef.sourceEnd;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int token = -1;
        do {
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (token != 32 || !this.pattern.matchesName(name, scanner.getCurrentTokenSource())) continue;
            int length = scanner.currentPosition - currentPosition;
            match.setOffset(currentPosition);
            match.setLength(length);
            this.report(match);
            return;
        } while (token != 70);
        match.setOffset(sourceStart);
        match.setLength(sourceEnd - sourceStart + 1);
        this.report(match);
    }

    protected void reportAccurateParameterizedMethodReference(SearchMatch match, ASTNode statement, TypeReference[] typeArguments) throws CoreException {
        int start;
        block10: {
            if (match.getRule() == 0) {
                return;
            }
            if (!this.encloses((IJavaScriptElement)match.getElement())) {
                return;
            }
            start = match.getOffset();
            if (typeArguments != null && typeArguments.length > 0) {
                boolean isErasureMatch;
                boolean bl = isErasureMatch = this.pattern instanceof OrPattern ? ((OrPattern)this.pattern).isErasureMatch() : ((JavaSearchPattern)this.pattern).isErasureMatch();
                if (!isErasureMatch) {
                    Scanner scanner = this.parser.scanner;
                    char[] source = this.currentPossibleMatch.getContents();
                    scanner.setSource(source);
                    start = typeArguments[0].sourceStart;
                    int end = statement.sourceEnd;
                    scanner.resetTo(start, end);
                    int lineStart = start;
                    try {
                        while (true) {
                            if (scanner.source[scanner.currentPosition] != '\n') {
                                --scanner.currentPosition;
                                if (scanner.currentPosition != 0) {
                                    continue;
                                }
                                break;
                            }
                            lineStart = scanner.currentPosition + 1;
                            scanner.resetTo(lineStart, end);
                            while (!scanner.atEnd()) {
                                if (scanner.getNextToken() != 21) continue;
                                start = scanner.getCurrentTokenStartPosition();
                                break block10;
                            }
                            scanner.currentPosition = end = lineStart - 2;
                        }
                    }
                    catch (InvalidInputException invalidInputException) {}
                }
            }
        }
        match.setOffset(start);
        match.setLength(statement.sourceEnd - start + 1);
        this.report(match);
    }

    /*
     * Unable to fully structure code
     */
    protected void reportAccurateParameterizedTypeReference(SearchMatch match, TypeReference typeRef, int index, TypeReference[] typeArguments) throws CoreException {
        block7: {
            block6: {
                block8: {
                    block9: {
                        if (match.getRule() == 0) {
                            return;
                        }
                        if (!this.encloses((IJavaScriptElement)match.getElement())) {
                            return;
                        }
                        end = typeRef.sourceEnd;
                        if (typeArguments == null) break block7;
                        scanner = this.parser.scanner;
                        source = this.currentPossibleMatch.getContents();
                        scanner.setSource(source);
                        shouldMatchErasure = this.pattern instanceof OrPattern != false ? ((OrPattern)this.pattern).isErasureMatch() : ((JavaSearchPattern)this.pattern).isErasureMatch();
                        v0 = hasSignatures = this.pattern instanceof OrPattern != false ? ((OrPattern)this.pattern).hasSignatures() : ((JavaSearchPattern)this.pattern).hasSignatures();
                        if (!shouldMatchErasure && hasSignatures) break block8;
                        if (!(typeRef instanceof QualifiedTypeReference) || index < 0) break block9;
                        positions = ((QualifiedTypeReference)typeRef).sourcePositions;
                        end = (int)positions[index];
                        break block7;
                    }
                    if (!(typeRef instanceof ArrayTypeReference)) break block7;
                    end = ((ArrayTypeReference)typeRef).originalSourceEnd;
                    break block7;
                }
                scanner.resetTo(end, source.length - 1);
                depth = 0;
                i = typeArguments.length - 1;
                while (i >= 0) {
                    if (typeArguments[i] != null) {
                        lastTypeArgInfo = this.findLastTypeArgumentInfo(typeArguments[i]);
                        depth = (int)(lastTypeArgInfo >>> 32) + 1;
                        scanner.resetTo((int)lastTypeArgInfo + 1, scanner.eofPosition - 1);
                        break block6;
                    }
                    --i;
                }
                break block6;
                while (true) {
                    if (scanner.getNextChar() != 62) continue;
                    end = scanner.currentPosition - 1;
                    break;
                }
            }
            while (depth-- > 0) {
                if (!scanner.atEnd()) ** continue;
            }
        }
        match.setLength(end - match.getOffset() + 1);
        this.report(match);
    }

    protected void reportAccurateEnumConstructorReference(SearchMatch match, FieldDeclaration field, AllocationExpression allocation) throws CoreException {
        this.report(match);
    }

    protected void reportAccurateFieldReference(SearchMatch[] matches, QualifiedNameReference qNameRef) throws CoreException {
        if (matches == null) {
            return;
        }
        int matchesLength = matches.length;
        int sourceStart = qNameRef.sourceStart;
        int sourceEnd = qNameRef.sourceEnd;
        char[][] tokens = qNameRef.tokens;
        Scanner scanner = this.parser.scanner;
        scanner.setSource(this.currentPossibleMatch.getContents());
        scanner.resetTo(sourceStart, sourceEnd);
        int sourceLength = sourceEnd - sourceStart + 1;
        int refSourceStart = -1;
        int refSourceEnd = -1;
        int length = tokens.length;
        int token = -1;
        int previousValid = -1;
        int i = 0;
        int index = 0;
        do {
            SearchMatch match;
            int currentPosition = scanner.currentPosition;
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (token != 70) {
                char[] currentTokenSource = scanner.getCurrentTokenSource();
                boolean equals = false;
                while (i < length && !(equals = this.pattern.matchesName(tokens[i++], currentTokenSource))) {
                }
                if (equals && (previousValid == -1 || previousValid == i - 2)) {
                    previousValid = i - 1;
                    if (refSourceStart == -1) {
                        refSourceStart = currentPosition;
                    }
                    refSourceEnd = scanner.currentPosition - 1;
                } else {
                    i = 0;
                    refSourceStart = -1;
                    previousValid = -1;
                }
                try {
                    token = scanner.getNextToken();
                }
                catch (InvalidInputException invalidInputException) {}
            }
            if ((match = matches[index]) != null && match.getRule() != 0) {
                if (!this.encloses((IJavaScriptElement)match.getElement())) {
                    return;
                }
                if (refSourceStart != -1) {
                    match.setOffset(refSourceStart);
                    match.setLength(refSourceEnd - refSourceStart + 1);
                    this.report(match);
                } else {
                    match.setOffset(sourceStart);
                    match.setLength(sourceLength);
                    this.report(match);
                }
                i = 0;
            }
            refSourceStart = -1;
            previousValid = -1;
            if (index >= matchesLength - 1) continue;
            ++index;
        } while (token != 70);
    }

    protected void reportBinaryMemberDeclaration(IResource resource, IMember binaryMember, Binding binaryMemberBinding, IBinaryType info, int accuracy) throws CoreException {
        char[] contents;
        SourceMapper mapper;
        BinaryType type;
        String sourceFileName;
        ISourceRange range;
        ClassFile classFile = (ClassFile)binaryMember.getClassFile();
        ISourceRange iSourceRange = range = classFile.isOpen() ? binaryMember.getNameRange() : SourceMapper.UNKNOWN_RANGE;
        if (range.getOffset() == -1 && (sourceFileName = (type = (BinaryType)classFile.getType()).sourceFileName(info)) != null && (mapper = classFile.getSourceMapper()) != null && (contents = mapper.findSource((IType)type, sourceFileName)) != null) {
            range = mapper.mapSource(type, contents, info, binaryMember);
        }
        if (resource == null) {
            resource = this.currentPossibleMatch.resource;
        }
        SearchMatch match = this.newDeclarationMatch(binaryMember, binaryMemberBinding, accuracy, range.getOffset(), range.getLength(), this.getParticipant(), resource);
        this.report(match);
    }

    protected void reportMatching(TypeDeclaration type, AbstractMethodDeclaration method, IJavaScriptElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        ASTNode[] nodes;
        IJavaScriptElement enclosingElement = null;
        if (accuracy > -1 && (enclosingElement = this.createHandle(method, parent)) != null) {
            Scanner scanner = this.parser.scanner;
            int nameSourceStart = method.sourceStart;
            scanner.setSource(this.currentPossibleMatch.getContents());
            scanner.resetTo(nameSourceStart, method.sourceEnd);
            try {
                scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {}
            if (this.encloses(enclosingElement)) {
                SearchMatch match = null;
                if (method.isDefaultConstructor()) {
                    int offset = type.sourceStart;
                    match = this.patternLocator.newDeclarationMatch(type, parent, type.binding, accuracy, type.sourceEnd - offset + 1, this);
                } else {
                    int length = scanner.currentPosition - nameSourceStart;
                    match = this.patternLocator.newDeclarationMatch(method, enclosingElement, method.binding, accuracy, length, this);
                }
                if (match != null) {
                    this.report(match);
                }
            }
        }
        if ((method.bits & 2) != 0) {
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(method, parent);
            }
            LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, method.binding, nodeSet);
            try {
                method.traverse((ASTVisitor)localDeclarationVisitor, (Scope)null);
            }
            catch (WrappedCoreException e) {
                throw e.coreException;
            }
        }
        if (typeInHierarchy && (nodes = nodeSet.matchingNodes(method.declarationSourceStart, method.declarationSourceEnd)) != null) {
            int i;
            if ((this.matchContainer & 4) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(method, parent);
                }
                if (this.encloses(enclosingElement)) {
                    i = 0;
                    int l = nodes.length;
                    while (i < l) {
                        ASTNode node = nodes[i];
                        Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                        this.patternLocator.matchReportReference(node, enclosingElement, method.binding, method.scope, level, this);
                        ++i;
                    }
                    return;
                }
            }
            i = 0;
            int l = nodes.length;
            while (i < l) {
                nodeSet.matchingNodes.removeKey(nodes[i]);
                ++i;
            }
        }
    }

    protected void reportMatching(CompilationUnitDeclaration unit, boolean mustResolve) throws CoreException {
        ProgramElement[] statements;
        TypeDeclaration[] types;
        Integer level;
        ImportReference[] imports;
        ASTNode[] nodes;
        boolean matchedUnitContainer;
        ImportReference importRef;
        boolean locatorMustResolve;
        MatchingNodeSet nodeSet;
        block38: {
            block35: {
                nodeSet = this.currentPossibleMatch.nodeSet;
                locatorMustResolve = this.patternLocator.mustResolve;
                if (nodeSet.mustResolve) {
                    this.patternLocator.mustResolve = true;
                }
                if (BasicSearchEngine.VERBOSE) {
                    System.out.println("Report matching: ");
                    int size = nodeSet.matchingNodes == null ? 0 : nodeSet.matchingNodes.elementSize;
                    System.out.print("\t- node set: accurate=" + size);
                    size = nodeSet.possibleMatchingNodesSet == null ? 0 : nodeSet.possibleMatchingNodesSet.elementSize;
                    System.out.println(", possible=" + size);
                    System.out.print("\t- must resolve: " + mustResolve);
                    System.out.print(" (locator: " + this.patternLocator.mustResolve);
                    System.out.println(", nodeSet: " + nodeSet.mustResolve + ')');
                }
                if (!mustResolve) break block35;
                this.unitScope = unit.scope.compilationUnitScope();
                Object[] nodes2 = nodeSet.possibleMatchingNodesSet.values;
                int i = 0;
                int l = nodes2.length;
                while (i < l) {
                    block36: {
                        ASTNode node;
                        block37: {
                            node = (ASTNode)nodes2[i];
                            if (node == null) break block36;
                            if (!(node instanceof ImportReference)) break block37;
                            if (this.hierarchyResolver != null) break block36;
                            importRef = (ImportReference)node;
                            Binding binding = (importRef.bits & 0x20000) != 0 ? this.unitScope.getImport(CharOperation.subarray(importRef.tokens, 0, importRef.tokens.length), true) : this.unitScope.getImport(importRef.tokens, false);
                            this.patternLocator.matchLevelAndReportImportRef(importRef, binding, this);
                        }
                        nodeSet.addMatch(node, this.patternLocator.resolveLevel(node));
                    }
                    ++i;
                }
                nodeSet.possibleMatchingNodesSet = new SimpleSet(3);
                if (BasicSearchEngine.VERBOSE) {
                    int size = nodeSet.matchingNodes == null ? 0 : nodeSet.matchingNodes.elementSize;
                    System.out.print("\t- node set: accurate=" + size);
                    size = nodeSet.possibleMatchingNodesSet == null ? 0 : nodeSet.possibleMatchingNodesSet.elementSize;
                    System.out.println(", possible=" + size);
                }
                break block38;
            }
            this.unitScope = null;
        }
        if (nodeSet.matchingNodes.elementSize == 0) {
            return;
        }
        this.methodHandles = new HashSet();
        boolean bl = matchedUnitContainer = (this.matchContainer & 1) != 0;
        if (unit.javadoc != null && (nodes = nodeSet.matchingNodes(unit.javadoc.sourceStart, unit.javadoc.sourceEnd)) != null) {
            if (!matchedUnitContainer) {
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else {
                IJavaScriptElement element = null;
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level2 = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (this.encloses(element)) {
                        this.patternLocator.matchReportReference(node, element, null, level2, this);
                    }
                    ++i;
                }
            }
        }
        if (matchedUnitContainer && (imports = unit.imports) != null) {
            int i = 0;
            int l = imports.length;
            while (i < l) {
                importRef = imports[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(importRef);
                if (level != null) {
                    this.patternLocator.matchReportImportRef(importRef, null, this.createImportHandle(importRef), level, this);
                }
                ++i;
            }
        }
        if ((types = unit.types) != null) {
            int i = 0;
            int l = types.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration type = types[i];
                level = (Integer)nodeSet.matchingNodes.removeKey(type);
                int accuracy = level != null && matchedUnitContainer ? level : -1;
                this.reportMatching(type, null, accuracy, nodeSet, 1);
                ++i;
            }
        }
        if ((statements = unit.statements) != null) {
            Openable enclosingElement = this.currentPossibleMatch.openable;
            if (enclosingElement == null) {
                return;
            }
            boolean typeInHierarchy = true;
            boolean matchedClassContainer = true;
            ReportMatchingVisitor reportMatchingVisitor = new ReportMatchingVisitor(nodeSet, matchedClassContainer, enclosingElement, typeInHierarchy);
            unit.traverse((ASTVisitor)reportMatchingVisitor, unit.scope);
            int i = 0;
            while (i < statements.length) {
                ASTNode[] nodes3;
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                if (!(statements[i] instanceof AbstractMethodDeclaration) && !(statements[i] instanceof LocalDeclaration) && (nodes3 = nodeSet.matchingNodes(statements[i].sourceStart, statements[i].sourceEnd)) != null) {
                    int l;
                    int j;
                    if ((this.matchContainer & 1) != 0 && this.encloses(enclosingElement)) {
                        j = 0;
                        l = nodes3.length;
                        while (j < l) {
                            ASTNode node = nodes3[j];
                            Integer level3 = (Integer)nodeSet.matchingNodes.removeKey(node);
                            int accuracy = level3 != null && matchedClassContainer ? level3 : -1;
                            this.patternLocator.matchReportReference(node, enclosingElement, unit.compilationUnitBinding, unit.scope, accuracy, this);
                            ++j;
                        }
                    }
                    j = 0;
                    l = nodes3.length;
                    while (j < l) {
                        nodeSet.matchingNodes.removeKey(nodes3[j]);
                        ++j;
                    }
                }
                ++i;
            }
        }
        int i = 0;
        while (i < unit.numberInferredTypes) {
            InferredType inferredType = unit.inferredTypes[i];
            IJavaScriptElement enclosingElement = this.currentPossibleMatch.openable;
            if (enclosingElement == null) {
                return;
            }
            boolean typeInHierarchy = true;
            boolean matchedClassContainer = true;
            enclosingElement = ((ITypeRoot)enclosingElement).getType(new String(inferredType.getName()));
            Integer level4 = (Integer)nodeSet.matchingNodes.removeKey(inferredType);
            int accuracy = level4 != null && matchedClassContainer ? level4 : -1;
            this.reportMatching(inferredType, null, accuracy, nodeSet, 1);
            int attributeInx = 0;
            while (attributeInx < inferredType.numberAttributes) {
                InferredAttribute attribute = inferredType.attributes[attributeInx];
                level4 = (Integer)nodeSet.matchingNodes.removeKey(attribute);
                accuracy = level4 != null && matchedClassContainer ? level4 : -1;
                this.reportMatching(attribute, inferredType, enclosingElement, accuracy, typeInHierarchy, nodeSet);
                ++attributeInx;
            }
            ArrayList methods = inferredType.methods;
            if (methods != null) {
                Iterator iterator = methods.iterator();
                while (iterator.hasNext()) {
                    InferredMethod method = (InferredMethod)iterator.next();
                    level4 = (Integer)nodeSet.matchingNodes.removeKey(method);
                    accuracy = level4 != null && matchedClassContainer ? level4 : -1;
                    int value = level4 != null && matchedClassContainer ? level4 : -1;
                    this.reportMatching(null, (AbstractMethodDeclaration)((Object)method.getFunctionDeclaration()), enclosingElement, value, typeInHierarchy, nodeSet);
                }
            }
            ++i;
        }
        this.methodHandles = null;
        this.bindings.removeKey(this.pattern);
        this.patternLocator.mustResolve = locatorMustResolve;
    }

    protected void reportMatching(FieldDeclaration field, FieldDeclaration[] otherFields, TypeDeclaration type, IJavaScriptElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        block25: {
            int fieldEnd;
            ASTNode[] nodes;
            ASTNode[] nodes2;
            IJavaScriptElement enclosingElement = null;
            if (accuracy > -1 && this.encloses(enclosingElement = this.createHandle(field, type, parent))) {
                int offset = field.sourceStart;
                SearchMatch match = this.newDeclarationMatch(enclosingElement, field.binding, accuracy, offset, field.sourceEnd - offset + 1);
                if (field.initialization instanceof AllocationExpression) {
                    this.reportAccurateEnumConstructorReference(match, field, (AllocationExpression)field.initialization);
                } else {
                    this.report(match);
                }
            }
            if ((field.bits & 2) != 0) {
                if (enclosingElement == null) {
                    enclosingElement = this.createHandle(field, type, parent);
                }
                LocalDeclarationVisitor localDeclarationVisitor = new LocalDeclarationVisitor(enclosingElement, field.binding, nodeSet);
                try {
                    field.traverse((ASTVisitor)localDeclarationVisitor, null);
                }
                catch (WrappedCoreException e) {
                    throw e.coreException;
                }
            }
            if (!typeInHierarchy) break block25;
            if (field.endPart1Position != 0 && (nodes2 = nodeSet.matchingNodes(field.declarationSourceStart, field.endPart1Position)) != null) {
                int l;
                if ((this.matchContainer & 8) == 0) {
                    int i = 0;
                    l = nodes2.length;
                    while (i < l) {
                        nodeSet.matchingNodes.removeKey(nodes2[i]);
                        ++i;
                    }
                } else {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(field, type, parent);
                    }
                    if (this.encloses(enclosingElement)) {
                        int i = 0;
                        l = nodes2.length;
                        while (i < l) {
                            ASTNode node = nodes2[i];
                            Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                            IJavaScriptElement[] otherElements = null;
                            if (otherFields != null) {
                                int length = otherFields.length;
                                int size = 0;
                                while (size < length && otherFields[size] != null) {
                                    ++size;
                                }
                                otherElements = new IJavaScriptElement[size];
                                int j = 0;
                                while (j < size) {
                                    otherElements[j] = this.createHandle(otherFields[j], type, parent);
                                    ++j;
                                }
                            }
                            this.patternLocator.matchReportReference(node, enclosingElement, null, otherElements, field.binding, level, this);
                            ++i;
                        }
                    }
                }
            }
            if ((nodes = nodeSet.matchingNodes(field.sourceStart, fieldEnd = field.endPart2Position == 0 ? field.declarationSourceEnd : field.endPart2Position)) != null) {
                int i;
                if ((this.matchContainer & 8) == 0) {
                    i = 0;
                    int l = nodes.length;
                    while (i < l) {
                        nodeSet.matchingNodes.removeKey(nodes[i]);
                        ++i;
                    }
                } else {
                    if (enclosingElement == null) {
                        enclosingElement = this.createHandle(field, type, parent);
                    }
                    if (this.encloses(enclosingElement)) {
                        i = 0;
                        int l = nodes.length;
                        while (i < l) {
                            Block block;
                            ASTNode node = nodes[i];
                            Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                            BlockScope blockScope = null;
                            if (field.getKind() == 2 && (block = ((Initializer)field).block) != null) {
                                blockScope = block.scope;
                            }
                            this.patternLocator.matchReportReference(node, enclosingElement, field.binding, blockScope, level, this);
                            ++i;
                        }
                    }
                }
            }
        }
    }

    protected void reportMatching(InferredAttribute field, InferredType type, IJavaScriptElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        IJavaScriptElement enclosingElement = null;
        if (accuracy > -1 && this.encloses(enclosingElement = this.createHandle(field, type, parent))) {
            int offset = field.sourceStart;
            SearchMatch match = this.newDeclarationMatch(enclosingElement, field.binding, accuracy, offset, field.sourceEnd - offset + 1);
            this.report(match);
        }
    }

    protected void reportMatching(InferredType type, IJavaScriptElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        IJavaScriptElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(new String(type.getName()));
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(new String(type.getName()));
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.isBinary() ? ((IClassFile)((Object)this.currentPossibleMatch.openable)).getType() : member.getType(new String(type.getName()), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        boolean enclosesElement = this.encloses(enclosingElement);
        if (accuracy > -1 && enclosesElement) {
            int offset = type.sourceStart;
            SearchMatch match = this.patternLocator.newDeclarationMatch(type, enclosingElement, type.binding, accuracy, type.sourceEnd - offset + 1, this);
            this.report(match);
        }
    }

    protected void reportMatching(IJavaScriptElement enclosingElement, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        if (enclosingElement == null) {
            return;
        }
        boolean enclosesElement = this.encloses(enclosingElement);
        if (accuracy > -1 && enclosesElement) {
            int elementLength = 0;
            SearchMatch match = this.patternLocator.newDeclarationMatch(null, enclosingElement, null, accuracy, elementLength, this);
            this.report(match);
        }
    }

    protected void reportMatching(LocalDeclaration field, LocalDeclaration[] otherFields, TypeDeclaration type, IJavaScriptElement parent, int accuracy, boolean typeInHierarchy, MatchingNodeSet nodeSet) throws CoreException {
        block4: {
            ASTNode[] nodes;
            IJavaScriptElement enclosingElement;
            block5: {
                enclosingElement = null;
                if (accuracy > -1 && this.encloses(enclosingElement = this.createHandle(field, parent))) {
                    int offset = field.sourceStart;
                    SearchMatch match = this.newDeclarationMatch(enclosingElement, field.binding, accuracy, offset, field.sourceEnd - offset + 1);
                    this.report(match);
                }
                if (!typeInHierarchy || (nodes = nodeSet.matchingNodes(field.sourceStart, field.declarationSourceEnd)) == null) break block4;
                if ((this.matchContainer & 8) != 0) break block5;
                int i = 0;
                int l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
                break block4;
            }
            if (enclosingElement == null) {
                enclosingElement = this.createHandle(field, parent);
            }
            if (!this.encloses(enclosingElement)) break block4;
            int i = 0;
            int l = nodes.length;
            while (i < l) {
                ASTNode node = nodes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                Scope blockScope = null;
                this.patternLocator.matchReportReference(node, enclosingElement, field.binding, blockScope, level, this);
                ++i;
            }
        }
    }

    protected void reportMatching(TypeDeclaration type, IJavaScriptElement parent, int accuracy, MatchingNodeSet nodeSet, int occurrenceCount) throws CoreException {
        TypeDeclaration[] memberTypes;
        AbstractMethodDeclaration[] methods;
        ASTNode[] nodes;
        boolean matchedClassContainer;
        IJavaScriptElement enclosingElement = parent;
        if (enclosingElement == null) {
            enclosingElement = this.createTypeHandle(new String(type.name));
        } else if (enclosingElement instanceof IType) {
            enclosingElement = ((IType)parent).getType(new String(type.name));
        } else if (enclosingElement instanceof IMember) {
            IMember member = (IMember)parent;
            enclosingElement = member.isBinary() ? ((IClassFile)((Object)this.currentPossibleMatch.openable)).getType() : member.getType(new String(type.name), occurrenceCount);
        }
        if (enclosingElement == null) {
            return;
        }
        boolean enclosesElement = this.encloses(enclosingElement);
        if (accuracy > -1 && enclosesElement) {
            int offset = type.sourceStart;
            SearchMatch match = this.patternLocator.newDeclarationMatch(type, enclosingElement, type.binding, accuracy, type.sourceEnd - offset + 1, this);
            this.report(match);
        }
        boolean bl = matchedClassContainer = (this.matchContainer & 2) != 0;
        if (type.javadoc != null && (nodes = nodeSet.matchingNodes(type.declarationSourceStart, type.sourceStart)) != null) {
            int l;
            int i;
            if (!matchedClassContainer) {
                i = 0;
                l = nodes.length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else {
                i = 0;
                l = nodes.length;
                while (i < l) {
                    ASTNode node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    if (enclosesElement) {
                        this.patternLocator.matchReportReference(node, enclosingElement, type.binding, level, this);
                    }
                    ++i;
                }
            }
        }
        if ((type.bits & 0x200) != 0) {
            Integer level;
            TypeReference superType = type.allocation.type;
            if (superType != null && (level = (Integer)nodeSet.matchingNodes.removeKey(superType)) != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superType, enclosingElement, type.binding, level, this);
            }
        } else {
            TypeReference superClass = type.superclass;
            if (superClass != null) {
                this.reportMatchingSuper(superClass, enclosingElement, type.binding, nodeSet, matchedClassContainer);
            }
        }
        boolean typeInHierarchy = type.binding == null || this.typeInHierarchy(type.binding);
        matchedClassContainer = matchedClassContainer && typeInHierarchy;
        FieldDeclaration[] fields = type.fields;
        if (fields != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            FieldDeclaration[] otherFields = null;
            int first = -1;
            int length = fields.length;
            int i = 0;
            while (i < length) {
                boolean last;
                FieldDeclaration field = fields[i];
                boolean bl2 = last = field.endPart2Position == 0 || field.declarationEnd == field.endPart2Position;
                if (!last && first == -1) {
                    first = i;
                }
                if (first >= 0) {
                    if (i > first) {
                        if (otherFields == null) {
                            otherFields = new FieldDeclaration[length - i];
                        }
                        otherFields[i - 1 - first] = field;
                    }
                    if (last) {
                        int j = first;
                        while (j <= i) {
                            Integer level = (Integer)nodeSet.matchingNodes.removeKey(fields[j]);
                            int value = level != null && matchedClassContainer ? level : -1;
                            this.reportMatching(fields[j], otherFields, type, enclosingElement, value, typeInHierarchy, nodeSet);
                            ++j;
                        }
                        first = -1;
                        otherFields = null;
                    }
                } else {
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(field);
                    int value = level != null && matchedClassContainer ? level : -1;
                    this.reportMatching(field, null, type, enclosingElement, value, typeInHierarchy, nodeSet);
                }
                ++i;
            }
        }
        if ((methods = type.methods) != null) {
            if (nodeSet.matchingNodes.elementSize == 0) {
                return;
            }
            int i = 0;
            int l = methods.length;
            while (i < l) {
                AbstractMethodDeclaration method = methods[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(method);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(type, method, enclosingElement, value, typeInHierarchy, nodeSet);
                ++i;
            }
        }
        if ((memberTypes = type.memberTypes) != null) {
            int i = 0;
            int l = memberTypes.length;
            while (i < l) {
                if (nodeSet.matchingNodes.elementSize == 0) {
                    return;
                }
                TypeDeclaration memberType = memberTypes[i];
                Integer level = (Integer)nodeSet.matchingNodes.removeKey(memberType);
                int value = level != null && matchedClassContainer ? level : -1;
                this.reportMatching(memberType, enclosingElement, value, nodeSet, 1);
                ++i;
            }
        }
    }

    protected void reportMatchingSuper(TypeReference superReference, IJavaScriptElement enclosingElement, Binding elementBinding, MatchingNodeSet nodeSet, boolean matchedClassContainer) throws CoreException {
        Object nodes = null;
        if (nodes != null) {
            if ((this.matchContainer & 2) == 0) {
                int i = 0;
                int l = (nodes).length;
                while (i < l) {
                    nodeSet.matchingNodes.removeKey(nodes[i]);
                    ++i;
                }
            } else if (this.encloses(enclosingElement)) {
                int i = 0;
                int l = (nodes).length;
                while (i < l) {
                    void node = nodes[i];
                    Integer level = (Integer)nodeSet.matchingNodes.removeKey(node);
                    this.patternLocator.matchReportReference((ASTNode)node, enclosingElement, elementBinding, level, this);
                    ++i;
                }
            }
        } else {
            Integer level = (Integer)nodeSet.matchingNodes.removeKey(superReference);
            if (level != null && matchedClassContainer) {
                this.patternLocator.matchReportReference(superReference, enclosingElement, elementBinding, level, this);
            }
        }
    }

    protected boolean typeInHierarchy(ReferenceBinding binding) {
        if (this.hierarchyResolver == null) {
            return true;
        }
        if (this.hierarchyResolver.subOrSuperOfFocus(binding)) {
            return true;
        }
        if (this.allSuperTypeNames != null) {
            char[][] compoundName = binding.compoundName;
            int i = 0;
            int length = this.allSuperTypeNames.length;
            while (i < length) {
                if (CharOperation.equals(compoundName, this.allSuperTypeNames[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public CompilationUnitDeclaration doParse(ICompilationUnit unit, AccessRestriction accessRestriction) {
        CompilationResult unitResult = new CompilationResult(unit, 1, 1, this.options.maxProblemsPerUnit);
        Parser parser = this.basicParser();
        CompilationUnitDeclaration parsedUnit = parser.parse(unit, unitResult);
        parser.inferTypes(parsedUnit, this.options);
        return parsedUnit;
    }

    public class LocalDeclarationVisitor
    extends ASTVisitor {
        IJavaScriptElement enclosingElement;
        Binding enclosingElementBinding;
        MatchingNodeSet nodeSet;
        HashtableOfIntValues occurrencesCounts = new HashtableOfIntValues();

        public LocalDeclarationVisitor(IJavaScriptElement enclosingElement, Binding enclosingElementBinding, MatchingNodeSet nodeSet) {
            this.enclosingElement = enclosingElement;
            this.enclosingElementBinding = enclosingElementBinding;
            this.nodeSet = nodeSet;
        }

        public boolean visit(TypeDeclaration typeDeclaration, BlockScope unused) {
            try {
                char[] simpleName = (typeDeclaration.bits & 0x200) != 0 ? CharOperation.NO_CHAR : typeDeclaration.name;
                int occurrenceCount = this.occurrencesCounts.get(simpleName);
                occurrenceCount = occurrenceCount == Integer.MIN_VALUE ? 1 : ++occurrenceCount;
                this.occurrencesCounts.put(simpleName, occurrenceCount);
                if ((typeDeclaration.bits & 0x200) != 0) {
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, -1, this.nodeSet, occurrenceCount);
                } else {
                    Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(typeDeclaration);
                    MatchLocator.this.reportMatching(typeDeclaration, this.enclosingElement, level != null ? level : -1, this.nodeSet, occurrenceCount);
                }
                return false;
            }
            catch (CoreException e) {
                throw new WrappedCoreException(e);
            }
        }
    }

    class ReportMatchingVisitor
    extends ASTVisitor {
        MatchingNodeSet nodeSet;
        boolean matchedClassContainer;
        IJavaScriptElement enclosingElement;
        boolean typeInHierarchy;
        CoreException exception;

        public ReportMatchingVisitor(MatchingNodeSet nodeSet, boolean matchedClassContainer, IJavaScriptElement enclosingElement, boolean typeInHierarchy) {
            this.nodeSet = nodeSet;
            this.matchedClassContainer = matchedClassContainer;
            this.enclosingElement = enclosingElement;
            this.typeInHierarchy = typeInHierarchy;
        }

        public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
            Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(localDeclaration);
            int accuracy = level != null && this.matchedClassContainer ? level : -1;
            try {
                MatchLocator.this.reportMatching(localDeclaration, null, null, this.enclosingElement, accuracy, this.typeInHierarchy, this.nodeSet);
            }
            catch (CoreException e) {
                this.exception = e;
            }
            return false;
        }

        public boolean visit(MethodDeclaration methodDeclaration, Scope parentScope) {
            Integer level = (Integer)this.nodeSet.matchingNodes.removeKey(methodDeclaration);
            int value = level != null && this.matchedClassContainer ? level : -1;
            try {
                MatchLocator.this.reportMatching(null, methodDeclaration, this.enclosingElement, value, this.typeInHierarchy, this.nodeSet);
            }
            catch (CoreException e) {
                this.exception = e;
            }
            return false;
        }
    }

    public static class WorkingCopyDocument
    extends JavaSearchDocument {
        public IJavaScriptUnit workingCopy;

        WorkingCopyDocument(IJavaScriptUnit workingCopy, SearchParticipant participant) {
            super(workingCopy.getPath().toString(), participant);
            this.charContents = ((CompilationUnit)workingCopy).getContents();
            this.workingCopy = workingCopy;
        }

        public String toString() {
            return "WorkingCopyDocument for " + this.getPath();
        }
    }

    public static class WrappedCoreException
    extends RuntimeException {
        private static final long serialVersionUID = 8354329870126121212L;
        public CoreException coreException;

        public WrappedCoreException(CoreException coreException) {
            this.coreException = coreException;
        }
    }
}

