/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.utils;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xsd.ui.internal.common.actions.OpenInNewEditor;
import org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenOnSelectionHelper {
    protected StructuredTextEditor textEditor;
    protected XSDSchema xsdSchema;
    boolean lastResult;

    public OpenOnSelectionHelper(StructuredTextEditor textEditor, XSDSchema xsdSchema) {
        this.textEditor = textEditor;
        this.xsdSchema = xsdSchema;
    }

    public static void openXSDEditor(XSDSchema schema) {
        IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        OpenInNewEditor.openXSDEditor(editorInput, schema, (XSDConcreteComponent)schema);
    }

    public static void openXSDEditor(String schemaLocation) {
        Path schemaPath = new Path(schemaLocation);
        final IFile schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow workbenchWindow = XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
                if (workbenchWindow != null) {
                    try {
                        workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(schemaFile), "org.eclipse.wst.xsd.ui.internal.editor.InternalXSDMultiPageEditor");
                    }
                    catch (PartInitException initEx) {
                        initEx.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    protected boolean revealObject(final XSDConcreteComponent component) {
        if (component.getRootContainer().equals(this.xsdSchema)) {
            Element element = component.getElement();
            if (element instanceof IndexedRegion) {
                IndexedRegion indexNode = (IndexedRegion)element;
                this.textEditor.getTextViewer().setRangeIndication(indexNode.getStartOffset(), indexNode.getEndOffset() - indexNode.getStartOffset(), true);
                return true;
            }
            return false;
        }
        this.lastResult = false;
        if (component.getSchema() != null) {
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)component.getSchema().getSchemaLocation());
            Path schemaPath = new Path(schemaLocation);
            final IFile schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IWorkbenchWindow workbenchWindow = XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
                    if (workbenchWindow != null) {
                        try {
                            IEditorPart editorPart = workbenchWindow.getActivePage().openEditor((IEditorInput)new FileEditorInput(schemaFile), "org.eclipse.wst.xsd.ui");
                            if (editorPart instanceof InternalXSDMultiPageEditor) {
                                ((InternalXSDMultiPageEditor)editorPart).openOnGlobalReference(component);
                                OpenOnSelectionHelper.this.lastResult = true;
                            }
                        }
                        catch (PartInitException partInitException) {}
                    }
                }
            });
        }
        return this.lastResult;
    }

    public XSDNamedComponent openOnGlobalReference(XSDConcreteComponent comp) {
        XSDTypeDefinition type;
        XSDSchema schema = this.xsdSchema;
        String name = null;
        if (comp instanceof XSDNamedComponent) {
            name = ((XSDNamedComponent)comp).getName();
        }
        if (name == null && comp instanceof XSDTypeDefinition && (comp = (type = (XSDTypeDefinition)comp).getContainer()) instanceof XSDNamedComponent) {
            name = ((XSDNamedComponent)comp).getName();
        }
        if (schema == null || name == null) {
            return null;
        }
        EList objects = null;
        if (comp instanceof XSDElementDeclaration) {
            objects = schema.getElementDeclarations();
        } else if (comp instanceof XSDTypeDefinition) {
            objects = schema.getTypeDefinitions();
        } else if (comp instanceof XSDAttributeGroupDefinition) {
            objects = schema.getAttributeGroupDefinitions();
        } else if (comp instanceof XSDIdentityConstraintDefinition) {
            objects = schema.getIdentityConstraintDefinitions();
        } else if (comp instanceof XSDModelGroupDefinition) {
            objects = schema.getModelGroupDefinitions();
        } else if (comp instanceof XSDAttributeDeclaration) {
            objects = schema.getAttributeDeclarations();
        }
        if (objects != null) {
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                XSDNamedComponent namedComp = (XSDNamedComponent)iter.next();
                if (!namedComp.getName().equals(name)) continue;
                this.revealObject((XSDConcreteComponent)namedComp);
                return namedComp;
            }
        }
        return null;
    }

    public boolean openOnSelection() {
        List selectedNodes = null;
        ISelection selection = this.textEditor.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection) {
            selectedNodes = ((IStructuredSelection)selection).toList();
        }
        if (selectedNodes != null && !selectedNodes.isEmpty()) {
            Iterator i = selectedNodes.iterator();
            while (i.hasNext()) {
                XSDSimpleTypeDefinition typeDef;
                XSDElementDeclaration elementDecl;
                Object obj = i.next();
                if (this.xsdSchema == null) continue;
                XSDConcreteComponent xsdComp = this.xsdSchema.getCorrespondingComponent((Node)obj);
                XSDElementDeclaration objectToReveal = null;
                if (xsdComp instanceof XSDElementDeclaration) {
                    elementDecl = (XSDElementDeclaration)xsdComp;
                    if (elementDecl.isElementDeclarationReference()) {
                        objectToReveal = elementDecl.getResolvedElementDeclaration();
                    } else {
                        XSDTypeDefinition typeDef2 = null;
                        if (elementDecl.getAnonymousTypeDefinition() == null) {
                            typeDef2 = elementDecl.getTypeDefinition();
                        }
                        XSDElementDeclaration subGroupAffiliation = elementDecl.getSubstitutionGroupAffiliation();
                        if (typeDef2 != null && subGroupAffiliation != null) {
                            if (obj instanceof Attr && ((Attr)obj).getLocalName().equals("substitutionGroup")) {
                                objectToReveal = subGroupAffiliation;
                            } else {
                                if (this.revealObject((XSDConcreteComponent)typeDef2)) {
                                    return true;
                                }
                                objectToReveal = subGroupAffiliation;
                            }
                        } else {
                            objectToReveal = typeDef2 != null ? typeDef2 : subGroupAffiliation;
                        }
                    }
                } else if (xsdComp instanceof XSDModelGroupDefinition) {
                    elementDecl = (XSDModelGroupDefinition)xsdComp;
                    if (elementDecl.isModelGroupDefinitionReference()) {
                        objectToReveal = elementDecl.getResolvedModelGroupDefinition();
                    }
                } else if (xsdComp instanceof XSDAttributeDeclaration) {
                    XSDAttributeDeclaration attrDecl = (XSDAttributeDeclaration)xsdComp;
                    if (attrDecl.isAttributeDeclarationReference()) {
                        objectToReveal = attrDecl.getResolvedAttributeDeclaration();
                    } else if (attrDecl.getAnonymousTypeDefinition() == null) {
                        objectToReveal = attrDecl.getTypeDefinition();
                    }
                } else if (xsdComp instanceof XSDAttributeGroupDefinition) {
                    XSDAttributeGroupDefinition attrGroupDef = (XSDAttributeGroupDefinition)xsdComp;
                    if (attrGroupDef.isAttributeGroupDefinitionReference()) {
                        objectToReveal = attrGroupDef.getResolvedAttributeGroupDefinition();
                    }
                } else if (xsdComp instanceof XSDIdentityConstraintDefinition) {
                    XSDIdentityConstraintDefinition idConstraintDef = (XSDIdentityConstraintDefinition)xsdComp;
                    if (idConstraintDef.getReferencedKey() != null) {
                        objectToReveal = idConstraintDef.getReferencedKey();
                    }
                } else if (xsdComp instanceof XSDSimpleTypeDefinition) {
                    EList memberTypes;
                    typeDef = (XSDSimpleTypeDefinition)xsdComp;
                    objectToReveal = typeDef.getItemTypeDefinition();
                    if (objectToReveal == null && (memberTypes = typeDef.getMemberTypeDefinitions()) != null && memberTypes.size() > 0) {
                        objectToReveal = (XSDConcreteComponent)memberTypes.get(0);
                    }
                } else if (xsdComp instanceof XSDTypeDefinition) {
                    typeDef = (XSDTypeDefinition)xsdComp;
                    objectToReveal = typeDef.getBaseType();
                } else if (xsdComp instanceof XSDSchemaDirective) {
                    XSDSchemaDirective directive = (XSDSchemaDirective)xsdComp;
                    objectToReveal = directive.getResolvedSchema();
                }
                if (objectToReveal == null) continue;
                return this.revealObject((XSDConcreteComponent)objectToReveal);
            }
        }
        return false;
    }
}

