/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator._BeanValidatorUELUtils;
import javax.faces.validator._ExternalSpecifications;
import javax.faces.validator._FacesMessageInterpolatorHolder;
import javax.faces.validator._MessageUtils;
import javax.faces.validator._ValueReferenceResolver;
import javax.faces.validator._ValueReferenceWrapper;
import javax.servlet.ServletContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;
import javax.validation.metadata.BeanDescriptor;

public class BeanValidator
implements Validator,
PartialStateHolder {
    private static final Logger log = Logger.getLogger(BeanValidator.class.getName());
    public static final String VALIDATOR_ID = "javax.faces.Bean";
    public static final String MESSAGE_ID = "javax.faces.validator.BeanValidator.MESSAGE";
    public static final String DISABLE_DEFAULT_BEAN_VALIDATOR_PARAM_NAME = "javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR";
    public static final String VALIDATOR_FACTORY_KEY = "javax.faces.validator.beanValidator.ValidatorFactory";
    public static final String VALIDATION_GROUPS_DELIMITER = ",";
    public static final String EMPTY_VALIDATION_GROUPS_PATTERN = "^[\\W,]*$";
    private String validationGroups;
    private Class<?>[] validationGroupsArray;
    private boolean isTransient = false;
    private boolean _initialStateMarked = false;

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            log.warning("cannot validate component with empty value: " + component.getClientId(context));
            return;
        }
        _ValueReferenceWrapper reference = this.getValueReference(valueExpression, context);
        if (reference == null) {
            return;
        }
        Object base = reference.getBase();
        if (base == null) {
            return;
        }
        Class<?> valueBaseClass = base.getClass();
        if (valueBaseClass == null) {
            return;
        }
        Object referenceProperty = reference.getProperty();
        if (!(referenceProperty instanceof String)) {
            return;
        }
        String valueProperty = (String)referenceProperty;
        ValidatorFactory validatorFactory = this.createValidatorFactory(context);
        javax.validation.Validator validator = this.createValidator(validatorFactory);
        BeanDescriptor beanDescriptor = validator.getConstraintsForClass(valueBaseClass);
        if (!beanDescriptor.isBeanConstrained()) {
            return;
        }
        Class[] validationGroupsArray = this.validationGroupsArray;
        Set constraintViolations = validator.validateValue(valueBaseClass, valueProperty, value, validationGroupsArray);
        if (!constraintViolations.isEmpty()) {
            LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(constraintViolations.size());
            for (Object violation : constraintViolations) {
                ConstraintViolation constraintViolation = (ConstraintViolation)violation;
                String message = constraintViolation.getMessage();
                Object[] args = new Object[]{message, _MessageUtils.getLabel(context, component)};
                FacesMessage msg = _MessageUtils.getErrorMessage(context, MESSAGE_ID, args);
                messages.add(msg);
            }
            throw new ValidatorException(messages);
        }
    }

    private javax.validation.Validator createValidator(ValidatorFactory validatorFactory) {
        if (this.validationGroupsArray == null) {
            this.postSetValidationGroups();
        }
        return validatorFactory.usingContext().messageInterpolator(_FacesMessageInterpolatorHolder.get(validatorFactory)).getValidator();
    }

    private _ValueReferenceWrapper getValueReference(ValueExpression valueExpression, FacesContext context) {
        ELContext elCtx = context.getELContext();
        if (_ExternalSpecifications.isUnifiedELAvailable()) {
            return _BeanValidatorUELUtils.getUELValueReferenceWrapper(valueExpression, elCtx);
        }
        return _ValueReferenceResolver.resolve(valueExpression, elCtx);
    }

    private synchronized ValidatorFactory createValidatorFactory(FacesContext context) {
        Object ctx = context.getExternalContext().getContext();
        if (ctx instanceof ServletContext) {
            ServletContext servletCtx = (ServletContext)ctx;
            Object attr = servletCtx.getAttribute(VALIDATOR_FACTORY_KEY);
            if (attr != null) {
                return (ValidatorFactory)attr;
            }
            if (_ExternalSpecifications.isBeanValidationAvailable()) {
                ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
                servletCtx.setAttribute(VALIDATOR_FACTORY_KEY, attr);
                return factory;
            }
            throw new FacesException("Bean Validation is not present");
        }
        throw new FacesException("Only Servlet environments are supported for Bean Validation");
    }

    private void postSetValidationGroups() {
        if (this.validationGroups == null || this.validationGroups.matches(EMPTY_VALIDATION_GROUPS_PATTERN)) {
            this.validationGroupsArray = new Class[]{Default.class};
        } else {
            String[] classes = this.validationGroups.split(VALIDATION_GROUPS_DELIMITER);
            ArrayList validationGroupsList = new ArrayList(classes.length);
            for (String clazz : classes) {
                if ((clazz = clazz.trim()).equals("")) continue;
                Class<?> theClass = null;
                ClassLoader cl = null;
                if (System.getSecurityManager() != null) {
                    try {
                        cl = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassLoader>(){

                            @Override
                            public ClassLoader run() throws PrivilegedActionException {
                                return Thread.currentThread().getContextClassLoader();
                            }
                        });
                    }
                    catch (PrivilegedActionException pae) {
                        throw new FacesException(pae);
                    }
                } else {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                try {
                    theClass = Class.forName(clazz, false, cl);
                }
                catch (ClassNotFoundException ignore) {
                    try {
                        theClass = Class.forName(clazz, false, BeanValidator.class.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Could not load validation group", e);
                    }
                }
                validationGroupsList.add(theClass);
            }
            this.validationGroupsArray = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        }
    }

    public Object saveState(FacesContext context) {
        return this.validationGroups;
    }

    public void restoreState(FacesContext context, Object state) {
        this.validationGroups = (String)state;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    public void setValidationGroups(String validationGroups) {
        this.validationGroups = validationGroups;
    }

    private Boolean isDisabled() {
        return null;
    }

    private String getFor() {
        return null;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

