/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.commons.discovery.ResourceNameIterator;
import org.apache.commons.discovery.resource.ClassLoaders;
import org.apache.commons.discovery.resource.names.DiscoverServiceNames;
import org.apache.myfaces.shared_impl.util.ClassUtils;
import org.apache.myfaces.spi.FaceletConfigResourceProvider;
import org.apache.myfaces.spi.FaceletConfigResourceProviderFactory;
import org.apache.myfaces.view.facelets.compiler.DefaultFaceletConfigResourceProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFaceletConfigResourceProviderFactory
extends FaceletConfigResourceProviderFactory {
    private static Logger log = Logger.getLogger(DefaultFaceletConfigResourceProviderFactory.class.getName());
    public static final String ANNOTATION_PROVIDER = FaceletConfigResourceProvider.class.getName();

    @Override
    public FaceletConfigResourceProvider createFaceletConfigResourceProvider(ExternalContext externalContext) {
        FaceletConfigResourceProvider returnValue = null;
        final ExternalContext extContext = externalContext;
        try {
            returnValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<FaceletConfigResourceProvider>(){

                @Override
                public FaceletConfigResourceProvider run() throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
                    return DefaultFaceletConfigResourceProviderFactory.this.resolveFaceletConfigResourceProviderFromService(extContext);
                }
            }) : this.resolveFaceletConfigResourceProviderFromService(extContext);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
        }
        catch (InstantiationException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException((Throwable)e);
        }
        return returnValue;
    }

    private FaceletConfigResourceProvider resolveFaceletConfigResourceProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        ClassLoaders loaders = new ClassLoaders();
        loaders.put(classLoader);
        DiscoverServiceNames dsn = new DiscoverServiceNames(loaders);
        ResourceNameIterator iter = dsn.findResourceNames(ANNOTATION_PROVIDER);
        return this.getApplicationObject(FaceletConfigResourceProvider.class, iter, new DefaultFaceletConfigResourceProvider());
    }

    private <T> T getApplicationObject(Class<T> interfaceClass, ResourceNameIterator classNamesIterator, T defaultObject) {
        return this.getApplicationObject(interfaceClass, null, null, classNamesIterator, defaultObject);
    }

    private <T> T getApplicationObject(Class<T> interfaceClass, Class<? extends T> extendedInterfaceClass, Class<? extends T> extendedInterfaceWrapperClass, ResourceNameIterator classNamesIterator, T defaultObject) {
        Object current = defaultObject;
        while (classNamesIterator.hasNext()) {
            String implClassName = classNamesIterator.nextResourceName();
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            Object newCurrent = null;
            try {
                Constructor delegationConstructor = null;
                if (extendedInterfaceClass != null && extendedInterfaceClass.isAssignableFrom(current.getClass())) {
                    try {
                        delegationConstructor = implClass.getConstructor(extendedInterfaceClass);
                    }
                    catch (NoSuchMethodException mnfe) {
                        // empty catch block
                    }
                }
                if (delegationConstructor == null) {
                    delegationConstructor = implClass.getConstructor(interfaceClass);
                }
                try {
                    newCurrent = delegationConstructor.newInstance(current);
                }
                catch (InstantiationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                newCurrent = ClassUtils.newInstance(implClass);
            }
            if (extendedInterfaceWrapperClass != null && !extendedInterfaceClass.isAssignableFrom(newCurrent.getClass())) {
                try {
                    Constructor<T> wrapperConstructor = extendedInterfaceWrapperClass.getConstructor(interfaceClass, extendedInterfaceClass);
                    newCurrent = wrapperConstructor.newInstance(newCurrent, current);
                }
                catch (NoSuchMethodException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (InstantiationException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException((Throwable)e);
                }
            }
            current = newCurrent;
        }
        return (T)current;
    }
}

