/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.el;

import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.Location;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompositeComponentELUtils {
    public static final String COMPONENT_STACK = "componentStack:" + UIComponent.class.getName();
    public static final String CURRENT_COMPOSITE_COMPONENT_KEY = "org.apache.myfaces.compositecomponent.current";
    public static final String LOCATION_KEY = "org.apache.myfaces.compositecomponent.location";
    public static final Pattern CC_EXPRESSION_REGEX = Pattern.compile(".*[^\\w\\.]cc[^\\w].*");
    public static final Pattern CC_ATTRS_METHOD_EXPRESSION_REGEX = Pattern.compile("[^\\(]*[^\\w\\.\\(]cc\\.attrs\\.[^\\.]*(\\(.*)?");

    private CompositeComponentELUtils() {
    }

    public static UIComponent getCompositeComponentBasedOnLocation(FacesContext facesContext, Location location) {
        LinkedList<UIComponent> componentStack = CompositeComponentELUtils.getComponentStack(facesContext);
        if (componentStack != null && !componentStack.isEmpty()) {
            for (UIComponent component : componentStack) {
                Location componentLocation;
                if (!UIComponent.isCompositeComponent((UIComponent)component) || (componentLocation = (Location)component.getAttributes().get(LOCATION_KEY)) == null || !componentLocation.getPath().equals(location.getPath())) continue;
                return component;
            }
        }
        UIComponent component = UIComponent.getCurrentCompositeComponent((FacesContext)facesContext);
        while (component != null) {
            Location componentLocation = (Location)component.getAttributes().get(LOCATION_KEY);
            if (componentLocation != null && componentLocation.getPath().equals(location.getPath())) {
                return component;
            }
            component = UIComponent.getCompositeComponentParent((UIComponent)component);
        }
        return null;
    }

    public static LinkedList<UIComponent> getComponentStack(FacesContext facesContext) {
        return (LinkedList)facesContext.getAttributes().get(COMPONENT_STACK);
    }

    public static void saveCompositeComponentForResolver(FacesContext facesContext, Location location) {
        UIComponent cc = CompositeComponentELUtils.getCompositeComponentBasedOnLocation(facesContext, location);
        facesContext.getAttributes().put(CURRENT_COMPOSITE_COMPONENT_KEY, cc);
    }

    public static void removeCompositeComponentForResolver(FacesContext facesContext) {
        facesContext.getAttributes().remove(CURRENT_COMPOSITE_COMPONENT_KEY);
    }

    public static boolean isCompositeComponentExpression(String expression) {
        return CC_EXPRESSION_REGEX.matcher(expression).matches();
    }

    public static boolean isCompositeComponentAttrsMethodExpression(String expression) {
        return CC_ATTRS_METHOD_EXPRESSION_REGEX.matcher(expression).matches();
    }
}

