/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.view.Location;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;
import org.apache.myfaces.util.ExternalSpecifications;
import org.apache.myfaces.view.facelets.el.CompositeComponentELUtils;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.el.LocationMethodExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpression;
import org.apache.myfaces.view.facelets.el.LocationValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.TagMethodExpression;
import org.apache.myfaces.view.facelets.el.TagValueExpression;
import org.apache.myfaces.view.facelets.el.TagValueExpressionUEL;
import org.apache.myfaces.view.facelets.el.ValueExpressionMethodExpression;

public final class TagAttributeImpl
extends TagAttribute {
    private final boolean literal;
    private final String localName;
    private final Location location;
    private final String namespace;
    private final String qName;
    private final String value;
    private String string;

    public TagAttributeImpl(Location location, String ns, String localName, String qName, String value) {
        this.location = location;
        this.namespace = ns;
        this.localName = localName;
        this.qName = qName;
        this.value = value;
        try {
            this.literal = ELText.isLiteral(this.value);
        }
        catch (ELException e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public boolean getBoolean(FaceletContext ctx) {
        if (this.literal) {
            return Boolean.valueOf(this.value);
        }
        return (Boolean)this.getObject(ctx, Boolean.class);
    }

    public int getInt(FaceletContext ctx) {
        if (this.literal) {
            return Integer.parseInt(this.value);
        }
        return ((Number)this.getObject(ctx, Integer.class)).intValue();
    }

    public String getLocalName() {
        return this.localName;
    }

    public Location getLocation() {
        return this.location;
    }

    public MethodExpression getMethodExpression(FaceletContext ctx, Class type, Class[] paramTypes) {
        try {
            MethodExpression methodExpression = null;
            if (CompositeComponentELUtils.isCompositeComponentAttrsMethodExpression(this.getValue())) {
                if (ExternalSpecifications.isUnifiedELAvailable() && this.value.contains("(")) {
                    throw new ELException("Cannot add parameters to a MethodExpression pointing to cc.attrs");
                }
                ValueExpression valueExpr = this.getValueExpression(ctx, MethodExpression.class);
                methodExpression = new ValueExpressionMethodExpression(valueExpr);
            } else {
                ExpressionFactory f = ctx.getExpressionFactory();
                methodExpression = f.createMethodExpression((ELContext)ctx, this.value, type, paramTypes);
                if (CompositeComponentELUtils.isCompositeComponentExpression(this.value)) {
                    methodExpression = new LocationMethodExpression(this.getLocation(), methodExpression);
                }
            }
            return new TagMethodExpression(this, methodExpression);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Object getObject(FaceletContext ctx) {
        return this.getObject(ctx, Object.class);
    }

    public String getQName() {
        return this.qName;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(FaceletContext ctx) {
        if (this.literal) {
            return this.value;
        }
        return (String)this.getObject(ctx, String.class);
    }

    public Object getObject(FaceletContext ctx, Class type) {
        if (this.literal) {
            if (String.class.equals((Object)type)) {
                return this.value;
            }
            try {
                return ctx.getExpressionFactory().coerceToType((Object)this.value, type);
            }
            catch (Exception e) {
                throw new TagAttributeException((TagAttribute)this, (Throwable)e);
            }
        }
        ValueExpression ve = this.getValueExpression(ctx, type);
        try {
            return ve.getValue((ELContext)ctx);
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public ValueExpression getValueExpression(FaceletContext ctx, Class type) {
        try {
            ExpressionFactory f = ctx.getExpressionFactory();
            ValueExpression valueExpression = f.createValueExpression((ELContext)ctx, this.value, type);
            valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? new TagValueExpressionUEL(this, valueExpression) : new TagValueExpression(this, valueExpression);
            if (CompositeComponentELUtils.isCompositeComponentExpression(this.value)) {
                valueExpression = ExternalSpecifications.isUnifiedELAvailable() ? new LocationValueExpressionUEL(this.getLocation(), valueExpression) : new LocationValueExpression(this.getLocation(), valueExpression);
            }
            return valueExpression;
        }
        catch (Exception e) {
            throw new TagAttributeException((TagAttribute)this, (Throwable)e);
        }
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public String toString() {
        if (this.string == null) {
            this.string = this.location + " " + this.qName + "=\"" + this.value + "\"";
        }
        return this.string;
    }
}

