/*
 * Decompiled with CFR 0.152.
 */
package oracle.streams;

import oracle.sql.NUMBER;
import oracle.streams.StreamsException;

public class XStreamUtility {
    public static final int POS_VERSION = 1;
    public static final int MAX_POS_LENGTH = 64;

    public static NUMBER getSCNFromPosition(byte[] byArray) throws StreamsException {
        int n = 14;
        if (byArray.length != 29 || byArray[28] != 1) {
            throw new StreamsException("XStream getSCNFromPostion: invalid position\n");
        }
        long l = ((byArray[n] & 0xFF) << 40) + ((byArray[n + 1] & 0xFF) << 32) + ((byArray[n + 2] & 0xFF) << 24) + ((byArray[n + 3] & 0xFF) << 16) + ((byArray[n + 4] & 0xFF) << 8) + (byArray[n + 5] & 0xFF);
        return new NUMBER(l);
    }

    public static NUMBER getCommitSCNFromPosition(byte[] byArray) throws StreamsException {
        if (byArray.length != 29 || byArray[28] != 1) {
            throw new StreamsException("XStream getCommitSCNFromPostion: invalid position\n");
        }
        long l = ((byArray[0] & 0xFF) << 40) + ((byArray[1] & 0xFF) << 32) + ((byArray[2] & 0xFF) << 24) + ((byArray[3] & 0xFF) << 16) + ((byArray[4] & 0xFF) << 8) + (byArray[5] & 0xFF);
        return new NUMBER(l);
    }

    public static byte[] convertSCNToPosition(NUMBER nUMBER) throws StreamsException {
        long l;
        byte[] byArray = new byte[29];
        int n = 14;
        try {
            l = nUMBER.longValue();
        }
        catch (Exception exception) {
            throw new StreamsException("XStream convertSCNToPosition: invalid input scn \n", exception);
        }
        byArray[0] = (byte)(l >> 40 & 0xFFL);
        byArray[1] = (byte)(l >> 32 & 0xFFL);
        byArray[2] = (byte)(l >> 24 & 0xFFL);
        byArray[3] = (byte)(l >> 16 & 0xFFL);
        byArray[4] = (byte)(l >> 8 & 0xFFL);
        byArray[5] = (byte)(l >> 0 & 0xFFL);
        byArray[n] = (byte)(l >> 40 & 0xFFL);
        byArray[n + 1] = (byte)(l >> 32 & 0xFFL);
        byArray[n + 2] = (byte)(l >> 24 & 0xFFL);
        byArray[n + 3] = (byte)(l >> 16 & 0xFFL);
        byArray[n + 4] = (byte)(l >> 8 & 0xFFL);
        byArray[n + 5] = (byte)(l >> 0 & 0xFFL);
        byArray[28] = 1;
        return byArray;
    }
}

