package net.kapsch.oss.common.ibs;

import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;

public final class DBTag implements BodyTag {

	private PageContext pc = null;
	private BodyContent body = null;
	private StringBuffer sb = new StringBuffer();
	private Connection con = null;
	private Statement stmt = null;
	private ResultSet rs = null;
    private int start_access_count = 0;
    private int setvar_access_count = 0;
	public void setPageContext(PageContext p) {
		pc = p;
	}

	public void setParent(Tag t) {}

	public Tag getParent() { return null; }

	public int doStartTag() throws JspException {
	    start_access_count++;
	    setvar_access_count = 0;
	    sb.setLength(0);
	    String driverClass = "org.gjt.mm.mysql.Driver";
		String path = "jdbc:mysql:///pet";
		String sql = "SELECT item_id, item_type, item_name, int_value, str_value FROM items";
		try {

		Class.forName(driverClass);
		con = DriverManager.getConnection(path);

		stmt = con.createStatement();
		rs = stmt.executeQuery(sql);

		setVariables();

		} catch (SQLException e) {
		throw new JspTagException("An SQLException occurred!");
		} catch (ClassNotFoundException e) {
		throw new JspTagException("JDBC Driver "+driverClass+" not found.");
		}
		return EVAL_BODY_BUFFERED;
	}

	public void setBodyContent(BodyContent b) {
		body = b;
	}

	public void doInitBody() throws JspException {}
	
	private boolean setVariables() throws JspTagException {
	    setvar_access_count++;
	try {
		if (rs.next()) {

		pc.setAttribute("item_id", rs.getObject(1).toString());
		pc.setAttribute("item_type", rs.getObject(2).toString());
		pc.setAttribute("item_name", rs.getObject(3).toString());
		pc.setAttribute("int_value",rs.getObject(4).toString());
		pc.setAttribute("string_value",rs.getObject(5).toString());
			return true;

		} else {
			return false;
		}

	} catch (SQLException e) {
		throw new JspTagException("SQLException occurred!");
	}
	}

	public int doAfterBody() throws JspException {
		try {
			sb.append(body.getString());
			body.clear();
		} catch (IOException e) {
			throw new JspTagException("Fatal IOException!");
		}
		
		if(setVariables()) {
			return EVAL_BODY_BUFFERED;
		}

		try {
			body.getEnclosingWriter().write(sb.toString());
		} catch (IOException e) {
			throw new JspTagException("Fatal IOException!");
		}
		return SKIP_BODY;
	}

	public int doEndTag() throws JspException {
		try {
			if(rs != null) {
				rs.close();
				rs = null;
			}
			if(stmt != null) {
				stmt.close();
				stmt = null;
			}
			if(con != null) {
				con.close();
				con = null;
			}
		} catch (SQLException e) {}
		
		return EVAL_PAGE;
	}

	public void release() {
		pc = null;
		body = null;
		sb = null;
	}
}
