package net.kapsch.oss.common.ibs;

import net.kapsch.oss.common.ibs.ItemBase;
import net.kapsch.oss.common.ibs.Items;
import java.sql.*;
import java.util.*;

public class Item {
    private ItemBase ib = null;
    private int id = 0;
    private String type;
    private String name;
    private int parent_id;
    private int int_value;
    private String str_value;
    private byte blob_value[];
    private int first_child;
    private int next_silbling;
    private boolean has_changed;
    private boolean deleted = false;

    protected Item(ItemBase the_base) {
	ib = the_base;
	has_changed = true;
	deleted = false;
    }

    protected Item(ItemBase theBase, int theID) throws IBSException {
	this(theBase);
	this.readFromDatabase(theID);
    }

    protected void setID(int theID) {
	id = theID;
	has_changed = true;
    }

    public void setType(String theType) {
	type = theType;
	has_changed = true;
    }

    public void setName(String theName) {
	name = theName;
	has_changed = true;
    }

    protected void setParentID(int theParentID) {
	parent_id = theParentID;
	has_changed = true;
    }

    public void setIntValue(int theIntValue) {
	int_value = theIntValue;
	has_changed = true;
    }

    public void setStrValue(String theStrValue) {
	str_value = theStrValue;
	has_changed = true;
    }

    public void setBlobValue(byte theBlobValue[]) {
	blob_value = theBlobValue;
	has_changed = true;
    }

    protected void setFirstChild(int theFirstChild) {
	first_child = theFirstChild;
	has_changed = true;
    }

    protected void setNextSilbling(int theNextSilbling) {
	next_silbling = theNextSilbling;
	has_changed = true;
    }

    public int getID() {
	return id;
    }

    public String getType() {
	return type;
    }

    public String getName() {
	return name;
    }

    public int getParentID() {
	return parent_id;
    }

    public int getIntValue() {
	return int_value;
    }

    public String getStringValue() {
	return str_value;
    }

    public byte[] getBlobValue() {
	return blob_value;
    }

    public int getFirstChild() {
	return first_child;
    }

    public int getNextSilbling() {
	return next_silbling;
    }

    protected void createInDatabase() throws IBSException {
	int rows = 0;
	try {
	PreparedStatement pstmt = ib.con.prepareStatement("INSERT INTO ITEMS VALUES(?,?,?,?,?,?,?,?,?)");
	pstmt.setInt(1,id);
	pstmt.setString(2,type);
	pstmt.setString(3,name);
	pstmt.setInt(4,parent_id);
	pstmt.setInt(5,int_value);
	pstmt.setString(6,str_value);
	pstmt.setBytes(7,blob_value);
	pstmt.setInt(8,first_child);
	pstmt.setInt(9,next_silbling);
	rows = pstmt.executeUpdate();
	has_changed = false;
	}
	catch (Exception e) { throw new IBSException(e); }
    }

    protected boolean readFromDatabase(int theID) throws IBSException {
        String sql = "SELECT item_id,item_type,item_name,parent_id,int_value,str_value,blob_value,first_child_id,next_silbling_id from ITEMS WHERE item_id=?";
	try {
	PreparedStatement pstmt = ib.con.prepareStatement(sql);
	pstmt.setInt(1,theID);
	ResultSet rs = pstmt.executeQuery();
	rs.first();
	id = rs.getInt(1);
        type = rs.getString(2);
	name = rs.getString(3);
	parent_id = rs.getInt(4);
	int_value = rs.getInt(5);
	str_value = rs.getString(6);
	blob_value = rs.getBytes(7);
	first_child = rs.getInt(8);
	next_silbling = rs.getInt(9);
	has_changed = false;
	deleted = false;
	}
	catch (Exception e) { throw new IBSException("Error in reading item "+theID+" from Database",e); }
	return true;
    }

    protected void saveToDatabase() throws IBSException {
	String sql = "UPDATE ITEMS SET item_type=?,item_name=?,parent_id=?,int_value=?,str_value=?,first_child_id=?,next_silbling_id=? WHERE item_id=?";
	int rows = 0;
	try {
	PreparedStatement pstmt = ib.con.prepareStatement(sql);
	pstmt.setString(1,type);
	pstmt.setString(2,name);
	pstmt.setInt(3,parent_id);
	pstmt.setInt(4,int_value);
	pstmt.setString(5,str_value);
	pstmt.setInt(6,first_child);
	pstmt.setInt(7,next_silbling);
	pstmt.setInt(8,id);
	rows = pstmt.executeUpdate();
	if (rows!=1) {
	    throw new IBSException(rows+" rows updated when saving item "+id+" to database",null);
	}
	has_changed = false;
	}
	catch (Exception e) { throw new IBSException("Error saving item "+id+" to database",e); }
    }

    protected Item findPreviousSilbling() throws IBSException {
	Item theSilbling = null;
	String sql = "SELECT item_id FROM items WHERE (next_silbling_id=?)";
	try {
	    PreparedStatement pstmt = ib.con.prepareStatement(sql);
	    pstmt.setInt(1,id);
	    ResultSet rs = pstmt.executeQuery();
	    if (rs.next()) {
		return new Item(ib,rs.getInt(1));
	    }
	    else {
		return null;
	    }
	}
	catch (Exception e) { throw new IBSException("Error finding previous silbling of item with ID "+id,e); }
    }

    public boolean hasSubItems() {
	return (first_child!=0);
    }

    public Item findSubItem(String theSubName) throws IBSException {
	String sql = "SELECT item_id FROM items WHERE (parent_id=? AND item_name=?)";
	try {
	    PreparedStatement pstmt = ib.con.prepareStatement(sql);
	    pstmt.setInt(1,id);
	    pstmt.setString(2,theSubName);
	    ResultSet rs = pstmt.executeQuery();
	    if (rs.next()) {
		int theSubID = rs.getInt(1);
		Item theSubItem = new Item(ib);
		theSubItem.readFromDatabase(theSubID);
		return theSubItem;
	    }
	    else {
		return null;
	    }
	}
	catch (Exception e) { throw new IBSException("Error finding SubItem <"+theSubName+"> for Item id "+id,e); }
    }

    public int getSubItemInt(String theSubName, int theDefaultValue) {
	int theValue = theDefaultValue;
	try {
	    Item theSubItem = this.findSubItem(theSubName);
	    theSubItem.getIntValue();
	}
	catch (Exception e) {}
	return theValue;
    }

    /**
     *
     * returns the String value of the named Sub-Item
     * if the sub-item is not existing, return the default value
     *
     * @param name of the sub-item
     * @param default value to be used if sub-item not found
     *
     */
    public String getSubItemString(String theSubName, String theDefaultValue) {
	String theValue = theDefaultValue;
	try {
	    Item theSubItem = this.findSubItem(theSubName);
	    theSubItem.getStringValue();
	}
	catch (Exception e) {}
	return theValue;
    }

    public Items enumerateSubItems() throws IBSException {
	String sql = "SELECT item_id FROM items WHERE (parent_id=?)";
	try {
	    PreparedStatement pstmt = ib.con.prepareStatement(sql);
	    pstmt.setInt(1,id);
	    ResultSet rs = pstmt.executeQuery();
	    return new Items(rs,ib);
	}
	catch (Exception e) { throw new IBSException("Error enumerating SubItems for Item is "+id,e); }
    }

    /**
     * create a new sub-item for this item
     *
     * @param type-name for new item
     * @param name for new item
     *
     */
    public Item newSubItem(String newType, String newName) throws IBSException {
	int fs = 0;
	Item theNewItem = new Item(this.ib);
	Item theNNItem = new Item(this.ib);
	theNNItem.readFromDatabase(0);   
	int nn = theNNItem.getIntValue();     // get next free item ID
        if (id!=0) {                          // if I'm not the number root ...
	  fs = this.getFirstChild();          // get ID of first of existing childs
	  this.setFirstChild(nn);             // let the new item be the first child
	}
	theNewItem.setID(nn++);               // set the ID
	theNNItem.setIntValue(nn);            // update the next free item ID counter
	theNNItem.saveToDatabase();           // save the next free item counter
	theNewItem.setType(newType);          // set the type of the new item
	theNewItem.setName(newName);          // set the name of the new item
	theNewItem.setParentID(this.getID()); // let the current item be the parent of the new item
	theNewItem.setNextSilbling(fs);       // let the existing others be silblings of this new one
	if (id!=0) {                          // if I'm not the number root ...
	    this.saveToDatabase();            // ... save parent item
	}
	theNewItem.createInDatabase();        // save new item
	return theNewItem;
    }

    /**
     * removes this item permanentely from the database
     *
     */
    public void delete() throws IBSException {
	// System.out.println(">>>> Deleting Item with ID "+this.id);
	if (deleted) {
	    return;
	}
	// remove any subitems
	if (first_child!=0) {
	    Items subItems = enumerateSubItems();
	    while (subItems.hasMoreElements()) {
		((Item)subItems.nextElement()).delete();
	    }
	}
	// unlink from silblings and parent
	if (parent_id!=0) {
	    Item theParent = new Item(ib,parent_id);
	    if (theParent.getFirstChild()==id) {
		theParent.setFirstChild(next_silbling);
		theParent.saveToDatabase();
	    }
	    else {
		Item prevSilbling = this.findPreviousSilbling();
		prevSilbling.setNextSilbling(next_silbling);
		prevSilbling.saveToDatabase();
	    }
	}
	// remove record from database
	String sql = "DELETE FROM items WHERE item_id=?";
	try {
	    PreparedStatement pstmt = ib.con.prepareStatement(sql);
	    pstmt.setInt(1,id);
	    int rows = pstmt.executeUpdate();
	    if (rows!=1) {
		throw new IBSException(rows+" deleted when deleting item "+id,null);
	    }
	}
	catch (Exception e) { throw new IBSException("Exception when deleting item "+id+" from database",e); }
	deleted = true;
    }

    public Item newSubMacro(String newMacroType, String newName) throws IBSException {
	Item root = new Item(this.ib,0);
	Item templatesRoot = root.findSubItem("MACRO_TEMPLATES");
	if (templatesRoot==null) { throw new IBSException("MACRO_TEMPLATES not found when adding macro "+newMacroType+"/"+newName,null); }
	Item theTemplate = templatesRoot.findSubItem(newMacroType);
	if (theTemplate==null) { throw new IBSException("template for "+newMacroType+" not found when adding macro "+newMacroType+"/"+newName,null); }
	System.out.println(">>>> template for macro "+newMacroType+" is at ID "+theTemplate.getID());
	String theNewType = theTemplate.getSubItemString("TYPE",newMacroType);
	String theNewName = theTemplate.getSubItemString("NAME",newName);
	Item theNewRoot = this.newSubItem(theNewType,theNewName);
	Item subItemsRoot = theTemplate.findSubItem("SUBITEMS");
	if (subItemsRoot!=null) {
	    System.out.println(">>>> sub-items for "+newMacroType+" at item "+subItemsRoot.getID());
	    Items subItems = subItemsRoot.enumerateSubItems();
	    while (subItems.hasMoreElements()) {
		Item theSubTemplate = (Item)subItems.nextElement();
		theNewRoot.newSubMacro(theSubTemplate.getSubItemString("TYPE",theSubTemplate.getType()),
				       theSubTemplate.getSubItemString("NAME",theSubTemplate.getName()));

	    }
	}
	theNewRoot.saveToDatabase();
	return theNewRoot;
    }
}
