package net.kapsch.oss.common.ibs;

import java.sql.*;
import net.kapsch.oss.common.ibs.Item;
import net.kapsch.oss.common.ibs.IBSException;

public class ItemBase {

    protected Connection con = null;
    private String dbUrl = null;
    private String driverClass = "org.gjt.mm.mysql.Driver";
    private Statement stmt;
    private ResultSet rs = null;

    public ItemBase(String jdbcUrl) throws IBSException {
	try {
	    dbUrl = jdbcUrl;
	    Class.forName(driverClass);
	    con = DriverManager.getConnection(dbUrl);
	    stmt = con.createStatement();
	}
	catch (Exception e) { throw new IBSException("Error connecting ItemBase <"+dbUrl+">",e); }
    }

    public Item findItem(int theID) throws IBSException {
	Item theItem = new Item(this);
	theItem.readFromDatabase(theID);
	return theItem;
    }


}
