package net.kapsch.oss.common.ibs;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

import java.io.*;

import net.kapsch.oss.common.ibs.*;

public class ibscmd {

    private static final String IBSCMD_VERSION = "V 0.1";
    private static final String DEFAULT_URL = "jdbc:mysql:///pet";
 
    private static ItemBase myIBS;
    private static Item myItem;
    private static Items myItems;

    private static String theUrl = DEFAULT_URL;


    private static void dumpItem(Item theItem, String thePrefix) {
	System.out.println(thePrefix+"Item(ID="+theItem.getID()+"), named "+theItem.getName()+" has type "+theItem.getType()+" Integer Value is "+theItem.getIntValue());
	String theString = theItem.getStringValue();
	if ((theString!=null) && (theString.length()>0)) {
	    System.out.println(thePrefix+"  String Value is \""+theString+"\"");
	}
    }

    private static void dumpDir(Item theItem, boolean doFull, String thePrefix) throws IBSException {
	System.out.println(thePrefix+"Item Directory at ID "+theItem.getID());
	Items theItems;
	Item actItem;
	try {
	    theItems = theItem.enumerateSubItems();
	}
	catch (Exception e) {
	    throw new IBSException("Exception during enumerating SubItems of ID "+theItem.getID(),e);
	}
	try {
	    while (theItems.hasMoreElements()) {
		actItem = (Item)(theItems.nextElement());
		dumpItem(actItem,thePrefix+"  ");
		if (doFull) {
		    if (actItem.hasSubItems()) {
			dumpDir(actItem,doFull,thePrefix+"    ");
		    }
		}
	    }
	}
	catch (Exception e) {
	    throw new IBSException("Exception during dumping SubItems of ID "+theItem.getID(),e);
	}
    }

    private static void printUsage(Options opt) {
	System.out.println("Usage: ibscmd [-f cmdfile] [-v] [-d database-url]");
    }

    private static Options createOptions()
    {
      Options options = new Options();
      OptionGroup group = new OptionGroup();

      // help, verbose, text only console and file options (mutually exclusive
      // options)
      group.addOption(new Option("h", "help", false,
          "Displays usage information."));
      group.addOption(new Option("v", "version", false,
          "Displays version information."));
      group.addOption(new Option(
              "f",
              "file",
              true,
              "Use a given file as the source of commands instead of reading commands interactively."));
      options.addOptionGroup(group);
      // database URL option
      String defaultURL = DEFAULT_URL;
      options
          .addOption(new Option(
              "d",
              "database",
              true,
              "Database URL to connect to (the default is '"
                  + defaultURL + "')."));

      return options;
    }   

    private static void doCommands() {
	String cmdline = "";
	String prompt = theUrl;
	boolean running = true;
	String cmdargs[] = null;
	CommandLineParser parser = new GnuParser();
	CommandLine commandline = null;
	BufferedReader cr = new BufferedReader(new InputStreamReader(System.in));
	while (running) {
	    System.out.print(prompt+"> ");
	    try {
		cmdline = cr.readLine();
	    }
	    catch (IOException e) { 
		running = false;
		continue;
	    }
	    cmdargs = cmdline.split("\\s");
	    if (cmdargs.length>0) {
		try {
		if (cmdargs[0].startsWith("quit")) {
		    running = false;
		    continue;
		}
		if (cmdargs[0].startsWith("cd")) {
		    int newID = 0;
		    Item newItem = null;
		    if (cmdargs.length>1) {
			if (cmdargs[1].startsWith("..")) {
			    newID = myItem.getParentID();
			}
			else if (cmdargs[1].startsWith(".")) {
			    newID = myItem.getID();
			}
			else if (Character.isDigit(cmdargs[1].charAt(0))) {
			    newID = Integer.parseInt(cmdargs[1]);
			}
			else {
			    newItem = myItem.findSubItem(cmdargs[1]);
			    if (newItem!=null) {
				newID = newItem.getID();
			    }
			    else {
				System.out.println("Usage: cd .|..|<id>|<nothing>");
				System.out.println("  cd "+cmdargs[1]+" is not supported");
				newID = myItem.getID();
			    }
			}
		    }
		    myItem.readFromDatabase(newID);
		    dumpItem(myItem,"");
		}
		if (cmdargs[0].startsWith("del")) {
		    myItem.delete();
		}
		if (cmdargs[0].startsWith("dir")) {
		    boolean doFull = false;
		    int theDirID = myItem.getID();
		    Item theDirItem = null;
		    if (cmdargs.length>1) {
			int i;
			for (i=1;i<cmdargs.length;i++) {
			    if (cmdargs[i].startsWith("-R")) { doFull = true; }
			    else if (Character.isDigit(cmdargs[i].charAt(0))) {
				theDirID = Integer.parseInt(cmdargs[i]);
			    }
			    else {
				theDirItem = myItem.findSubItem(cmdargs[i]);
				if (theDirItem!=null) {
				    theDirID=theDirItem.getID();
				}
			    }
			}
		    }
		    if (theDirItem==null) {
			myItem.readFromDatabase(theDirID);
			theDirItem = myItem;
		    }
		    dumpDir(theDirItem,doFull,"");
		}
		if (cmdargs[0].startsWith("new")) {
		    if (cmdargs.length>1) {
			if (cmdargs[1].startsWith("item")) {
			    String newType = "";
			    String newName = "";
			    if (cmdargs.length>2) {
				newType = cmdargs[2];
				if (cmdargs.length>3) {
				    newName = cmdargs[3];
				}
			    }
			    Item newItem = myItem.newSubItem(newType, newName);
			    System.out.println("new Sub-Item of type \""+newType+"\" with name \""+newName+"\" ID "+newItem.getID()+" added.");
			}
			else if (cmdargs[1].startsWith("macro")) {
			    String newType = "";
			    String newName = "";
			    if (cmdargs.length>2) {
				newType = cmdargs[2];
				if (cmdargs.length>3) {
				    newName = cmdargs[3];
				}
			    }
			    Item newMacro = myItem.newSubMacro(newType,newName);
			    System.out.println("new Sub-Macro of type \""+newType+"\" with name \""+newName+"\" ID "+newMacro.getID()+" added.");
			}
			else {
			    System.out.println("Adding New "+cmdargs[1]+" currently not supported");
			}
		    }
		    else {
			System.out.println("what new ?");
		    }
		}
		if (cmdargs[0].startsWith("set")) {
		    if (cmdargs.length!=3) {
			System.out.println("Usage: set int|str|name|type <value>");
		    }
		    else {
			if (cmdargs[1].startsWith("int")) {
			    myItem.setIntValue(Integer.parseInt(cmdargs[2]));
			    myItem.saveToDatabase();
			}
		        else if (cmdargs[1].startsWith("str")) {
			    myItem.setStrValue(cmdargs[2]);
			    myItem.saveToDatabase();
			}
			else if (cmdargs[1].startsWith("name")) {
			    myItem.setName(cmdargs[2]);
			    myItem.saveToDatabase();
			}
			else if (cmdargs[1].startsWith("type")) {
			    myItem.setType(cmdargs[2]);
			    myItem.saveToDatabase();
			}
			else {
			    System.out.println("Usage: set int|str|name|type <value>");
			}
		    }
		}
		}
		catch (Exception e) {
		    System.out.println("Error in processing command: Exception "+e);
		}
	    }
	}
    }

    public static void main(String args[]) {
	try {
	    Integer ival;

	    // Create options object
	    Options options = createOptions();

	    // Parse command line
	    CommandLineParser parser = new GnuParser();
	    CommandLine commandLine = null;
	    try
	    {
	      commandLine = parser.parse(options, args);
	    }
	    catch (ParseException e)
	    {
	      System.err.println("Syntax error (" + e + ")");
	      printUsage(options);
	      System.exit(1);
	    }

	    // Non-recognized options
	    int n = commandLine.getArgs().length;
	    for (int i = 0; i < n; i++)
	    {
	      System.err.println("Syntax error (unrecognized option: "
	          + commandLine.getArgs()[i] + ")");
	      printUsage(options);
	      System.exit(1);
	    }

	    // Handle --help option
	    if (commandLine.hasOption('h'))
	    {
	      if (commandLine.getOptions().length > 1)
	        System.err.println("Syntax error");

	      printUsage(options);
	      System.exit(1);
	    }

	    // Handle --version option
	    if (commandLine.hasOption('v'))
	    {
	      if (commandLine.getOptions().length > 1)
	      {
	        System.err.println("Syntax error");
	        printUsage(options);
	      }
	      else
	        System.out.println("ItemBase Commander version "+IBSCMD_VERSION);
	      System.exit(1);
	    }

	    // Handle --database option
	    if (commandLine.hasOption('d')) {
	      String tmp = commandLine.getOptionValue('d');
	      if (tmp != null)
	      {
	        theUrl = tmp;
	      }
	    }

	    myIBS = new ItemBase(theUrl);
	    myItem = new Item(myIBS);
	    System.out.println("Connected to Item Base "+theUrl);
	    myItem.readFromDatabase(0);
	    dumpItem(myItem,">");
	    doCommands();
	}
	catch (IBSException e) { 
	    System.out.println("IBS-Exception: "+e);
	    e.printStackTrace();
	}

    }
}
