/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;

public class OracleRow
implements Serializable,
Cloneable {
    private Object[] column;
    private Object[] changedColumn;
    private boolean[] isOriginalNull;
    private byte[] columnChangeFlag;
    private int noColumn = 0;
    private int noColumnsInserted;
    private boolean rowDeleted = false;
    private boolean rowInserted = false;
    private final byte COLUMN_CHANGED = (byte)17;
    private boolean rowUpdated = false;

    public OracleRow(int n) {
        this.noColumn = n;
        this.column = new Object[n];
        this.changedColumn = new Object[n];
        this.columnChangeFlag = new byte[n];
        this.isOriginalNull = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.columnChangeFlag[i] = 0;
        }
    }

    public OracleRow(int n, boolean bl) {
        this(n);
        this.rowInserted = bl;
        this.noColumnsInserted = 0;
    }

    public OracleRow(int n, Object[] objectArray) {
        this(n);
        System.arraycopy(objectArray, 0, this.column, 0, n);
    }

    public void setColumnValue(int n, Object object) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.column[n - 1] = object;
    }

    void markOriginalNull(int n, boolean bl) throws SQLException {
        this.isOriginalNull[n - 1] = bl;
    }

    boolean isOriginalNull(int n) throws SQLException {
        return this.isOriginalNull[n - 1];
    }

    public void updateObject(int n, Object object) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.columnChangeFlag[n - 1] = 17;
        this.changedColumn[n - 1] = object;
    }

    public void cancelRowUpdates() {
        this.noColumnsInserted = 0;
        for (int i = 0; i < this.noColumn; ++i) {
            this.columnChangeFlag[i] = 0;
        }
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Object getColumn(int n) {
        return this.column[n - 1];
    }

    public Object getModifiedColumn(int n) {
        return this.changedColumn[n - 1];
    }

    public boolean isColumnChanged(int n) {
        return this.columnChangeFlag[n - 1] == 17;
    }

    public boolean isRowUpdated() {
        if (this.rowInserted || this.rowDeleted) {
            return false;
        }
        for (int i = 0; i < this.noColumn; ++i) {
            if (this.columnChangeFlag[i] != 17) continue;
            return true;
        }
        return false;
    }

    public void setRowUpdated(boolean bl) {
        this.rowUpdated = bl;
        if (!bl) {
            this.cancelRowUpdates();
        }
    }

    public boolean isRowInserted() {
        return this.rowInserted;
    }

    public void cancelRowDeletion() {
        this.rowDeleted = false;
    }

    public void setRowDeleted(boolean bl) {
        this.rowDeleted = bl;
    }

    public boolean isRowDeleted() {
        return this.rowDeleted;
    }

    public Object[] getOriginalRow() {
        return this.column;
    }

    public boolean isRowFullyPopulated() {
        if (!this.rowInserted) {
            return false;
        }
        return this.noColumnsInserted == this.noColumn;
    }

    public void setInsertedFlag(boolean bl) {
        this.rowInserted = bl;
    }

    void makeUpdatesOriginal() {
        for (int i = 0; i < this.noColumn; ++i) {
            if (this.columnChangeFlag[i] != 17) continue;
            this.column[i] = this.changedColumn[i];
            this.changedColumn[i] = null;
            this.columnChangeFlag[i] = 0;
        }
        this.rowUpdated = false;
    }

    public void insertRow() {
        this.columnChangeFlag = null;
        this.columnChangeFlag = new byte[this.noColumn];
        System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.noColumn);
        for (int i = 1; i <= this.noColumn; ++i) {
            vector.add(this.isColumnChanged(i) ? this.getModifiedColumn(i) : this.getColumn(i));
        }
        return vector;
    }

    public OracleRow createCopy() throws SQLException {
        OracleRow oracleRow = new OracleRow(this.noColumn);
        for (int i = 0; i < this.noColumn; ++i) {
            oracleRow.column[i] = this.getCopy(this.column[i]);
            oracleRow.changedColumn[i] = this.getCopy(this.changedColumn[i]);
        }
        System.arraycopy(this.columnChangeFlag, 0, oracleRow.columnChangeFlag, 0, this.noColumn);
        oracleRow.noColumnsInserted = this.noColumnsInserted;
        oracleRow.rowDeleted = this.rowDeleted;
        oracleRow.rowInserted = this.rowInserted;
        oracleRow.rowUpdated = this.rowUpdated;
        return oracleRow;
    }

    public Object getCopy(Object object) throws SQLException {
        Object object2;
        block9: {
            object2 = null;
            try {
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    object2 = new String((String)object);
                    break block9;
                }
                if (object instanceof Number) {
                    object2 = new BigDecimal(((Number)object).toString());
                    break block9;
                }
                if (object instanceof Date) {
                    object2 = new Date(((Date)object).getTime());
                    break block9;
                }
                if (object instanceof Timestamp) {
                    object2 = new Timestamp(((Timestamp)object).getTime());
                    break block9;
                }
                if (object instanceof InputStream) {
                    object2 = new DataInputStream((InputStream)object);
                    break block9;
                }
                if (object instanceof OutputStream) {
                    object2 = new DataOutputStream((OutputStream)object);
                    break block9;
                }
                throw new SQLException("Error, could not reproduce the copy of the object, " + object.getClass().getName());
            }
            catch (Exception exception) {
                throw new SQLException("Error while creating a copy of the column of type, " + object.getClass().getName() + "\n" + exception.getMessage());
            }
        }
        return object2;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("Error while cloning\n" + sQLException.getMessage());
        }
    }
}

