/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class ClientProfile
extends Properties {
    private static final String profile_name = "ora-net-profile";
    private static final String shared_profile_name = "ora-shared-profile";

    public ClientProfile() {
    }

    public ClientProfile(Properties properties) {
        if (properties.containsKey("oracle.net.profile")) {
            this.put("oracle.net.profile", properties.getProperty("oracle.net.profile"));
        }
        this.put("oracle.net.authentication_services", properties.getProperty("oracle.net.authentication_services", "()"));
        this.put("oracle.net.encryption_client", properties.getProperty("oracle.net.encryption_client", "ACCEPTED"));
        this.put("oracle.net.encryption_types_client", properties.getProperty("oracle.net.encryption_types_client", "()"));
        this.put("oracle.net.crypto_checksum_client", properties.getProperty("oracle.net.crypto_checksum_client", "ACCEPTED"));
        this.put("oracle.net.crypto_checksum_types_client", properties.getProperty("oracle.net.crypto_checksum_types_client", "()"));
        this.put("oracle.net.crypto_seed", properties.getProperty("oracle.net.crypto_seed", ""));
    }

    public String[] getAuthenticationServices() {
        return this.getServices((String)this.get("oracle.net.authentication_services"));
    }

    public String[] getEncryptionServices() {
        return this.getServices((String)this.get("oracle.net.encryption_types_client"));
    }

    public String[] getDataIntegrityServices() {
        return this.getServices((String)this.get("oracle.net.crypto_checksum_types_client"));
    }

    public String getEncryptionLevel() {
        return (String)this.get("oracle.net.encryption_client");
    }

    public int getEncryptionLevelNum() {
        return this.translateAnoValue(this.getEncryptionLevel());
    }

    public String getDataIntegrityLevel() {
        return (String)this.get("oracle.net.crypto_checksum_client");
    }

    public int getDataIntegrityLevelNum() {
        return this.translateAnoValue(this.getDataIntegrityLevel());
    }

    public void print() {
        System.out.println(" ----------------------------------------");
        System.out.println(" Displaying the content of ClientProfile ");
        System.out.println(" List:");
        this.list(System.out);
        Enumeration<?> enumeration = this.propertyNames();
        System.out.println("Enumeration has elements ? " + enumeration.hasMoreElements());
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("Key " + n + " = " + string);
            System.out.println("Value = " + this.getProperty(string));
            ++n;
        }
        System.out.println(" ----------------------------------------");
    }

    private String[] getServices(String string) {
        String string2 = this.removeParenths(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        return stringArray;
    }

    private String removeParenths(String string) {
        int n = string.indexOf(40);
        int n2 = n == -1 ? 0 : n + 1;
        int n3 = string.lastIndexOf(41);
        int n4 = n3 == -1 ? string.length() : n3;
        String string2 = string.substring(n2, n4);
        return string2.trim();
    }

    private int translateAnoValue(String string) {
        int n = 0;
        if (string.equalsIgnoreCase("ACCEPTED")) {
            n = 0;
        } else if (string.equalsIgnoreCase("REQUESTED")) {
            n = 2;
        } else if (string.equalsIgnoreCase("REQUIRED")) {
            n = 3;
        } else if (string.equalsIgnoreCase("REJECTED")) {
            n = 1;
        }
        return n;
    }
}

