/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/


asm LMUL(long a, long b)
{
link a6,#0
move.l 8(a6),d0
move.l 12(a6),d1
movem.l	d2-d3,-(sp)
move.l	d0,d2
swap	d2
mulu.w	d1,d2
move.l	d1,d3
swap	d3
mulu.w	d0,d3
add.w	d3,d2
swap	d2
clr.w	d2
mulu	d1,d0
add.l	d2,d0
movem.l	(sp)+,d2-d3
unlk a6
rts
}

asm LUDIV(long a, long b)
{
link a6,#0
move.l 8(a6),d0
move.l 12(a6),d1
movem.l	d2-d3,-(sp)
move.l	d1,d2
clr.w	d2
swap	d2
bne	L1
move.w	d0,d3
clr.w	d0
swap	d0
beq	L0
divu.w	d1,d0
move.w	d0,d2
swap	d2
L0:
move.w	d3,d0
divu.w	d1,d0
move.w	d0,d2
move.l	d2,d0
bra L4
L1:
move.w	d0,d2
clr.w	d0
swap	d0
swap	d2
move.l	d1,d3
moveq	#15,d1
L2:
add.l	d2,d2
addx.l	d0,d0
cmp.l	d3,d0
bcs	L3
sub.l	d3,d0
addq.b	#1,d2
L3:
dbra	d1,L2
move.l	d2,d0
L4:
movem.l	(sp)+,d2-d3
unlk	a6
rts
}


asm LDIV(long a, long b)
{
link a6,#0
move.l 8(a6),d0
move.l 12(a6),d1
tst.l	d0
bge	L1
neg.l	d0
tst.l	d1
bge	L2
neg.l	d1
move.l d1,-(a7)
move.l d0,-(a7)
jsr	LUDIV
addq #8,a7
bra L3 
L1:
tst.l	d1
blt L4
move.l d1,-(a7)
move.l d0,-(a7)
jsr	LUDIV
addq #8,a7
bra L3
L4:
neg.l	d1
L2:
move.l d1,-(a7)
move.l d0,-(a7)
jsr	LUDIV
addq #8,a7
neg.l	d0
L3:
unlk a6
rts
}

asm LUREM(long a, long b)
{
link a6,#0
move.l 8(a6),d0
move.l 12(a6),d1
movem.l	d2-d3,-(sp)
move.l	d1,d2
clr.w	d2
swap	d2
bne		L1
move.w	d0,d3
clr.w	d0
swap	d0
beq		L2
divu.w	d1,d0
move.w	d0,d2
swap	d2
L2:
move.w	d3,d0
divu.w	d1,d0
clr.w	d0
swap	d0
bra		L5
L1:
move.w	d0,d2
clr.w	d0
swap	d0
swap	d2
move.l	d1,d3
moveq	#15,d1
L3:
add.l	d2,d2
addx.l	d0,d0
cmp.l	d3,d0
bcs		L4
sub.l	d3,d0
L4:
dbra	d1,L3
L5:
movem.l	(sp)+,d2-d3
unlk a6
rts
}

asm LREM(long a, long b)
{
link a6,#0
move.l 8(a6),d0
move.l 12(a6),d1
tst.l	d1
bge		L1
neg.l	d1
L1:
tst.l	d0
blt		L2
move.l d1,-(a7)
move.l d0,-(a7)
jsr		LUREM
addq #8,a7
bra		L3
L2:
neg.l	d0
move.l d1, -(a7)
move.l d0,-(a7)
jsr		LUREM
addq #8, a7
neg.l	d0
L3:
unlk a6
rts
}

