/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For
 * more information on developing OnBoard C (including submission of
 * bug reports), see http://sourceforge.net/projects/onboardc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***********************************************************************/

#include <PalmCompatibility.h>
#include <PalmOS.h>
#include <SysEvtMgr.h>
#include <DataMgr.h>
#include <SystemMgr.h>
#include <Find.h>
#include <Form.h>
#include <FeatureMgr.h>

#define version20   0x02000000

#include "OnBoard_res.h"
#include "OnBoard.h"
#include "debug.h"

typedef struct {
    int mVersion;
    int mSourceDBCount;
    int mIncludeCount;
    ULong mFlags;
    ULong mCreator;
    ULong mType;
    char mAppName[dmDBNameLength];
    char mPrcName[dmDBNameLength];
    char reserved[32];
} ProjectHeader_New;    // followed by sourceDBCount SourceFile records, then includeCount IncludeFile records.

/* Multi-Segment Defines */
#ifdef __GNUC__
#define SEG_1 __attribute__ ((section("Seg1")))
#else
#define SEG_1
#endif

Boolean finish(LocalID *lid, Boolean debug, Boolean *executable, ULong type) SEG_1;
CharPtr getEA(CharPtr curTextPtr, int *opCode, long *opData, long *target, Boolean isJsrOrJmp) SEG_1;
Boolean optimizeBranches() SEG_1;
Boolean compile(CharPtr text, ProjectHeader_New *prjHdr, int sourceIndex) SEG_1;
static Boolean mainListEventHandler(EventPtr event) SEG_1;
CharPtr processArgument(CharPtr curTextPtr, int *stackDepth) SEG_1;
CharPtr buildSysTrapInstruction(CharPtr curTextPtr) SEG_1;

/* End of Multi-segment defines */

char gPRCName[dmDBNameLength];
ULong gCreator;
ULong gType;
Boolean gExecute;
Boolean gKeepAsm;
PrefsData gPrefs;
Boolean gInvokedFromCompiler;
LocalID gTargetDB;
int gTargetRecord;
int codeSeg;

DmOpenRef dataDB = 0;
DmOpenRef codeCopyDB = 0;
DmOpenRef sourceCopyDB = 0;

typedef enum { DocSource, MemoSource, Resource } SourceKind;

#define PROJECT_VERSION_CURRENT 6
#define PROJECT_VERSION_NEWOBJ 7
#define MAX_SOURCE 20
#define MaxInclude 16

CharPtr includeStack[MaxInclude];
int gIncludeDepth=0;

typedef struct {

    SourceKind sourceKind;
    char sourceDB[dmDBNameLength];
    LocalID sourceDBid;             // for Memo sources, this is the record number
    int includeIndex[MaxInclude];
    int includeCount;

    char outputDB[dmDBNameLength];
    LocalID outputDBid;

} SourceFile;

typedef struct {
    SourceKind includeKind;
    char includeDB[dmDBNameLength];
    int includeNameLength;
} IncludeFile;
/*
typedef struct {
    int version;
    int sourceDBCount;
    Boolean execute;
    Boolean alwaysRebuild;
    ULong creator;
    char appName[dmDBNameLength];
    char prcName[dmDBNameLength];
    SourceFile source[MAX_SOURCE];
    int includeCount;
    IncludeFile include[MAX_SOURCE];
    ULong type;
} ProjectHeader;
*/
#define EXECUTE_FLAG (0x1)
#define REBUILD_FLAG (0x2)
#define DEBUG_FLAG (0x4)
#define AUTOVERSION_FLAG (0x8)



Boolean gTokenStream = false;




enum { LocalCodeLabel = 0x10000, GlobalCodeLabel = 0x30000, GlobalDataLabel = 0x40000 };

typedef struct LabelData {
    CharPtr name;
    char hash;
    int length;
    long offset;
    int size;
    int index;
    int scope;
    int next;       // index in whichever table is the base for the collection
} LabelData;

int gMaxLocalCodeLabels = 128;
int gLocalCodeLabelIndex;
Handle localCodeLabelListH = NULL;
LabelData *localCodeLabelList;
int localCodeLabelTop;
int localCodeLabelHashTable[128];

int gMaxGlobalCodeLabels = 128;
int gGlobalCodeLabelIndex;
Handle globalCodeLabelListH = NULL;
LabelData *globalCodeLabelList;
int globalCodeLabelTop;
int globalCodeLabelHashTable[128];

int gMaxGlobalDataLabels = 128;
int gGlobalDataLabelIndex;
LabelData *globalDataLabelList;
Handle globalDataLabelListH = NULL;
int globalDataLabelTop;
int globalDataLabelHashTable[128];

int gCurrentScope;

typedef struct {
    int index;
    long offset;
    int scope;
    Boolean fromCode;
} FixupData;

int gMaxGlobalDataFixups = 128;
int gGlobalDataFixupIndex;
Handle globalDataFixupListH = NULL;
FixupData *globalDataFixupList;
int globalDataFixupTop;

int gMaxGlobalCodeFixups = 128;
int gGlobalCodeFixupIndex;
Handle globalCodeFixupListH = NULL;
FixupData *globalCodeFixupList;
int globalCodeFixupTop;

enum { Nothing, Branch, PCRelFixup, DBranch };

//#define MaxProcedureSize 4096
//char branchList[MaxProcedureSize];
Handle branchListHandle = NULL;
int branchListSize = 0;
char *branchList = NULL;
long procStart;

Handle objectCodeHandle = NULL;
short *objectCodePtr;
long objectCodeSize;
long objectCodeTop;

Handle dataHandle = NULL;
long dataSize;
long dataTop;
long totalDataSize;
Handle dataInit = NULL;
long dataInitSize;
Handle codeInit = NULL;
long codeInitSize;

#define InitialCodeStashSize 8096
long gCodeStashTop;
long gCodeStashSize;
Handle gCodeStashH = NULL;
char *gCodeStash;

struct {
    int segNumber;
    Handle codeStash;
    Boolean addLongMath;
} gSegContents[32];
int gSegCount = 0;


void setStatus(CharPtr message, CharPtr status, int length);

long findLocalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset);
long addLocalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset);
long findGlobalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset);
long addGlobalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset);
long findGlobalDataLabel(CharPtr startTextPtr, int length, char hash, long offset);
long addGlobalDataLabel(CharPtr startTextPtr, int length, char hash, long offset);
Boolean addGlobalDataFixup(int targetIndex, long offset, Boolean fromCode);
Boolean addGlobalCodeFixup(int targetIndex, long offset, Boolean fromCode);
void removeGlobalCodeLabel(CharPtr startTextPtr, int length, char hash);
void resetLabelTable();

Boolean completeSegmentFixups(Boolean *addLongMath);


long codeZeroData[] = {
    32,                 // size of initialized data
    0                   // size of uninitialized data
};
#define CodeZeroSize 8
char dataZeroData[] = {
    0x0, 0x0, 0x0, 0x11,        // offset to xref (beyond end)
    0x0, 0x0, 0x0, 0x4,         // start at A5 +4
    0x7f,                       // 64 bytes of zero
    0x7f,                       // 64 bytes of zero
    0x0,                        // end of compressed stream
    0x0,0x0,0x0,0x0,            // block 2 is empty
    0x0,
    0x0,0x0,0x0,0x0,            // block 3 is empty
    0x0,
};
#define DataZeroSize 21

short startupCode[] = {
 0x4e56, 0xfff4,         //     LINK    A6,#-12
 0x486e, 0xfff4,         //     PEA -12(A6)
 0x486e, 0xfff8,         //     PEA -8(A6)
 0x486e, 0xfffc,         //     PEA -4(A6)
 0x4e4f,                 //     TRAP    #15
 0xa08f,                 //     DC.W    sysTrapSysAppStartup
 0x4fef, 0x000c,         //     LEA 12(A7),A7
 0x4a40,                 //     TST.W   D0
 0x670e,                 //     BEQ L1
 0x1f3c, 0x0003,         //     MOVE.B  #3,-(A7)
 0x4e4f,                 //     TRAP    #15
 0xa234,                 //     DC.W    sysTrapSndPlaySystemSound
 0x548f,                 //     ADDQ.L  #2,A7
 0x70ff,                 //     MOVEQ   #-1,D0
 0x603e,                 //     BRA L2
 0x206e, 0xfffc,         // L1  MOVEA.L -4(A6),A0
 0x3f28, 0x0006,         //     MOVE.W  6(A0),-(A7)
 0x2f28, 0x0002,         //     MOVE.L  2(A0),-(A7)
 0x3f10,                 //     MOVE.W  (A0),-(A7)
 0x6612,                 //     bne.s *+20      -- skip datainit if cmd != normalLaunch
 0x7001,                 //     moveq   #1,d0
 0x204D,                 //     move.l  a5,a0
 0x4EBA, 0x002C,         //     jsr *+6         -- call datainit
 0x7002,                 //     moveq   #2,d0
 0x41FA, 0x0090,         //     lea     90(pc),a0       -- start of startupCode, hence start of CODE #1
 0x4EBA, 0x0022,         //     jsr *+6         -- call datainit
 0x4EBA, 0x0000,         //     jsr main
 0x508f,                 //     ADDQ.L  #8,A7
 0x2f2e,                 //     MOVE.L  -12(A6),-(A7)
 0xfff4,
 0x2f2e,                 //     MOVE.L  -8(A6),-(A7)
 0xfff8,
 0x2f2e,                 //     MOVE.L  -4(A6),-(A7)
 0xfffc,
 0x4e4f,                 //     TRAP    #15
 0xa090,                 //     DC.W    sysTrap SysAppExit
 0x4fef,                 //     LEA 12(A7),A7
 0x000c,
 0x7000,                 //     MOVEQ   #0,D0
 0x4e5e,                 // L2  UNLK    A6
 0x4e75,                 //     RTS
 // datainit (@54) :
 0x4E56, 0x0000,         // link      a6,#0
 0x48E7, 0x1E38,         // movem.l   d3-d6/a2-a4,-(a7)
 0x2A08,                 // move.l    a0,d5
 0x3F00,                 // move.w    d0,-(a7)
 0x2F3C, 0x6461, 0x7461, // move.l    #'data',-(a7)
 0x4E4F,                 // trap      #15
 0xA05F,                 // sysTrapDmGetResource
 0x2448,                 // movea.l   a0,a2
 0x47ED, 0x0000,         // lea       0(a5),a3              // this is set to -totalDataSize (i.e. the base of the data block)
 0x200A,                 // move.l    a2,d0
 0x5C4F,                 // addq.w    #6,a7
 0x6740,                 // beq.s     *+64
 0x2F0A,                 // move.l    a2,-(a7)
 0x4E4F,                 // trap      #15
 0xA021,                 // sysTrapMemHandleLock
 0x2848,                 // movea.l   a0,a4
 0x7800,                 // moveq     #0,d4
 0x584F,                 // addq.w    #4,a7
 0x601E,                 // bra.s     *+30           ; 0x00000050
 0x1C1C,                 // move.b    (a4)+,d6
 0x7607,                 // moveq     #7,d3
 0x6012,                 // bra.s     *+18           ; 0x0000004a
 0x7001,                 // moveq     #1,d0
 0xE768,                 // lsl.w     d3,d0
 0x7200,                 // moveq     #0,d1
 0x1206,                 // move.b    d6,d1
 0xC240,                 // and.w     d0,d1
 0x6702,                 // beq.s     *+4            ; 0x00000048
 0xDB93,                 // add.l     d5,(a3)
 0x548B,                 // addq.l    #2,a3
 0x5343,                 // subq.w    #1,d3
 0x4A43,                 // tst.w     d3
 0x6CEA,                 // bge.s     *-18           ; 0x0000003a
 0x5244,                 // addq.w    #1,d4
 0x0C44, 0x0000,         // cmpi.w    #0000,d4
 0x6DDC,                 // blt.s     *-32           ; 0x00000034
 0x2F0A,                 // move.l    a2,-(a7)
 0x4E4F,                 // trap      #15
 0xA022,                 // sysTrapMemHandleUnlock
 0x2F0A,                 // move.l    a2,-(a7)
 0x4E4F,                 // trap      #15
 0xA061,                 // sysTrapDmReleaseResource
 0x504F,                 // addq.w    #8,a7
 0x4CDF, 0x1C78,         // movem.l   (a7)+,d3-d6/a2-a4
 0x4E5E,                 // unlk      a6
 0x4E75                  // rts
};

int jsrToMainOffset = 39;
int dataInitSizeOffset = 94;
int dataBaseOffset = 67;

/* see Math.c */
short longMathCode[] = {
/* LMUL */
0x4E56, 0x0000,
0x202E, 0x0008,
0x222E, 0x000C,
0x48E7, 0x3000,
0x2400,
0x4842,
0xC4C1,
0x2601,
0x4843,
0xC6C0,
0xD443,
0x4842,
0x4242,
0xC0C1,
0xD082,
0x4CDF, 0x000C,
0x4E5E,
0x4E75,
/* LUDIV */
0x4E56, 0x0000,
0x202E, 0x0008,
0x222E, 0x000C,
0x48E7, 0x3000,
0x2401,
0x4242,
0x4842,
0x6618,
0x3600,
0x4240,
0x4840,
0x6706,
0x80C1,
0x3400,
0x4842,
0x3003,
0x80C1,
0x3400,
0x2002,
0x601E,
0x3400,
0x4240,
0x4840,
0x4842,
0x2601,
0x720F,
0xD482,
0xD180,
0xB083,
0x6504,
0x9083,
0x5202,
0x51C9, 0xFFF2,
0x2002,
0x4CDF, 0x000C,
0x4E5E,
0x4E75,
/* LDIV */
0x4E56, 0x0000,
0x202E, 0x0008,
0x222E, 0x000C,
0x4A80,
0x6C14,
0x4480,
0x4A81,
0x6C20,
0x4481,
0x2F01,
0x2F00,
0x4EBA, 0xFF8C,
0x504F,
0x601E,
0x4A81,
0x6D0C,
0x2F01,
0x2F00,
0x4EBA, 0xFF7C,
0x504F,
0x600E,
0x4481,
0x2F01,
0x2F00,
0x4EBA, 0xFF6C,
0x504F,
0x4480,
0x4E5E,
0x4E75,
/* LUREM */
0x4E56, 0x0000,
0x202E, 0x0008,
0x222E, 0x000C,
0x48E7, 0x3000,
0x2401,
0x4242,
0x4842,
0x6618,
0x3600,
0x4240,
0x4840,
0x6706,
0x80C1,
0x3400,
0x4842,
0x3003,
0x80C1,
0x4240,
0x4840,
0x601A,
0x3400,
0x4240,
0x4840,
0x4842,
0x2601,
0x720F,
0xD482,
0xD180,
0xB083,
0x6502,
0x9083,
0x51C9, 0xFFF4,
0x4CDF, 0x000C,
0x4E5E,
0x4E75,
/* LREM */
0x4E56, 0x0000,
0x202E, 0x0008,
0x222E, 0x000C,
0x4A81,
0x6C02,
0x4481,
0x4A80,
0x6D0C,
0x2F01,
0x2F00,
0x4EBA, 0xFF92,
0x504F,
0x600E,
0x4480,
0x2F01,
0x2F00,
0x4EBA, 0xFF84,
0x504F,
0x4480,
0x4E5E,
0x4E75
};

/*
int LMUL_offset = -336;
int LUDIV_offset = -290;
int LDIV_offset = -204;
int LUREM_offset = -134;
int LREM_offset = -52;
*/
int LMUL_offset = 0;
int LUDIV_offset = 46;
int LDIV_offset = 132;
int LUREM_offset = 202;
int LREM_offset = 284;

struct {
    char *name;
    int length;
    char hash;
    int offset;
} longMath[5] = {
    {"LMUL",  4, 'L' ^ 'M' ^ 'U' ^ 'L',       0},
    {"LUDIV", 5, 'L' ^ 'U' ^ 'D' ^ 'I' ^ 'V', 46},
    {"LDIV",  4, 'L' ^ 'D' ^ 'I' ^ 'V',       132},
    {"LUREM", 5, 'L' ^ 'U' ^ 'R' ^ 'E' ^ 'M', 202},
    {"LREM",  4, 'L' ^ 'R' ^ 'E' ^ 'M',       284}
};

#define PilotMainHash 'P' ^ 'i' ^ 'l' ^ 'o' ^ 't' ^ 'M' ^ 'a' ^ 'i' ^ 'n' ^ '_' ^ '0' ^ '0'


/*
long gd;
void initData()
{
    Handle h = DmGetResource('data', 1);
    long *dataPtr = &gd;
    long t = gd;
    if (h != NULL) {
        int i;
        Ptr p = MemHandleLock(h);
        for (i = 0; i < 17312; i++) {
            Byte b = *p++;
            int j;
            for (j = 7; j >= 0; j--) {
                if (b & (1 << j))
                    *dataPtr += t;
                dataPtr++;
            }
        }
        MemHandleUnlock(h);
        DmReleaseResource(h);
    }
}
*/

typedef struct {
    short flags;
    short operand1;
    short operand2;
    short opcode;
} InstructionData ;

enum {
    EA_Immediate     = 0x3C,        // opCode has 111000, opData has the value
    EA_DRegister     = 0x00,        // opCode has 000rrr
    EA_ARegister     = 0x08,        // opCode has 001rrr
    EA_Indirect      = 0x10,        // opCode has 010rrr
    EA_Indexed       = 0x30,        // opCode has 110rrr, opData has the extension word
    EA_Displacement  = 0x28,        // opCode has 101rrr, opData has the displacement
    EA_AbsoluteWord  = 0x38,        // opCode has 111000, opData has the value
    EA_AbsoluteLong  = 0x39,        // opCode has 111001, opData has the value
    EA_PreDecrement  = 0x20,        // opCode has 100rrr
    EA_PCDisp        = 0x3A,        // opCode has 111010, opData has the displacement
    EA_PCIndx        = 0x3B,        // opCode has 111011, opData has the extension word
    EA_StackPush     = 0x27,        // -(a7)
    EA_PostIncrement = 0x18,        // opCode has 011rrr
    EA_Target        = 0x3D,        // opData has the label kind/index
    EA_RegisterSet   = 0x3E,        // opData has the set twice, with d0 thru a7, then a7 thru d0
    EA_None          = 0x3F,
    EA_Error         = 0xFF
};

enum {
    DReg = 1,
    AReg = 2,
    Ind = 4,
    Post = 8,
    Pre = 16,
    Disp = 32,
    Indx = 64,
    AbsW = 128,
    AbsL = 256,
    PCRel = 512,
    PCIndex = 1024,
    Imm = 2048,
    TgtEA = 4096,
    RegList = 8192,
    AnyEA = 0xFFFF,
    DataEA = DReg + Ind + Post + Pre + Disp + TgtEA + Indx + AbsW + AbsL,
    MemEA = Ind + Post + Pre + Disp + TgtEA + Indx + AbsW + AbsL,
    AltEA = DReg + AReg + Ind + Post + Pre + Disp + TgtEA + Indx + AbsW + AbsL,
    CtrlEA = Ind + Disp + Indx + AbsW + AbsL + TgtEA + PCRel + PCIndex,
    NoEA = 16384
};

enum {
    ByteSize = 1,
    WordSize = 2,
    LongSize = 4,
    Unsized = 7
};

enum {
    LastEntry = 0x8000,             // LastEntry is set for the last entry for each opcode
    SizeSpec = 0x4000,              // SizeSpec is set on the first entry if a specifier is allowed
    OP1_EA = 0x2000,                // operand 1 is encoded in the EA field (else operand 2 is)
    OPX_EA = 0x1000,                // the other operand contributes it's low 3 bits (if set)
    OP1_RegOnly = 0x0800,           // operand 1 encoded as low 3 bits only (if set)
    OPX_RegOnly = 0x0400            // the other operand encoded as low 3 bits only (if set)
};


Handle eaMappingH = NULL;
short *eaMappingPtr;        // maps any EA field (6 bits) into an EA bit setting


Handle instructionH = NULL;
InstructionData *instructionDataPtr;

int dataIndex;
void installData(short flags, short op1, short op2, short opcode)
{
    InstructionData id;
    id.flags = flags;
    id.operand1 = op1;
    id.operand2 = op2;
    id.opcode = opcode;
    DmWrite(instructionDataPtr, (dataIndex++ * sizeof(InstructionData)), &id, sizeof(InstructionData));
}

void installMapping(short m0, short m1, short m2, short m3, short m4, short m5, short m6, short m7)
{
    short m[8];
    m[0] = m1; m[1] = m1; m[2] = m2; m[3] = m3; m[4] = m4; m[5] = m5; m[6] = m6; m[7] = m7;
    DmWrite(eaMappingPtr, (dataIndex++ * 8 * sizeof(short)), &m[0], 8 * sizeof(short));
}

void initDataTables()
{
    dataIndex = 0;

installData( SizeSpec+OP1_EA+OPX_EA+ByteSize, AnyEA-AReg, DReg, 0xD000 );   // 0 Add.b <ea>,Dn
installData( OP1_EA+OPX_EA+WordSize, AnyEA, DReg, 0xD040 );             // 1 Add.w <ea>,Dn
installData( OP1_EA+OPX_EA+LongSize, AnyEA, DReg, 0xD080 );                 // 2 Add.l <ea>,Dn
installData( OPX_EA+ByteSize, DReg, MemEA, 0xD100 );                        // 3 Add.b Dn,<ea>
installData( OPX_EA+WordSize, DReg, MemEA, 0xD140 );                        // 4 Add.w Dn,<ea>
installData( OPX_EA+LastEntry+LongSize, DReg, MemEA, 0xD180 );          // 5 Add.l Dn,<ea>

installData( SizeSpec+OP1_EA+OPX_EA+ByteSize, AnyEA-AReg, DReg, 0x9000 );   // 6 Sub.b <ea>,Dn
installData( OP1_EA+OPX_EA+WordSize, AnyEA, DReg, 0x9040 );                 // 7 Sub.w <ea>,Dn
installData( OP1_EA+OPX_EA+LongSize, AnyEA, DReg, 0x9080 );                 // 8 Sub.l <ea>,Dn
installData( OPX_EA+ByteSize, DReg, MemEA, 0x9100 );                        // 9 Sub.b Dn,<ea>
installData( OPX_EA+WordSize, DReg, MemEA, 0x9140 );                        // 10 Sub.w Dn,<ea>
installData( OPX_EA+LastEntry+LongSize, DReg, MemEA, 0x9180 );          // 11 Sub.l Dn,<ea>

installData( SizeSpec+OP1_EA+OPX_EA+WordSize, AnyEA, AReg, 0xD0C0 );        // 12 Adda.w <ea>,An
installData( LastEntry+OP1_EA+OPX_EA+LongSize, AnyEA, AReg, 0xD1C0 );       // 13 Adda.l <ea>,An

installData( SizeSpec+ByteSize, Imm, AltEA-AReg, 0x0600 );                  // 14 Addi.b #,<ea>
installData( WordSize, Imm, AltEA-AReg, 0x0640 );                           // 15 Addi.w #,<ea>
installData( LastEntry+LongSize, Imm, AltEA-AReg, 0x0680 );             // 16 Addi.l #,<ea>

installData( SizeSpec+OPX_EA+ByteSize, Imm, AltEA-AReg, 0x5000 );           // 17 Addq.b #,<ea>
installData( OPX_EA+WordSize, Imm, AltEA, 0x5040 );                     // 18 Addq.w #,<ea>
installData( OPX_EA+LastEntry+LongSize, Imm, AltEA, 0x5080 );               // 19 Addq.l #,<ea>

installData( SizeSpec+OP1_EA+OPX_EA+WordSize, AnyEA, AReg, 0x90C0 );        // 20 Suba.w <ea>,An
installData( LastEntry+OP1_EA+OPX_EA+LongSize, AnyEA, AReg, 0x91C0 );       // 21 Suba.l <ea>,An

installData( SizeSpec+ByteSize, Imm, AltEA-AReg, 0x0400 );                  // 22 Subi.b #,<ea>
installData( WordSize, Imm, AltEA-AReg, 0x0440 );                           // 23 Subi.w #,<ea>
installData( LastEntry+LongSize, Imm, AltEA-AReg, 0x0480 );             // 24 Subi.l #,<ea>

installData( SizeSpec+OPX_EA+ByteSize, Imm, AltEA-AReg, 0x5100 );           // 25 Subq.b #,<ea>
installData( OPX_EA+WordSize, Imm, AltEA, 0x5140 );                     // 26 Subq.w #,<ea>
installData( OPX_EA+LastEntry+LongSize, Imm, AltEA, 0x5180 );               // 27 Subq.l #,<ea>

installData( SizeSpec+OP1_EA+OPX_EA+ByteSize, AnyEA-AReg, DReg, 0xC000 );   // 28 And.b <ea>,Dn
installData( OP1_EA+OPX_EA+WordSize, AnyEA-AReg, DReg, 0xC040 );                // 29 And.w <ea>,Dn
installData( OP1_EA+OPX_EA+LongSize, AnyEA-AReg, DReg, 0xC080 );                // 30 And.l <ea>,Dn
installData( OPX_EA+ByteSize, DReg, MemEA, 0xC100 );                        // 31 And.b Dn,<ea>
installData( OPX_EA+WordSize, DReg, MemEA, 0xC140 );                        // 32 And.w Dn,<ea>
installData( OPX_EA+LastEntry+LongSize, DReg, MemEA, 0xC180 );              // 33 And.l Dn,<ea>

installData( SizeSpec+ByteSize, AnyEA-AReg, AltEA-AReg, 0x1000 );           // 34 Move.b <ea>,<ea>
installData( WordSize, AnyEA, AltEA, 0x3000 );                              // 35 Move[a].w <ea>,<ea>
installData( LastEntry+LongSize, AnyEA, AltEA, 0x2000 );                    // 36 Move[a].l <ea>,<ea>

installData( SizeSpec+ByteSize, Imm, AltEA-AReg, 0x0C00 );                  // 37 Cmpi.b #,<ea>
installData( WordSize, Imm, AltEA-AReg, 0x0C40 );                           // 38 Cmpi.w #,<ea>
installData( LastEntry+LongSize, Imm, AltEA-AReg, 0x0C80 );             // 39 Cmpi.l #,<ea>

installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6700 );                // 40 Beq tgt
installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6F00 );                // 41 Ble tgt
installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6C00 );                // 42 Bge tgt
installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6E00 );                // 43 Bgt tgt
installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6D00 );                // 44 Blt tgt
installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6600 );                // 45 Bne tgt

installData( SizeSpec+WordSize, RegList, MemEA-Post, 0x4880 );              // 46 Movem.w <list>,<ea>
installData( WordSize, DReg, MemEA-Post, 0x4880 );                          // 46 Movem.w <list>,<ea>
installData( WordSize, AReg, MemEA-Post, 0x4880 );                          // 46 Movem.w <list>,<ea>
installData( LongSize, RegList, MemEA-Post, 0x48C0 );                       // 47 Movem.l <list>,<ea>
installData( LongSize, DReg, MemEA-Post, 0x48C0 );                      // 47 Movem.l <list>,<ea>
installData( LongSize, AReg, MemEA-Post, 0x48C0 );                      // 47 Movem.l <list>,<ea>
installData( WordSize, MemEA-Pre, RegList, 0x4C80 );                        // 48 Movem.w <ea>,<list>
installData( WordSize, MemEA-Pre, DReg, 0x4C80 );                       // 48 Movem.w <ea>,<list>
installData( WordSize, MemEA-Pre, AReg, 0x4C80 );                       // 48 Movem.w <ea>,<list>
installData( LongSize, MemEA-Pre, RegList, 0x4CC0 );                // 49 Movem.l <ea>,<list>
installData( LongSize, MemEA-Pre, DReg, 0x4CC0 );               // 49 Movem.l <ea>,<list>
installData( LastEntry+LongSize, MemEA-Pre, AReg, 0x4CC0 );             // 49 Movem.l <ea>,<list>

installData( SizeSpec+OP1_EA+ByteSize, DataEA, NoEA, 0x4A00 );              // 50 Tst.b <ea>
installData( OP1_EA+WordSize, DataEA, NoEA, 0x4A40 );                       // 51 Tst.w <ea>
installData( LastEntry+OP1_EA+LongSize, DataEA, NoEA, 0x4A80 );         // 52 Tst.l <ea>

installData( LastEntry+OP1_EA+OP1_RegOnly+Unsized, AReg, NoEA, 0x4E58 );    // 53 Unlk An
installData( LastEntry+OP1_EA+OP1_RegOnly+Unsized, AReg, Imm, 0x4E50 ); // 54 Link An,#

installData( LastEntry+OP1_EA+Unsized, CtrlEA, NoEA, 0x4840 );              // 55 Pea <ea>

installData( LastEntry+OP1_EA+OPX_EA+Unsized, CtrlEA, AReg, 0x41C0 );       // 56 Lea <ea>,An

installData( LastEntry+OP1_EA+Unsized, CtrlEA, NoEA, 0x4E80 );              // 57 Jsr <ea>

installData( LastEntry+Unsized, NoEA, NoEA, 0x4E75 );                       // 58 Rts

installData( LastEntry+SizeSpec+OP1_EA+OPX_EA+WordSize, AnyEA-AReg, DReg, 0xC0C0 ); // 59 Mulu <ea>,Dn

installData( LastEntry+SizeSpec+OP1_EA+OPX_EA+WordSize, AnyEA-AReg, DReg, 0xC1C0 ); // 60 Muls <ea>,Dn

installData( SizeSpec+OP1_EA+ByteSize, DataEA, NoEA, 0x4400 );              // 61 Neg.b <ea>
installData( OP1_EA+WordSize, DataEA, NoEA, 0x4440 );                       // 62 Neg.w <ea>
installData( LastEntry+OP1_EA+LongSize, DataEA, NoEA, 0x4480 );         // 63 Neg.l <ea>

installData( SizeSpec+OP1_EA+OPX_EA+ByteSize, AnyEA-AReg, DReg, 0xB000 );   // 64 Cmp.b <ea>,Dn
installData( OP1_EA+OPX_EA+WordSize, AnyEA, DReg, 0xB040 );                 // 65 Cmp.w <ea>,Dn
installData( LastEntry+OP1_EA+OPX_EA+LongSize, AnyEA, DReg, 0xB080 );       // 66 Cmp.l <ea>,Dn

installData( SizeSpec+OP1_EA+WordSize, DataEA, NoEA, 0x4880 );              // 68 Ext.w <ea>
installData( LastEntry+OP1_EA+LongSize, DataEA, NoEA, 0x48C0 );         // 69 Ext.l <ea>

installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6000 );                // 70 Bra tgt

installData( SizeSpec+ByteSize, Imm, AltEA-AReg, 0x0200 );                  // 71 Andi.b #,<ea>
installData( WordSize, Imm, AltEA-AReg, 0x0240 );                           // 72 Andi.w #,<ea>
installData( LastEntry+LongSize, Imm, AltEA-AReg, 0x0280 );             // 73 Andi.l #,<ea>

installData( LastEntry+Unsized, Imm, DReg, 0x7000 );                        // 74 Moveq #,Dn

installData( LastEntry+SizeSpec+OP1_EA+OPX_EA+WordSize, AnyEA-AReg, DReg, 0x80C0 ); // 59 Divu <ea>,Dn

installData( LastEntry+SizeSpec+OP1_EA+OPX_EA+WordSize, AnyEA-AReg, DReg, 0x81C0 ); // 60 Divs <ea>,Dn

installData( LastEntry+Unsized+OP1_EA+OP1_RegOnly, DReg, NoEA, 0x4840 );                        // 74  Swap Dn

installData( SizeSpec+ByteSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE108 );             // 71 Lsl.b #,Dn
installData( WordSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE148 );                          // 72 Lsl.w #,Dn
installData( LongSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE188 );                          // 73 Lsl.l #,Dn

installData( ByteSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE128 );                     // 71 Lsl.b Dm,Dn
installData( WordSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE168 );                     // 72 Lsl.w Dm,Dn
installData( LastEntry+LongSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE1A8 );               // 73 Lsl.l Dm,Dn

installData( SizeSpec+ByteSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE008 );             // 71 Lsr.b #,Dn
installData( WordSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE048 );                          // 72 Lsr.w #,Dn
installData( LongSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE088 );                          // 73 Lsr.l #,Dn

installData( ByteSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE028 );                     // 71 Lsr.b Dm,Dn
installData( WordSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE068 );                     // 72 Lsr.w Dm,Dn
installData( LastEntry+LongSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE0A8 );               // 73 Lsr.l Dm,Dn

installData( SizeSpec+ByteSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE000 );             // 71 Asr.b #,Dn
installData( WordSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE040 );                          // 72 Asr.w #,Dn
installData( LongSize+OPX_EA+OPX_RegOnly, Imm, DReg, 0xE080 );                          // 73 Asr.l #,Dn

installData( ByteSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE020 );                     // 71 Asr.b Dm,Dn
installData( WordSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE060 );                     // 72 Asr.w Dm,Dn
installData( LastEntry+LongSize+OPX_EA+OPX_RegOnly, DReg, DReg, 0xE0A0 );               // 73 Asr.l Dm,Dn

installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x57C0 );              // 40 Seq <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x5FC0 );              // 41 Sle <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x5CC0 );              // 42 Sge <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x5EC0 );              // 43 Sgt <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x5DC0 );              // 44 Slt <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x56C0 );              // 45 Sne <ea>

installData( SizeSpec+OP1_EA+OPX_EA+ByteSize, AnyEA-AReg, DReg, 0x8000 );   // 28 Or.b <ea>,Dn
installData( OP1_EA+OPX_EA+WordSize, AnyEA-AReg, DReg, 0x8040 );            // 29 Or.w <ea>,Dn
installData( OP1_EA+OPX_EA+LongSize, AnyEA-AReg, DReg, 0x8080 );            // 30 Or.l <ea>,Dn
installData( OPX_EA+ByteSize, DReg, MemEA, 0x8100 );                        // 31 Or.b Dn,<ea>
installData( OPX_EA+WordSize, DReg, MemEA, 0x8140 );                        // 32 Or.w Dn,<ea>
installData( OPX_EA+LastEntry+LongSize, DReg, MemEA, 0x8180 );              // 33 Or.l Dn,<ea>

installData( SizeSpec+ByteSize, Imm, AltEA-AReg, 0x0000 );                  // 71 Ori.b #,<ea>
installData( WordSize, Imm, AltEA-AReg, 0x0040 );                           // 72 Ori.w #,<ea>
installData( LastEntry+LongSize, Imm, AltEA-AReg, 0x0080 );             // 73 Ori.l #,<ea>

installData( SizeSpec+OP1_EA+ByteSize, DataEA, NoEA, 0x4200 );              // 61 Clr.b <ea>
installData( OP1_EA+WordSize, DataEA, NoEA, 0x4240 );                       // 62 Clr.w <ea>
installData( LastEntry+OP1_EA+LongSize, DataEA, NoEA, 0x4280 );         // 63 Clr.l <ea>

installData( SizeSpec+OP1_EA+OP1_RegOnly+OPX_EA+ByteSize, DReg, DReg, 0xD100 );     // 12 Addx.b Dm,Dn
installData( OP1_EA+OP1_RegOnly+OPX_EA+OP1_RegOnly+WordSize, DReg, DReg, 0xD140 );      // 12 Addx.w Dm,Dn
installData( OP1_EA+OP1_RegOnly+OPX_EA+LongSize, DReg, DReg, 0xD180 );              // 13 Addx.l Dm,Dn
installData( OP1_EA+OP1_RegOnly+OPX_EA+ByteSize, Pre, Pre, 0xD108 );                    // 13 Addx.b -(Am),-(An)
installData( OP1_EA+OP1_RegOnly+OPX_EA+WordSize, Pre, Pre, 0xD148 );                    // 13 Addx.w -(Am),-(An)
installData( LastEntry+OP1_EA+OP1_RegOnly+OPX_EA+LongSize, Pre, Pre, 0xD188 );      // 13 Addx.l -(Am),-(An)

installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6500 );                // 45 Bcs tgt

installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6400 );                // 45 Bcc tgt

installData( LastEntry+Unsized, DReg, TgtEA+PCRel, 0x51C8 );                // 45 Dbra Dn,tgt

installData( SizeSpec+OPX_EA+ByteSize, DReg, MemEA, 0xB100 );               // 31 Eor.b Dn,<ea>
installData( OPX_EA+WordSize, DReg, MemEA, 0xB140 );                        // 32 Eor.w Dn,<ea>
installData( OPX_EA+LastEntry+LongSize, DReg, MemEA, 0xB180 );              // 33 Eor.l Dn,<ea>

installData( SizeSpec+ByteSize, Imm, AltEA-AReg, 0x0A00 );                  // 71 Eori.b #,<ea>
installData( WordSize, Imm, AltEA-AReg, 0x0A40 );                           // 72 Eori.w #,<ea>
installData( LastEntry+LongSize, Imm, AltEA-AReg, 0x0A80 );             // 73 Eori.l #,<ea>

installData( LastEntry+Unsized, Imm, NoEA, 0x4e40 );                        // 73 Trap #

installData( Unsized, Imm, DataEA, 0x0800 );                                // 5 Btst #,<ea>
installData( OPX_EA+LastEntry+Unsized, DReg, DataEA, 0x0100 );          // 5 Btst Dn,<ea>

installData( Unsized, Imm, DataEA, 0x0840 );                                // 5 Bchg #,<ea>
installData( OPX_EA+LastEntry+Unsized, DReg, DataEA, 0x0140 );          // 5 Bchg Dn,<ea>

installData( Unsized, Imm, DataEA, 0x0880 );                                // 5 Bclr #,<ea>
installData( OPX_EA+LastEntry+Unsized, DReg, DataEA, 0x0180 );          // 5 Bclr Dn,<ea>

installData( Unsized, Imm, DataEA, 0x08C0 );                                // 5 Bset #,<ea>
installData( OPX_EA+LastEntry+Unsized, DReg, DataEA, 0x01C0 );          // 5 Bset Dn,<ea>

installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6000 );                // 70 Bsr tgt

installData( SizeSpec+OP1_EA+ByteSize, DataEA, NoEA, 0x4600 );              // 61 Not.b <ea>
installData( OP1_EA+WordSize, DataEA, NoEA, 0x4640 );                       // 62 Not.w <ea>
installData( LastEntry+OP1_EA+LongSize, DataEA, NoEA, 0x4680 );         // 63 Not.l <ea>

installData( LastEntry+Unsized, NoEA, NoEA, 0x4E73 );                       // 58 Rte


installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6300 );                // 42 Bls tgt
installData( LastEntry+Unsized, TgtEA+PCRel, NoEA, 0x6200 );                // 44 Bhi tgt

installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x53C0 );              // 42 Sls <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x55C0 );              // 43 Scs <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x52C0 );              // 44 Shi <ea>
installData( LastEntry+OP1_EA+Unsized, DataEA, NoEA, 0x54C0 );              // 45 Scc <ea>
installData( LastEntry+OP1_EA+Unsized, CtrlEA, NoEA, 0x4EC0 );             // Jmp <ea>


dataIndex = 0;
installMapping( DReg, DReg, DReg, DReg, DReg, DReg, DReg, DReg );
installMapping( AReg, AReg, AReg, AReg, AReg, AReg, AReg, AReg );
installMapping( Ind, Ind, Ind, Ind, Ind, Ind, Ind, Ind );
installMapping( Post, Post, Post, Post, Post, Post, Post, Post );
installMapping( Pre, Pre, Pre, Pre, Pre, Pre, Pre, Pre );
installMapping( Disp, Disp, Disp, Disp, Disp, Disp, Disp, Disp );
installMapping( Indx, Indx, Indx, Indx, Indx, Indx, Indx, Indx );
installMapping( AbsW, AbsL, PCRel, PCIndex, Imm, TgtEA, RegList, NoEA );


}

typedef struct {
    char *name;
    int length;
    char hash;
    Int token;
} ReservedWordEntry;
#define MaxReservedWord 98

ReservedWordEntry reservedWordList[MaxReservedWord + 1] = {

    { "a0", 2, 0, Token_a0 },
    { "a1", 2, 0, Token_a1 },
    { "a2", 2, 0, Token_a2 },
    { "a3", 2, 0, Token_a3 },
    { "a4", 2, 0, Token_a4 },
    { "a5", 2, 0, Token_a5 },
    { "a6", 2, 0, Token_a6 },
    { "a7", 2, 0, Token_a7 },
    { "add", 3, 0, Token_Add },
    { "adda", 4, 0, Token_Adda },
    { "addi", 4, 0, Token_Addi },
    { "addq", 4, 0, Token_Addq },
    { "addx", 4, 0, Token_Addx },
    { "and", 3, 0, Token_And },
    { "andi", 4, 0, Token_Andi },
    { "asr", 3, 0, Token_Asr },
    { "beginproc", 9, 0, Token_BeginProc },
    { "beq", 3, 0, Token_Beq },
    { "bne", 3, 0, Token_Bne },
    { "blt", 3, 0, Token_Blt },
    { "bgt", 3, 0, Token_Bgt },
    { "bge", 3, 0, Token_Bge },
    { "ble", 3, 0, Token_Ble },
    { "bra", 3, 0, Token_Bra },
    { "bcc", 3, 0, Token_Bcc },
    { "bcs", 3, 0, Token_Bcs },
    { "bsr", 3, 0, Token_Bsr },
    { "btst", 4, 0, Token_Btst },
    { "bset", 4, 0, Token_Bset },
    { "bclr", 4, 0, Token_Bclr },
    { "bchg", 4, 0, Token_Bchg },
    { "clr", 3, 0, Token_Clr },
    { "cmp", 3, 0, Token_Cmp },
    { "cmpi", 4, 0, Token_Cmpi },
    { "code", 4, 0, Token_Code },
    { "creator", 7, 0, Token_Creator },
    { "d0", 2, 0, Token_d0 },
    { "d1", 2, 0, Token_d1 },
    { "d2", 2, 0, Token_d2 },
    { "d3", 2, 0, Token_d3 },
    { "d4", 2, 0, Token_d4 },
    { "d5", 2, 0, Token_d5 },
    { "d6", 2, 0, Token_d6 },
    { "d7", 2, 0, Token_d7 },
    { "dc", 2, 0, Token_Dc },
    { "data", 4, 0, Token_Data },
    { "divs", 4, 0, Token_Divs },
    { "divu", 4, 0, Token_Divu },
    { "dbra", 4, 0, Token_Dbra },
    { "endproc", 7, 0, Token_EndProc },
    { "end", 3, 0, Token_End },
    { "ext", 3, 0, Token_Ext },
    { "eor", 3, 0, Token_Eor },
    { "eori", 4, 0, Token_Eori },
    { "equ", 3, 0, Token_Equ }, // 54
    { "get", 3, 0, Token_Get },
    { "goto", 4, 0, Token_Goto },
    { "include", 7, 0, Token_Include },
    { "jsr", 3, 0, Token_Jsr },
    { "jmp", 3, 0, Token_Jmp },
    { "link", 4, 0, Token_Link },
    { "lea", 3, 0, Token_Lea },
    { "lsl", 3, 0, Token_Lsl },
    { "lsr", 3, 0, Token_Lsr },
    { "label", 5, 0, Token_Label },
    { "local", 5, 0, Token_Local },
    { "move", 4, 0, Token_Move },
    { "movea", 5, 0, Token_Move },
    { "movem", 5, 0, Token_Movem },
    { "moveq", 5, 0, Token_Moveq },
    { "mulu", 4, 0, Token_Mulu },
    { "muls", 4, 0, Token_Muls },
    { "neg", 3, 0, Token_Neg },
    { "not", 3, 0, Token_Not },
    { "or", 2, 0, Token_Or },
    { "ori", 3, 0, Token_Ori },
    { "pc", 2, 0, Token_PC },
    { "pea", 3, 0, Token_Pea },
    { "prc", 3, 0, Token_Prc },
    { "proc", 4, 0, Token_Proc },
    { "rts", 3, 0, Token_Rts },
    { "rte", 3, 0, Token_Rte },
    { "sp", 2, 0, Token_SP },
    { "sub", 3, 0, Token_Sub },
    { "suba", 4, 0, Token_Suba },
    { "subi", 4, 0, Token_Subi },
    { "subq", 4, 0, Token_Subq },
    { "swap", 4, 0, Token_Swap },
    { "systrap", 7, 0, Token_Systrap },
    { "seq", 3, 0, Token_Seq },
    { "sle", 3, 0, Token_Sle },
    { "sge", 3, 0, Token_Sge },
    { "sgt", 3, 0, Token_Sgt },
    { "slt", 3, 0, Token_Slt },
    { "sne", 3, 0, Token_Sne },
    { "tst", 3, 0, Token_Tst },
    { "trap", 4, 0, Token_Trap },
    { "unlk", 4, 0, Token_Unlk },
    { "+", Token_Error }
};

char reservedWordIndex[26] =
//        a   b   c   d   e   f   g   h   i   j   k   l   m
        { 0, 16, 27, 36, 49, -1, 55, -1, 57, 58, -1, 59, 65,
         71, 73, 75, -1, 79, 80, 93, 95, -1, -1, -1, -1, -1 };
//        n   o   p   q   r   s   t   u   v   w   x   y   z

Token charTokenMap[256] = {
                EndOfInput, NotACharacter, NotACharacter, NotACharacter,
                NotACharacter, NotACharacter, NotACharacter, NotACharacter,
                NotACharacter,
                Whitespace,                             // 09 (tab)
                Whitespace,                             // 0A (LF)
                NotACharacter,
                NotACharacter,
                Whitespace,                             // 0D (CR)
                NotACharacter,
                NotACharacter,
                NotACharacter, NotACharacter, NotACharacter, NotACharacter, // 10
                NotACharacter, NotACharacter, NotACharacter, NotACharacter,
                NotACharacter, NotACharacter, NotACharacter, NotACharacter,
                NotACharacter, NotACharacter, NotACharacter, NotACharacter,
                Whitespace,     // 20 (space)
                Operator, DoubleQuote, Number,
                Dollar, Operator, AddressOf, Operator,
                LeftParen, RightParen, Operator, Plus,
                Comma, Minus, Period, Divide,
                Digit,          // 30 (0)
                Digit,
                Digit,
                Digit,
                Digit,
                Digit,
                Digit,
                Digit,
                Digit,
                Digit,
                Operator, SemiColon, Operator, Operator,
                Operator, Operator,
                Operator,       // 40
                HexDigit, HexDigit, HexDigit, HexDigit,
                HexDigit, HexDigit, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter,
                Operator,       // 5B
                Operator, Operator, Operator, Letter,
                Operator,       // 60
                HexDigit, HexDigit, HexDigit, HexDigit,
                HexDigit, HexDigit, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter,
                Letter, Letter,
                Operator,           // 7B
                Operator, Operator, Operator,
                NotACharacter,      // 7F (DEL)
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter,
                Letter, Letter, Letter, Letter, Letter, Letter, Letter, Letter
};

int errorCount = 0;

char errBuf[128];
void error(char *errMessage)
{
//  int *p = (int *)33;
    FrmCustomAlert(ErrorAlert, errMessage, NULL, NULL);
    errorCount++;
//  *p = 1;
}

Boolean gMatchReservedWords = true;

short comparF(void *A, void *B, Long other)
{
    ReservedWordEntry *a = (ReservedWordEntry *)A;
    ReservedWordEntry *b = (ReservedWordEntry *)B;
    return a->hash - b->hash;
}

int hashEntryIndex[256];

void buildReservedWordHashMap()
{
    int i;
    int hashIndex;
    char curHash;

    for (i = 0; i < MaxReservedWord; i++) {
        int x;
        char hash = 0;
        for (x = 0; x < reservedWordList[i].length; x++)
            hash ^= reservedWordList[i].name[x];
        reservedWordList[i].hash = hash;
    }
    SysQSort(reservedWordList, MaxReservedWord, sizeof(ReservedWordEntry), comparF, 0xDEADBEEF);

    hashEntryIndex[0] = 0;
    hashIndex = 1;
    curHash = 0;
    for (i = 0; i < MaxReservedWord; i++) {
        if (reservedWordList[i].hash != curHash) {
            curHash = reservedWordList[i].hash;
            while (hashIndex <= curHash) {
                hashEntryIndex[hashIndex] = i;
                hashIndex++;
            }
        }
    }
    for (i = hashIndex; i < 255; i++) hashEntryIndex[i] = MaxReservedWord;
}

Boolean findReservedWord(CharPtr startTextPtr, int length, unsigned char hash, int *token)
{
    int hashStartIndex = hashEntryIndex[hash];
    int hashEndIndex;
    int i;

    if (hash == 255)
        hashEndIndex = MaxReservedWord;
    else
        hashEndIndex = hashEntryIndex[hash + 1];

    for (i = hashStartIndex; i < hashEndIndex; i++) {
        ReservedWordEntry *re = &reservedWordList[i];
        if (re->length == length) {
            int x;
            for (x = 0; x < length; x++) {
                if (startTextPtr[x] != re->name[x])
                    break;
            }
            if (x == length) {
                *token = re->token;
                return true;
            }
        }
    }
    return false;

/*
    Char initial = *startTextPtr;
    ReservedWordEntry *re;
    int index = reservedWordIndex[initial - 'a'];

    if (!gMatchReservedWords) return false;

    if ((initial < 'a') || (initial > 'z')) return false;
    if (index == -1) return false;

    re = &reservedWordList[index];
    while (true) {
        if (re->length == length) {
            int x;
            for (x = 0; x < length; x++) {
                if (startTextPtr[x] != re->name[x])
                    break;
            }
            if (x == length) {
                *token = re->token;
                return true;
            }
        }
        re++;
        if (*re->name != initial)
            break;
    }

    return false;
*/
}

/*
char zero = 0;
CharPtr nextChar(CharPtr curTextPtr)
{
    if (sourceIndex == sourceIndexTop)
        return &zero;
    else {
        sourceIndex++;
        curTextPtr = sourceList[sourceIndex].start;
        sourceEnd = sourceList[sourceIndex].end;
        return curTextPtr;
    }
}
*/
Boolean gHasPushBackToken;
int gPushBackToken;
long gPushBackValue;
char gPushBackHash;
CharPtr gPushBackStart;

void pushBack(int tToken, long tValue, CharPtr tStart, char tHash)
{
    if (gHasPushBackToken) {
        error("Only 1 push back token allowed");
    }
    gHasPushBackToken = true;
    gPushBackToken = tToken;
    gPushBackValue = tValue;
    gPushBackStart = tStart;
    gPushBackHash = tHash;
}

struct {
    char *name;
    unsigned char hash;
    int length;
} gIdPool[1000];


Boolean gSubLexer = false;
int gSubLexerLength;
CharPtr startSubLexer(CharPtr tPtr, int length)
{
    gSubLexer = true;
    gSubLexerLength = length;
    return tPtr;
}

CharPtr getNextToken(CharPtr curTextPtr, int *token, long *tValue, CharPtr *tStart, CharPtr hash)
{
    if (gHasPushBackToken) {
        gHasPushBackToken = false;
        *token = gPushBackToken;
        *tValue = gPushBackValue;
        *tStart = gPushBackStart;
        *hash = gPushBackHash;
        return curTextPtr;
    }

    if (gSubLexer) {
        CharPtr savePtr = curTextPtr;
        Boolean oldTokenStream = gTokenStream;
        gTokenStream = false;
        gSubLexer = false;
        curTextPtr = getNextToken(curTextPtr, token, tValue, tStart, hash);
        gTokenStream = oldTokenStream;

        if (*token == Token_EOF)
            return getNextToken(curTextPtr, token, tValue, tStart, hash);

        gSubLexerLength -= (curTextPtr - savePtr);
        if (gSubLexerLength > 0)
            gSubLexer = true;
        return curTextPtr;
    }

    if (gTokenStream) {

      while(true){
	  int tok = *((unsigned char *)curTextPtr)++;
	  while (tok == Whitespace) tok = *((unsigned char *)curTextPtr)++;
	  *token = tok;
	  switch (tok) {
	  case DefinePoolID : {
	    int i;
	    int index = *curTextPtr++ << 8;
	    index |= (*curTextPtr++ & 0xFF);
	    if ((index < 0) || (index >= 1000)) error("too many pool ids defined");
	    curTextPtr++;           // skip Identifier token
	    *tValue = *curTextPtr++;    // length
	    *tStart = curTextPtr;
	    *hash = *curTextPtr++;
	    for (i = 1; i < *tValue; i++)
	      *hash ^= *curTextPtr++;
	    gIdPool[index].name = *tStart;
	    gIdPool[index].length = *tValue;
	    gIdPool[index].hash = *hash;
	    *token = Identifier;
	  }
	    return curTextPtr;
	    //	    break;
	  case PoolID : {
	    int index = *curTextPtr++ << 8;
	    index |= (*curTextPtr++ & 0xFF);
	    if ((index < 0) || (index >= 1000)) error("too many pool ids used");
	    *tStart = gIdPool[index].name;
	    *tValue = gIdPool[index].length;
	    *hash = gIdPool[index].hash;
	    *token = Identifier;
	  }
	    return curTextPtr;
	    //	    break;
	  case Identifier : {
	    int i;
	    *tValue = *curTextPtr++;    // length
	    *tStart = curTextPtr;
	    *hash = *curTextPtr++;
	    for (i = 1; i < *tValue; i++)
	      *hash ^= *curTextPtr++;
	  }
	    return curTextPtr;
	    //	    break;
	  case Zero :
	    *token = Digit;
	    *tValue = 0;
	    return curTextPtr;
	    //	    break;
	  case HexDigit :
	  case Digit :
	    *tValue = (long)(*curTextPtr++) << 24;
	    *tValue |= (long)(*curTextPtr++ & 0xFF) << 16;
	    *tValue |= (long)(*curTextPtr++ & 0xFF) << 8;
	    *tValue |= (long)(*curTextPtr++ & 0xFF);
	    return curTextPtr;
	    //	    break;
	  case DoubleQuote :
	    *tValue = (long)(*curTextPtr++) << 16;
	    *tValue |= (*curTextPtr++ & 0xFF);
	    *tStart = curTextPtr;
	    curTextPtr += *tValue;
	    return curTextPtr;
	    //	    break;
	  case SemiColon :{
	    int i;
	    *tValue = (*curTextPtr++ << 8) &0xFF;    // length
	    *tValue |= (*curTextPtr++ & 0xFF);
	    
	    for (i = 0; i < *tValue; i++)
	      curTextPtr++;
	  }
	    break;
	  default:
	    return curTextPtr;
	  }
	  //	  return curTextPtr;
      }
    }

    while (true) {
        CharPtr startPtr = curTextPtr;
        int chToken;
/*
        if ((*curTextPtr >= 128) || (*curTextPtr < 0)) {
            *token = Token_Error;
            return curTextPtr;
        }
*/
        chToken = charTokenMap[(UChar)*curTextPtr++];	
/*
        if (curTextPtr != sourceEnd)
            curTextPtr++;
        else
            curTextPtr = nextChar(curTextPtr);
*/
        switch (chToken) {
            case SemiColon :
                while ((*curTextPtr != 0)
                         && (*curTextPtr != '\n')
                         && (*curTextPtr != '\r'))
//                  if (curTextPtr != sourceEnd)
                        curTextPtr++;
//                  else
//                      curTextPtr = nextChar(curTextPtr);
                break;
            case HexDigit :
            case Letter : {
                    int length = 1;
                    *hash = *startPtr;
                    while (/*(*curTextPtr >= 0) && (*curTextPtr <= 127)
                            && */((charTokenMap[(UChar)(*curTextPtr)] == Letter)
                                    || (charTokenMap[(UChar)(*curTextPtr)] == HexDigit)
                                    || (charTokenMap[(UChar)*curTextPtr] == Digit))) {
                        *hash ^= *curTextPtr;
//                      if (curTextPtr != sourceEnd)
                            curTextPtr++;
//                      else
//                          curTextPtr = nextChar(curTextPtr);
                        length++;
                    }
                    if (/* (*curTextPtr < 0) || (*curTextPtr > 127)
                            || */ (charTokenMap[(UChar)*curTextPtr] == NotACharacter)) {
                        *token = Token_Error;
                        return curTextPtr;
                    }
                    if (!findReservedWord(startPtr, length, *hash, token)) {
                        *tValue = length;
                        *tStart = startPtr;
                        *token = Identifier;
                    }
                    return curTextPtr;
                }
            case DoubleQuote : {
                    Boolean wasEscaped = false;
                    while (/* (*curTextPtr >= 0) && (*curTextPtr <= 127)
                            && */ ((charTokenMap[(UChar)(*curTextPtr)] != DoubleQuote)
                                    || (wasEscaped))
                            && (*curTextPtr != '\n')
                            && (*curTextPtr != '\r')
                            && (charTokenMap[(UChar)(*curTextPtr)] != NotACharacter)) {
                        wasEscaped = !wasEscaped && (*curTextPtr == '\\');
//                      if (curTextPtr != sourceEnd)
                            curTextPtr++;
//                      else
//                          curTextPtr = nextChar(curTextPtr);
                    }
                    if (charTokenMap[(UChar)(*curTextPtr)] != DoubleQuote) {
                        *token = Token_Error;
                        return curTextPtr;
                    }
//                  if (curTextPtr != sourceEnd)
                        curTextPtr++;
//                  else
//                      curTextPtr = nextChar(curTextPtr);
                    *tValue = curTextPtr - startPtr - 2;
                    *tStart = startPtr + 1;
                    *token = DoubleQuote;
                }
                return curTextPtr;
            case Digit : {
                    long value = *startPtr - '0';;
                    while (/* (*curTextPtr >= 0) && (*curTextPtr <= 127)
                            && */ (charTokenMap[(UChar)*curTextPtr] == Digit)) {
                        value = (value * 10) + (*curTextPtr - '0');
//                      if (curTextPtr != sourceEnd)
                            curTextPtr++;
//                      else
//                          curTextPtr = nextChar(curTextPtr);
                    }
                    if (/* (*curTextPtr < 0) || (*curTextPtr > 127)
                            || */ (charTokenMap[(UChar)*curTextPtr] == NotACharacter)) {
                        *token = Token_Error;
                        return curTextPtr;
                    }
                    *token = Digit;
                    *tValue = value;
                    return curTextPtr;
                }
            case Dollar : {
                    long value = 0;
                    while (/* (*curTextPtr >= 0) && (*curTextPtr <= 127)
                            && */ ((charTokenMap[(UChar)*curTextPtr] == Digit)
                                || (charTokenMap[(UChar)(*curTextPtr)] == HexDigit))) {
                        if (charTokenMap[(UChar)*curTextPtr] == Digit)
                            value = (value * 16) + (*curTextPtr - '0');
                        else
                            if (*curTextPtr <= 'F')
                                value = (value * 16) + (*curTextPtr - 'A' + 10);
                            else
                                value = (value * 16) + (*curTextPtr - 'a' + 10);
//                      if (curTextPtr != sourceEnd)
                            curTextPtr++;
//                      else
//                          curTextPtr = nextChar(curTextPtr);
                    }
                    if (/* (*curTextPtr < 0) || (*curTextPtr > 127)
                            || */ (charTokenMap[(UChar)*curTextPtr] == NotACharacter)) {
                        *token = Token_Error;
                        return curTextPtr;
                    }
                    if ((curTextPtr - startPtr) > 1) {
                        *tValue = value;
                        *token = HexDigit;
                        return curTextPtr;
                    }
                    else {
                        *token = Token_Error;
                        return curTextPtr;
                    }
                }
            case Operator :
            case NotACharacter :
                *token = Token_Error;
                return curTextPtr;
            case EndOfInput :
                *token = Token_EOF;
                return curTextPtr;
            case Whitespace :
                break;
            default :
                *token = charTokenMap[(UChar)*startPtr];
                return curTextPtr;
        }
    }
}

CharPtr getSizeSpec(CharPtr curTextPtr, int *sizeSpec, Boolean allowNumber)
{
    CharPtr startPtr;
    int token;
    long value;
    //CharPtr savePtr = curTextPtr;
    int spec = WordSize;            // default if none
    char hash;

    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
    switch (token) {
        case ByteSpec :
            spec = ByteSize;
            break;
        case WordSpec :
            spec = WordSize;
            break;
        case LongSpec :
            spec = LongSize;
            break;
        case Period : {
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if (token == Identifier) {
                    if (value == 1) {
                        if (*startPtr == 'b')
                            spec = ByteSize;
                        else
                            if (*startPtr == 'w')
                                spec = WordSize;
                            else
                                if (*startPtr == 'l')
                                    spec = LongSize;
                                else {
                                    error("invalid size specification");
                                    return NULL;
                                }
                    }
                    else {
                        error("invalid size specification");
                        return NULL;
                    }
                }
                else {
                    if (token == Digit) {
                        spec = -value;
                    }
                }
            }
            break;
        default :
            pushBack(token, value, startPtr, hash);
            break;
    }

    *sizeSpec = spec;
    return curTextPtr;
}

Boolean getBuffers()
{
    if (objectCodeHandle == NULL) {
        objectCodeSize = 1024;
        objectCodeHandle = MemHandleNew(objectCodeSize);
        if (objectCodeHandle == NULL) {
            error("Fatal RAM loss (1)");
            return false;
        }
        objectCodeTop = 0;
        objectCodePtr = MemHandleLock(objectCodeHandle);
    }
    if (dataHandle == NULL) {
        dataSize = 256;
        dataHandle = MemHandleNew(dataSize);
        if (dataHandle == NULL) {
            error("Fatal RAM loss (2)");
            return false;
        }
        dataTop = 0;
    }
    if (branchListHandle == NULL) {
        branchListSize = 1024;
        branchListHandle = MemHandleNew(branchListSize);
        if (branchListHandle == NULL) {
            error("Fatal RAM loss (3)");
            return false;
        }
        branchList = MemHandleLock(branchListHandle);
    }
    return true;
}

void addDataByte(char aByte)
{
    char *p;
    if ((dataTop + 1) >= dataSize) {
        int err;
        dataSize += 256;
        err = MemHandleResize(dataHandle, dataSize);
        if (err) {
            error("Fatal RAM emptiness");
            return;
        }
    }
    p = (char *)(MemHandleLock(dataHandle));
    p[dataTop] = aByte;
    MemHandleUnlock(dataHandle);
    dataTop++;
}

void addDataWord(short aWord)
{
    short *p;
    if ((dataTop + 2) >= dataSize) {
        int err;
        dataSize += 256;
        err = MemHandleResize(dataHandle, dataSize);
        if (err) {
            error("Fatal RAM emptiness");
            return;
        }
    }
    p = (short *)(MemHandleLock(dataHandle));
    p[dataTop >> 1] = aWord;
    MemHandleUnlock(dataHandle);
    dataTop += 2;
}

Boolean ensureCode()
{
    int i;
    int err;

    if (objectCodeTop == objectCodeSize) {
        objectCodeSize += 1024;
        MemHandleUnlock(objectCodeHandle);
        MemHandleUnlock(branchListHandle);
        err = MemHandleResize(objectCodeHandle, objectCodeSize);
        if (err) {
            error("Fatal RAM emptiness (2)");
            return false;
        }
        objectCodePtr = MemHandleLock(objectCodeHandle);
        branchList = MemHandleLock(branchListHandle);
    }
    i = (objectCodeTop - procStart) >> 1;
    if (i >= branchListSize) {
        MemHandleUnlock(objectCodeHandle);
        MemHandleUnlock(branchListHandle);
        branchListSize += 512;
        err = MemHandleResize(branchListHandle, branchListSize);
        if (err) {
            error("Fatal RAM emptiness (3)");
            return false;
        }
        objectCodePtr = MemHandleLock(objectCodeHandle);
        branchList = MemHandleLock(branchListHandle);
        for (i = (branchListSize - 512); i < branchListSize; i++) {
            branchList[i] = Nothing;
        }
    }
    return true;
}

void addWord(short aWord)
{
    short *p;
    if (!ensureCode()) return;
    p = (short *)objectCodePtr;
    p[objectCodeTop >> 1] = aWord;
    objectCodeTop += 2;
}

void addCodeByte(unsigned char aByte)
{
    short *p;
    if (!ensureCode()) return;
    p = (short *)objectCodePtr;
    if (objectCodeTop & 1)
        p[objectCodeTop >> 1] = (p[objectCodeTop >> 1] & 0xFF00) | (aByte & 0xFF);
    else
        p[objectCodeTop >> 1] = (aByte << 8);
    objectCodeTop += 1;
}


void addStringConstantToCode(CharPtr stringConstant, int length)
{
    int i = 0;
    int t = 0;
    CharPtr s = stringConstant;
    while (i < length) {
        if (*s == '\\') {
            s++;
            i++;
            switch (*s) {
                case '0' :
                case '1' :
                case '2' :
                case '3' :
                case '4' :
                case '5' :
                case '6' :
                case '7' :
                    t = *s++ - '0';
                    i++;
                    while ((*s >= '0') && (*s <= '7')) {
                        t = (t << 3) | (*s++ - '0');
                        i++;
                    }
                    addCodeByte(t);
                    break;
                case 'x' :
                    s++;
                    i++;
                    while ( ((*s >= '0') && (*s <= '9'))
                                || ((*s >= 'A') && (*s <= 'F'))
                                || ((*s >= 'a') && (*s <= 'f')) ) {
                        t <<= 4;
                        if ((*s >= '0') && (*s <= '9'))
                            t += *s++ - '0';
                        else
                            if (*s > 'F')
                                t += *s++ - 'a' + 10;
                            else
                                t += *s++ - 'A' + 10;
                        i++;
                    }
                    addCodeByte(t);
                    break;
                case 'n' :
                    addCodeByte('\n');
                    s++;
                    i++;
                    break;
                case 'r' :
                    addCodeByte('\r');
                    s++;
                    i++;
                    break;
                case 't' :
                    addCodeByte('\t');
                    s++;
                    i++;
                    break;
                case '\\' :
                    addCodeByte('\\');
                    s++;
                    i++;
                    break;
                case '"' :
                    addCodeByte('"');
                    s++;
                    i++;
                    break;
                default :
                    addCodeByte('\\');
                    addCodeByte(*s);
                    s++;
                    i++;
                    break;
            }
        }
        else {
            addCodeByte(*s++);
            i++;
        }
    }
    addCodeByte(0);
    if (objectCodeTop & 1) addCodeByte(0);
}

Boolean stashCode()
{
    char *codeBase;
    while ((objectCodeTop + gCodeStashTop) >= gCodeStashSize) {
        gCodeStashSize += 1024;
        gCodeStashH = DmResizeRecord(codeCopyDB, 0, gCodeStashSize);
        if (gCodeStashH == NULL) {
            error("Fatal RAM emptiness (4)");
            return false;
        }
    }
    codeBase = MemHandleLock(gCodeStashH);
    DmWrite(codeBase, gCodeStashTop, objectCodePtr, objectCodeTop);
    MemHandleUnlock(gCodeStashH);
    gCodeStashTop += objectCodeTop;
    objectCodeTop = 0;
    return true;
}

void setCodeTop(long codeTop)
{
    objectCodeTop = codeTop;
}

long getPC()
{
    return objectCodeTop;
}

int getDataOffset()
{
    return dataTop;
}

void resetObjectCode()
{
    if (objectCodeHandle != NULL) {
        MemHandleUnlock(objectCodeHandle);
        MemHandleFree(objectCodeHandle);
    }
    objectCodeHandle = NULL;
    if (branchListHandle != NULL) {
        MemHandleUnlock(branchListHandle);
        MemHandleFree(branchListHandle);
    }
    branchListSize = 0;
    branchListHandle = NULL;
    objectCodeSize = 0;
    objectCodeTop = 0;
    gCodeStashTop = 0;

    if (dataHandle != NULL)
        MemHandleFree(dataHandle);
    dataHandle = NULL;
    dataSize = 0;
    dataTop = 0;
    if (dataInit != NULL)
        MemHandleFree(dataInit);
    if (codeInit != NULL)
        MemHandleFree(codeInit);
    dataInit = NULL;
    dataInitSize = 0;
    codeInit = NULL;
    codeInitSize = 0;
}

char *prcName = "Aardvark";
char *versionString = "version 1.0 build 0001";

typedef struct {
    short flags;
    long stackSize;
    long heapSize;
} ApplPref;

ApplPref prefData = {
    sysAppLaunchFlagNewStack|sysAppLaunchFlagNewGlobals|sysAppLaunchFlagUIApp|sysAppLaunchFlagSubCall,
    0x1000,
    0x1000
};

void lockAllDataHandles()
{
    globalDataFixupList = MemHandleLock(globalDataFixupListH);
    localCodeLabelList = MemHandleLock(localCodeLabelListH);
    globalCodeFixupList = MemHandleLock(globalCodeFixupListH);
    globalDataLabelList = MemHandleLock(globalDataLabelListH);
    globalCodeLabelList = MemHandleLock(globalCodeLabelListH);
    gSymbolDataList = MemHandleLock(gSymbolDataH);
    gSymbolString = MemHandleLock(gSymbolStringH);
}

void unlockAllDataHandles()
{
    MemHandleUnlock(globalDataFixupListH);
    MemHandleUnlock(localCodeLabelListH);
    MemHandleUnlock(globalCodeFixupListH);
    MemHandleUnlock(globalDataLabelListH);
    MemHandleUnlock(globalCodeLabelListH);
    MemHandleUnlock(gSymbolDataH);
    MemHandleUnlock(gSymbolStringH);
}

SymbolData zeroSym = {
    -1,
    0,              // offset field, used for flags
    0,              // size field - count of # entries
    SymBase, DBG_Unknown
};

void addSymbol(CharPtr name, int nameLength, SymFlag flag, int offset, int size, DBG_TypeFlag type)
{
    SymbolData lsd;

    if (name &&
            (name[0] == 't')
            && ((name[1] >= '0') && (name[1] <= '9'))
            && ((name[2] >= '0') && (name[2] <= '9'))
            && ((name[3] >= '0') && (name[3] <= '9')) )
        return;

    if (gSymbolDataListTop == gMaxSymbolData) {
        unlockAllDataHandles();
        gMaxSymbolData += 64;
        gSymbolDataH = DmResizeRecord(dataDB, gSymbolDataIndex, sizeof(SymbolData) * gMaxSymbolData);
        if (gSymbolDataH == NULL) {
            error("Out of memory (55)");
            return;
        }
        lockAllDataHandles();
    }

    if ((nameLength > 3) && (name[nameLength - 3] == '_'))
        nameLength -= 3;

    if ((gSymbolStringTop + nameLength + 1) >= gMaxSymbolString) {
        unlockAllDataHandles();
        gMaxSymbolString += 256 + nameLength;
        gSymbolStringH = DmResizeRecord(dataDB, gSymbolStringIndex, gMaxSymbolString);
        if (gSymbolStringH == NULL) {
            error("Out of memory (56)");
            return;
        }
        lockAllDataHandles();
    }

    lsd.nameOffset = gSymbolStringTop;
    DmWrite(gSymbolString, gSymbolStringTop, name, nameLength);
    gSymbolStringTop += nameLength;
    nameLength = 0;
    DmWrite(gSymbolString, gSymbolStringTop, &nameLength, 1);
    gSymbolStringTop++;

    lsd.flag = flag;
    lsd.offset = offset;
    lsd.size = size;
    lsd.type = type;
    lsd.debugAction = NoAction;
    DmWrite(gSymbolDataList, gSymbolDataListTop * sizeof(SymbolData), &lsd, sizeof(SymbolData));
    gSymbolDataListTop++;
    zeroSym.size = gSymbolDataListTop;
    DmWrite(gSymbolDataList, 0, &zeroSym, sizeof(SymbolData));
}

void addGlobalSymbol(long index)
{
    long i = (index & 0xFFFF);
    addSymbol(globalCodeLabelList[i].name,
                globalCodeLabelList[i].length, SymCode,
                globalCodeLabelList[i].offset + sizeof(startupCode),
                globalCodeLabelList[i].size, DBG_Unknown);
}
/*
void buildSymbolInfo()
{
    long i;
    for (i = 0; i < globalCodeLabelTop; i++) {
        addSymbol(globalCodeLabelList[i].name,
                    globalCodeLabelList[i].length, true,
                    globalCodeLabelList[i].offset + sizeof(startupCode),
                    globalCodeLabelList[i].size - globalCodeLabelList[i].offset);
    }
}
*/
Ptr prepareDataSeg(int *dataSegSize)
{
  Ptr result/*,dataSegPtr,dataPtr*/;
  CharPtr dataSegPtr, dataPtr;
    int totalSize;
    int i;
    int initChunkSize;

    initChunkSize = (totalDataSize >> 7) * 129; // each - 0xFF followed by 128 bytes of raw data
    if ((totalDataSize & 0x7F) != 0) initChunkSize += 1 + (totalDataSize & 0x7F);   // the remainder block

    initChunkSize++;        // the end-of-compressed stream marker

    totalSize = 4 + 4 + initChunkSize + 5 + 5;  // offset to xref, start offset, chunks, 2 empty blocks
    *dataSegSize = totalSize;
    result = MemPtrNew(totalSize);
    if (result == NULL) {
        error("out of memory (11)");
        return NULL;
    }

    ((long *)result)[0] = totalSize;        // offset to xref, beyond end
    ((long *)result)[1] = -totalDataSize;
    dataSegPtr = (CharPtr)result + 8;


    dataPtr = (CharPtr) MemHandleLock(dataHandle);

    for (i = 0; i < (totalDataSize >> 7); i++) {
        int j;
        *dataSegPtr++ = 0xFF;
        for (j = 0; j < 128; j++)
            *dataSegPtr++ = *dataPtr++;
    }
    if ((totalDataSize & 0x7F) != 0) {
        *dataSegPtr++ = 0x80 + ((totalDataSize & 0x7F) - 1);
        for (i = 0; i < (totalDataSize & 0x7F); i++)
            *dataSegPtr++ = *dataPtr++;
    }
    *dataSegPtr++ = 0;  // end-of-compressed stream
    for (i = 0; i < 10; i++)
        *dataSegPtr++ = 0;      // 2 empty blocks


    MemHandleUnlock(dataHandle);

    return result;

}

Boolean addCodeResource(char *sourceName, int segNumber, LocalID *lid, Boolean addLongMath, ULong type)
{
    DmOpenRef prcDB;
    Handle resH;
    CharPtr resPtr;
    Boolean didDelete;

    if (gCodeStashTop) {
        long codeSize = gCodeStashTop;
        short *codeBase = MemHandleLock(gCodeStashH);

        setStatus("Adding code resource ... ", sourceName, StrLen(sourceName));

        *lid = DmFindDatabase(0, sourceName);
        if (*lid == 0) {
            if (DmCreateDatabase(0, sourceName, gCreator, gType, true)) {
                error("Couldn't create code resource PRC");
                return false;
            }
            *lid = DmFindDatabase(0, sourceName);
        }
        else
            DmSetDatabaseInfo(0, *lid, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &gCreator);
        prcDB = DmOpenDatabase(0, *lid, dmModeReadWrite);

        do {
            UInt resCount;
            UInt i;
            didDelete = false;
            resCount = DmNumResources(prcDB);
            for (i = 0; i < resCount; i++) {
                ULong resType;
                UShort resID;
                Err err;
                err = DmResourceInfo(prcDB, i, &resType, &resID, NULL);
                if (resType == type) {
                    if (resID == segNumber) {
                        DmRemoveResource(prcDB, i);
                        didDelete = true;
                        break;
                    }
                    else {
                        if (gSegCount) {
                            int j;
                            for (j = 0; j < gSegCount; j++) {
                                if (resID == gSegContents[j].segNumber) {
                                    DmRemoveResource(prcDB, i);
                                    didDelete = true;
                                    break;
                                }
                            }
                            if (didDelete) break;
                        }
                    }
                }
            }
        } while (didDelete);

        if (addLongMath)
            resH = DmNewResource(prcDB, type, segNumber, codeSize + sizeof(longMathCode));
        else
            resH = DmNewResource(prcDB, type, segNumber, codeSize);

        if (resH == NULL) {
            error("out of memory (20)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        DmWrite(resPtr, 0, codeBase, codeSize);
        if (addLongMath)
            DmWrite(resPtr, codeSize, longMathCode, sizeof(longMathCode));
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
        MemHandleUnlock(gCodeStashH);

        if (gSegCount) {
            int j;
            for (j = 0; j < gSegCount; j++) {
                Long size = MemHandleSize(gSegContents[j].codeStash);
                if (gSegContents[j].addLongMath)
                    resH = DmNewResource(prcDB, type, gSegContents[j].segNumber, size + sizeof(longMathCode));
                else
                    resH = DmNewResource(prcDB, type, gSegContents[j].segNumber, size);
                if (resH == NULL) {
                    error("out of memory (21)");
                    return false;
                }
                resPtr = MemHandleLock(resH);
                DmWrite(resPtr, 0, MemHandleLock(gSegContents[j].codeStash), size);
                if (gSegContents[j].addLongMath)
                    DmWrite(resPtr, size, longMathCode, sizeof(longMathCode));
                MemHandleUnlock(gSegContents[j].codeStash);
                MemHandleUnlock(resH);
                DmReleaseResource(resH);
            }
        }

        DmCloseDatabase(prcDB);

    }
    setStatus("Finished", NULL, 0);

    return true;
}

Boolean writePRC(char *sourceName, long mainOffset, LocalID *lid, Boolean addLongMath, Boolean debug)
{
    Handle resH;
    CharPtr resPtr;
    DmOpenRef prcDB;
    ULong codeResSize;
    ULong offset;
    UInt16 dbattrs;

    long codeSize = gCodeStashTop;
    short *codeBase = MemHandleLock(gCodeStashH);

    *lid = DmFindDatabase(0, sourceName);

    setStatus("Writing PRC ... ", sourceName, StrLen(sourceName));

    if (*lid != 0) {
        UInt resCount;
        UInt i;
        Boolean didDelete;
        DmSetDatabaseInfo(0, *lid, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, &gCreator);
        prcDB = DmOpenDatabase(0, *lid, dmModeReadWrite);

        if (debug && (gSymbolDataListTop > 0)) {
            int i,j;
            Handle h = DmGet1Resource('Symb', 1);
            if (h) {
                SymbolData *oldSym = MemHandleLock(h);
                int oldCount = oldSym[0].size;
                for (i = 1; i < gSymbolDataListTop; i++) {
                    if (gSymbolDataList[i].flag == SymCode) {
                        // try the same slot in the old, in case this is a simple rebuild
                        if ((oldSym[i].flag == SymCode)
                                && (StrCompare(&gSymbolString[oldSym[i].nameOffset], &gSymbolString[gSymbolDataList[i].nameOffset]) == 0))
                            DmWrite(gSymbolDataList, (char *)(&gSymbolDataList[i].debugAction) - (char *)gSymbolDataList, &oldSym[i].debugAction, sizeof(char));
                        else {
                            for (j = 1; j < oldCount; j++) {
                                if ((oldSym[j].flag == SymCode)
                                        && (StrCompare(&gSymbolString[oldSym[j].nameOffset], &gSymbolString[gSymbolDataList[i].nameOffset]) == 0)) {
                                    DmWrite(gSymbolDataList, (char *)(&gSymbolDataList[i].debugAction) - (char *)gSymbolDataList, &oldSym[i].debugAction, sizeof(char));
                                    break;
                                }
                            }
                        }
                    }
                }
                MemHandleUnlock(h);
            }
        }

        do {
            didDelete = false;
            resCount = DmNumResources(prcDB);
            for (i = 0; i < resCount; i++) {
                ULong resType;
                UShort resID;
                Err err;
                err = DmResourceInfo(prcDB, i, &resType, &resID, NULL);
                if (((resType == 'code') && (resID == 0))
                        || ((resType == 'code') && (resID == 1))
                        || ((resType == 'data') && (resID == 0))
                        || ((resType == 'data') && (resID == 2))
                        || ((resType == 'Symb') && (resID == 1))
                        || ((resType == 'SymS') && (resID == 1))
                        || ((resType == 'data') && (resID == 1))) {
                    DmRemoveResource(prcDB, i);
                    didDelete = true;
                    break;
                }
            }
        } while (didDelete);
    }
    else {
        if (DmCreateDatabase(0, sourceName, gCreator, gType, true) != 0) {
            error("Couldn't create prc database");
            return false;
        }
        *lid = DmFindDatabase(0, sourceName);
	// Set the Backup bit.
	if (DmDatabaseInfo (0, *lid, NULL, &dbattrs, NULL, NULL, NULL,
			    NULL, NULL, NULL, NULL, NULL, NULL) == 0){
	  dbattrs |= dmHdrAttrBackup;
	  (void) DmSetDatabaseInfo (0, *lid, NULL, &dbattrs, NULL, NULL,
				    NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	}
        prcDB = DmOpenDatabase(0, *lid, dmModeReadWrite);
        // tver
        resH = DmNewResource(prcDB, 'tver', 1, StrLen(versionString) + 1);
        if (resH == NULL) {
            error("out of memory (12)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        DmStrCopy(resPtr, 0, versionString);
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
        // pref
        resH = DmNewResource(prcDB, 'pref', 1, sizeof(ApplPref));
        if (resH == NULL) {
            error("out of memory (13)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        DmWrite(resPtr, 0, &prefData, sizeof(ApplPref));
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
    }


// code 0
    resH = DmNewResource(prcDB, 'code', 0, CodeZeroSize);
    if (resH == NULL) {
        error("out of memory (14)");
        return false;
    }
    resPtr = MemHandleLock(resH);
    codeZeroData[1] = totalDataSize;
    DmWrite(resPtr, 0, &codeZeroData, CodeZeroSize);
    MemHandleUnlock(resH);
    DmReleaseResource(resH);
// data 0
    if (totalDataSize == 0) {
        resH = DmNewResource(prcDB, 'data', 0, DataZeroSize);
        if (resH == NULL) {
            error("out of memory (15)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        DmWrite(resPtr, 0, &dataZeroData, DataZeroSize);
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
    }
    else {
        int dataSegSize;
        Ptr p;
        Ptr dataSeg = prepareDataSeg(&dataSegSize);
        if (dataSeg == NULL) return false;
        resH = DmNewResource(prcDB, 'data', 0, dataSegSize);
        if (resH == NULL) {
            error("out of memory (16)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        DmWrite(resPtr, 0, dataSeg, dataSegSize);
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
        MemPtrFree(dataSeg);
// data 1
        resH = DmNewResource(prcDB, 'data', 1, dataInitSize);
        if (resH == NULL) {
            error("out of memory (17)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        p = MemHandleLock(dataInit);
        DmWrite(resPtr, 0, p, dataInitSize);
        MemHandleUnlock(dataInit);
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
// data 2
        resH = DmNewResource(prcDB, 'data', 2, codeInitSize);
        if (resH == NULL) {
            error("out of memory (18)");
            return false;
        }
        resPtr = MemHandleLock(resH);
        p = MemHandleLock(codeInit);
        DmWrite(resPtr, 0, p, codeInitSize);
        MemHandleUnlock(codeInit);
        MemHandleUnlock(resH);
        DmReleaseResource(resH);
    }

// code 1
    if (mainOffset != -1) {
        long offsetValue = (mainOffset + sizeof(startupCode)) - (jsrToMainOffset * 2);
        if (offsetValue > 32767) {
            error("PilotMain too far from start of code segment");
            return false;
        }
        startupCode[jsrToMainOffset] = (mainOffset + sizeof(startupCode)) - (jsrToMainOffset * 2);
    }

//  startupCode[36] = 0x4e71;
//  startupCode[37] = 0x4e71;

    startupCode[dataInitSizeOffset] = dataInitSize;
    startupCode[dataBaseOffset] = -totalDataSize;

    codeResSize = sizeof(startupCode) + codeSize;
    if (addLongMath)
        codeResSize += sizeof(longMathCode);

#if DEBUG_SUPPORT
    if (debug)
        codeResSize += SizeOfDebugCode;
#endif

    resH = DmNewResource(prcDB, 'code', 1, codeResSize);
    if (resH == NULL) {
        error("out of memory (19)");
        return false;
    }
    resPtr = MemHandleLock(resH);
    DmWrite(resPtr, 0, startupCode, sizeof(startupCode));
    DmWrite(resPtr, sizeof(startupCode), codeBase, codeSize);
    offset = sizeof(startupCode) + codeSize;
    if (addLongMath) {
        DmWrite(resPtr, offset, longMathCode, sizeof(longMathCode));
        offset += sizeof(longMathCode);
    }

#if DEBUG_SUPPORT
    if (debug)
        DmWrite(resPtr, offset, StartOfDebugCode, SizeOfDebugCode);
#endif

    MemHandleUnlock(resH);
    DmReleaseResource(resH);

    MemHandleUnlock(gCodeStashH);

    if (debug) {
        if (gSymbolDataListTop > 0) {
            resH = DmNewResource(prcDB, 'Symb', 1, sizeof(SymbolData) * gSymbolDataListTop);
            resPtr = MemHandleLock(resH);
            DmWrite(resPtr, 0, gSymbolDataList, sizeof(SymbolData) * gSymbolDataListTop);
            MemHandleUnlock(resH);
            DmReleaseResource(resH);

            resH = DmNewResource(prcDB, 'SymS', 1, gSymbolStringTop);
            resPtr = MemHandleLock(resH);
            DmWrite(resPtr, 0, gSymbolString, gSymbolStringTop);
            MemHandleUnlock(resH);
            DmReleaseResource(resH);
        }
    }
    DmCloseDatabase(prcDB);

    setStatus("Finished", NULL, 0);

    return true;

}

Boolean finish(LocalID *lid, Boolean debug, Boolean *executable, ULong prjType)
{
    Boolean success = true;
    int i;
    CharPtr dataInitP = NULL;
    CharPtr codeInitP = NULL;
    short *dataP;
    UInt *codebase;
    Boolean foundMathName = false;
    ULong codeSize;

    totalDataSize = dataTop;
    if ((totalDataSize & 3) != 0) {
        for (i = 0; i < (4 - (totalDataSize & 3)); i++)
            addDataByte(0);
        totalDataSize = dataTop;
    }

    codeInitSize = dataInitSize = (totalDataSize >> 1);                 // 1 bit per word
    if (dataInitSize > 0) {
        if ((dataInitSize & 0x7) != 0) dataInitSize += 8 - (dataInitSize & 0x7);    // whole number of bytes
        dataInitSize >>= 3;
        codeInitSize = dataInitSize;
        dataInit = MemHandleNew(dataInitSize);
        if (dataInit == NULL) {
            error("out of memory (9)");
            return false;
        }
        dataInitP = MemHandleLock(dataInit);
        MemSet(dataInitP, dataInitSize, 0);
        codeInit = MemHandleNew(codeInitSize);
        if (codeInit == NULL) {
            error("out of memory (10)");
            return false;
        }
        codeInitP = MemHandleLock(codeInit);
        MemSet(codeInitP, codeInitSize, 0);
    }
    else
        codeInit = dataInit = NULL;

    dataP = (short *)(MemHandleLock(dataHandle));

    for (i = 0; i < globalDataLabelTop; i++) {
        LabelData localD;
        if (globalDataLabelList[i].offset == -1) {
            int t,x;
            StrCopy(errBuf, "Undefined global data label ");
            t = StrLen(errBuf);
            for (x = 0; x < globalDataLabelList[i].length; x++)
                errBuf[t + x] = globalCodeLabelList[i].name[x];
            errBuf[t + x] = '\0';
            error(errBuf);
            success = false;
            break;
        }
        localD = globalDataLabelList[i];
        localD.offset = -(totalDataSize - localD.offset);
        DmWrite(globalDataLabelList, sizeof(LabelData) * i, &localD, sizeof(LabelData));
    }

    if (!stashCode()) return false;
    codebase = MemHandleLock(gCodeStashH);
    codeSize = gCodeStashTop;

    for (i = 0; i < globalCodeFixupTop; i++) {
        int j;
        LabelData *tgtLabel = &globalCodeLabelList[globalCodeFixupList[i].index];
        for (j = 0; j < 5; j++) {
            if ((longMath[j].length == tgtLabel->length)
                    && (longMath[j].hash == tgtLabel->hash)) {
                int x;
                foundMathName = true;
                for (x = 0; x < longMath[j].length; x++) {
                    if (longMath[j].name[x] != tgtLabel->name[x]) {
                        foundMathName = false;
                        break;
                    }
                }
                if (foundMathName) {
                    int k;
                    for (k = 0; k < 5; k++) {
                        if (addGlobalCodeLabel(longMath[k].name, longMath[k].length, longMath[k].hash, longMath[k].offset + codeSize) == -9999)
                            return false;
                    }
                    break;
                }
            }
        }
        if (foundMathName) break;
    }

#if DEBUG_SUPPORT
    if (debug) {
        long offset = codeSize;
        if (foundMathName)
            offset += sizeof(longMathCode);
        if (addGlobalCodeLabel(DebugEntryName, DebugEntryNameLength, DebugEntryNameHash, offset + OffsetOfDebugEntry) == -9999)
            return false;
        if (addGlobalCodeLabel(DebugInitName, DebugInitNameLength, DebugInitNameHash, offset + OffsetOfDebugInit) == -9999)
            return false;
        if (addGlobalCodeLabel(DebugExitName, DebugExitNameLength, DebugExitNameHash, offset + OffsetOfDebugExit) == -9999)
            return false;
        if (addGlobalCodeLabel(DebugTermName, DebugTermNameLength, DebugTermNameHash, offset + OffsetOfDebugTerm) == -9999)
            return false;
    }
#endif

    for (i = 0; i < globalCodeFixupTop; i++) {
        long targetOffset = globalCodeLabelList[globalCodeFixupList[i].index].offset;
        if (targetOffset == -1) {
            int t,x;
//          StrCopy(errBuf, "Global fixup to unknown code label ");
            StrPrintF(errBuf, "Global fixup from %ld(%d)%d %d to unknown code label ",
                    globalCodeFixupList[i].offset, globalCodeFixupList[i].fromCode,
                    codebase[(globalCodeFixupList[i].offset - 2) >> 1],
                    codebase[(globalCodeFixupList[i].offset) >> 1]
                    );
            t = StrLen(errBuf);
            for (x = 0; x < globalCodeLabelList[globalCodeFixupList[i].index].length; x++)
                errBuf[t + x] = globalCodeLabelList[globalCodeFixupList[i].index].name[x];
            errBuf[t + x] = '\0';
            error(errBuf);
            success = false;
            break;
        }
        if (globalCodeFixupList[i].fromCode) {
            UInt t = codebase[globalCodeFixupList[i].offset >> 1];
            t += targetOffset - globalCodeFixupList[i].offset;
            if (((targetOffset - globalCodeFixupList[i].offset) >= 32768)
                    || ((targetOffset - globalCodeFixupList[i].offset) <= -32768)) {
                int t,x;
                StrCopy(errBuf, "Fixup to ");
                t = StrLen(errBuf);
                for (x = 0; x < globalCodeLabelList[globalCodeFixupList[i].index].length; x++)
                    errBuf[t + x] = globalCodeLabelList[globalCodeFixupList[i].index].name[x];
                errBuf[t + x] = '\0';
                StrCat(errBuf, " beyond 32k displacement");
                error(errBuf);
                success = false;
                break;
            }
            DmWrite(codebase, globalCodeFixupList[i].offset, &t, sizeof(UInt));
        }
        else {
            int offsetInCodeInit = globalCodeFixupList[i].offset >> 1;
            *((long *)(&dataP[globalCodeFixupList[i].offset >> 1])) += targetOffset;
            codeInitP[offsetInCodeInit >> 3] |= 1 << (7 - (offsetInCodeInit & 0x7));
        }
    }

    for (i = 0; i < globalDataFixupTop; i++) {
        long targetOffset = globalDataLabelList[globalDataFixupList[i].index].offset;
        if (targetOffset == -1) {
            error("Global fixup to unknown data label");
            success = false;
            break;
        }
        if (globalDataFixupList[i].fromCode) {
            UInt t = codebase[globalDataFixupList[i].offset >> 1];
            t += targetOffset;
            DmWrite(codebase, globalDataFixupList[i].offset, &t, sizeof(UInt));
        }
        else {
            int offsetInDataInit = globalDataFixupList[i].offset >> 1;
            *((long *)(&dataP[globalDataFixupList[i].offset >> 1])) += targetOffset;
            dataInitP[offsetInDataInit >> 3] |= 1 << (7 - (offsetInDataInit & 0x7));
        }
    }

    MemHandleUnlock(gCodeStashH);

    MemHandleUnlock(dataHandle);
    if (dataInit != NULL)
        MemHandleUnlock(dataInit);
    if (codeInit != NULL)
        MemHandleUnlock(codeInit);

    if (success) {
        long offset;

/*
    if there is a code NNN specified, or no PilotMain to be found,
    then simply write the code segment (without a data seg)
*/
        offset = findGlobalCodeLabel("PilotMain_00", 12, PilotMainHash, -1);
        if ((codeSeg != -1) || (offset == -1)) {
	  if(prjType=='libr'){
	    if (codeSeg == -1) codeSeg = 0;
	    success = addCodeResource(gPRCName, codeSeg, lid, foundMathName,'libr');
	  } else {
	    if (codeSeg == -1) codeSeg = 1000;
	    success = addCodeResource(gPRCName, codeSeg, lid, foundMathName,'code');
	  }
	    
        }
        else {
            success = writePRC(gPRCName, globalCodeLabelList[offset & 0xFFFF].offset, lid, foundMathName, debug);
            *executable = true;
        }
    }

    resetObjectCode();
    resetLabelTable();

    return success;
}


Boolean addExtension(int sizeSpec, int ea, long opData, long target)
{
    if (ea == Imm) {
        if (sizeSpec == ByteSize)
            addWord(opData & 0xFF);
        else
            if (sizeSpec == LongSize) {
                addWord(opData >> 16);
                addWord(opData);
            }
            else
                addWord(opData);
    }
    else {
        if (ea == TgtEA)  {
            if ((target & 0xFFFF0000) == GlobalCodeLabel) {
                if (!addGlobalCodeFixup(target & 0xFFFF, getPC() + gCodeStashTop, true))
                    return false;
            }
            else {
                if (!addGlobalDataFixup(target & 0xFFFF, getPC() + gCodeStashTop, true))
                    return false;
            }
            addWord(opData);
        }
        else {
            if (ea == PCRel) {
                addWord(opData - getPC());
            }
            else {
                if ((ea >= Disp) && (ea != AbsL))
                    addWord(opData);
                else {
                    if (ea == AbsL) {
                        addWord(opData >> 16);
                        addWord(opData);
                    }
                }
            }
        }
    }
    return true;
}

Boolean buildMoveInstruction(InstructionData *id, int sizeSpec, int opCode1, long opData1, long target1,
                                int opCode2, int opData2, long target2)
{
    int ea1 = eaMappingPtr[opCode1];
    int ea2 = eaMappingPtr[opCode2];
    int opcode;

    if (ea1 == TgtEA) {
        if ((target1 & 0xFFFF0000) == GlobalCodeLabel)
            opCode1 = EA_PCDisp;
        else
            opCode1 = EA_Displacement + 5;
    }
    if (ea2 == TgtEA)
    {
        if ((target2 & 0xFFFF0000) == GlobalCodeLabel)
            opCode2 = EA_PCDisp;
        else
            opCode2 = EA_Displacement + 5;
    }

    opcode = id->opcode | opCode1 | ((opCode2 & 0x7) << 9) | ((opCode2 & 0x38) << 3);
    addWord(opcode);
    if (!addExtension(sizeSpec, ea1, opData1, target1)) return false;
    return addExtension(sizeSpec, ea2, opData2, target2);
}

void buildMoveqInstruction(InstructionData *id, int sizeSpec, int opCode1, long opData1,
                                int opCode2, int opData2)
{
    int opcode = id->opcode | (opData1 & 0xFF) | ((opCode2 & 0x7) << 9);
    addWord(opcode);
}

Boolean buildMovemInstruction(InstructionData *id, int sizeSpec, int opCode1, long opData1, long target1,
                                int opCode2, int opData2, long target2)
{
    int ea1 = eaMappingPtr[opCode1];
    int ea2 = eaMappingPtr[opCode2];
    int opcode;

    if (ea1 == TgtEA)
    {
        if ((target1 & 0xFFFF0000) == GlobalCodeLabel)
            opCode1 = EA_PCDisp;
        else
            opCode1 = EA_Displacement + 5;
    }
    if (ea2 == TgtEA)
    {
        if ((target2 & 0xFFFF0000) == GlobalCodeLabel)
            opCode2 = EA_PCDisp;
        else
            opCode2 = EA_Displacement + 5;
    }

    opcode = id->opcode;

    if (ea1 == DReg) {
        ea1 = RegList;
        opData1 = (1 << (opCode1 & 0x7)) | (0x80000000 >> (opCode1 & 0x7));
    }
    else
        if (ea1 == AReg) {
            ea1 = RegList;
            opData1 = (0x100 << (opCode1 & 0x7)) | (0x00800000 >> (opCode1 & 0x7));
        }
        else
            if (ea2 == DReg) {
                ea2 = RegList;
                opData2 = (1 << (opCode2 & 0x7)) | (0x80000000 >> (opCode2 & 0x7));
            }
            else
                if (ea2 == AReg) {
                    ea2 = RegList;
                    opData2 = (0x100 << (opCode2 & 0x7)) | (0x00800000 >> (opCode2 & 0x7));
                }

    if (ea1 == RegList) {
        opcode |= opCode2;
        addWord(opcode);
        if (ea2 == Pre)
            addWord(opData1 >> 16);
        else
            addWord(opData1);
        return addExtension(sizeSpec, ea2, opData2, target2);
    }
    else {
        opcode |= opCode1;
        addWord(opcode);
        addWord(opData2);
        return addExtension(sizeSpec, ea1, opData1, target1);
    }
}

Boolean buildInstruction(InstructionData *id, int sizeSpec, int opCode1, long opData1, long target1,
                        int opCode2, long opData2, long target2)
{
    int ea1 = eaMappingPtr[opCode1];
    int ea2 = eaMappingPtr[opCode2];
    int opcode;

    if (ea1 == TgtEA)
    {
        if ((target1 & 0xFFFF0000) == GlobalCodeLabel)
            opCode1 = EA_PCDisp;
        else
            opCode1 = EA_Displacement + 5;
    }
    if (ea2 == TgtEA)
    {
        if ((target2 & 0xFFFF0000) == GlobalCodeLabel)
            opCode2 = EA_PCDisp;
        else
            opCode2 = EA_Displacement + 5;
    }

    opcode = id->opcode;
    if (ea1 == NoEA) {
        addWord(opcode);
    }
    else {
        if (id->flags & OP1_EA) {
            if (id->flags & OP1_RegOnly)
                opcode |= opCode1 & 0x7;
            else
                opcode |= opCode1;
            if (ea2 != NoEA) {
                if (id->flags & OPX_EA) {
                    opcode |= (opCode2 & 0x7) << 9;
                }
                addWord(opcode);
                if (ea2 == Imm) {   // (only here to handle link instruction)
                                    // can add the immediate now as the op1 has
                                    // no extension word.
                    addWord(opData2);
                }
            }
            else
                addWord(opcode);
            return addExtension(sizeSpec, ea1, opData1, target1);
        }
        else {
            if (id->flags & OPX_RegOnly)
                opcode |= (opCode2 & 0x7);
            else
                opcode |= opCode2;
            if (id->flags & OPX_EA) {
                if (ea1 == Imm)
                    opcode |= (opData1 & 0x7) << 9;
                else
                    opcode |= (opCode1 & 0x7) << 9;
                addWord(opcode);
            }
            else {
                addWord(opcode);
                if (ea1 == Imm) {
                    if (sizeSpec == ByteSize)
                        addWord(opData1 & 0xFF);
                    else
                        if (sizeSpec == LongSize) {
                            addWord(opData1 >> 16);
                            addWord(opData1);
                        }
                        else
                            addWord(opData1);
                }
            }
            return addExtension(sizeSpec, ea2, opData2, target2);
        }
    }
    return true;
}

int procIndex;

void resetLabelTable()
{
    int i;
    localCodeLabelTop = 0;
    globalCodeLabelTop = 0;
    globalDataLabelTop = 0;
    globalCodeFixupTop = 0;
    globalDataFixupTop = 0;
    for (i = 0; i < 128; i++) {
        localCodeLabelHashTable[i] = -1;
        globalCodeLabelHashTable[i] = -1;
        globalDataLabelHashTable[i] = -1;
    }
}


long findLocalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset)
{
    LabelData *ld = (localCodeLabelHashTable[(int) hash] == -1) ? NULL : localCodeLabelList + localCodeLabelHashTable[(int) hash];
    while (ld) {
        if (ld->length == length) {
            int x;
            for (x = length - 1; x >= 0; x--) {
                if (ld->name[x] != startTextPtr[x])
                    break;
            }
            if (x < 0) {
                return LocalCodeLabel | ld->index;
            }
        }
        ld = (ld->next == -1) ? NULL : localCodeLabelList + ld->next;
    }
    return -1;
}

long addLocalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset)
{
    long index = findLocalCodeLabel(startTextPtr, length, hash, offset);
    if (index == -1) {
        LabelData ld;
        if (localCodeLabelTop == gMaxLocalCodeLabels) {
            gMaxLocalCodeLabels += 128;
            unlockAllDataHandles();
            localCodeLabelListH = DmResizeRecord(dataDB, gLocalCodeLabelIndex, sizeof(LabelData) * gMaxLocalCodeLabels);
            if (localCodeLabelListH == NULL) {
                error("Out of memory (5)");
                return -9999;
            }
            lockAllDataHandles();
        }
        ld.name = startTextPtr;
        ld.length = length;
        ld.hash = hash;
        ld.offset = offset;
        ld.index = localCodeLabelTop;
        ld.next = localCodeLabelHashTable[(int) hash];
        localCodeLabelHashTable[(int) hash] = localCodeLabelTop;
        DmWrite(localCodeLabelList, localCodeLabelTop * sizeof(LabelData), &ld, sizeof(LabelData));
        return LocalCodeLabel | localCodeLabelTop++;
    }
    else {
        if (localCodeLabelList[index & 0xFFFF].offset == -1) {
            LabelData ld = localCodeLabelList[index & 0xFFFF];
            ld.offset = offset;
            DmWrite(localCodeLabelList, (index & 0xFFFF) * sizeof(LabelData), &ld, sizeof(LabelData));
            return index;
        }
        else {
            if (offset != -1) {
                error("Duplicate local code label");
                return -9999;
            }
            return index;
        }
    }
}

long findGlobalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset)
{

    LabelData *ld = (globalCodeLabelHashTable[(int) hash] == -1) ? NULL : globalCodeLabelList + globalCodeLabelHashTable[(int) hash];

    while (ld) {
        if (ld->length == length) {
            int x;
            for (x = length - 1; x >= 0; x--) {
                if (ld->name[x] != startTextPtr[x])
                    break;
            }
            if (x < 0) {
                return GlobalCodeLabel | ld->index;
            }
        }
        ld = (ld->next == -1) ? NULL : globalCodeLabelList + ld->next;
    }
    return -1;
}

void removeGlobalCodeLabel(CharPtr startTextPtr, int length, char hash)
{
    LabelData *ld = (globalCodeLabelHashTable[(int) hash] == -1) ? NULL : globalCodeLabelList + globalCodeLabelHashTable[(int) hash];
    LabelData *previous = NULL;
    while (ld) {
        if (ld->length == length) {
            int x;
            for (x = length - 1; x >= 0; x--) {
                if (ld->name[x] != startTextPtr[x])
                    break;
            }
            if (x < 0) {
                if (previous == NULL)
                    globalCodeLabelHashTable[(int) hash] = -1;
                else
                    previous->next = ld->next;
                break;
            }
        }
        previous = ld;
        ld = (ld->next == -1) ? NULL : globalCodeLabelList + ld->next;
    }
}

/* resolved for :
    for jsr/jmp to pc-relative target
    [for any EA for pc-relative target]
defined for :
    any identifier at global scope in the code segment, i.e.
    - global code labels, proc names
*/

long addGlobalCodeLabel(CharPtr startTextPtr, int length, char hash, long offset)
{
    long index = findGlobalCodeLabel(startTextPtr, length, hash, offset);
    if (index == -1) {
        LabelData ld;
        if (globalCodeLabelTop == gMaxGlobalCodeLabels) {
            gMaxGlobalCodeLabels += 128;
            unlockAllDataHandles();
            globalCodeLabelListH = DmResizeRecord(dataDB, gGlobalCodeLabelIndex, sizeof(LabelData) * gMaxGlobalCodeLabels);
            if (globalCodeLabelListH == NULL) {
                error("Out of memory (6)");
                return -9999;
            }
            lockAllDataHandles();
        }
        ld.name = startTextPtr;
        ld.length = length;
        ld.hash = hash;
        ld.offset = offset;
        ld.index = globalCodeLabelTop;
        ld.next = globalCodeLabelHashTable[(int) hash];
        globalCodeLabelHashTable[(int) hash] = globalCodeLabelTop;
        DmWrite(globalCodeLabelList, globalCodeLabelTop * sizeof(LabelData), &ld, sizeof(LabelData));
        return GlobalCodeLabel | globalCodeLabelTop++;
    }
    else {
        if (globalCodeLabelList[index & 0xFFFF].offset == -1) {
            LabelData ld = globalCodeLabelList[index & 0xFFFF];
            ld.offset = offset;
            DmWrite(globalCodeLabelList, (index & 0xFFFF) * sizeof(LabelData), &ld, sizeof(LabelData));
            return index;
        }
        else {
            if (offset != -1) {
                int t,x;
                StrCopy(errBuf, "Duplicate global code label ");
                t = StrLen(errBuf);
                for (x = 0; x < globalCodeLabelList[index & 0xFFFF].length; x++)
                    errBuf[t + x] = globalCodeLabelList[index & 0xFFFF].name[x];
                errBuf[t + x] = '\0';
                error(errBuf);
//              error("Duplicate global code label");
                return -9999;
            }
            return index;
        }
    }
}

void setGlobalCodeLabelSize(long index, int size)
{
    LabelData ld = globalCodeLabelList[index & 0xFFFF];
    ld.size = size;
    DmWrite(globalCodeLabelList, (index & 0xFFFF) * sizeof(LabelData), &ld, sizeof(LabelData));
}

long findGlobalDataLabel(CharPtr startTextPtr, int length, char hash, long offset)
{
    LabelData *ld = (globalDataLabelHashTable[(int) hash] == -1) ? NULL : globalDataLabelList + globalDataLabelHashTable[(int) hash];
    while (ld) {
        if ((ld->length == length)
                && ((ld->scope == -1) || (ld->scope == gCurrentScope))) {
            int x;
            for (x = length - 1; x >= 0; x--) {
                if (ld->name[x] != startTextPtr[x])
                    break;
            }
            if (x < 0) {
                return GlobalDataLabel | ld->index;
            }
        }
        ld = (ld->next == -1) ? NULL : globalDataLabelList + ld->next;
    }
    return -1;
}

/* global data labels */
long addGlobalDataLabel(CharPtr startTextPtr, int length, char hash, long offset)
{
    LabelData localD;
    long index = findGlobalDataLabel(startTextPtr, length, hash, offset);
    if (index == -1) {
        if (globalDataLabelTop == gMaxGlobalDataLabels) {
            gMaxGlobalDataLabels += 128;
            unlockAllDataHandles();
            globalDataLabelListH = DmResizeRecord(dataDB, gGlobalDataLabelIndex, sizeof(LabelData) * gMaxGlobalDataLabels);
            if (globalDataLabelListH == NULL) {
                error("Out of memory (7)");
                return -9999;
            }
            lockAllDataHandles();
        }
        localD.name = startTextPtr;
        localD.length = length;
        localD.hash = hash;
        localD.offset = offset;
        localD.index = globalDataLabelTop;
        if ((startTextPtr[0] == '_') && (startTextPtr[1] == '_') && (startTextPtr[2] == 'S'))
            localD.scope = gCurrentScope;
        else
            localD.scope = -1;
        localD.next = globalDataLabelHashTable[(int) hash];
        globalDataLabelHashTable[(int) hash] = globalDataLabelTop;
        DmWrite(globalDataLabelList, sizeof(LabelData) * globalDataLabelTop, &localD, sizeof(LabelData));
        return GlobalDataLabel | globalDataLabelTop++;
    }
    else {
        if (globalDataLabelList[index & 0xFFFF].offset == -1) {
            localD = globalDataLabelList[index & 0xFFFF];
            localD.offset = offset;
            DmWrite(globalDataLabelList, sizeof(LabelData) * (index & 0xFFFF), &localD, sizeof(LabelData));
            return index;
        }
        else {
            if (offset != -1) {
                int t,x;
                StrCopy(errBuf,"Duplicate global data label ");
                t = StrLen(errBuf);
                for (x = 0; x < globalDataLabelList[index & 0xFFFF].length; x++)
                    errBuf[t + x] = globalDataLabelList[index & 0xFFFF].name[x];
                errBuf[t + x] = '\0';
                error(errBuf);
//              error("Duplicate global data label");
                return -9999;
            }
            return index;
        }
    }
}

Boolean addGlobalDataFixup(int targetIndex, long offset, Boolean fromCode)
{
    FixupData fd;
    if (globalDataFixupTop == gMaxGlobalDataFixups) {
        gMaxGlobalDataFixups += 128;
        unlockAllDataHandles();
        globalDataFixupListH = DmResizeRecord(dataDB, gGlobalDataFixupIndex, sizeof(FixupData) * gMaxGlobalDataFixups);
        if (globalDataFixupListH == NULL) {
            error("Out of memory (8)");
            return false;
        }
        lockAllDataHandles();
    }
    fd.index = targetIndex;
    fd.offset = offset;
    fd.fromCode = fromCode;
    fd.scope = gCurrentScope;
    DmWrite(globalDataFixupList, globalDataFixupTop * sizeof(FixupData), &fd, sizeof(FixupData));
    globalDataFixupTop++;
    return true;
}

Boolean addGlobalCodeFixup(int targetIndex, long offset, Boolean fromCode)
{
    FixupData fd;
    if (globalCodeFixupTop == gMaxGlobalCodeFixups) {
        gMaxGlobalCodeFixups += 128;
        unlockAllDataHandles();
        globalCodeFixupListH = DmResizeRecord(dataDB, gGlobalCodeFixupIndex, sizeof(FixupData) * gMaxGlobalCodeFixups);
        if (globalCodeFixupListH == NULL) {
            error("Out of memory (8)");
            return false;
        }
        lockAllDataHandles();
    }
    fd.index = targetIndex;
    fd.offset = offset;
    fd.fromCode = fromCode;
    DmWrite(globalCodeFixupList, globalCodeFixupTop * sizeof(FixupData), &fd, sizeof(FixupData));
    globalCodeFixupTop++;
    return true;
}

int localSymbolIndex;
#define MaxLocalSymbols 128
struct {
    CharPtr name;
    char hash;
    DBG_TypeFlag type;
    int length;
    int offset;
    int size;
} localSymbol[MaxLocalSymbols];

Boolean findLocalSymbol(CharPtr name, int length, char hash, int *offset)
{
    int i;
    for (i = 0; i < localSymbolIndex; i++) {
        if ((hash == localSymbol[i].hash) && (length == localSymbol[i].length)) {
            int x;
            for (x = 0; x < length; x++)
                if (name[x] != localSymbol[i].name[x])
                    break;
            if (x == length) {
                *offset = localSymbol[i].offset;
                return true;
            }
        }
    }
    return false;
}

CharPtr getEA(CharPtr curTextPtr, int *opCode, long *opData, long *target, Boolean isJsrOrJmp)
{
    CharPtr startPtr;
    int token;
    long value;
    int displacementValue = 0;
    Boolean negative = false;
    Boolean hasDisplacement = false;
    char hash;
    *opCode = EA_Error;

    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
    if ((token == Token_EOF) || (token == Token_Error)) {
        error("Expected operand");
        return curTextPtr;
    }
    switch (token) {
        case EA_d0 :
        case EA_d1 :
        case EA_d2 :
        case EA_d3 :
        case EA_d4 :
        case EA_d5 :
        case EA_d6 :
        case EA_d7 :
            *opCode = EA_DRegister | (token - EA_d0);
            return curTextPtr;
        case EA_a0 :
        case EA_a1 :
        case EA_a2 :
        case EA_a3 :
        case EA_a4 :
        case EA_a5 :
        case EA_a6 :
        case EA_a7 :
            *opCode = EA_ARegister | (token - EA_a0);
            return curTextPtr;

        case EA_local :
            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
            if (token != Digit) error("Expected number after local symbol bytecode");
            *opCode = EA_Displacement + 6;
            *opData = value;
            return curTextPtr;


        case Token_d0 :
        case Token_d1 :
        case Token_d2 :
        case Token_d3 :
        case Token_d4 :
        case Token_d5 :
        case Token_d6 :
        case Token_d7 :
        case Token_a0 :
        case Token_a1 :
        case Token_a2 :
        case Token_a3 :
        case Token_a4 :
        case Token_a5 :
        case Token_a6 :
        case Token_a7 : {
                CharPtr savePtr = curTextPtr;
                int reg = token;
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if ((token == Divide) || (token == Minus)) {
                    long regSetBits = 0;
                    Boolean regSet[16];
                    int i;
                    for (i = 0; i < 16; i++) regSet[i] = false;
                    reg = reg - Token_d0;
                    regSet[reg] = true;
                    while (true) {
                        if (token == Divide) {
                            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                            if ((token >= Token_d0) && (token <= Token_a7)) {
                                reg = token - Token_d0;
                                regSet[reg] = true;
                                savePtr = curTextPtr;
                                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                            }
                            else {
                                error("Expected register in register set");
                                return curTextPtr;
                            }
                        }
                        else {
                            if (token == Minus) {
                                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                if ((token >= Token_d0) && (token <= Token_a7)) {
                                    int reg2 = token - Token_d0;
                                    if (reg >= reg2) {
                                        error("Invalid register range");
                                        return curTextPtr;
                                    }
                                    else {
                                        for (i = reg; i <= reg2; i++) regSet[i] = true;
                                        savePtr = curTextPtr;
                                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                        if (token != Divide) {
                                            pushBack(token, value, startPtr, hash);
                                            break;
                                        }
                                    }
                                }
                                else {
                                    error("Expected register in register set range");
                                    return curTextPtr;
                                }
                            }
                            else {
                                pushBack(token, value, startPtr, hash);
                                break;
                            }
                        }
                    }
                    for (i = 0; i < 16; i++) {
                        if (regSet[i]) {
                            regSetBits |= 1 << i;
                            regSetBits |= 0x80000000 >> i;
                        }
                    }
                    *opData = regSetBits;
                    *opCode = EA_RegisterSet;
                    return curTextPtr;
                }
                else {
                    pushBack(token, value, startPtr, hash);
                    if (reg >= Token_a0)
                        *opCode = EA_ARegister | (reg - Token_a0);
                    else
                        *opCode = EA_DRegister | (reg - Token_d0);
                    return curTextPtr;
                }
            }
        case Number : {
                Boolean negative = false;
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if (token == Minus) {
                    negative = true;
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                }
                if ((token != Digit) && (token != HexDigit)) {
                    error("Bad form for immediate operand");
                    return curTextPtr;
                }
                else {
                    if (negative) value = -value;
                    *opCode = EA_Immediate;
                    *opData = value;
                    return curTextPtr;
                }
            }
        case Minus :
            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
            if (token == LeftParen) {
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if ((token < Token_a0) || (token > Token_a7)) {
                    error("Expected A register for pre-decrement");
                    return curTextPtr;
                }
                else {
                    int baseRegister = token;
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                    if (token != RightParen) {
                        error("Expected right parenthesis for pre-decrement");
                        return curTextPtr;
                    }
                    else {
                        *opCode = EA_PreDecrement | (baseRegister - Token_a0);
                        return curTextPtr;
                    }
                }
            }
            else {
                if ((token != Digit) && (token != HexDigit)) {
                    error("Expected left parenthesis or digit after minus");
                    return curTextPtr;
                }
                negative = true;
                // fall thru
            }
        case Digit :
        case HexDigit : {
                //CharPtr savePtr = curTextPtr;
                int sizeSpec = WordSize;
                displacementValue = value;
                if (negative) displacementValue = -displacementValue;
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if (token != LeftParen) {
                    if (token == Period) {
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if ((token == Identifier) && (value == 1)
                                && ((*startPtr == 'w') || (*startPtr == 'l'))) {
                            if (*startPtr == 'l')
                                sizeSpec = LongSize;
                        }
                        else {
                            error("Invalid size specification for absolute");
                            return curTextPtr;
                        }
                    }
                    else
                        if (token == WordSpec)
                            sizeSpec = WordSize;
                        else
                            if (token == LongSpec)
                                sizeSpec = LongSize;
                            else
                                pushBack(token, value, startPtr, hash);
                    *opData = displacementValue;
                    if (sizeSpec == WordSize)
                        *opCode = EA_AbsoluteWord;
                    else
                        *opCode = EA_AbsoluteLong;
                }
                else
		  //                    hasDisplacement = true;
		  // S. Little 20040219
		  // Change as suggested by P. Guillot, to generate
		  // 'move (a6), d0' instead of 'move 0(a6), d0'
		  hasDisplacement = (displacementValue != 0);
                    // & fall thru...
            }
        case LeftParen :
            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
            if ((token >= Token_a0) && (token <= Token_PC)) {
                int baseRegister = token;
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if (token == Comma) {
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                    if ((token >= Token_d0) && (token <= Token_a7)) {
                        int indexRegister = token;
                        int sizeSpec = WordSize;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token == Period) {
                            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                            if ((token == Identifier) && (value == 1)
                                    && ((*startPtr == 'w') || (*startPtr == 'l'))) {
                                if (*startPtr == 'l')
                                    sizeSpec = LongSize;
                                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                            }
                            else {
                                error("Invalid size specification for index");
                                return curTextPtr;
                            }
                        }
                        else {
                            if (token == WordSpec) {
                                sizeSpec = WordSize;
                                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                            }
                            else {
                                if (token == LongSpec) {
                                    sizeSpec = LongSize;
                                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                }
                            }
                        }
                        if (token != RightParen) {
                            error("Expected comma or right parenthesis in operand");
                            return curTextPtr;
                        }
                        else {
                            int extension = ((indexRegister - Token_d0) << 12) | (displacementValue & 0xFF);
                            if (sizeSpec == LongSize) extension |= 0x800;
                            *opData = extension;
                            if (baseRegister == Token_PC) {
                                *opData = 0;
                                *opCode = EA_PCIndx;
                            }
                            else
                                *opCode = EA_Indexed | (baseRegister - Token_a0);
                            return curTextPtr;
                        }
                    }
                    else {
                        error("Expected index register");
                        return curTextPtr;
                    }
                }
                else {
                    if (token != RightParen) {
                        error("Expected comma or right parenthesis in operand");
                        return curTextPtr;
                    }
                    else {
                        if (baseRegister == Token_PC) {
                            *opData = displacementValue;
                            *opCode = EA_PCDisp;
                        }
                        else {
                            if (hasDisplacement) {
                                *opData = displacementValue;
                                *opCode = EA_Displacement | (baseRegister - Token_a0);
                            }
                            else {
                                //CharPtr savePtr = curTextPtr;
                                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                if (token == Plus) {
                                    *opCode = EA_PostIncrement | (baseRegister - Token_a0);
                                }
                                else {
                                    pushBack(token, value, startPtr, hash);
                                    *opCode = EA_Indirect | (baseRegister - Token_a0);
                                }
                            }
                        }
                        return curTextPtr;
                    }
                }

            }
            else {
                error("Expected An or PC in operand");
                return curTextPtr;
            }
        case Identifier : {
                CharPtr name = startPtr;
                int length = value;
                int reg = -1;
                char iHash = hash;
                long adjust = 0;
                // CharPtr savePtr = curTextPtr;
                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                if ((token == Plus) || (token == Minus)) {
                    Boolean negative = (token == Minus);
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                    if ((token != Digit) && (token != HexDigit)) {
                        error("expected digit or hexdigit following '+'");
                        return curTextPtr;
                    }
                    if (negative)
                        adjust = -value;
                    else
                        adjust = value;
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                }
                if (token == LeftParen) {
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                    if ((token != Token_a6) && (token != Token_a5) && (token != Token_PC)) {
                        error("expected (a5) or (a6) or (pc) following symbol name");
                        return curTextPtr;
                    }
                    else {
                        reg = token;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != RightParen) {
                            error("expected right parenthesis following register");
                            return curTextPtr;
                        }
                    }
                }
                else
                    pushBack(token, value, startPtr, hash);
                *opCode = EA_Target;
                if (isJsrOrJmp) {   // then must be to a global code label
                    if (reg != Token_PC) {
                        error("Can only Jsr or Jmp to global code labels (pc)");
                        *opCode = EA_Error;
                        return curTextPtr;
                    }
                    value = addGlobalCodeLabel(name, length, iHash, -1);
                    if (value == -9999) *opCode = EA_Error;
                    *target = value;
                    *opData = adjust;
                }
                else {  // can be a local branch - to a label, a reference to a local symbol
                        // or to a global symbol, we use the reg as a distinguisher
                    if (reg == Token_a5) {
                        value = addGlobalDataLabel(name, length, iHash, -1);
                        if (value == -9999) *opCode = EA_Error;
                        *target = value;
                        *opData = adjust;
                    }
                    else
                        if (reg == Token_PC) {
                            value = addGlobalCodeLabel(name, length, iHash, -1);
                            if (value == -9999) *opCode = EA_Error;
                            *target = value;
                            *opData = adjust;
                        }
                        else
                            if (reg == Token_a6) {
                                int offset;
                                if (findLocalSymbol(name, length, iHash, &offset)) {
                                    *opData = offset + adjust;
                                    *opCode = EA_Displacement + 6;
                                }
                                else {
                                    error("Unknown local symbol");
                                    *opCode = EA_Error;
                                    return curTextPtr;
                                }
                            }
                            else {
                                value = addLocalCodeLabel(name, length, iHash, -1);
                                if (value == -9999) *opCode = EA_Error;
                                *target = value;
                                *opData = adjust;
                            }
                }
                return curTextPtr;
            }
        default : {
            error("Unexpected token in operand");
            return curTextPtr;
        }
    }
}

Boolean matchAndBuildInstruction(int token, int sizeSpec, int opCode1, long opData1, long target1,
                                        int opCode2, long opData2, long target2)
{
    int ea1 = eaMappingPtr[opCode1];
    int ea2 = eaMappingPtr[opCode2];
    InstructionData *id = &instructionDataPtr[token - Token_Instruction_Start];

    while (true) {
        int curPC = getPC();
        if ((id->flags & sizeSpec)
                && (id->operand1 & ea1)
                && (id->operand2 & ea2)) {
            switch (token) {
                case Token_Dbra :
/*
                    if (((getPC() - procStart) >> 1) >= MaxProcedureSize)
                        error("Too many branches");
                    else
                        branchList[(getPC() - procStart) >> 1] = DBranch;
*/
                    addWord(id->opcode + (opCode1 & 0x7));
                    addWord(target2 & 0xFFFF);
                    branchList[(curPC - procStart) >> 1] = DBranch;
                    break;
                case Token_Beq :
                case Token_Ble :
                case Token_Bge :
                case Token_Bgt :
                case Token_Blt :
                case Token_Bne :
                case Token_Bra :
                case Token_Bcs :
                case Token_Bcc :
                case Token_Bls :
                case Token_Bhi :
/*
                    if (((getPC() - procStart) >> 1) >= MaxProcedureSize)
                        error("Too many branches");
                    else
                        branchList[(getPC() - procStart) >> 1] = Branch;
*/
                    addWord(id->opcode);
                    addWord(target1 & 0xFFFF);
                    branchList[(curPC - procStart) >> 1] = Branch;
                    break;
                case Token_Bsr :
                    if (!buildInstruction(id, sizeSpec, opCode1, opData1, target1, opCode2, opData2, target2))
                        return false;
                    break;
                case Token_Trap :
                    addWord(id->opcode | (opData1 & 0xF));
                    break;
                case Token_Move:
                    if (!buildMoveInstruction(id, sizeSpec, opCode1, opData1, target1, opCode2, opData2, target2))
                        return false;
                    break;
                case Token_Movem:
                    if (!buildMovemInstruction(id, sizeSpec, opCode1, opData1, target1, opCode2, opData2, target2))
                        return false;
                    break;
                case Token_Moveq :
                    buildMoveqInstruction(id, sizeSpec, opCode1, opData1, opCode2, opData2);
                    break;
                case Token_Lea :
                case Token_Jsr :
	        case Token_Jmp :
		  if (!buildInstruction(id, sizeSpec, opCode1, opData1, target1, opCode2, opData2, target2))
                        return false;
                    break;
                default :
                    if (!buildInstruction(id, sizeSpec, opCode1, opData1, target1, opCode2, opData2, target2))
                        return false;
                    break;
            }
            return true;
        }
        else
            if (id->flags & LastEntry) {
                int i;
                for (i = 0; i < MaxReservedWord; i++)
                    if (reservedWordList[i].token == token) break;
                StrPrintF(errBuf, "%s %x %x", reservedWordList[i].name, ea1, ea2);
                error(errBuf);
                error("Invalid combination of opcode and operands");
                return false;
            }
            else
                id++;
    }
    return true;
}

typedef struct {
  char *name;
  int trap;
} SysTrapEntry;

typedef struct equType equEntry;

struct equType {
  char *name;
  int length;
  char hash;
  int trap;
  equEntry* next;
};

#define SysTrapTableSize 2

SysTrapEntry sysTrapTable[SysTrapTableSize] = {
    { "SndPlaySystemSound", 41524 },
    { "FrmAlert", 41362 }
};

equEntry *gEquTable=NULL;
equEntry *gEquTableLast=NULL;

char makeHash(CharPtr name, int length){
  int i;
  char hashValue=0;
  for(i=0;i<length;i++)
    hashValue ^= name[i];
  return hashValue;
}

Boolean addEqu(CharPtr name, int length, int value, char hash)
{
  if(gEquTable==NULL){ // special case for first equ
    gEquTable = MemPtrNew(sizeof(equEntry));
    if(gEquTable==NULL)
      return false;
    gEquTableLast = gEquTable;
  } else {
    gEquTableLast->next = MemPtrNew(sizeof(equEntry));
    if(gEquTableLast->next==NULL)
      return false;
    gEquTableLast = gEquTableLast->next;
  }

  gEquTableLast->name=name;
  gEquTableLast->length=length;
  gEquTableLast->hash=hash;
  gEquTableLast->trap=value;
  gEquTableLast->next=NULL;
  
  return true;
}

CharPtr processEqu(CharPtr curTextPtr, CharPtr name, long length, char equHash)
{
  int token;
  long value;
  CharPtr startPtr;
  char hash;

  curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
  if(token==Number){
    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
  } else if(token==HexDigit) {
    
  } else {
    error("Expected a digit in equ directive");
    return false;
  }
  addEqu(name,length,value,equHash);
  //			    return true;
  return curTextPtr;

}

void emptyEquList(void)
{
  equEntry *p = gEquTable;
  equEntry *pNext = gEquTable;

  while(p){
    pNext=p->next;
    MemPtrFree(p);
    p=pNext;
  }
  gEquTable=NULL;
}

Boolean lookupEqu(CharPtr name, char hash, int *value){
  equEntry* p = gEquTable;

  while(p){
    if(p->hash==hash){
      if(StrNCompare(p->name,name,p->length) == 0) {
	*value = p->trap;
	return true;
      }
    }
    p=p->next;
  }
  return false;
}

int makeSysTrapTable(CharPtr source)
{
  int i=0;
  int len=0;
  CharPtr p = source; // point to the start of the list
  CharPtr pStart = source;

  while(*p!=NULL){ // go through the list of systraps and add to Equ list
    if((*p==' ')||(*p=='\n')||(*p=='\r')){
      addEqu(pStart,len,sysTrapBase+i,makeHash(pStart,len));
      while((*p!=NULL)&&((*p==' ')||(*p=='\r')||(*p=='\n'))) // skip past \n, \r or spaces
	p++;
      pStart=p;
      len=0;
      i++;
    }
    len++;
    p++;
  }

  return true;
}

int findSystrap(CharPtr startPtr, CharPtr* curTextPtr, char hash)
{
  int trapValue=-1;

  if(lookupEqu(startPtr,hash,&trapValue)){
    return trapValue;
  } else {
    return -1;
  }

}

/*
int findSystrap(CharPtr startPtr, CharPtr* curTextPtr, char hash)
{
    int i;
    CharPtr saveChar = *curTextPtr;
    *curTextPtr = 0;

    for (i = 0; i < SysTrapTableSize; i++) {
        if (StrNCompare(sysTrapTable[i].name, startPtr, StrLen(sysTrapTable[i].name)) == 0) {
	    *curTextPtr = saveChar;
            return sysTrapTable[i].trap;
        } 
    }

    *curTextPtr = saveChar;
    return -1;
}
*/

CharPtr processArgument(CharPtr curTextPtr, int *stackDepth)
{
    CharPtr startPtr;
    int token;
    long value;
    int opCode1, opCode2;
    long opData1, target1;
    int sizeSpec;
    char hash;

    int instrToken = Token_Move;
    CharPtr savePtr = curTextPtr;
    opCode2 = EA_StackPush;
    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
    if (token == AddressOf) {
        instrToken = Token_Pea;
        opCode2 = EA_None;
    }
    else
        pushBack(token, value, startPtr, hash);

    curTextPtr = getEA(curTextPtr, &opCode1, &opData1, &target1, false);
    if (opCode1 == EA_Error) return NULL;
    curTextPtr = getSizeSpec(curTextPtr, &sizeSpec, false);
    if (sizeSpec == 0) return NULL;
    (*stackDepth) += 2;
    if (sizeSpec == LongSize) (*stackDepth) += 2;

    savePtr = curTextPtr;
    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
    if (token == Comma) {
        curTextPtr = processArgument(curTextPtr, stackDepth);
        if (curTextPtr == NULL) return NULL;
    }
    else
        pushBack(token, value, startPtr, hash);

    if (!matchAndBuildInstruction(instrToken, sizeSpec,
                                        opCode1, opData1, target1, opCode2, 0, 0))
        return NULL;
    else
        return curTextPtr;
}


CharPtr buildSysTrapInstruction(CharPtr curTextPtr)
{
    CharPtr startPtr;
    int token;
    long value;
    int trap;
    char hash;

    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
    switch(token){
    case Number:
      curTextPtr = getNextToken(curTextPtr,&token,&value,&startPtr,&hash);
      if(token != Digit){
	error("Bad number for systrap");
	return NULL;
      }
      // fall through
    case HexDigit:
      trap = value;
      break;
    case Identifier:
      trap = findSystrap(startPtr, &curTextPtr,hash);
      if (trap == -1) {
	error("Unknown trap");
	return NULL;
      }
      break;
    default:
      {
	error("number or identifier expected after systrap");
	return NULL;
      }
    }
    /*
    if (token != Identifier) {
        error("identifier expected after systrap");
        return NULL;
    }
    else {
        trap = findSystrap(startPtr, &curTextPtr);
        if (trap == -1) {
            error("Unknown trap");
            return NULL;
        }
    }
    */
    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
    if (token != LeftParen) {
        error("Left parenthesis expected after systrap");
        return NULL;
    }
    else {
        //CharPtr savePtr = curTextPtr;
        int stackDepth = 0;
        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
        if (token != RightParen) {
            pushBack(token, value, startPtr, hash);
            curTextPtr = processArgument(curTextPtr, &stackDepth);
            if (curTextPtr == NULL) return false;
            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
            if (token != RightParen) {
                error("Comma or right parenthesis expected in systrap");
                return NULL;
            }
        }
        addWord(0x4E4F);        // TRAP #F
        addWord(trap);
        if (stackDepth <= 8) {
	  if(stackDepth != 0){ // addq #0 == addq #8, so don't generate that.
            if (!matchAndBuildInstruction(Token_Addq, LongSize,
					  EA_Immediate, stackDepth, 0, EA_ARegister + 7, 0, 0))
	      return NULL;
	  }
        }
        else {
            if (!matchAndBuildInstruction(Token_Lea, Unsized,
                                        EA_Displacement + 7, stackDepth, 0, EA_ARegister + 7, 0, 0))
                return NULL;
        }
        return curTextPtr;
    }
}

#define ForwardJsrListSize 64
int forwardJsrList[ForwardJsrListSize];
int forwardJsrListTop;

Boolean gDoShortBranches = true;

Boolean optimizeBranches()
{
    int i;
    int procBottom = (procStart >> 1);
    int procSize = (getPC() - procStart) >> 1;      // #words
    int procTop = (procBottom + procSize);  // index of word at end of proc
    int *delta = (int *)MemPtrNew(procSize * sizeof(int));      // a delta per word

    int lastDelta, compressedCodeTop;

    Boolean branchShortened;
    for (i = 0; i < procSize; i++) delta[i] = 0;

    // all the branches are currently 16 bit :
    // repeatedly :
    //      remove branches to next instructions
    //      find those that can be within 8 bits instead

    for (i = procBottom; i < procTop; i++) {
        if ((branchList[i - procBottom] == Branch)
                || (branchList[i - procBottom] == DBranch)) {
            int index = objectCodePtr[i + 1];
            int offset = localCodeLabelList[index].offset;
            if (offset == -1) {
                error("Branch to unknown local label");
                return false;
            }
            else
                objectCodePtr[i + 1] = offset - ((i + 1) << 1);
        }
    }

    if (gDoShortBranches) {
        do {
            branchShortened = false;
            for (i = procBottom; i < procTop; i++) {
                if (branchList[i - procBottom] == Branch) {
                    int displacement;
                    int brPC = ((i + 1) << 1) - delta[i - procBottom];
                    int target = objectCodePtr[i + 1] + ((i + 1) << 1);
                    target -= delta[(target >> 1) - procBottom];
                    displacement = target - brPC;
                    if ((objectCodePtr[i] & 0xFF) == 0) {           // a short branch can't have a zero displacement
                        if (displacement == 2) {        // branch to next, blow it off completely
                            int j;
                            branchList[i - procBottom] = Nothing;
                            branchShortened = true;
                            delta[(i + 1) - procBottom] += 2;
                            for (j = i + 2; j < procTop; j++)
                                delta[j - procBottom] += 4;
                        }
                        else {
                            if ((displacement <= 126) && (displacement >= -128)) {
                                int j;
                                objectCodePtr[i] = objectCodePtr[i] | 0xFF; // mark as short
                                branchShortened = true;
                                for (j = i + 2; j < procTop; j++)
                                    delta[j - procBottom] += 2;
                            }
                        }
                    }
                    else {  // have to check that short branches didn't become branch to next's
                        if (displacement == 0) {
                            int j;
                            branchList[i - procBottom] = Nothing;
                            branchShortened = true;
                            delta[(i + 1) - procBottom] += 2;
                            for (j = i + 2; j < procTop; j++)
                                delta[j - procBottom] += 2;
                        }
                    }
                }
            }
        } while (branchShortened);
    }

    for (i = procBottom; i < procTop; i++) {
        if (branchList[i - procBottom] == Branch) {
            int displacement;
            int brPC = ((i + 1) << 1) - delta[i - procBottom];
            int target = objectCodePtr[i + 1] + ((i + 1) << 1);
            target -= delta[(target >> 1) - procBottom];
            displacement = target - brPC;
            if (gDoShortBranches && ((displacement <= 126) && (displacement >= -128))) {
                objectCodePtr[i] = (objectCodePtr[i] & 0xFF00) | (displacement & 0xFF);
            }
            else {
                objectCodePtr[i + 1] = displacement;
            }
        }
        else {
            if (branchList[i - procBottom] == DBranch) {
                int displacement;
                int brPC = ((i + 1) << 1) - delta[i - procBottom];
                int target = objectCodePtr[i + 1] + ((i + 1) << 1);
                target -= delta[(target >> 1) - procBottom];
                displacement = target - brPC;
                objectCodePtr[i + 1] = displacement;
            }
        }
    }

    lastDelta = 0;
    compressedCodeTop = procBottom;
    i = procBottom;
    while (true) {
        int startBlock = i;
        while (((i + 1) < procTop) && (delta[(i + 1) - procBottom] == lastDelta))
            i++;
        if (i != procBottom) {
            while (startBlock < i)
                objectCodePtr[compressedCodeTop++] = objectCodePtr[startBlock++];
        }
        if (i == (procTop - 1)) {
            objectCodePtr[compressedCodeTop++] = objectCodePtr[startBlock++];
           break;
        }
        while ((delta[(i + 1) - procBottom] != lastDelta) && ((i + 1) < procTop)) {
            lastDelta = delta[(i + 1) - procBottom];
            i++;
        }
        if (i == (procTop - 1)) break;
    }
    setCodeTop(compressedCodeTop << 1);

    for (i = 0; i < globalDataFixupTop; i++) {
        int offset = globalDataFixupList[i].offset - gCodeStashTop;
        if (globalDataFixupList[i].fromCode
                && (offset >= (procBottom << 1))
                && (offset < (procTop << 1)))  {
            FixupData fd = globalDataFixupList[i];
            fd.offset -= delta[(offset >> 1) - procBottom];
            DmWrite(globalDataFixupList, i * sizeof(FixupData), &fd, sizeof(FixupData));
//          globalDataFixupList[i].offset -= delta[(globalDataFixupList[i].offset >> 1) - procBottom];
        }
    }
    for (i = 0; i < globalCodeFixupTop; i++) {
        int offset = globalCodeFixupList[i].offset - gCodeStashTop;
        if (globalCodeFixupList[i].fromCode
                && (offset >= (procBottom << 1))
                && (offset < (procTop << 1))) {
            FixupData fd = globalCodeFixupList[i];
            fd.offset -= delta[(offset >> 1) - procBottom];
            DmWrite(globalCodeFixupList, i * sizeof(FixupData), &fd, sizeof(FixupData));
//          globalCodeFixupList[i].offset -= delta[(globalCodeFixupList[i].offset >> 1) - procBottom];
        }
    }

    MemPtrFree(delta);
    return true;
}

void addStringConstant(CharPtr stringConstant, int length)
{
    int i = 0;
    CharPtr s = stringConstant;
    while (i < length) {
        if (*s == '\\') {
            s++;
            switch (*s) {
                case 'n' :
                    addDataByte('\n');
                    break;
                case 'r' :
                    addDataByte('\r');
                    break;
                case 't' :
                    addDataByte('\t');
                    break;
                case '\\' :
                    addDataByte('\\');
                    break;
                case '"' :
                    addDataByte('"');
                    break;
                default :
                    addDataByte('\\');
                    addDataByte(*s);
                    break;
            }
            s++;
            i += 2;
        }
        else {
            addDataByte(*s++);
            i++;
        }
    }
    addDataByte(0);
}

Boolean compile(CharPtr text, ProjectHeader_New *prjHdr, int sourceIndex)
{
    CharPtr curTextPtr = text;
    CharPtr startPtr;
    CharPtr procName = NULL;
    int procNameLength = 0;
    int token;
    long value;
    int opCode1, opCode2;
    long opData1, opData2;
    long target1, target2;
    int sizeSpec;
    char hash;
    SourceFile *src = (SourceFile *)(prjHdr + 1);
    //int stmtCount = 0;
    int procStackSize = 0;
    Boolean procInProgress = false;
    long curProcIndex = 0;
    Boolean hadBeginProc = false;
    Boolean inCodeSeg = false;
    procIndex = 0;
    forwardJsrListTop = 0;
    codeSeg = -1;
    gSegCount = 0;
    gCurrentScope = 0;
    gSymbolDataListTop = 1; // zero'th reserved

    resetObjectCode();
    resetLabelTable();

    if (!getBuffers()) return false;

    if ((prjHdr!=NULL)&&((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG)) {
        DWord id, chip;
        Word revision;
        Err err;
        err = FtrGet(sysFtrCreator, sysFtrNumProcessorID, &id);
        if (!err) {
            chip = id & sysFtrNumProcessorMask;
            revision = id & 0x0ffff;
            if (chip == sysFtrNumProcessor328)
                zeroSym.offset = 0; // traditional Dragonball
            else
                if (chip == sysFtrNumProcessorEZ)
                    zeroSym.offset = 1; // Dragonball EZ
        }
    }

    while (true) {
        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
        if (token == Token_EOF) {
	  if(gIncludeDepth>0){
	    curTextPtr =  includeStack[gIncludeDepth-1];
	    gIncludeDepth--;
	    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
	  } else {

            if (prjHdr == NULL)
                return true;
            else {
                if (prjHdr->mVersion == PROJECT_VERSION_NEWOBJ) {
                    closeSourceDB();
                }
                sourceIndex++;
                gCurrentScope++;
                if (sourceIndex < prjHdr->mSourceDBCount) {
                    while (sourceIndex < prjHdr->mSourceDBCount) {
                        if (src[sourceIndex].sourceKind != Resource) {
                            if (prjHdr->mVersion == PROJECT_VERSION_NEWOBJ)
                                curTextPtr = getSourceAsm(src[sourceIndex].outputDBid);
                            else
                                curTextPtr = getSourceText( ((prjHdr->mFlags & REBUILD_FLAG) == REBUILD_FLAG), src[sourceIndex].outputDBid);
                            if (curTextPtr == NULL) return false;
                            break;
                        }
                        else
                            sourceIndex++;
                    }
                    if (sourceIndex == prjHdr->mSourceDBCount) {
                        if ((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG) {
                            addDataWord(0);
                            addDataWord(0);
                        }
                        return true;
                    }
                    else
                        continue;
                }
                else {
                    if ((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG) {
                        addDataWord(0);
                        addDataWord(0);
                    }
                    return true;
                }
            }
	  }
        }
        if (token == Token_Error) {
            error("Unexpected token");
            return false;
        }
        if ((token >= Token_Instruction_Start)
                && (token < Token_Instruction_End)) {
            int instrToken = token;
            InstructionData *id = &instructionDataPtr[instrToken - Token_Instruction_Start];
            sizeSpec = Unsized;
            if (id->flags & SizeSpec) {
                curTextPtr = getSizeSpec(curTextPtr, &sizeSpec, false);
                if (sizeSpec == 0) {
                    error("expected size specifier");
                    return false;
                }
            }
            opCode1 = EA_None;
            opCode2 = EA_None;
            if (id->operand1 != NoEA) {
                Boolean isJsrOrJmp = (instrToken == Token_Jsr)
                                         || (instrToken == Token_Bsr)
                                         || (instrToken == Token_Jmp) ;
                curTextPtr = getEA(curTextPtr, &opCode1, &opData1, &target1, isJsrOrJmp);
                if (opCode1 == EA_Error) return false;
                if (id->operand2 != NoEA) {
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                    if (token != Comma) {
                        int i;
                        for (i = 0; i < MaxReservedWord; i++)
                            if (reservedWordList[i].token == instrToken) break;
                        StrPrintF(errBuf, "Expected comma or right parenthesis in operand for %s", reservedWordList[i].name);
                        error(errBuf);
                        return false;
                    }
                    curTextPtr = getEA(curTextPtr, &opCode2, &opData2, &target2, false);
                    if (opCode1 == EA_Error) return false;
                }
            }
            if (!matchAndBuildInstruction(instrToken, sizeSpec, opCode1, opData1, target1, opCode2, opData2, target2))
                return false;
        }
        else {
            switch (token) {
	    case SemiColon:
	      curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
	      break;
                case Token_Include : {
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != DoubleQuote) {
                            error("include name expected");
                            return false;
                        }
                        else {
//                          releaseSourceRecord(!gKeepAsm);
			  if(gIncludeDepth<MaxInclude-1){
			    includeStack[gIncludeDepth]=curTextPtr;
			    gIncludeDepth++;
                            curTextPtr = getIncludeSource(startPtr, value, !gKeepAsm);
                            if (curTextPtr == NULL) {
			      error("Couldn't open include file");
			      return false;
                            }
			    setStatus("processing... ", startPtr, value);
			  } else {
			    error("Max number of nested includes exceeded!");
			    return false;
			  }
                        }
                    }
                    break;
                case Extend : {
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != DoubleQuote) {
                            error("extend name expected");
                            return false;
                        }
                        else {
                            closeSourceDB( );
                            curTextPtr = getExtendAsm(startPtr, value);
                            if (curTextPtr == NULL) {
                                error("Couldn't open extend file");
                                return false;
                            }
                        }
                    }
                    break;
                case Identifier : {
		  CharPtr savePtr = curTextPtr;
		  long saveValue = value;
		  char saveHash = hash;
		  CharPtr saveStart = startPtr;
		  // Boz 20031022
		  // save and restore gSubLexerLength incase we're doing
		  // inline asm. Should be an 'unGetNextToken' func to do all this
		  // or a look-ahead function so we don't need to...
		  int saveSubLexLen = gSubLexerLength;
		    if (inCodeSeg) {
		      int offset = getPC();

		      curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
		      if(token==Token_Equ){
			curTextPtr = processEqu(curTextPtr,saveStart,saveValue,saveHash);
		      } else {
			curTextPtr=savePtr;
			value=saveValue;
			hash=saveHash;
			startPtr=saveStart;
			gSubLexerLength=saveSubLexLen;
		      }
                            if (procInProgress) {
                                if (addLocalCodeLabel(startPtr, value, hash, offset) == -9999)
                                    return false;
                            }
                            else {
                                if (addGlobalCodeLabel(startPtr, value, hash, offset + gCodeStashTop) == -9999)
                                    return false;
                            }
                        }
                        else {
                            int offset;
                            if ((getDataOffset() & 1) != 0) addDataByte(0);
                            offset = getDataOffset();
                            if (addGlobalDataLabel(startPtr, value, hash,offset) == -9999) return false;
                            setStatus("Assembling data ... ", startPtr, value);
                        }
                    }
                    break;
                case Token_Code : {
                        CharPtr savePtr = curTextPtr;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != Digit) {
                            curTextPtr = savePtr;
                        }
                        else {
                            if (codeSeg != -1) {    // switching to a new, numbered, segment. Close off the old one
                                UInt at = 1;
                                Boolean addLongMath = false;
                                if (!completeSegmentFixups(&addLongMath)) return false;
                                gSegContents[gSegCount].segNumber = codeSeg;
                                gSegContents[gSegCount].codeStash = DmNewRecord(codeCopyDB, &at, gCodeStashTop);
                                gSegContents[gSegCount].addLongMath = addLongMath;
                                if (gSegContents[gSegCount].codeStash == NULL) {
                                    error("Out of memory (22)");
                                    return false;
                                }
                                DmWrite(MemHandleLock(gSegContents[gSegCount].codeStash), 0, MemHandleLock(gCodeStashH), gCodeStashTop);
                                MemHandleUnlock(gSegContents[gSegCount].codeStash);
                                MemHandleUnlock(gCodeStashH);
                                gCodeStashTop = 0;
                                resetLabelTable();
                                gSegCount++;
                            }
                            codeSeg = value;
                        }
                        inCodeSeg = true;
                    }
                    break;
                case Token_Data :
                    inCodeSeg = false;
                    break;
                case Token_Prc : {
                        int i;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != DoubleQuote) {
                            error("PRC name-string expected");
                            return false;
                        }
                        for (i = 0; i < value; i++)
                            gPRCName[i] = startPtr[i];
                        gPRCName[value] = '\0';
			gType = 'appl';
                    }
                    break;
                case Token_Creator : {
                        int i;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != DoubleQuote) {
                            error("Creator name-string expected");
                            return false;
                        }
                        for (i = 0; (i < value) && (i < 4); i++)
                            ((char*)(&gCreator))[i] = startPtr[i];
                    }
                    break;
                case Token_Proc :
                    if (!inCodeSeg) {
                        error("Can't have a proc in a data seg");
                        return false;
                    }
                    if (procInProgress) {
                        error("Proc already in progress");
                        return false;
                    }
                    else {
                        int offset = getPC();
                        procInProgress = true;
                        procStart = offset; // overridden later if begin_proc occurs
/*
                        for (i = 0; i < branchListSize; i++)
                            branchList[i] = Nothing;
*/
                        MemSet(&branchList[0], branchListSize, Nothing);
                        MemSet(&localCodeLabelHashTable, 128 * sizeof(int), -1);

                        hadBeginProc = false;
                        procIndex++;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token != Identifier) {
                            error("Proc name expected");
                            return false;
                        }
                        curProcIndex = addGlobalCodeLabel(startPtr, value, hash, offset + gCodeStashTop);
                        if (curProcIndex == -9999) return false;
                        if (startPtr[value - 6] == '_')
                            setStatus("Assembling ... ", startPtr, value - 6);
                        else
                            if (startPtr[value - 3] == '_')
                                setStatus("Assembling ... ", startPtr, value - 3);
                            else
                                setStatus("Assembling ... ", startPtr, value);
                        procName = startPtr;
                        procNameLength = value;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token == Token_Asm) {
                            int length = (*curTextPtr++ << 8);
                            length += (*curTextPtr++ & 0xFF);
                            curTextPtr = startSubLexer(curTextPtr, length);
                        }
                        else {
                            if (token != LeftParen) {
                                error("Left parenthesis expected following Proc name");
                                return false;
                            }
                            else {
                                int curParameterOffset = 8;
                                localSymbolIndex = 0;
                                localCodeLabelTop = 0;
                                procStackSize = 0;
                                while (true) {
                                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                    if (token == RightParen)
                                        break;
                                    else {
                                        if (token != Identifier) {
                                            error("Identifier expected in Proc parameter list");
                                            return false;
                                        }
                                        else {
                                            int sizeSpec = WordSize;
                                            if (localSymbolIndex == MaxLocalSymbols) {
                                                error("Too many parameters");
                                                return false;
                                            }
                                            localSymbol[localSymbolIndex].name = startPtr;
                                            localSymbol[localSymbolIndex].length = value;
                                            localSymbol[localSymbolIndex].hash = hash;
                                            localSymbol[localSymbolIndex].offset = curParameterOffset;
                                            curTextPtr = getSizeSpec(curTextPtr, &sizeSpec, false);
                                            if (sizeSpec == 0) return false;
                                            localSymbol[localSymbolIndex].size = sizeSpec;
                                            if ((sizeSpec == WordSize) || (sizeSpec == ByteSize))
                                                curParameterOffset += 2;
                                            else {
                                                if (sizeSpec == LongSize)
                                                    curParameterOffset += 4;
                                                else {
                                                    if (sizeSpec < 0) {
                                                        curParameterOffset += -sizeSpec;
                                                        if ((curParameterOffset & 1) != 0)
                                                            curParameterOffset++;
                                                    }
                                                }
                                            }
                                            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                            if (token == Digit) {
                                                localSymbol[localSymbolIndex].type = (DBG_TypeFlag)value;
                                                curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                            }
                                            else
                                                localSymbol[localSymbolIndex].type = DBG_Unknown;
                                            localSymbolIndex++;
                                            if (token != Comma) {
                                                if (token != RightParen) {
                                                    error("Comma or Right parenthesis expected in Proc parameter list");
                                                    return false;
                                                }
                                                else
                                                    break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;
                case Token_BeginProc : {
                        if (hadBeginProc) {
                            error("Already saw beginproc");
                            return false;
                        }
                        hadBeginProc = true;
                        if (!procInProgress) {
                            error("No proc in progress for beginproc");
                            return false;
                        }
                        procStart = getPC();
                        addWord(0x4E56);        // Link A6, #n
                        addWord(-procStackSize);
                    }
                    break;
                case Token_EndAsm : {
                        int i;
                        procInProgress = false;
                        if (!optimizeBranches())
                            return false;

                        addWord(0x8000 | (procNameLength << 8) | procName[0]);
                        for (i = 1; i < procNameLength; i += 2) {
                            int x = 0;
                            x = (procName[i] << 8);
                            if (i < (procNameLength - 1))
                                x |= procName[i + 1];
                            addWord(x);
                        }
                        addWord(0);

                        if (prjHdr && ((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG)) {
                            setGlobalCodeLabelSize(curProcIndex, getPC() - procStart);
                            addGlobalSymbol(curProcIndex);
                        }

                        if (getPC() > 1024)
                            if (!stashCode()) return false;
                    }
                    break;
                case Token_EndProc : {
		  //                        int i;
                        if (!hadBeginProc) {
                            error("No matching beginproc");
                            return false;
                        }
                        if (!procInProgress) {
                            error("No proc in progress for endproc");
                            return false;
                        }
                        addWord(0x4E5E);        // Unlk A6
                        addWord(0x4E75);        // Rts
                        procInProgress = false;
                        if (!optimizeBranches())
                            return false;

			// S. Little
			// 20040219
			// wrapped function name insertion in debug tags
                        if (prjHdr && ((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG)) {
			  int i;
                        addWord(0x8000 | (procNameLength << 8) | procName[0]);
                        for (i = 1; i < procNameLength; i += 2) {
                            int x = 0;
                            x = (procName[i] << 8);
                            if (i < (procNameLength - 1))
                                x |= procName[i + 1];
                            addWord(x);
                        }
                        addWord(0);

			//                        if (prjHdr && ((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG)) {
			//                            int i;
                            setGlobalCodeLabelSize(curProcIndex, getPC() - procStart);
                            addGlobalSymbol(curProcIndex);
                            for (i = 0; i < localSymbolIndex; i++) {
//                              if (localSymbol[i].offset > 0) {
                                    addSymbol(localSymbol[i].name, localSymbol[i].length, SymLocal, localSymbol[i].offset, localSymbol[i].size, localSymbol[i].type);
//                              }
//                              else
//                                  break;
                            }
                        }

                        if (getPC() > 1024)
                            if (!stashCode()) return false;

                    }
                    break;
                case Token_End :
                    if (!procInProgress) {
                        error("No proc in progress for endproc");
                        return false;
                    }
                    if (hadBeginProc) {
                        error("Beginproc without endproc");
                        return false;
                    }
                    procInProgress = false;
                    if (!optimizeBranches())
                        return false;

                    setGlobalCodeLabelSize(curProcIndex, getPC());

                    break;
                case Token_Return :
                    if (!procInProgress) {
                        error("No proc in progress for return");
                        return false;
                    }
                    else {
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token == Digit) {
                            addSymbol(NULL, 0, SymReturn, 0, 0, (DBG_TypeFlag)value);
                        }
                        else {
                            addSymbol(NULL, 0, SymReturn, 0, 0, DBG_Unknown);
                            pushBack(token, value, startPtr, hash);
                        }
                    }
                    break;
                case Token_Local :
                    if (!procInProgress) {
                        error("No proc in progress for local");
                        return false;
                    }
                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                    if (token != Identifier) {
                        error("Local name expected");
                        return false;
                    }
                    else {
                        if (localSymbolIndex == MaxLocalSymbols) {
                            error("Too many locals");
                            return false;
                        }
                        else {
                            int sizeSpec = WordSize;
                            localSymbol[localSymbolIndex].name = startPtr;
                            localSymbol[localSymbolIndex].length = value;
                            localSymbol[localSymbolIndex].hash = hash;
                            curTextPtr = getSizeSpec(curTextPtr, &sizeSpec, true);
                            if (sizeSpec == 0) return false;
                            localSymbol[localSymbolIndex].size = sizeSpec;
                            if (sizeSpec < 0) {
                                procStackSize += -sizeSpec;
                                if ((procStackSize & 1) != 0) procStackSize++;
                            }
                            else {
                                procStackSize += 2;
                                if (sizeSpec == LongSize) procStackSize += 2;
                            }
                            localSymbol[localSymbolIndex].offset = -procStackSize;

                            curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                            if (token == Digit) {
                                localSymbol[localSymbolIndex].type = (DBG_TypeFlag)value;
                            }
                            else {
                                localSymbol[localSymbolIndex].type = DBG_Unknown;
                                pushBack(token, value, startPtr, hash);
                            }
                            localSymbolIndex++;
                        }
                    }
                    break;
                case Token_Systrap :
                    curTextPtr = buildSysTrapInstruction(curTextPtr);
                    if (curTextPtr == NULL) return false;
                    break;
                case Token_Dc : {
                        int sizeSpec = WordSize;
                        curTextPtr = getSizeSpec(curTextPtr, &sizeSpec, true);
                        if (sizeSpec == 0) return false;
                        curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                        if (token == DoubleQuote) {
                            if (sizeSpec != ByteSize) {
                                error("string constant must be specified with dc.b");
                                return false;
                            }
                            if (inCodeSeg)
                                addStringConstantToCode(startPtr, value);
                            else
                                addStringConstant(startPtr, value);
                        }
                        else {
                            if (token == Identifier) {
                                long target;
                                if (procInProgress || inCodeSeg) {
                                    error("Can only initialize global data with references");
                                    return false;
                                }
                                if (sizeSpec != LongSize) {
                                    error("Reference initialization must be dc.l");
                                    return false;
                                }
                                if ((getDataOffset() & 1) != 0) addDataByte(0);
                                target = findGlobalCodeLabel(startPtr, value, hash, -1);
                                if (target == -1) {
                                    target = addGlobalDataLabel(startPtr, value, hash, -1);
                                    if (target == -9999) return false;
                                    if (!addGlobalDataFixup(target & 0xFFFF, getDataOffset(), false)) return false;
                                }
                                else {
                                    if (!addGlobalCodeFixup(target & 0xFFFF, getDataOffset(), false)) return false;
                                }
                                addDataWord(0);
                                addDataWord(0);
                            }
                            else {
                                Boolean negative = false;
                                if (token == Minus) {
                                    negative = true;
                                    curTextPtr = getNextToken(curTextPtr, &token, &value, &startPtr, &hash);
                                }
                                if ((token != Digit) && (token != HexDigit)) {
                                    error("initializer expected");
                                    return false;
                                }
                                else {
                                    if (negative) value = -value;
                                    if (sizeSpec < 0) {
                                        int i;
                                        int size = -sizeSpec;
                                        if (inCodeSeg) {
                                            int fillValue = (value & 0xFF) | ((value & 0xFF) << 8);
                                            if ((size & 1) != 0) size++;
                                            size >>= 2;
                                            for (i = 0; i < size; i++) {
                                                addWord(fillValue);
                                            }
                                        }
                                        else {
                                            if ((dataTop & 1) != 0) addDataByte(0);
                                            for (i = 0; i < size; i++) {
                                                addDataByte(value);
                                            }
                                        }
                                    }
                                    else {
                                        switch (sizeSpec) {
                                            case ByteSize :
                                                if (inCodeSeg)
                                                    addWord(value & 0xFF);
                                                else
                                                    addDataByte(value);
                                                break;
                                            case WordSize :
                                                if (inCodeSeg)
                                                    addWord(value & 0xFFFF);
                                                else {
                                                    if ((getDataOffset() & 1) != 0) addDataByte(0);
                                                    addDataWord(value);
                                                }
                                                break;
                                            case LongSize :
                                                if (inCodeSeg) {
                                                    addWord(value >> 16);
                                                    addWord(value & 0xFFFF);
                                                }
                                                else {
                                                    if ((getDataOffset() & 1) != 0) addDataByte(0);
                                                    addDataWord(value >> 16);
                                                    addDataWord(value & 0xFFFF);
                                                }
                                                break;
                                        }
                                    }
                                }
                            }
                        }
                    }
                    break;
                default :
                    error("Unexpected token");
                    return false;
            }
        }
    }
    if (procInProgress) {
        error("Proc not completed");
        return false;
    }
    return true;
}


Boolean completeSegmentFixups(Boolean *addLongMath)
{
    int i;
    UInt *codebase;
    Boolean success = true;
    Boolean foundMathName = false;
    ULong codeSize;

    if (!stashCode()) return false;
    codebase = MemHandleLock(gCodeStashH);
    codeSize = gCodeStashTop;

    for (i = 0; i < globalCodeFixupTop; i++) {
        int j;
        LabelData *tgtLabel = &globalCodeLabelList[globalCodeFixupList[i].index];
        for (j = 0; j < 5; j++) {
            if ((longMath[j].length == tgtLabel->length)
                    && (longMath[j].hash == tgtLabel->hash)) {
                int x;
                foundMathName = true;
                for (x = 0; x < longMath[j].length; x++) {
                    if (longMath[j].name[x] != tgtLabel->name[x]) {
                        foundMathName = false;
                        break;
                    }
                }
                if (foundMathName) {
                    int k;
                    for (k = 0; k < 5; k++) {
                        if (addGlobalCodeLabel(longMath[k].name, longMath[k].length, longMath[k].hash, longMath[k].offset + codeSize) == -9999)
                            return false;
                    }
                    break;
                }
            }
        }
        if (foundMathName) break;
    }

    if (foundMathName) *addLongMath = true;

    for (i = 0; i < globalCodeFixupTop; i++) {
        long targetOffset = globalCodeLabelList[globalCodeFixupList[i].index].offset;
        if (targetOffset == -1) {
            int t,x;
//          StrCopy(errBuf, "(seg) Global fixup to unknown code label ");
            StrPrintF(errBuf, "(seg) Global fixup to unknown code label (%d) %d ",
                                    globalCodeFixupList[i].index,
                                    globalCodeLabelList[globalCodeFixupList[i].index].length );
            t = StrLen(errBuf);
            for (x = 0; x < globalCodeLabelList[globalCodeFixupList[i].index].length; x++)
                errBuf[t + x] = globalCodeLabelList[globalCodeFixupList[i].index].name[x];
            errBuf[t + x] = '\0';
            error(errBuf);
            //error("Global fixup to unknown code label");
            success = false;
            break;
        }
        if (globalCodeFixupList[i].fromCode) {
//          objectCodePtr[globalCodeFixupList[i].offset >> 1] += targetOffset - globalCodeFixupList[i].offset;
            UInt t = codebase[globalCodeFixupList[i].offset >> 1];
            t += targetOffset - globalCodeFixupList[i].offset;
            DmWrite(codebase, globalCodeFixupList[i].offset, &t, sizeof(UInt));
        }
    }

    if (foundMathName) {    // want to remove them now, and re-discover anew them for the next segment
        int k;
        for (k = 0; k < 5; k++)
            removeGlobalCodeLabel(longMath[k].name, longMath[k].length, longMath[k].hash);
    }

    MemHandleUnlock(gCodeStashH);
    return true;
}

void setStatus(CharPtr message, CharPtr status, int length)
{
    CharPtr p;
    FormPtr frm = FrmGetActiveForm();
    Int fldIndex = FrmGetObjectIndex(frm, MainListStatusField);
    FieldPtr fld = FrmGetObjectPtr(frm, fldIndex);
    Handle h;
    Handle oldH = (Handle)FldGetTextHandle(fld);
    int messageLength = StrLen(message);
    h = MemHandleNew(messageLength + length + 1);
    p = MemHandleLock(h);
    StrCopy(p, message);
    MemMove(p + messageLength, status, length);
    p[messageLength + length] = 0;
    MemHandleUnlock(h);
    FldSetTextHandle(fld, h);
    FldDrawField(fld);
    if (oldH != NULL) MemHandleFree(oldH);
}

int targetIndex = -1;



static Boolean mainListEventHandler(EventPtr event)
{
    Boolean handled = false;
    switch (event->eType) {

        case frmOpenEvent: {
                Boolean result = false;
                FormPtr frm = FrmGetActiveForm();

                if (gInvokedFromCompiler) {
                    CharPtr sourceText;
                    Handle h;
                    ProjectHeader_New *prjHdr;
                    SourceFile *src;
                    int i;
                    DmOpenRef projDB = DmOpenDatabase(0, gTargetDB, dmModeReadOnly);

                    FrmDrawForm(frm);


                    h = DmGet1Resource('OBPJ', 1);
                    prjHdr = MemHandleLock(h);

                    if (prjHdr->mVersion < PROJECT_VERSION_CURRENT) {
                        error("Wrong project version - try rebuilding all sources");
                        MemHandleUnlock(h);
                        DmReleaseResource(h);
                        DmCloseDatabase(projDB);
                        break;
                    }

                    src = (SourceFile *)(prjHdr + 1);

                    StrCopy(gPRCName, prjHdr->mPrcName);
                    gCreator = prjHdr->mCreator;
                    gType = prjHdr->mType;

                    for (i = 0; i < prjHdr->mSourceDBCount; i++) {
                        if (src[i].sourceKind != Resource) {

                            if (prjHdr->mVersion == PROJECT_VERSION_NEWOBJ)
                                sourceText = getSourceAsm(src[i].outputDBid);
                            else
                                sourceText = getSourceText( ((prjHdr->mFlags & REBUILD_FLAG) == REBUILD_FLAG), src[i].outputDBid);
                            if (sourceText != NULL) {
                                result = compile(sourceText, prjHdr, i);
                                if (!result) {
                                    error("Assembly abended");
                                }
                                break;
                            }
                            else
                                break;
                        }
                    }
                    if (result) {
                        UInt cardNo;
                        LocalID dbID = 0;
                        DmSearchStateType searchState;
                        Err err;

                        Boolean executable = false;
                        LocalID lid = 0;
                        result = finish(&lid, (prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG, &executable, prjHdr->mType);
                        if (!result) {
                            error("Output incomplete");
                        }
                        else {
                            if (lid) {
                                DmOpenRef tgtDB = DmOpenDatabase(0, lid, dmModeReadWrite);
                                for (i = 0; i < prjHdr->mSourceDBCount; i++) {
                                    if (src[i].sourceKind == Resource) {
                                        int x;
                                        UInt count;
                                        LocalID dbID = DmFindDatabase(0, src[i].sourceDB);
                                        DmOpenRef srcDB = DmOpenDatabase(0, dbID, dmModeReadWrite);
                                        count = DmNumResources(srcDB);
                                        for (x = 0; x < count; x++) {
                                            ULong type;
                                            UShort resID;
                                            Handle srcH, tgtH;
                                            int tgtIndex;
                                            long size;

                                            DmResourceInfo(srcDB, x, &type, &resID, NULL);
                                            tgtIndex = DmFindResource(tgtDB, type, resID, NULL);
                                            if (tgtIndex != -1) {
                                                DmRemoveResource(tgtDB, tgtIndex);
                                            }
                                            srcH = DmGetResourceIndex(srcDB, x);
                                            size = MemHandleSize(srcH);
                                            tgtH = DmNewResource(tgtDB, type, resID, size);
                                            if (tgtH == NULL) {
                                                error("out of memory (21)");
                                                result = false;
                                                break;
                                            }
                                            if ((type == 'tver')
                                                    && (size >= 5)
                                                    && ((prjHdr->mFlags & AUTOVERSION_FLAG) == AUTOVERSION_FLAG)) {
                                                CharPtr p = MemHandleLock(srcH);
                                                Int d = (p[size - 5] - '0') * 1000
                                                            + (p[size - 4] - '0') * 100
                                                            + (p[size - 3] - '0') * 10
                                                            + (p[size - 2] - '0') + 1;
                                                char buf[4];
                                                DmWrite(MemHandleLock(tgtH), 0, p, size);
                                                buf[0] = (d / 1000) + '0';
                                                d = d % 1000;
                                                buf[1] = (d / 100) + '0';
                                                d = d % 100;
                                                buf[2] = (d / 10) + '0';
                                                d = d % 10;
                                                buf[3] = d + '0';
                                                DmWrite(p, size - 5, buf, 4);
                                            }
                                            else
                                                DmWrite(MemHandleLock(tgtH), 0, MemHandleLock(srcH), size);
                                            MemHandleUnlock(srcH);
                                            MemHandleUnlock(tgtH);
                                            DmReleaseResource(srcH);
                                            DmReleaseResource(tgtH);
                                        }
                                        DmCloseDatabase(srcDB);
                                    }
                                }
                                DmCloseDatabase(tgtDB);
                            }
                        }
                        if (result && gExecute && executable) {
                            if ((prjHdr->mFlags & DEBUG_FLAG) == DEBUG_FLAG) {
                                dbID = DmFindDatabase(0, "OBDebug");
                                if (dbID) {
                                    GoToParamsType *pBlock = (GoToParamsType *)MemPtrNew(sizeof(GoToParamsType));
                                    MemPtrSetOwner(pBlock, 0);
                                    MemSet(pBlock, sizeof(GoToParamsType), 0);
                                    pBlock->dbID = lid;
                                    err = SysUIAppSwitch(0, dbID, sysAppLaunchCmdGoTo, (Ptr)pBlock);
                                    ErrNonFatalDisplayIf(err, "Could not launch OBDebug");
                                    gExecute = false;
                                }
                                else
                                    error("Couldn't find OBDebug");
                            }
                            else {
                                err = SysUIAppSwitch(0, lid, sysAppLaunchCmdNormalLaunch, NULL);
                            }
                        }
                        else {
                            if (gExecute && (prjHdr->mType == 'HACK')) {
                                err = DmGetNextDatabaseByTypeCreator(true, &searchState, 'appl', 'dwHM', true, &cardNo, &dbID);
                                if ((err == 0) && dbID) {
                                    err = SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdNormalLaunch, NULL);
                                    ErrNonFatalDisplayIf(err, "Could not launch HackMaster");
                                    gExecute = false;
                                }
                            }
                        }
                    }
                    if (prjHdr->mVersion == PROJECT_VERSION_NEWOBJ) {
                        closeAllDBs( ((prjHdr->mFlags & REBUILD_FLAG) == REBUILD_FLAG) );
                    }
                    MemHandleUnlock(h);
                    DmReleaseResource(h);
                    DmCloseDatabase(projDB);
                    if (!result || !gExecute) {
                        EventType newEvent;
                        MemSet(&newEvent, sizeof(EventType), 0);
                        newEvent.eType = appStopEvent;
                        EvtAddEventToQueue(&newEvent);
                    }
                }
                else {
                    FrmDrawForm(frm);
                    if (gPrefs.memoRecords) {
                        FrmSetControlGroupSelection(frm, MainListGroupID, MainListMemoPushButton);
                        collectAsmTextNamesFromMemoDB();
                    }
                    else {
                        FrmSetControlGroupSelection(frm, MainListGroupID, MainListQedPushButton);
                        collectAsmTextNamesFromQED();
                    }
                    setStatus("", "", 0);
                    setListSelection(gPrefs.sourceName);
                }

                handled = true;
            }
            break;

        case menuEvent:
            switch (event->data.menu.itemID) {
                case OptionsAboutOnBoardAssembler: {
                        FormPtr frm = FrmInitForm(AboutForm);
                        FrmDoDialog(frm);
                        FrmDeleteForm(frm);
                    }
                    break;
            }
            handled = true;
            break;

        case lstSelectEvent :
            gSourceIndex = event->data.lstSelect.selection;
            break;

        case ctlSelectEvent:
            switch (event->data.ctlSelect.controlID) {
                case MainListMemoPushButton : {
                        if (event->data.ctlSelect.on) {
                            collectAsmTextNamesFromMemoDB();
                            gPrefs.memoRecords = true;
                        }
                    }
                    break;
                case MainListQedPushButton : {
                        if (event->data.ctlSelect.on) {
                            collectAsmTextNamesFromQED();
                            gPrefs.memoRecords = false;
                        }
                    }
                    break;
                case MainListBuildButton : {
                        CharPtr sourceText = getSourceText(!gKeepAsm, 0);
                        Boolean executable = false;
                        if (sourceText != NULL) {
                            Boolean result;
                            StrCopy(gPRCName, getSourceName());
                            gCreator = *((ULong *)gPRCName);
                            result = compile(sourceText, NULL, 0);
                            if (result) {
                                LocalID lid;
                                result = finish(&lid, false, &executable, 'code');
                                if (!result) error("Output incomplete");
                            }
                            else
                                error("Assembly abended");
                        }
                        else
                            error("Source missing");
                    }
                    break;
            }
            break;
        default:
            break;

    }
    return handled;
}

Boolean applicationHandleEvent(EventPtr event)
{
    FormPtr frm;

    Int     formId;
    Boolean handled = false;

    if (event->eType == frmLoadEvent) {
        formId = event->data.frmLoad.formID;
        frm = FrmInitForm(formId);
        FrmSetActiveForm(frm);
        switch (formId) {
            case MainListForm :
                FrmSetEventHandler(frm, mainListEventHandler);
                break;
        }
        handled = true;
    }
    return handled;
}


void eventLoop()
{
    EventType   event;
    Word            error;

    do {
        EvtGetEvent(&event, -1);
        if (!SysHandleEvent(&event))
            if (!MenuHandleEvent(0, &event, &error))
                if (!applicationHandleEvent(&event))
                    FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
}


/***********************************************************************
 *
 * FUNCTION:    RomVersionCompatible
 *
 * DESCRIPTION: P4. Check that the ROM version meets your
 *              minimum requirement.  Warn if the app was switched to.
 *
 * PARAMETERS:  requiredVersion - minimum rom version required
 *                                (see sysFtrNumROMVersion in SystemMgr.h
 *                                for format)
 *              launchFlags     - flags indicating how the application was
 *                                           launched.  A warning is displayed only if
 *                                these flags indicate that the app is
 *                                           launched normally.
 *
 * RETURNED:    zero if rom is compatible else an error code
 *
 ***********************************************************************/
static Err RomVersionCompatible (DWord requiredVersion, Word launchFlags)
{
    DWord romVersion;


    // See if we're on in minimum required version of the ROM or later.
    // The system records the version number in a feature.  A feature is a
    // piece of information which can be looked up by a creator and feature
    // number.
    FtrGet(sysFtrCreator, sysFtrNumROMVersion, &romVersion);
    if (romVersion < requiredVersion)
        {
        // If the user launched the app from the launcher, explain
        // why the app shouldn't run.  If the app was contacted for something
        // else, like it was asked to find a string by the system find, then
        // don't bother the user with a warning dialog.  These flags tell how
        // the app was launched to decided if a warning should be displayed.
        if ((launchFlags & (sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp)) ==
            (sysAppLaunchFlagNewGlobals | sysAppLaunchFlagUIApp))
            {
//          FrmAlert (RomIncompatibleAlert);

            // Pilot 1.0 will continuously relaunch this app unless we switch to
            // another safe one.  The sysFileCDefaultApp is considered "safe".
            if (romVersion < 0x02000000)
                {
//              Err err;

                AppLaunchWithCommand(sysFileCDefaultApp, sysAppLaunchCmdNormalLaunch, NULL);
                }
            }

        return (sysErrRomIncompatible);
        }

    return 0;
}

Boolean startApplication()
{
    UInt at;

    Word prefSize = sizeof(PrefsData);

    errorCount = 0;
    gMatchReservedWords = true;
    objectCodeHandle = NULL;
    objectCodeSize = 0;
    objectCodeTop = 0;
    dataHandle = NULL;
    dataSize = 0;
    dataTop = 0;
    totalDataSize = 0;
    dataInit = NULL;
    dataInitSize = 0;
    codeInit = NULL;
    codeInitSize = 0;
    targetIndex = -1;
    branchListHandle = NULL;
    gExecute = false;
    gKeepAsm = true;
    gInvokedFromCompiler = false;

    dataDB = DmOpenDatabaseByTypeCreator('DATA', 'OnBA', dmModeReadWrite);
    if (dataDB == NULL) {
        int error;
        error = DmCreateDatabase(0, "AssemblerData.OnBA", 'OnBA', 'DATA', false);
        dataDB = DmOpenDatabaseByTypeCreator('DATA', 'OnBA', dmModeReadWrite);
    }
    else {
        UInt num = DmNumRecords(dataDB);
        if (num > 0) {
            UInt i;
            for (i = 0; i < num; i++) {
                DmRemoveRecord(dataDB, 0);
            }
        }
    }

    at = 0;
    instructionH = DmNewRecord(dataDB, &at, InstructionTableSize * sizeof(InstructionData));
    if (instructionH == NULL) return false;
    instructionDataPtr = MemHandleLock(instructionH);

    at = 1;
    eaMappingH = DmNewRecord(dataDB, &at, sizeof(short) * 64);
    if (eaMappingH == NULL) return false;
    eaMappingPtr = MemHandleLock(eaMappingH);

    initDataTables();

    at = 2;
    globalDataFixupListH = DmNewRecord(dataDB, &at, sizeof(FixupData) * gMaxGlobalDataFixups);
    if (globalDataFixupListH == NULL) return false;
    globalDataFixupList = MemHandleLock(globalDataFixupListH);
    gGlobalDataFixupIndex = at;

    at = 3;
    localCodeLabelListH = DmNewRecord(dataDB, &at, sizeof(LabelData) * gMaxLocalCodeLabels);
    if (localCodeLabelListH == NULL) return false;
    localCodeLabelList = MemHandleLock(localCodeLabelListH);
    gLocalCodeLabelIndex = at;

    at = 4;
    globalCodeFixupListH = DmNewRecord(dataDB, &at, sizeof(FixupData) * gMaxGlobalCodeFixups);
    if (globalCodeFixupListH == NULL) return false;
    globalCodeFixupList = MemHandleLock(globalCodeFixupListH);
    gGlobalCodeFixupIndex = at;

    at = 5;
    globalDataLabelListH = DmNewRecord(dataDB, &at, sizeof(LabelData) * gMaxGlobalDataLabels);
    if (globalDataLabelListH == NULL) return false;
    globalDataLabelList = MemHandleLock(globalDataLabelListH);
    gGlobalDataLabelIndex = at;

    at = 6;
    globalCodeLabelListH = DmNewRecord(dataDB, &at, sizeof(LabelData) * gMaxGlobalCodeLabels);
    if (globalCodeLabelListH == NULL) return false;
    globalCodeLabelList = MemHandleLock(globalCodeLabelListH);
    gGlobalCodeLabelIndex = at;

    at = 7;
    gSymbolDataH = DmNewRecord(dataDB, &at, sizeof(SymbolData) * gMaxSymbolData);
    if (gSymbolDataH == NULL) return false;
    gSymbolDataList = MemHandleLock(gSymbolDataH);
    gSymbolDataIndex = at;

    at = 8;
    gSymbolStringH = DmNewRecord(dataDB, &at, gMaxSymbolString);
    if (gSymbolStringH == NULL) return false;
    gSymbolString = MemHandleLock(gSymbolStringH);
    gSymbolStringIndex = at;

    codeCopyDB = DmOpenDatabaseByTypeCreator('CDTA', 'OnBA', dmModeReadWrite);
    if (codeCopyDB == NULL) {
        int error;
        error = DmCreateDatabase(0, "AssemblerCodeData.OnBA", 'OnBA', 'CDTA', false);
        if (error) return false;
        codeCopyDB = DmOpenDatabaseByTypeCreator('CDTA', 'OnBA', dmModeReadWrite);
    }
    else {
        UInt num = DmNumRecords(codeCopyDB);
        if (num > 0) {
            UInt i;
            for (i = 0; i < num; i++) {
                DmRemoveRecord(codeCopyDB, 0);
            }
        }
    }
    at = 0;
    gCodeStashH = DmNewRecord(codeCopyDB, &at, InitialCodeStashSize);
    if (gCodeStashH == NULL) return false;
    gCodeStashTop = 0;
    gCodeStashSize = InitialCodeStashSize;


    sourceCopyDB = DmOpenDatabaseByTypeCreator('SDTA', 'OnBA', dmModeReadWrite);
    if (sourceCopyDB == NULL) {
        int error;
        error = DmCreateDatabase(0, "AssemblerSourceData.OnBA", 'OnBA', 'SDTA', false);
        if (error) return false;
        sourceCopyDB = DmOpenDatabaseByTypeCreator('SDTA', 'OnBA', dmModeReadWrite);
    }
    else {
        UInt num = DmNumRecords(sourceCopyDB);
        if (num > 0) {
            UInt i;
            for (i = 0; i < num; i++) {
                DmRemoveRecord(sourceCopyDB, 0);
            }
        }
    }

    buildReservedWordHashMap();

    if (!PrefGetAppPreferences('OnBA', 1000, &gPrefs, &prefSize, false)) {
        gPrefs.memoRecords = true;
        gPrefs.sourceName[0] = 0;
        gPrefs.execute = true;
        gPrefs.saveASM = false;
    }


    return true;

}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    Word err;

    err = RomVersionCompatible (version20, launchFlags);

    if (err) return err;

    if ((cmd == sysAppLaunchCmdNormalLaunch)
            || (cmd == sysAppLaunchCmdGoTo)) {
/*
        DateTimeType dt;
        TimSecondsToDateTime(TimGetSeconds(), &dt);
        if ((dt.month > november) || (dt.year > 1998)) {
            FrmAlert(BetaExpiredAlert);
            return 0;
        }
*/
        if (!startApplication()) {
            error("Startup failed!");
            return -1;
        }

        if (cmd == sysAppLaunchCmdGoTo) {
            gTargetRecord = ((GoToParamsType *)cmdPBP)->recordNum;
            gTargetDB = ((GoToParamsType *)cmdPBP)->dbID;
            gExecute = (((GoToParamsType *)cmdPBP)->matchCustom >> 1) & 0x1;
            gKeepAsm = (((GoToParamsType *)cmdPBP)->matchCustom) & 0x1;
            gTokenStream = !gKeepAsm;
            gInvokedFromCompiler = true;
            if (gTargetRecord == -1)
                gPrefs.memoRecords = false;
            else
                gPrefs.memoRecords = true;
        }

    FrmGotoForm(MainListForm);
    eventLoop();

    emptyEquList();

        PrefSetAppPreferences('OnBA', 1000, 1, &gPrefs, sizeof(PrefsData), false);

        if (instructionH != NULL)
            MemHandleUnlock(instructionH);
        if (eaMappingH != NULL)
            MemHandleUnlock(eaMappingH);
        if (globalDataFixupListH != NULL)
            MemHandleUnlock(globalDataFixupListH);
        if (localCodeLabelListH != NULL)
            MemHandleUnlock(localCodeLabelListH);
        if (globalCodeFixupListH != NULL)
            MemHandleUnlock(globalCodeFixupListH);
        if (globalDataLabelListH != NULL)
            MemHandleUnlock(globalDataLabelListH);
        if (globalCodeLabelListH != NULL)
            MemHandleUnlock(globalCodeLabelListH);
        if (gSymbolDataH != NULL)
            MemHandleUnlock(gSymbolDataH);
        if (gSymbolStringH != NULL)
            MemHandleUnlock(gSymbolStringH);
        if (dataDB != 0) {
            UInt i;
            UInt num = DmNumRecords(dataDB);
            for (i = 0; i < 8; i++)
                DmReleaseRecord(dataDB, i, true);
            if (num > 0) {
                for (i = 0; i < num; i++) {
                    DmRemoveRecord(dataDB, 0);
                }
            }
            DmCloseDatabase(dataDB);
        }
        if (codeCopyDB != 0) {
            UInt i;
            for (i = 0; i <= gSegCount; i++)
                DmReleaseRecord(codeCopyDB, i, true);
            for (i = 0; i <= gSegCount; i++)
                DmRemoveRecord(codeCopyDB, 0);
            DmCloseDatabase(codeCopyDB);
        }
        if (sourceCopyDB != 0) {
            UInt num = DmNumRecords(sourceCopyDB);
            if (num > 0) {
                UInt i;
                for (i = 0; i < num; i++)
                    DmReleaseRecord(sourceCopyDB, i, false);
                for (i = 0; i < num; i++)
                    DmRemoveRecord(sourceCopyDB, 0);
            }
            DmCloseDatabase(sourceCopyDB);
        }

        if(gAsmTextListIndex != NULL) {
            MemPtrFree(gAsmTextListIndex);
        }

        if(gAsmTextList != NULL) {
            UInt i;

            for(i = 0; i < gAsmTextListSize; i++) {
                MemPtrFree(gAsmTextList[i]);
            }

            MemPtrFree(gAsmTextList);
        }

        FrmCloseAllForms();
    }
    return 0;
}


