/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/

#include <PalmCompatibility.h>
#include <PalmOS.h>

#include "OnBoard.h"
#include "OnBoard_res.h"

CharPtr *gAsmTextList = NULL;     // the list of names
LongPtr gAsmTextListIndex = NULL; // list of either LocalID's for QED DBs or record numbers for Memo
UInt16 gAsmTextListSize = 0;

DmOpenRef gSourceDB;        // the Memo appl. DB or the QED DB
Handle sourceH;             // handle for Memo pad record

int gSourceIndex = -1;          // the selected source list entry when 'build' was pressed
/*
LocalID findDB(ULong type, ULong creator)
{
    ULong xtype = 0;
    ULong xcreator = 0;
    int i;

    UInt count = DmNumDatabases(0);
    for (i = 0; i < count; i++) {
        LocalID dbID = DmGetDatabase(0, i);
        DmDatabaseInfo(card, dbID, 0, 0, 0, 0, 0, 0, 0, 0, 0, &xtype, &xcreator);
        strLength = StrLen(dbName);
        if ((xtype == type) && (xcreator == creator)) {
            return dbID;
        }
    }
    return 0;
}
*/

void collectAsmTextNamesFromMemoDB()
{
    FormPtr frm = FrmGetActiveForm();
    Int fldIndex = FrmGetObjectIndex(frm, MainListAsmTextList);
    ListPtr lst = FrmGetObjectPtr(frm, fldIndex);
    DmOpenRef memoDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadWrite);
    UInt16 i;

    if(gAsmTextList != NULL) {
        for(i = 0; i < gAsmTextListSize; i++) {
            MemPtrFree(gAsmTextList[i]);
        }

        MemPtrFree(gAsmTextList);
    }

    if (gAsmTextListIndex != NULL) {
        MemPtrFree(gAsmTextListIndex);
    }

    gAsmTextListSize = 0;
    gAsmTextList = NULL;
    gAsmTextListIndex = NULL;

    if (memoDB != NULL) {
        UInt numRecords = DmNumRecords(memoDB);
        UInt asmTextCount = 0;
		Boolean *isAsmText = NULL;
		if (numRecords > 0)
		{
        	isAsmText = (Boolean *)MemPtrNew(numRecords);
        	if (isAsmText == NULL) error("failed to allocate isAsmText");
		}
		
        for (i = 0; i < numRecords; i++) {
            Handle h = DmGetRecord(memoDB, i);
            isAsmText[i] = false;
            if (h != NULL) {
                CharPtr p = MemHandleLock(h);
                if ((p[0] == '/') && (p[1] == '*')) {
                    isAsmText[i] = true;
                    asmTextCount++;
                }
                MemHandleUnlock(h);
                DmReleaseRecord(memoDB, i, false);
            }
        }
        if (asmTextCount > 0) {
            int index = 0;
            gAsmTextList = (char **)MemPtrNew(asmTextCount * sizeof(char *));
            gAsmTextListIndex = (long *)MemPtrNew(asmTextCount * sizeof(long));
            for (i = 0; i < numRecords; i++) {
                if (isAsmText[i]) {
                    CharPtr startPtr;
                    char hash;
                    int token;
                    long value;
                    Handle h = DmGetRecord(memoDB, i);
                    CharPtr p = MemHandleLock(h);
                    gMatchReservedWords = false;
                    getNextToken((p + 2), &token, &value, &startPtr, &hash);
                    gMatchReservedWords = true;
                    if (token == Identifier) {
                        int s;
                        CharPtr name = (char *)MemPtrNew(value + 1);
                        gAsmTextList[index] = name;         
                        gAsmTextListIndex[index] = i;               
                        for (s = 0; s < value; s++)
                            name[s] = startPtr[s];
                        name[s] = 0;
                        index++;    
                    }
                    MemHandleUnlock(h);
                    DmReleaseRecord(memoDB, i, false);
                }
            }
            gAsmTextListSize = index;
        }
		if (isAsmText != NULL)
	        MemPtrFree(isAsmText);
    }
    DmCloseDatabase(memoDB);
    gSourceIndex = -1;
    LstSetSelection(lst, -1);
    LstSetListChoices(lst, gAsmTextList, gAsmTextListSize);
    LstDrawList(lst);
}


CharPtr gMainSourceBasePtr;

CharPtr getSourceName()
{
    if (gSourceIndex != -1)
        return gAsmTextList[gSourceIndex];
    else
        return NULL;
}

void setFromTarget()
{
    int i;
    if (gTargetRecord == -1) {
        for (i = 0; i < gAsmTextListSize; i++) {
            if (gAsmTextListIndex[i] == gTargetDB) {
                gSourceIndex = i;
                break;
            }
        }
    }
    else {
        for (i = 0; i < gAsmTextListSize; i++) {
            if (gAsmTextListIndex[i] == gTargetRecord) {
                gSourceIndex = i;
                break;
            }
        }
    }
}

Handle gSourceH = NULL;

#define SOURCE_RECORD_NUMBER 0

LocalID gCurrentSourceDBID = 0;


#define MAX_SOURCE_FILES 128
struct {
    Handle h;
    DmOpenRef db;
    LocalID id;
} sourceFiles[MAX_SOURCE_FILES];
int sourceFileTop = 0;

void closeAllDBs(Boolean deleteFlag)
{
    int i;
    for (i = 0; i < sourceFileTop; i++)
    {
        MemHandleUnlock(sourceFiles[i].h);
        DmReleaseRecord(sourceFiles[i].db, 0, false);
        DmCloseDatabase(sourceFiles[i].db);
        if (deleteFlag) {
            DmDeleteDatabase(0, sourceFiles[i].id);
        }
    }   
}

void closeSourceDB()
{
    if ((sourceFileTop + 1) < MAX_SOURCE_FILES) {
        sourceFiles[sourceFileTop].h = gSourceH;
        sourceFiles[sourceFileTop].db = gSourceDB;
        sourceFiles[sourceFileTop].id = gCurrentSourceDBID;
        sourceFileTop++;
    }
    gCurrentSourceDBID = 0;
}

CharPtr getSourceText(Boolean deleteFlag, LocalID dbID)
{
    UInt at = SOURCE_RECORD_NUMBER;
    char zero = 0;
    ULong size;

    CharPtr sourcePtr = NULL;
    if ((gSourceIndex != -1) || (dbID != 0)) {
        if (gPrefs.memoRecords) {
            gSourceDB = DmOpenDatabaseByTypeCreator('DATA', 'memo', dmModeReadOnly);
            sourceH = DmGetRecord(gSourceDB, gAsmTextListIndex[gSourceIndex]);
            size = MemHandleSize(sourceH);
            gSourceH = DmNewRecord(sourceCopyDB, &at, size + 1);
            if (gSourceH == NULL) {
                error("out of memory (23)");
                return NULL;
            }
            sourcePtr = (CharPtr)MemHandleLock(gSourceH);
            
            DmWrite(sourcePtr, 0, MemHandleLock(sourceH), size);
            DmWrite(sourcePtr, size, &zero, 1);
            DmReleaseRecord(gSourceDB, gAsmTextListIndex[gSourceIndex], false);
            DmCloseDatabase(gSourceDB);

        }
        else {
            if (dbID == 0)
                gCurrentSourceDBID = gAsmTextListIndex[gSourceIndex];
            else
                gCurrentSourceDBID = dbID;
            gSourceDB = DmOpenDatabase(0, gCurrentSourceDBID, dmModeReadOnly);
            gSourceH = copyDOCSource(gSourceDB, sourceCopyDB, &at, NULL);
            if (gSourceH == NULL) return NULL;
            sourcePtr = (CharPtr)MemHandleLock(gSourceH);
            if (deleteFlag) {
                if (gCurrentSourceDBID != 0) {
                    DmDeleteDatabase(0, gCurrentSourceDBID);
                    gCurrentSourceDBID = 0;
                }
            }
        }
        // remember the name of the last built source file
        if (gSourceIndex != -1)
            StrCopy(gPrefs.sourceName, getSourceName());
    }
    
    return sourcePtr;
}

Handle copyDOCSource(DmOpenRef sourceDB, DmOpenRef theCopyDB, UIntPtr at, Handle *recordLengthList)
{
/*
    Build a zero terminated single record out of all the records (index > 0)
*/
    Handle copy;
    Handle original;
    CharPtr p;
    int i;
    int *rllp;
    int flag;
    unsigned long size;
    unsigned long offset;
    DOCHeader *header;
    
    original = DmGetRecord(sourceDB, 0);
    if (original == NULL) {
        DmCloseDatabase(sourceDB);
        return NULL;
    }
    header = (DOCHeader *)MemHandleLock(original);
    size = header->size;
    flag = header->flag;
    MemHandleUnlock(original);
    DmReleaseRecord(sourceDB, 0, false);

    if(flag==2){
      error("No support for compressed DOC files yet!");
      return NULL;
    }
    
    copy = DmNewRecord(theCopyDB, at, size + 1);
    if (copy == NULL) {
        DmCloseDatabase(sourceDB);
        error("Out of memory (24)");
        return NULL;
    }
    p = MemHandleLock(copy);
    offset = 0;

// save the record count in recordLengthList[0] - which is unused otherwise
//
    if (recordLengthList != NULL) {
        *recordLengthList = MemHandleNew(sizeof(int) * DmNumRecords(sourceDB));
        if (*recordLengthList == NULL) {
            error("Out of memory (25)");
            return NULL;
        }
        i = DmNumRecords(sourceDB);
        rllp = MemHandleLock(*recordLengthList);
        DmWrite(rllp, 0, &i, sizeof(int));
        MemHandleUnlock(*recordLengthList);
    }

    for (i = 1; i < DmNumRecords(sourceDB); i++) {
        int intSize;
        original = DmGetRecord(sourceDB, i);
        if (original == NULL) {
            error("GetRecord failed");
            DmCloseDatabase(sourceDB);
            return NULL;
        }
        size = MemHandleSize(original);
        if (recordLengthList != NULL) {
            rllp = MemHandleLock(*recordLengthList);
            intSize = size;
            DmWrite(rllp, i * sizeof(int), &intSize, sizeof(int));
            MemHandleUnlock(*recordLengthList);
        }
        DmWrite(p, offset, MemHandleLock(original), size);
        offset += size;
        MemHandleUnlock(original);
        DmReleaseRecord(sourceDB, i, false);
    }
    
    DmWrite(p, offset, "", 1);
    DmCloseDatabase(sourceDB);

    MemHandleUnlock(copy);
    DmReleaseRecord(theCopyDB, *at, true);
    copy = DmGetRecord(theCopyDB, *at);

    return copy;
}


void collectAsmTextNamesFromQED()
{
    FormPtr frm = FrmGetActiveForm();
    Int fldIndex = FrmGetObjectIndex(frm, MainListAsmTextList);
    ListPtr lst = FrmGetObjectPtr(frm, fldIndex);
    
//  LocalID dbID;
//  Boolean search = true;
//  DmSearchStateType state;
    ULong type = 0;//'TEXt';
    ULong creator = 0;//'REAd';
    UInt card = 0;
//  Err error;
    UInt16 i;
    UInt count = DmNumDatabases(0);

    char dbName[dmDBNameLength];

    if(gAsmTextList != NULL) {
        for(i = 0; i < gAsmTextListSize; i++) {
            MemPtrFree(gAsmTextList[i]);
        }

        MemPtrFree(gAsmTextList);
    }

    if (gAsmTextListIndex != NULL) {
        MemPtrFree(gAsmTextListIndex);
    }

    gAsmTextListSize = 0;
    gAsmTextList = (char **)MemPtrNew(sizeof(char *) * DmNumDatabases(0));
    gAsmTextListIndex = (long *)MemPtrNew(sizeof(long) * DmNumDatabases(0));

    for (i = 0; i < count; i++) {
        int strLength;
        Boolean isAsmCode;
        LocalID dbID = DmGetDatabase(0, i);
        DmDatabaseInfo(card, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, &type, &creator);
        strLength = StrLen(dbName);
        isAsmCode = (type == 'TEXt') && (creator == 'REAd') && (StrStr(dbName, ".asm") == (dbName + strLength - 4));
        if (isAsmCode) {
            gAsmTextListIndex[gAsmTextListSize] = dbID;
            gAsmTextList[gAsmTextListSize] = (char *)MemPtrNew(strLength + 1);
            StrCopy(gAsmTextList[gAsmTextListSize], dbName);
            gAsmTextListSize++;
        }
    }
/*
    while (true) {
        int strLength;
        Boolean isAsmCode = false;
        type = 0;
        creator = 0;
        error = DmGetNextDatabaseByTypeCreator(search, &state, type, creator, true, &card, &dbID);
        search = false;
        if (error != 0)
            break;
        DmDatabaseInfo(card, dbID, dbName, 0, 0, 0, 0, 0, 0, 0, 0, &type, &creator);
        strLength = StrLen(dbName);
        isAsmCode = (type == 'TEXt') && (creator == 'REAd') && (StrStr(dbName, ".asm") == (dbName + strLength - 4));
        if (isAsmCode) {
            gAsmTextListIndex[gAsmTextListSize] = dbID;
            gAsmTextList[gAsmTextListSize] = (char *)MemPtrNew(strLength + 1);
            StrCopy(gAsmTextList[gAsmTextListSize], dbName);
            gAsmTextListSize++;
        }
    }
*/
    gSourceIndex = -1;
    LstSetSelection(lst, -1);
    LstSetListChoices(lst, gAsmTextList, gAsmTextListSize);
    LstDrawList(lst);
}

void setListSelection(CharPtr sourceName)
{
    int i;
    for (i = 0; i < gAsmTextListSize; i++) {
        if (StrCompare(sourceName, gAsmTextList[i]) == 0) {
            FormPtr frm = FrmGetActiveForm();
            Int fldIndex = FrmGetObjectIndex(frm, MainListAsmTextList);
            ListPtr lst = FrmGetObjectPtr(frm, fldIndex);
            LstSetSelection(lst, i);
            gSourceIndex = i;
            break;
        }   
    }
}

void gotoEditor(CharPtr sourcePtr, int length)
{
    if (gPrefs.memoRecords) {
        GoToParamsType *pBlock;
        UInt                    cardNo;
        LocalID             dbID;
        DmSearchStateType   searchState;
        Err err;
        //UInt pblockAt = 0;
    
        pBlock = (GoToParamsType *)MemPtrNew(sizeof(GoToParamsType));
        MemPtrSetOwner(pBlock, 0);
        
        pBlock->searchStrLen = length;      // length of search string.
        pBlock->dbCardNo = 0;           // card number of the database  
        pBlock->dbID = 0;               // LocalID of the database
        pBlock->recordNum = gAsmTextListIndex[gSourceIndex];            // index of record that contain a match
        pBlock->matchPos = sourcePtr - gMainSourceBasePtr;          // postion in record of the match.
        pBlock->matchFieldNum = 0;      // field number string was found int
        pBlock->matchCustom = 0;        // application specific info
        
        DmGetNextDatabaseByTypeCreator(true, &searchState, 'appl', 'memo', true, &cardNo, &dbID);
        ErrNonFatalDisplayIf(!dbID, "Could not find app");
        if (dbID) {
            err = SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdGoTo, (Ptr)pBlock);
            ErrNonFatalDisplayIf(err, "Could not launch app");
        }
    }
    else {
        // QED doesn't support Goto so we launch it instead and
        // change it's savedPrefs record to the name of the error DB,
        // and set the cursor position in the appInfoBlock of that DB
        LocalID dbID;
        DmSearchStateType searchState;
        UInt cardNo;
        QEDPrefsData QEDPrefs;
        DmOpenRef theSourceDB;
        LocalID appInfoID;
        long cursorPos;
        UInt version;
        theSourceDB = DmOpenDatabase(0, gAsmTextListIndex[gSourceIndex], dmModeReadWrite);
        cursorPos = sourcePtr - gMainSourceBasePtr;
        StrCopy(QEDPrefs.name, getSourceName());

        DmGetNextDatabaseByTypeCreator(true, &searchState, 'appl', 'QEDi', true, &cardNo, &dbID);
        ErrNonFatalDisplayIf(!dbID, "Could not find app");
        DmDatabaseInfo(0, dbID, 0, 0, &version, 0, 0, 0, 0, 0, 0, 0, 0);
        
        PrefSetAppPreferences('QEDi', 1, version, &QEDPrefs, sizeof(QEDPrefsData), true);
        
        appInfoID = DmGetAppInfoID(theSourceDB);
        if (appInfoID != 0) {
            long *p = MemLocalIDToLockedPtr(appInfoID, 0);
            long pageStart = cursorPos - 10;    // set page top as 10 characters before error
            if (pageStart < 0) pageStart = 0;
            DmWrite(p, 0, &pageStart, sizeof(long));
            DmWrite(p, 4, &cursorPos, sizeof(long));
            if (MemLocalIDKind(appInfoID) == memIDHandle) {
                MemHandleUnlock(MemPtrRecoverHandle(p));
            }
        }
        DmCloseDatabase(theSourceDB);
        
        if (dbID) {
            Err err = SysUIAppSwitch(cardNo, dbID, sysAppLaunchCmdNormalLaunch, NULL);
            ErrNonFatalDisplayIf(err, "Could not launch app");
        }
    }
}

CharPtr getSourceAsm(LocalID dbID)
{
    CharPtr sourcePtr = NULL;
    gCurrentSourceDBID = dbID;
    gSourceDB = DmOpenDatabase(0, gCurrentSourceDBID, dmModeReadOnly);
    gSourceH = DmGetRecord(gSourceDB, 0);
    if (gSourceH == NULL) {
        //int err = DmGetLastErr();
        return NULL;
    }
    sourcePtr = (CharPtr)MemHandleLock(gSourceH);
    return sourcePtr;
}

CharPtr getExtendAsm(CharPtr includeDBname, int includeNameLength)
{
    //UInt at = SOURCE_RECORD_NUMBER;
    LocalID lid;
    CharPtr sourcePtr = NULL;
    
    char buf[dmDBNameLength];
    StrNCopy(buf, includeDBname, includeNameLength);
    buf[includeNameLength] = '\0';

    lid = DmFindDatabase(0, buf);
    if (lid == 0) return NULL;
    gCurrentSourceDBID = lid;
    gSourceDB = DmOpenDatabase(0, lid, dmModeReadOnly);
    gSourceH = DmGetRecord(gSourceDB, 0);
    if (gSourceH == NULL) return NULL;
    sourcePtr = (CharPtr)MemHandleLock(gSourceH);

    return sourcePtr;
}

CharPtr getIncludeSource(CharPtr includeDBname, int includeNameLength, Boolean deleteFlag)
{
    UInt at = SOURCE_RECORD_NUMBER;
    LocalID lid;
    CharPtr sourcePtr = NULL;
    
    char buf[dmDBNameLength];
    StrNCopy(buf, includeDBname, includeNameLength);
    buf[includeNameLength] = '\0';

    lid = DmFindDatabase(0, buf);
    if (lid == 0) return NULL;
    gCurrentSourceDBID = lid;
    gSourceDB = DmOpenDatabase(0, lid, dmModeReadOnly);
    gSourceH = copyDOCSource(gSourceDB, sourceCopyDB, &at, NULL);
    if (gSourceH == NULL) return NULL;
    sourcePtr = (CharPtr)MemHandleLock(gSourceH);
    if (deleteFlag) {
        if (gCurrentSourceDBID != 0) {
            DmDeleteDatabase(0, gCurrentSourceDBID);
            gCurrentSourceDBID = 0;
        }
    }
    return sourcePtr;
}

