/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/

typedef enum {
	Asm_NotACharacter,			// 0x00
	Asm_Whitespace,				// 0x01
	Asm_Operator,				// 0x02
	Asm_Digit,					// 0x03
	Asm_HexDigit,				// 0x04
	Asm_Letter,					// 0x05
	Asm_EndOfInput,				// 0x06
	Asm_Identifier,				// 0x07
	Asm_Token_Error,			// 0x08
	Asm_Token_EOF,				// 0x09
	Asm_Number,					// 0x0A
	Asm_Dollar,					// 0x0B
	Asm_AddressOf,				// 0x0C
	Asm_LeftParen,				// 0x0D
	Asm_RightParen,				// 0x0E
	Asm_Plus,					// 0x0F
	Asm_Comma,					// 0x10
	Asm_Minus,					// 0x11
	Asm_Period,					// 0x12
	Asm_Divide,					// 0x13
	Asm_SemiColon,				// 0x14
	Asm_DoubleQuote,			// 0x15
	Token_d0,					// 0x16
	Token_d1,					// 0x17
	Token_d2,					// 0x18
	Token_d3,					// 0x19
	Token_d4,					// 0x1A
	Token_d5,					// 0x1B
	Token_d6,					// 0x1C
	Token_d7,					// 0x1D
	Token_a0,					// 0x1E
	Token_a1,					// 0x1F
	Token_a2,					// 0x20
	Token_a3,					// 0x21
	Token_a4,					// 0x22
	Token_a5,					// 0x23
	Token_a6,					// 0x24
	Token_a7, Token_SP=Token_a7,// 0x25 
	Token_PC,					// 0x26
	Token_Get,					// 0x27
	Token_Prc,					// 0x28
	Token_Label,				// 0x29
	Token_Goto,					// 0x2A
	Token_Systrap,				// 0x2B
	Token_Dc,					// 0x2C
	Token_Proc,					// 0x2D
	Token_BeginProc,			// 0x2E
	Token_EndProc,				// 0x2F
	Token_End,					// 0x30
	Token_Local,				// 0x31
	Token_Code,					// 0x32
	Token_Data,					// 0x33
	Token_Include,				// 0x34
	Token_Creator,				// 0x35
	ByteSpec,					// 0x36
	WordSpec,					// 0x37
	LongSpec,					// 0x38
	Unsized,					// 0x39
	Token_Instruction_Start, Token_Add = Token_Instruction_Start, // 0x3A
	Token_Sub = Token_Add + 6,		// 0x40
	Token_Adda = Token_Sub + 6,		// 0x46
	Token_Addi = Token_Adda + 2,	// 0x48
	Token_Addq = Token_Addi + 3,	// 0x4B
	Token_Suba = Token_Addq + 3,	// 0x4E
	Token_Subi = Token_Suba + 2,	// 0x50
	Token_Subq = Token_Subi + 3,	// 0x53
	Token_And = Token_Subq + 3,		// 0x56
	Token_Move = Token_And + 6,		// 0x5C
	Token_Cmpi = Token_Move + 3,	// 0x5F
	Token_Beq = Token_Cmpi + 3,		// 0x62
	Token_Ble = Token_Beq + 1,      // 0x63 // S. Little 17/03/2003
	Token_Bge = Token_Ble + 1,      // 0x64
	Token_Bgt = Token_Bge + 1,      // 0x65
	Token_Blt = Token_Bgt + 1,      // 0x66
	Token_Bne = Token_Blt + 1,      // 0x67
	Token_Movem = Token_Bne + 1,    // 0x68
	Token_Tst = Token_Movem + 12,   // 0x74
	Token_Unlk = Token_Tst + 3,     // 0x77
	Token_Link = Token_Unlk + 1,    // 0x78
	Token_Pea = Token_Link + 1,     // 0x79
	Token_Lea = Token_Pea + 1,      // 0x7A
	Token_Jsr = Token_Lea + 1,      // 0x7B
	Token_Rts = Token_Jsr + 1,      // 0x7C
	Token_Mulu = Token_Rts + 1,     // 0x7D
	Token_Muls = Token_Mulu + 1,    // 0x7E
	Token_Neg = Token_Muls + 1,     // 0x7F 
	Token_Cmp = Token_Neg + 3,      // 0x82
	Token_Ext = Token_Cmp + 3,      // 0x85
	Token_Bra = Token_Ext + 2,      // 0x87
	Token_Andi = Token_Bra + 1,     // 0x88
	Token_Moveq = Token_Andi + 3,   // 0x8B
	Token_Divu = Token_Moveq + 1,   // 0x8C
	Token_Divs = Token_Divu + 1,    // 0x8D
	Token_Swap = Token_Divs + 1,    // 0x8E
	Token_Lsl = Token_Swap + 1,     // 0x8F
	Token_Lsr = Token_Lsl + 6,      // 0x95
	Token_Asr = Token_Lsr + 6,      // 0x9B
	Token_Seq = Token_Asr + 6,      // 0xA1
	Token_Sle = Token_Seq + 1,      // 0xA2
	Token_Sge = Token_Sle + 1,      // 0xA3
	Token_Sgt = Token_Sge + 1,      // 0xA4
	Token_Slt = Token_Sgt + 1,      // 0xA5
	Token_Sne = Token_Slt + 1,      // 0xA6
	Token_Or = Token_Sne + 1,       // 0xA7 // ok point
	Token_Ori = Token_Or + 6,       // 0xAD 
	Token_Clr = Token_Ori + 3,      // 0xB0
	Token_Addx = Token_Clr + 3,     // 0xB3
	Token_Bcs = Token_Addx + 6,     // 0xB9
	Token_Bcc = Token_Bcs + 1,      // 0xBA
	Token_Dbra = Token_Bcc + 1,     // 0xBB
	Token_Eor = Token_Dbra + 1,     // 0xBC
	Token_Eori = Token_Eor + 3,     // 0xBF
	Token_Trap = Token_Eori + 3,    // 0xC2
	Token_Btst = Token_Trap + 1,    // 0xC3
	Token_Bchg = Token_Btst + 2,    // 0xC5
	Token_Bclr = Token_Bchg + 2,    // 0xC7
	Token_Bset = Token_Bclr + 2,    // 0xC9
	Token_Bsr = Token_Bset + 2,     // 0xCB
	Token_Not = Token_Bsr + 1,      // 0xCC
	Token_Rte = Token_Not + 3,      // 0xCF
	
	Token_Bls = Token_Rte + 1,      // 0xD0
	Token_Bhi = Token_Bls + 1,      // 0xD1
	
	Token_Sls = Token_Bhi + 1,      // 0xD2
	Token_Scs = Token_Sls + 1,      // 0xD3
	Token_Shi = Token_Scs + 1,      // 0xD4
	Token_Scc = Token_Shi + 1,      // 0xD5

	Token_Jmp = Token_Scc + 1,      // 0xD6

	Token_Instruction_End = Token_Jmp + 1, // 0xD7

	PoolID,                        // 0xD8
	DefinePoolID,                  // 0xD9

	EA_d0,                         // 0xDA
	EA_d1,                         // 0xDB
	EA_d2,                         // 0xDC
	EA_d3,                         // 0xDD
	EA_d4,                         // 0xDE
	EA_d5,                         // 0xDF
	EA_d6,                         // 0xE0
	EA_d7,                         // 0xE1
	EA_a0,                         // 0xE2
	EA_a1,                         // 0xE3
	EA_a2,                         // 0xE4
	EA_a3,                         // 0xE5
	EA_a4,                         // 0xE6
	EA_a5,                         // 0xE7
	EA_a6,                         // 0xE8
	EA_a7,                         // 0xE9

	EA_local,                      // 0xEA
	Token_Stmt,                    // 0xEB
	Asm_Return,                    // 0xEC
	Asm_Zero,                      // 0xED
	Asm_Extend,                    // 0xEE
	Token_Asm,                     // 0xEF
	Token_EndAsm                   // 0xF0

	
} AsmToken;
