/***********************************************************************
 *
 * This file is part of the OnBoard C package.  For more information on 
 * using OnBoard C, see http://groups.yahoo.com/group/onboardc.  For 
 * more information on developing OnBoard C (including submission of 
 * bug reports), see http://sourceforge.net/projects/onboardc.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 ***********************************************************************/

#include <PalmOS.h>
#include <PalmCompatibility.h>

#include "OnBoardC.h"

/* Multi-Segment Defines */
#include "Initialization-seg.h"
/* End of Multi-segment defines */

TempNamePool *tempNameSpace = NULL;
TempNamePool *tempNameBase = NULL;


static Declaration *newTempDecl(int typeIndex, int scope, int statementIndex, Boolean *dup)
{
	Declaration *decl;
	unsigned char tempHash;
	CharPtr tempNamePtr;
	
	if (tempNameBase == NULL) {
		tempNameBase = MemPtrNew(sizeof(TempNamePool));
		tempNameBase->next = NULL;
		tempNameSpace = tempNameBase;
		tempIndex = 0;
	}
	else {
		if (statementIndex != -1) {			// scan for an existing temp of the right type, not in this statement
			TempNamePool *t = tempNameBase;
			int i;
			int base = 0;
			while (t) {
				for (i = 0; (i < TEMP_COUNT); i++) {
					if ((i + base) == tempCount)
						break;
					if ((t->statementIndex[i] != -1) 
								&& (t->tempType[i] == typeIndex)
								&& (t->statementIndex[i] != statementIndex)) {
						t->statementIndex[i] = statementIndex;
						if (dup) *dup = true;
						return &t->tempDecl[i];
					}
				}
				if ((i + base) == tempCount)
					break;
				t = t->next;
				base += TEMP_COUNT;
			}
		}
		
		if (tempIndex == TEMP_COUNT) {
			if (tempNameSpace->next == NULL) {
				tempNameSpace->next = MemPtrNew(sizeof(TempNamePool));
				tempNameSpace = tempNameSpace->next;
				tempNameSpace->next = NULL;
			}
			else {
				tempNameSpace = tempNameSpace->next;
			}
			tempIndex = 0;
		}
	}
	if (tempIndex == 0) {	// initialize this entire temp pool
		int i;
		for (i = 0; i < TEMP_COUNT; i++) {
			int index = i + tempCount;
			tempNameSpace->tempNames[i][0] = 't';
			tempNameSpace->tempNames[i][1] = '0' + ((index >> 6) & 0x7);
			tempNameSpace->tempNames[i][2] = '0' + ((index >> 3) & 0x7);
			tempNameSpace->tempNames[i][3] = '0' + ((index) & 0x7);
			tempNameSpace->tempNames[i][4] = '\0';
		}
	}
	
	tempNamePtr = tempNameSpace->tempNames[tempIndex];	
	tempHash = tempNamePtr[0] ^ tempNamePtr[1] ^ tempNamePtr[2] ^ tempNamePtr[3];
	decl = &tempNameSpace->tempDecl[tempIndex];
	decl->data.nextField = -1;
	decl->name = tempNamePtr;
	decl->hash = tempHash;
	decl->depth = -1;
	decl->bitWidth = 0;
	decl->length = TEMP_NAME_SIZE - 1;
	decl->typeIndex = typeIndex;
	decl->isTypedef = false;
	decl->isStatic = false;
	decl->typeNameSpace = false;
	decl->nextDecl = gLocalHashTable[tempHash];
	gLocalHashTable[tempHash] = decl;
	
//	makeDeclaration(tempNamePtr, (TEMP_NAME_SIZE - 1), typeIndex, NULL, scope, tempHash, false);

	tempNameSpace->tempType[tempIndex] = typeIndex;
	tempNameSpace->statementIndex[tempIndex] = statementIndex;
//	tempNameSpace->tempDecl[tempIndex] = decl;

	tempIndex++;
	tempCount++;

	return decl;
}

Node *newTemp(int typeIndex, int statementIndex)
{
	Node *temp;
	Boolean dup = false;
	Declaration *theDecl = newTempDecl(typeIndex, LocalScope, statementIndex, &dup);
	if (!dup) {
		theDecl->depth = blockIndex;
		theDecl->data.value = -(gFrameSize + getTypeSize(theDecl->typeIndex));
		gFrameSize += getTypeSize(theDecl->typeIndex);
		if (gFrameSize & 1) gFrameSize++;
	
		addTokenToOutput(Token_Local);
		writeDeclaration(theDecl);
	}
	temp = addIdentifierNode(theDecl->name, theDecl->length, theDecl->hash);
	return resolveIdentifier(temp);
}

static void writeDeclToDataBuffer(Declaration *theDecl)	// only used for local statics
{
	char depthString[4] = "_xx";

	depthString[0] = Asm_Identifier;
	depthString[1] = theDecl->length + 3 + 3;
	writeToDataBuffer(depthString, 2);
//	DmWrite(dataBuffer, dataTop, depthString, 2);
//	dataTop += 2;
	writeToDataBuffer(theDecl->name, theDecl->length);
//	DmWrite(dataBuffer, dataTop, theDecl->name, theDecl->length);
//	dataTop += theDecl->length;
	writeToDataBuffer("_f_", 3);
//	DmWrite(dataBuffer, dataTop, "_f_", 3);
//	dataTop += 3;
	depthString[0] = '_';
	depthString[1] = (gFunctionCount >> 3) + '0';
	depthString[2] = (gFunctionCount & 0x7) + '0';
	writeToDataBuffer(depthString, 3);
//	DmWrite(dataBuffer, dataTop, &depthString[0], 3);
//	dataTop += 3;
	writeTokenToDataBuffer(Token_Dc);
	writeSize(getTypeSize(theDecl->typeIndex));
	writeTokenToDataBuffer(Asm_Zero);
//	depthString[0] = Asm_Zero;
//	DmWrite(dataBuffer, dataTop, depthString, 1);
//	dataTop++;
//	DmWrite(dataBuffer, dataTop, "\0\0\0\0", 4);
//	dataTop += 4;
}

Declaration *newGlobalTemp(int typeIndex)
{
	Declaration *theDecl = newTempDecl(typeIndex, GlobalScope, -1, NULL);
	theDecl->depth = - gFunctionCount - 2;			// make them local static
	
	writeDeclToDataBuffer(theDecl);

	return theDecl;
}


/*
	construct a tree __S_R = &result (a struct assignment expects pointer arguments)
*/

void constructStructResult(Node *result, int typeIndex)
{
	initTarget[0].op = Decl;
	initTarget[0].offset = 0;
	initTarget[0].reg = A6;
	initTarget[0].data.decl = structResult;
	initTarget[0].typeIndex = newPointerType(typeIndex);

	initTarget[1].op = AddressOf;
	initTarget[1].offset = 0;
	initTarget[1].reg = None;
	initTarget[1].data.children.node1 = result;
	initTarget[1].data.children.node2 = NULL;
	initTarget[1].typeIndex = newPointerType(typeIndex);

	initTarget[2].op = Equal;
	initTarget[2].offset = getTypeSize(typeIndex);
	initTarget[2].reg = None;
	initTarget[2].typeIndex = typeIndex;
	initTarget[2].data.children.node1 = &initTarget[0];
	initTarget[2].data.children.node2 = &initTarget[1];
}

/*
	construct a tree *__S_R = result
*/

void constructFPResult(Node *result, int typeIndex)
{
	initTarget[0].op = Decl;
	initTarget[0].offset = 0;
	initTarget[0].reg = A6;
	initTarget[0].data.decl = structResult;
	initTarget[0].typeIndex = newPointerType(typeIndex);

	initTarget[1].op = Arrow;
	initTarget[1].offset = 0;
	initTarget[1].reg = None;
	initTarget[1].data.children.node1 = &initTarget[0];
	initTarget[1].data.children.node2 = NULL;
	initTarget[1].typeIndex = typeIndex;

	initTarget[2].op = Equal;
	initTarget[2].offset = 0;
	initTarget[2].reg = None;
	initTarget[2].typeIndex = typeIndex;
	initTarget[2].data.children.node1 = &initTarget[1];
	initTarget[2].data.children.node2 = result;
}

/*
	construct a tree with &theDecl, or &theDecl->theField
*/
void constructInitTarget(Declaration *theDecl, Declaration *theField, Boolean isLocalStatic, int offset)
{
	initTarget[0].op = Decl;
	initTarget[0].offset = offset;
	initTarget[0].reg = (isLocalStatic) ? A5 : A6;
	initTarget[0].data.decl = theDecl;
	initTarget[0].typeIndex = theDecl->typeIndex;

	initTarget[1].op = AddressOf;
	initTarget[1].offset = 0;
	initTarget[1].reg = None;
	initTarget[1].data.children.node1 = &initTarget[0];
	initTarget[1].data.children.node2 = NULL;
	initTarget[1].typeIndex = IntPtrTypeIndex;

	if (theField != NULL) {
		initTarget[1].typeIndex = newPointerType(theField->typeIndex);
		initTarget[2].op = Arrow;
		initTarget[2].reg = None;
		initTarget[2].offset = theField->depth >> 3;
		initTarget[2].data.children.node1 = &initTarget[1];
		initTarget[2].data.children.node2 = (Node *)theField;
		initTarget[2].typeIndex = theField->typeIndex;
	}
}

void constructInitArrayTarget(Declaration *theDecl, int baseTypeIndex, Boolean isLocalStatic)
{
/*
	constructInitTarget(theDecl, NULL, isLocalStatic);

	initTarget[2].op = Arrow;
	initTarget[2].reg = None;
	initTarget[2].offset = 0;
	initTarget[2].data.children.node1 = &initTarget[1];
	initTarget[2].data.children.node2 = NULL;
	initTarget[2].typeIndex = baseTypeIndex;
*/

	initTarget[2].op = Decl;
	initTarget[2].offset = 0;
	initTarget[2].reg = (isLocalStatic) ? A5 : A6;
	initTarget[2].data.decl = theDecl;
	initTarget[2].typeIndex = baseTypeIndex;

}

void addInitField(Declaration *theField)
{
	initTarget[2].offset += theField->depth >> 3;
	initTarget[2].typeIndex = theField->typeIndex;
}

void removeInitField(Declaration *theField)
{
	initTarget[2].offset -= theField->depth >> 3;
}

void addInitOffset(int offset)
{
	initTarget[2].offset += offset;
}

void removeInitOffset(int offset)
{
	initTarget[2].offset -= offset;
}

int getActualStringLength(CharPtr s, int length)
{
	int discount = 0;
	int i;
	for (i = 0; i < length; i++) {
		if (s[i] == '\\') {
			discount++;			// the '\' won't count in the total
			i++;
			switch (s[i]) {
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
					while ((charTokenMap[(UChar)(s[i])] == Digit) && (i < length)) i++;	// all the following digits collapse to a single
					break;
				case 'x':
					i++;
					discount++;	// the 'x' won't count either
					while ((charTokenMap[(UChar)(s[i])] == HexDigit) && (i < length)) i++;	// all the following hex digits collapse to a single
					break;
			}
		}
	}
	return length - discount;
}

CharPtr localInitializer(CharPtr curTextPtr, Declaration *theDecl, int initTypeIndex, 
									Boolean seenLeftCurly, Boolean isLocalStatic, 
									Declaration *baseDecl, int offset)
{
	Node *result;
	ParseState ps;
    CharPtr savePtr;
	Declaration *theField;
	
//	char buf[32];
		
	savePtr = curTextPtr;
    curTextPtr = getNextToken(curTextPtr, &ps);
    
//    StrPrintF(buf, "entered with offset %d", offset);
//    error(buf);

    if (seenLeftCurly && isStruct(initTypeIndex) && (ps.token != LeftCurly)) {
    	pushBack(&ps);
		theField = getFirstField(initTypeIndex);
		while (true) {
//			addInitField(theField);
			curTextPtr = localInitializer(curTextPtr, theField, theField->typeIndex, true, isLocalStatic, baseDecl, offset + (theField->depth >> 3));
			if (curTextPtr == NULL) return NULL;
//			removeInitField(theField);
			theField = getNextField(initTypeIndex, theField);
			if (theField == NULL) break;
			savePtr = curTextPtr;
		    curTextPtr = getNextToken(curTextPtr, &ps);
		    if (ps.token == RightCurly)
		    	break;
		    else {
		    	if (ps.token != Comma) {
		    		sourceError("Illegal token in struct initializer list", savePtr);
		    		return NULL;
		    	}
		    }
		}
		return curTextPtr;
    }

    if (ps.token == LeftCurly) {
		if (isArray(initTypeIndex)) {
	    	int index = 0;
//			if (!seenLeftCurly)
//				constructInitArrayTarget(theDecl, getBaseType(initTypeIndex), isLocalStatic);
			while (true) {
				curTextPtr = localInitializer(curTextPtr, NULL, getBaseType(initTypeIndex), true, isLocalStatic, baseDecl, offset);
//				addInitOffset(getTypeSize(getBaseType(initTypeIndex)));
				offset += getTypeSize(getBaseType(initTypeIndex));
				if (curTextPtr == NULL) return NULL;
				savePtr = curTextPtr;
			    curTextPtr = getNextToken(curTextPtr, &ps);
			    if (ps.token == RightCurly)
			    	break;
			    else {
			    	if (ps.token != Comma) {
			    		sourceError("Illegal token in array initializer list", savePtr);
			    		return NULL;
			    	}
			    }
			    index++;
			    if (getDimension(initTypeIndex) != -1) {
				    if (index >= getDimension(initTypeIndex)) {
			    	 	sourceError("Too many array initializers", savePtr);
			    		return NULL;
				    }
				}
			}
			if (getDimension(initTypeIndex) == -1) {
				setDimension(initTypeIndex, (index + 1));
				fixTypeSizes(initTypeIndex);
			}
//			removeInitOffset(getDimension(initTypeIndex) * getTypeSize(getBaseType(initTypeIndex)));
		}
		else {
			if (!isStruct(initTypeIndex)) {
				sourceError("Can't have struct initializer for non-struct", savePtr);
				return NULL;
			}
			theField = getFirstField(initTypeIndex);
//			if (!seenLeftCurly) 
//				constructInitTarget(theDecl, theField, isLocalStatic);
			while (theField != NULL) {
//				addInitField(theField);
				curTextPtr = localInitializer(curTextPtr, theField, theField->typeIndex, true, isLocalStatic, baseDecl, offset + (theField->depth >> 3));
				if (curTextPtr == NULL) return NULL;
//				removeInitField(theField);
				theField = getNextField(initTypeIndex, theField);
				savePtr = curTextPtr;
			    curTextPtr = getNextToken(curTextPtr, &ps);
			    if (ps.token == RightCurly) {
			    	break;
			    }
			    else {
			    	if (ps.token != Comma) {
			    		sourceError("Illegal token in struct initializer list", savePtr);
			    		return NULL;
			    	}
			    }
			}
		}
    }
    else {
		pushBack(&ps);
        curTextPtr = expression(curTextPtr, -1, -1, &result, false);
        if (curTextPtr == NULL) return NULL;
#ifdef DO_CODEGEN        
		if (!matchTypes(initTypeIndex, result->typeIndex)) {
			if (isPointer(initTypeIndex)
					&& (result->typeIndex == IntTypeIndex)
					&& (result->op == Decl)
					&& (result->reg == Immediate)
					&& (result->value == 0)) {
				result->typeIndex = UnsignedLongTypeIndex;
/*				
				initTarget[0].op = Decl;
				initTarget[0].offset = 0;
				initTarget[0].reg = (isLocalStatic) ? A5 : A6;
				initTarget[0].data.decl = theDecl;
				initTarget[0].typeIndex = UnsignedLongTypeIndex;
*/
				initTarget[0].op = Decl;
				initTarget[0].offset = offset;
				initTarget[0].reg = (isLocalStatic) ? A5 : A6;
				initTarget[0].data.decl = baseDecl;
				initTarget[0].typeIndex = UnsignedLongTypeIndex;
				
				emitMove(result, &initTarget[0], true);
			}
			else {
				if (isArray(initTypeIndex) 
						&& (getBaseType(initTypeIndex) == CharTypeIndex)
						&& (result->typeIndex == CharPtrTypeIndex)
						&& (ps.token == DoubleQuote) ) {
//					if (!seenLeftCurly) {
						int length = result->data.children.node1->data.identifier.length;
						Node *targetAddress;
						if (getActualStringLength(result->data.children.node1->data.identifier.name, result->data.children.node1->data.identifier.length) >= getTypeSize(initTypeIndex)) {
							sourceError("String initializer exceeds size of declaration", savePtr);
							return NULL;
						}					
//						constructInitTarget(theDecl, NULL, isLocalStatic);
						constructInitTarget(baseDecl, NULL, isLocalStatic, offset);		// need addressOf for array assignment in codegen
						initTarget[2].op = Equal;
						initTarget[2].offset = length + 1;
						initTarget[2].typeIndex = initTypeIndex;
						initTarget[2].data.children.node1 = &initTarget[1];
						initTarget[2].data.children.node2 = result;						// already got addressOf from expression() called on ".."
						targetAddress = generateCode(&initTarget[2], -1, -1);
						if (targetAddress == NULL) return NULL;
//					}
//					else {
//						sourceError("char[] init not supported inside structs", savePtr);
//						return NULL;
//					}
				}
				else {
					sourceError("Illegal types for initialization", savePtr);
					return NULL;
				}
			}
		}
		else {
			if (isEnum(initTypeIndex))
				initTypeIndex = getBaseType(initTypeIndex);
			if (isEnum(result->typeIndex))
				result->typeIndex = getBaseType(result->typeIndex);
			if (!isPointer(result->typeIndex)) {
				if (!emitConvert(result, initTypeIndex))
					return NULL;
			}
			if (!seenLeftCurly) {
				if (isStruct(initTypeIndex)) {	// a struct initialization as single assignment
					Node *targetAddress;
//					constructInitTarget(theDecl, NULL, isLocalStatic);
					constructInitTarget(baseDecl, NULL, isLocalStatic, offset);
					initTarget[2].op = Equal;
					initTarget[2].offset = getTypeSize(initTypeIndex);
					initTarget[2].typeIndex = initTypeIndex;
					initTarget[2].data.children.node1 = &initTarget[1];
					initTarget[2].data.children.node2 = &initTarget[3];
					initTarget[3].op = AddressOf;
					initTarget[3].offset = 0;
					initTarget[3].reg = None;
					initTarget[3].typeIndex = newPointerType(initTypeIndex);
					initTarget[3].data.children.node1 = result;
					initTarget[3].data.children.node2 = NULL;
					targetAddress = generateCode(&initTarget[2], -1, -1);
					if (targetAddress == NULL) return NULL;
				}
				else {
					initTarget[0].op = Decl;
//					initTarget[0].offset = 0;
					initTarget[0].offset = offset;
					initTarget[0].reg = (isLocalStatic) ? A5 : A6;
//					initTarget[0].data.decl = theDecl;
					initTarget[0].data.decl = baseDecl;
// why wasn't this here???
						initTarget[0].typeIndex = initTypeIndex;

					if (initTypeIndex == DoubleTypeIndex) {
						emitMoveDouble(result, &initTarget[0]);
					}
					else {
						initTarget[0].typeIndex = initTypeIndex;
						emitMove(result, &initTarget[0], true);
					}
				}
			}
			else {
			// initializing an individual field, driven by inside-curly-braces-loop above
				initTarget[0].op = Decl;
				initTarget[0].offset = offset;
				initTarget[0].reg = (isLocalStatic) ? A5 : A6;
				initTarget[0].data.decl = baseDecl;
				initTarget[0].typeIndex = initTypeIndex;
				if (initTypeIndex == DoubleTypeIndex)
					emitMoveDouble(result, &initTarget[0]);
				else
					emitMove(result, &initTarget[0], true);
/*			
				int oldOp = initTarget[2].op;
				int oldReg = initTarget[2].reg;
				Node *targetAddress = generateCode(&initTarget[2], -1, -1);
				if (targetAddress == NULL) return NULL;
				emitMove(result, targetAddress, true);
				freeRegister(targetAddress);
				initTarget[2].reg = oldReg;
				initTarget[2].op = oldOp;
				initTarget[1].reg = None;
				initTarget[1].op = AddressOf;
*/				
			}
		}
#endif		
    }
    
    return curTextPtr;
}


CharPtr handleLocalStatics(CharPtr curTextPtr, Declaration *theDecl, int baseType)
{
	ParseState ps;
	Declaration *other;
	char reg;

	while (true) {
		CharPtr savePtr = curTextPtr;

		setDepth(theDecl, GlobalScope, - gFunctionCount - 2);
		other = findIdentifier(theDecl->name, theDecl->length, &reg, theDecl->hash, theDecl);
		if (other) {
			if (other->isTypedef) {
				sourceError("Illegal redefinition of typedef", theDecl->name);
				return NULL;
			}
			if ((reg == A5) && (other->depth == theDecl->depth)) {
				sourceError("Duplicate local static definition", theDecl->name);
				return NULL;
			}
		}

		writeDeclToDataBuffer(theDecl);
/*		
		DmWrite(dataBuffer, dataTop, theDecl->name, theDecl->length);
		dataTop += theDecl->length;
		DmWrite(dataBuffer, dataTop, "_f_", 3);
		dataTop += 3;
		buf[0] = '_';
		buf[1] = (gFunctionCount >> 3) + '0';
		buf[2] = (gFunctionCount & 0x7) + '0';
		buf[3] = '\0';
		DmWrite(dataBuffer, dataTop, &buf[0], 3);
		dataTop += 3;
		DmWrite(dataBuffer, dataTop, "\tdc\t0\n", 6);
		dataTop += 6;												
*/
        curTextPtr = getNextToken(curTextPtr, &ps);
        if (ps.token == Equal) {			            	
			Declaration *flagDecl = newGlobalTemp(UnsignedCharTypeIndex);
			int skipLabel = nextLabel++;
			int initLabel = nextLabel++;
			
			initTarget[0].op = Decl;
			initTarget[0].offset = 0;
			initTarget[0].reg = A5;
			initTarget[0].data.decl = flagDecl;
			initTarget[0].typeIndex = UnsignedCharTypeIndex;
			
			if (!emitConditionalBranch(&initTarget[0], skipLabel, initLabel))
				return NULL;
			emitLabel(initLabel);
			initTarget[0].reg = A5;
			initTarget[1].op = Decl;
			initTarget[1].offset = 0;
			initTarget[1].reg = Immediate;
			initTarget[1].value = 1;
			initTarget[1].typeIndex = UnsignedCharTypeIndex;
			emitMove(&initTarget[1], &initTarget[0], true);
			
        	curTextPtr = localInitializer(curTextPtr, theDecl, theDecl->typeIndex, false, true, theDecl, 0);
        	if (curTextPtr == NULL)
        		return NULL;
			emitLabel(skipLabel);

        	curTextPtr = getNextToken(curTextPtr, &ps);
		}

        if (ps.token == SemiColon)
            break;
        else {
            if (ps.token != Comma) {
                sourceError("Comma or semi-colon expected after declaration", savePtr);
                return NULL;
            }
            theDecl = NULL;
            savePtr = curTextPtr;
            curTextPtr = declaration(curTextPtr, &baseType, &theDecl, GlobalScope, false);
            if (curTextPtr == NULL) return NULL;
            if (theDecl == NULL) {
				sourceError("Declaration expected", savePtr);
				return NULL;
            }
        }
	}
	
	return curTextPtr;
}

void writeSize(int size)
{
	long val;
	
	switch (size) {
		case 1 : 
			writeTokenToDataBuffer(ByteSpec);
			break;
		case 2 : 
			writeTokenToDataBuffer(WordSpec);
			break;
		case 4 : 
			writeTokenToDataBuffer(LongSpec);
			break;
		default : {
				writeTokenToDataBuffer(Asm_Period);
				writeTokenToDataBuffer(Asm_Digit);
				val = size;
				writeToDataBuffer((char *)(&val), 4);
//				DmWrite(dataBuffer, dataTop, &val, 4);
//				dataTop += 4;
			}
			break;
	}
}

Char initString[256];		// keeping this off the stack

CharPtr handleInitializer(CharPtr curTextPtr, Declaration *theDecl, int initTypeIndex, Boolean seenLeftCurly)
{
	ParseState ps;
    CharPtr savePtr;
    int i;
    int length;
	Declaration *theField;
	
	savePtr = curTextPtr;
    curTextPtr = getNextToken(curTextPtr, &ps);
    
    if (seenLeftCurly && isStruct(initTypeIndex) && (ps.token != LeftCurly)) {
    	pushBack(&ps);
		theField = getFirstField(initTypeIndex);
		while (true) {
			curTextPtr = handleInitializer(curTextPtr, theField, theField->typeIndex, true);
			if (curTextPtr == NULL) return NULL;
			theField = getNextField(initTypeIndex, theField);
			if (theField == NULL) break;
			savePtr = curTextPtr;
		    curTextPtr = getNextToken(curTextPtr, &ps);
		    if (ps.token == RightCurly)
		    	break;
		    else
		    	if (ps.token != Comma)
		    		sourceError("Illegal token in struct initializer list", savePtr);		    	
		}
		return curTextPtr;
    }
    	
    if (ps.token == LeftCurly) {
		if (isArray(initTypeIndex)) {
	    	int index = 0;
			while (true) {
				curTextPtr = handleInitializer(curTextPtr, NULL, getBaseType(initTypeIndex), true);
				if (curTextPtr == NULL) return NULL;
				savePtr = curTextPtr;
			    curTextPtr = getNextToken(curTextPtr, &ps);
			    if (ps.token == RightCurly)
			    	break;
			    else {
			    	if (ps.token != Comma) {
			    		sourceError("Illegal token in array initializer list", savePtr);
			    		return NULL;
			    	}
			    }
			    index++;
			    if (getDimension(initTypeIndex) != -1) {
				    if (index >= getDimension(initTypeIndex)) {
			    		sourceError("Too many array initializers", savePtr);
			    		return NULL;
				    }
				}
			}
			if (getDimension(initTypeIndex) == -1) {
				setDimension(initTypeIndex, (index + 1));
				fixTypeSizes(initTypeIndex);
			}
// left over from copy/paste??			
//			removeInitOffset(getDimension(initTypeIndex) * getTypeSize(getBaseType(initTypeIndex)));
		}
		else {
			if (!isStruct(initTypeIndex)) {
				sourceError("Can't have struct initializer for non-struct", savePtr);
				return NULL;
			}
			theField = getFirstField(initTypeIndex);
			while (theField != NULL) {
				curTextPtr = handleInitializer(curTextPtr, theField, theField->typeIndex, true);
				if (curTextPtr == NULL) return NULL;
				theField = getNextField(initTypeIndex, theField);
				savePtr = curTextPtr;
			    curTextPtr = getNextToken(curTextPtr, &ps);
			    if (ps.token == RightCurly) {
			    	break;
			    }
			    else
			    	if (ps.token != Comma)
			    		sourceError("Illegal token in struct initializer list", savePtr);		    	
			}
		}
    }
    else {
		writeTokenToDataBuffer(Token_Dc);
		if (isArray(initTypeIndex)
				&& (ps.token == DoubleQuote)
    			&& (getBaseType(initTypeIndex) == CharTypeIndex)) {
    		int x;
    		int t = 0;
    		int i;
    		if (getActualStringLength(ps.start, ps.value) >= getTypeSize(initTypeIndex)) {    		
				sourceError("String initializer exceeds size of declaration", savePtr);
				return NULL;
    		}
    		writeTokenToDataBuffer(ByteSpec);
    		
    		x = getTypeSize(initTypeIndex);
    		while (x > 250) {
				initString[0] = Asm_DoubleQuote;
	    		initString[1] = 0;
	    		initString[2] = 250;	    		
	    		for (i = 0; i < 250; i++)
	    			if ((t + i) < ps.value)
	    				initString[i + 3] = ps.start[t + i];
	    			else
	    				initString[i + 3] = 0;
	    		x -= 250;
	    		t += 250;
	    		writeToDataBuffer(initString, 253);
//				DmWrite(dataBuffer, dataTop, initString, 253);
				writeTokenToDataBuffer(Token_Dc);
	    		writeTokenToDataBuffer(ByteSpec);
    		}
    		
    		initString[0] = Asm_DoubleQuote;
    		initString[1] = 0;
    		initString[2] = x & 0xFF;
    		for (i = 0; i < x; i++)
    			if ((t + i) < ps.value)
	    			initString[3 + i] = ps.start[t + i];
	    		else
	    			initString[3 + i] = 0;
			length = 3 + x;
    	}
    	else {
			if (initTypeIndex == DoubleTypeIndex)
				writeTokenToDataBuffer(LongSpec);			// have to handle doubles as a pair of longs
			else
				writeSize(getTypeSize(initTypeIndex));
	    	if (ps.token == DoubleQuote) {
	    		if (initTypeIndex != CharPtrTypeIndex) {
	    			sourceError("Illegal initializer type", savePtr);
	    			return NULL;
	    		}
				addStringConstant(ps.start, ps.value, initString, &length);
	    	}
	    	else {
				Declaration *d = NULL;
				char reg;
	    		if (ps.token == And) {
	    			int ptrBaseTypeIndex;
	        		if (!isPointer(initTypeIndex)) {
	        			sourceError("Illegal initializer type", savePtr);
	        			return NULL;
	        		}
	    			savePtr = curTextPtr;
	                curTextPtr = getNextToken(curTextPtr, &ps);
	                if (ps.token != Identifier) {
	                	sourceError("Identifier expected after '&' in initializer", savePtr);
						return NULL;
	                }
	                ptrBaseTypeIndex = getBaseType(initTypeIndex);
	                d = findIdentifier(ps.start, ps.value, &reg, ps.hash, NULL);
	                if (d == NULL) {
	                	d = makeDeclaration(ps.start, ps.value, ptrBaseTypeIndex, curTextPtr, GlobalScope, ps.hash, false);
	                	setDepth(d, GlobalScope, -1); // mark as forward declaration
	                }
	                else {
	            		if (!matchTypes(ptrBaseTypeIndex, d->typeIndex)) {
	            			sourceError("Illegal initializer type", savePtr);
	            			return NULL;
	            		}
					}
					initString[0] = Asm_Identifier;
					initString[1] = ps.value + 3;
					length = 2;
					for (i = 0; i < ps.value; i++) {
						initString[length++] = ps.start[i];
					}
					initString[length++] = '_';
					if (d == NULL) {
						initString[length++] = '0';
						initString[length++] = '0';
					}
					else {
						initString[length++] = (d->depth >> 3) + '0';
						initString[length++] = (d->depth & 0x7) + '0';
						if (d->isStatic) {
							initString[length++] = '_';
							initString[length++] = (gStaticIndex >> 3) + '0';
							initString[length++] = (gStaticIndex) + '0';
						}
					}
	    		}
	    		else {
					Boolean fpInit = (initTypeIndex == FloatTypeIndex) || (initTypeIndex == DoubleTypeIndex);
					double dValue;
		    		if (ps.token == Identifier) {
						d = findIdentifier(ps.start, ps.value, &reg, ps.hash, NULL);
						if (d == NULL) {
							sourceError("Unknown identifier in initializer", savePtr);
							return NULL;
						}
		                // only special case functions here
						if (isFunction(d->typeIndex)) {
							if (!matchTypes(d->typeIndex, getBaseType(initTypeIndex))) {
		            			sourceError("Illegal initializer type", savePtr);
		            			return NULL;
							}
							initString[0] = Asm_Identifier;
							initString[1] = ps.value + 3;
							length = 2;
							for (i = 0; i < ps.value; i++) {
								initString[length++] = ps.start[i];
							}
							initString[length++] = '_';
							initString[length++] = (d->depth >> 3) + '0';
							initString[length++] = (d->depth & 0x7) + '0';
						}
						else {
							d = NULL;		// fall into generic constant expression handling
						}
		    		}
		    		if (d == NULL) {
						pushBack(&ps);					
						curTextPtr = constantExpression(curTextPtr, &ps.value, fpInit, &dValue);
						if (curTextPtr == NULL) return NULL;
						if (fpInit) {
							if (initTypeIndex == FloatTypeIndex) {
								float fValue = (float)dValue;
								writeTokenToDataBuffer(Asm_Digit);
								writeToDataBuffer((CharPtr)(&fValue), 4);
//								DmWrite(dataBuffer, dataTop, (CharPtr)(&fValue), 4);
//								dataTop += 4;
								length = 0;
							}
							else {
								writeTokenToDataBuffer(Asm_Digit);
								writeToDataBuffer((CharPtr)(&dValue), 4);
//								DmWrite(dataBuffer, dataTop, (CharPtr)(&dValue), 4);
//								dataTop += 4;
								writeTokenToDataBuffer(Token_Dc);
								writeSize(4);
								writeTokenToDataBuffer(Asm_Digit);
								writeToDataBuffer((CharPtr)(&dValue) + 4, 4);
//								DmWrite(dataBuffer, dataTop, (CharPtr)(&dValue) + 4, 4);
//								dataTop += 4;
								length = 0;
							}
						}
						else {
							if (ps.value == 0)
								writeTokenToDataBuffer(Asm_Zero);							
							else {
								writeTokenToDataBuffer(Asm_Digit);							
								writeToDataBuffer((char *)(&ps.value), 4);
//								DmWrite(dataBuffer, dataTop, &ps.value, 4);
//								dataTop += 4;
							}
							length = 0;
						}
					}
	    		}
	    	}
    	}
    	if (length > 0) {
			writeToDataBuffer(initString, length);
//			DmWrite(dataBuffer, dataTop, initString, length);
//			dataTop += length;
		}
	}
	
	return curTextPtr;
}

